/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.trace.api.cache;

import com.datadog.android.trace.internal.compat.function.IntFunction;
import com.datadog.trace.bootstrap.instrumentation.api.UTF8BytesString;
import java.util.concurrent.atomic.AtomicReferenceArray;

public final class RadixTreeCache<T> {
    private static final IntFunction<UTF8BytesString> TO_STRING = value -> UTF8BytesString.create(Integer.toString(value));
    public static final int UNSET_STATUS = 0;
    public static final RadixTreeCache<UTF8BytesString> HTTP_STATUSES = new RadixTreeCache<UTF8BytesString>(16, 32, TO_STRING, 200, 201, 301, 307, 400, 401, 403, 404, 500, 502, 503);
    public static final int UNSET_PORT = 0;
    public static final RadixTreeCache<Integer> PORTS = new RadixTreeCache<Integer>(256, 256, Integer::valueOf, 80, 443, 8080);
    private final int level1;
    private final int level2;
    private final int shift;
    private final int mask;
    private final AtomicReferenceArray<Object[]> tree;
    private final IntFunction<T> mapper;

    public RadixTreeCache(int level1, int level2, IntFunction<T> mapper, int ... commonValues) {
        this.tree = new AtomicReferenceArray(level1);
        this.mapper = mapper;
        this.level1 = level1;
        this.level2 = level2;
        this.mask = level2 - 1;
        this.shift = Integer.bitCount(this.mask);
        for (int commonValue : commonValues) {
            this.get(commonValue);
        }
    }

    public T get(int primitive) {
        int prefix = primitive >>> this.shift;
        if (prefix >= this.level1) {
            return this.mapper.apply(primitive);
        }
        return this.computeIfAbsent(prefix, primitive);
    }

    private T computeIfAbsent(int prefix, int primitive) {
        int suffix;
        Object cached;
        Object[] page = this.tree.get(prefix);
        if (null == page && !this.tree.compareAndSet(prefix, null, page = new Object[this.level2])) {
            page = this.tree.get(prefix);
        }
        if ((cached = page[suffix = primitive & this.mask]) == null) {
            cached = page[suffix] = this.mapper.apply(primitive);
        }
        return (T)cached;
    }
}

