/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.trace.api.gateway;

import com.datadog.trace.appsec.api.blocking.BlockingContentType;
import java.util.Collections;
import java.util.Map;

public interface Flow<T> {
    public Action getAction();

    public T getResult();

    public static class ResultFlow<R>
    implements Flow<R> {
        private static final ResultFlow EMPTY = new ResultFlow<Object>(null);
        private final R result;

        public static <R> ResultFlow<R> empty() {
            return EMPTY;
        }

        public ResultFlow(R result) {
            this.result = result;
        }

        @Override
        public Action getAction() {
            return Action.Noop.INSTANCE;
        }

        @Override
        public R getResult() {
            return this.result;
        }
    }

    public static interface Action {
        public boolean isBlocking();

        public static class RequestBlockingAction
        implements Action {
            private final int statusCode;
            private final BlockingContentType blockingContentType;
            private final Map<String, String> extraHeaders;

            public RequestBlockingAction(int statusCode, BlockingContentType blockingContentType, Map<String, String> extraHeaders) {
                this.statusCode = statusCode;
                this.blockingContentType = blockingContentType;
                this.extraHeaders = extraHeaders;
            }

            public RequestBlockingAction(int statusCode, BlockingContentType blockingContentType) {
                this(statusCode, blockingContentType, Collections.emptyMap());
            }

            public static RequestBlockingAction forRedirect(int statusCode, String location) {
                return new RequestBlockingAction(statusCode, BlockingContentType.NONE, Collections.singletonMap("Location", location));
            }

            @Override
            public boolean isBlocking() {
                return true;
            }

            public int getStatusCode() {
                return this.statusCode;
            }

            public BlockingContentType getBlockingContentType() {
                return this.blockingContentType;
            }

            public Map<String, String> getExtraHeaders() {
                return this.extraHeaders;
            }
        }

        public static class Noop
        implements Action {
            public static Action INSTANCE = new Noop();

            private Noop() {
            }

            @Override
            public boolean isBlocking() {
                return false;
            }
        }
    }
}

