/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.trace.api.naming.v1;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.datadog.trace.api.naming.NamingSchema;
import com.datadog.trace.api.naming.SpanNaming;
import com.datadog.trace.util.Strings;
import java.util.Locale;

public class CloudNamingV1
implements NamingSchema.ForCloud {
    @Override
    @NonNull
    public String operationForRequest(@NonNull String provider, @NonNull String cloudService, @NonNull String qualifiedOperation) {
        switch (qualifiedOperation) {
            case "SQS.SendMessage": 
            case "SQS.SendMessageBatch": 
            case "Sqs.SendMessage": 
            case "Sqs.SendMessageBatch": {
                return SpanNaming.instance().namingSchema().messaging().outboundOperation("sqs");
            }
            case "Sqs.ReceiveMessage": 
            case "SQS.ReceiveMessage": {
                return SpanNaming.instance().namingSchema().messaging().inboundOperation("sqs");
            }
            case "Sns.Publish": 
            case "SNS.Publish": {
                return SpanNaming.instance().namingSchema().messaging().outboundOperation("sns");
            }
        }
        String lowercaseService = cloudService.toLowerCase(Locale.ROOT);
        return Strings.join(".", provider, lowercaseService, "request");
    }

    @Override
    public String serviceForRequest(@NonNull String provider, @Nullable String cloudService) {
        return null;
    }

    @Override
    @NonNull
    public String operationForFaas(@NonNull String provider) {
        return "aws.lambda.invoke";
    }
}

