/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.trace.common.writer;

import com.datadog.trace.common.writer.TraceStructureWriter;
import com.datadog.trace.common.writer.Writer;
import com.datadog.trace.core.DDSpan;
import com.datadog.trace.core.MetadataConsumer;
import com.datadog.trace.core.tagprocessor.PeerServiceCalculator;
import com.datadog.trace.logger.Logger;
import com.datadog.trace.logger.LoggerFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;

public class ListWriter
extends CopyOnWriteArrayList<List<DDSpan>>
implements Writer {
    private static final Logger log = LoggerFactory.getLogger(ListWriter.class);
    public static final Filter ACCEPT_ALL = new Filter(){

        @Override
        public boolean accept(List<DDSpan> trace) {
            return true;
        }
    };
    private final List<CountDownLatch> latches = new ArrayList<CountDownLatch>();
    private final AtomicInteger traceCount = new AtomicInteger();
    private final TraceStructureWriter structureWriter = new TraceStructureWriter(true);
    private final PeerServiceCalculator peerServiceCalculator = new PeerServiceCalculator();
    private Filter filter = ACCEPT_ALL;

    public List<DDSpan> firstTrace() {
        return (List)this.get(0);
    }

    public List<DDSpan> secondTrace() {
        return (List)this.get(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(List<DDSpan> trace) {
        if (!this.filter.accept(trace)) {
            return;
        }
        for (DDSpan span : trace) {
            span.processTagsAndBaggage(MetadataConsumer.NO_OP);
        }
        this.traceCount.incrementAndGet();
        List<CountDownLatch> list = this.latches;
        synchronized (list) {
            this.add(trace);
            for (CountDownLatch latch : this.latches) {
                if ((long)this.size() < latch.getCount()) continue;
                while (latch.getCount() > 0L) {
                    latch.countDown();
                }
            }
        }
        this.structureWriter.write(trace);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitForTracesMax(int number, int seconds) throws InterruptedException, TimeoutException {
        CountDownLatch latch = new CountDownLatch(number);
        List<CountDownLatch> list = this.latches;
        synchronized (list) {
            if (this.size() >= number) {
                return true;
            }
            this.latches.add(latch);
        }
        return latch.await(seconds, TimeUnit.SECONDS);
    }

    public void waitForTraces(int number) throws InterruptedException, TimeoutException {
        if (!this.waitForTracesMax(number, 20)) {
            String msg = "Timeout waiting for " + number + " trace(s). ListWriter.size() == " + this.size() + " : " + super.toString();
            log.warn(msg);
            throw new TimeoutException(msg);
        }
    }

    public void waitUntilReported(DDSpan span) throws InterruptedException, TimeoutException {
        this.waitUntilReported(span, 20, TimeUnit.SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilReported(DDSpan span, int timeout, TimeUnit unit) throws InterruptedException, TimeoutException {
        CountDownLatch latch;
        do {
            latch = new CountDownLatch(this.size() + 1);
            List<CountDownLatch> list = this.latches;
            synchronized (list) {
                this.latches.add(latch);
            }
            if (!this.isReported(span)) continue;
            return;
        } while (latch.await(timeout, unit));
        String msg = "Timeout waiting for span to be reported: " + span;
        log.warn(msg);
        throw new TimeoutException(msg);
    }

    public void setFilter(Filter filter) {
        this.filter = filter;
    }

    private boolean isReported(DDSpan span) {
        for (List trace : this) {
            for (DDSpan aSpan : trace) {
                if (aSpan != span) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void incrementDropCounts(int spanCount) {
    }

    @Override
    public void start() {
        this.close();
    }

    @Override
    public boolean flush() {
        this.filter = ACCEPT_ALL;
        return true;
    }

    public AtomicInteger getTraceCount() {
        return this.traceCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        this.clear();
        List<CountDownLatch> list = this.latches;
        synchronized (list) {
            for (CountDownLatch latch : this.latches) {
                while (latch.getCount() > 0L) {
                    latch.countDown();
                }
            }
            this.latches.clear();
        }
    }

    @Override
    public String toString() {
        return "ListWriter { size=" + this.size() + " }";
    }

    public static interface Filter {
        public boolean accept(List<DDSpan> var1);
    }
}

