/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.trace.core.propagation;

import com.datadog.android.trace.internal.compat.function.Supplier;
import com.datadog.trace.api.TraceConfig;
import com.datadog.trace.bootstrap.instrumentation.api.AgentPropagation;
import com.datadog.trace.bootstrap.instrumentation.api.TagContext;
import com.datadog.trace.core.propagation.ContextInterpreter;
import com.datadog.trace.core.propagation.HttpCodec;

public class TagContextExtractor
implements HttpCodec.Extractor {
    private final Supplier<TraceConfig> traceConfigSupplier;
    private final ThreadLocal<ContextInterpreter> ctxInterpreter;

    public TagContextExtractor(Supplier<TraceConfig> traceConfigSupplier, ContextInterpreter.Factory factory) {
        this.traceConfigSupplier = traceConfigSupplier;
        this.ctxInterpreter = new ThreadLocal();
        this.ctxInterpreter.set(factory.create());
    }

    @Override
    public <C> TagContext extract(C carrier, AgentPropagation.ContextVisitor<C> getter) {
        ContextInterpreter interpreter = this.ctxInterpreter.get().reset(this.traceConfigSupplier.get());
        getter.forEachKey(carrier, interpreter);
        return interpreter.build();
    }

    @Override
    public void cleanup() {
        this.ctxInterpreter.remove();
    }
}

