/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.trace.core.scopemanager;

import com.datadog.trace.bootstrap.instrumentation.api.AgentScope;
import com.datadog.trace.bootstrap.instrumentation.api.AgentSpan;
import com.datadog.trace.core.scopemanager.AbstractContinuation;
import com.datadog.trace.core.scopemanager.ContinuableScopeManager;
import com.datadog.trace.logger.Logger;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;

final class ConcurrentContinuation
extends AbstractContinuation {
    private static final int START = 1;
    private static final int CLOSED = -1073741824;
    private static final int BARRIER = -536870912;
    private volatile int count = 1;
    private static final AtomicIntegerFieldUpdater<ConcurrentContinuation> COUNT = AtomicIntegerFieldUpdater.newUpdater(ConcurrentContinuation.class, "count");

    public ConcurrentContinuation(ContinuableScopeManager scopeManager, AgentSpan spanUnderScope, byte source, Logger logger) {
        super(scopeManager, spanUnderScope, source, logger);
    }

    private boolean tryActivate() {
        int current = COUNT.incrementAndGet(this);
        if (current < 1) {
            COUNT.decrementAndGet(this);
        }
        return current > 1;
    }

    private boolean tryClose() {
        int current = COUNT.get(this);
        if (current < -536870912) {
            return false;
        }
        current = COUNT.decrementAndGet(this);
        while (current < 1 && current > -536870912) {
            if (COUNT.compareAndSet(this, current, -1073741824)) {
                return true;
            }
            current = COUNT.get(this);
        }
        return false;
    }

    @Override
    public AgentScope activate() {
        if (this.tryActivate()) {
            return this.scopeManager.continueSpan(this, this.spanUnderScope, this.source);
        }
        return null;
    }

    @Override
    public void cancel() {
        if (this.tryClose()) {
            this.trace.cancelContinuation(this);
        }
        this.logger.debug("t_id={} -> canceling continuation {}", (Object)this.spanUnderScope.getTraceId(), (Object)this);
    }

    @Override
    public AgentSpan getSpan() {
        return this.spanUnderScope;
    }

    @Override
    void cancelFromContinuedScopeClose() {
        this.cancel();
    }

    public String toString() {
        int c = COUNT.get(this);
        String s = c < -536870912 ? "CANCELED" : String.valueOf(c);
        return this.getClass().getSimpleName() + "@" + Integer.toHexString(this.hashCode()) + "(" + s + ")->" + this.spanUnderScope;
    }
}

