/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.trace.core.scopemanager;

import com.datadog.android.api.InternalLogger;
import com.datadog.trace.api.Config;
import com.datadog.trace.api.Stateful;
import com.datadog.trace.api.scopemanager.ExtendedScopeListener;
import com.datadog.trace.api.scopemanager.ScopeListener;
import com.datadog.trace.bootstrap.instrumentation.api.AgentScope;
import com.datadog.trace.bootstrap.instrumentation.api.AgentScopeManager;
import com.datadog.trace.bootstrap.instrumentation.api.AgentSpan;
import com.datadog.trace.bootstrap.instrumentation.api.AgentTracer;
import com.datadog.trace.bootstrap.instrumentation.api.ProfilerContext;
import com.datadog.trace.bootstrap.instrumentation.api.ProfilingContextIntegration;
import com.datadog.trace.bootstrap.instrumentation.api.ScopeSource;
import com.datadog.trace.bootstrap.instrumentation.api.ScopeState;
import com.datadog.trace.core.monitor.HealthMetrics;
import com.datadog.trace.core.scopemanager.AbstractContinuation;
import com.datadog.trace.core.scopemanager.ContinuableScope;
import com.datadog.trace.core.scopemanager.ContinuingScope;
import com.datadog.trace.core.scopemanager.ScopeStack;
import com.datadog.trace.core.scopemanager.SingleContinuation;
import com.datadog.trace.logger.Logger;
import com.datadog.trace.logger.LoggerFactory;
import com.datadog.trace.relocate.api.RatelimitedLogger;
import com.datadog.trace.util.AgentTaskScheduler;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;

public final class ContinuableScopeManager
implements AgentScopeManager {
    private final Logger log;
    private final RatelimitedLogger ratelimitedLogger;
    static final long iterationKeepAlive = TimeUnit.SECONDS.toMillis(Config.get().getScopeIterationKeepAlive());
    volatile ConcurrentMap<ScopeStack, ContinuableScope> rootIterationScopes;
    final List<ScopeListener> scopeListeners;
    final List<ExtendedScopeListener> extendedScopeListeners;
    final boolean strictMode;
    private final ScopeStackThreadLocal tlsScopeStack;
    private final int depthLimit;
    private final boolean inheritAsyncPropagation;
    final HealthMetrics healthMetrics;
    private final ProfilingContextIntegration profilingContextIntegration;

    public ContinuableScopeManager(int depthLimit, boolean strictMode, boolean inheritAsyncPropagation, InternalLogger internalLogger) {
        this(depthLimit, strictMode, inheritAsyncPropagation, ProfilingContextIntegration.NoOp.INSTANCE, HealthMetrics.NO_OP, internalLogger);
    }

    public ContinuableScopeManager(int depthLimit, boolean strictMode, boolean inheritAsyncPropagation, ProfilingContextIntegration profilingContextIntegration, HealthMetrics healthMetrics, InternalLogger internalLogger) {
        this.depthLimit = depthLimit == 0 ? Integer.MAX_VALUE : depthLimit;
        this.strictMode = strictMode;
        this.inheritAsyncPropagation = inheritAsyncPropagation;
        this.scopeListeners = new CopyOnWriteArrayList<ScopeListener>();
        this.extendedScopeListeners = new CopyOnWriteArrayList<ExtendedScopeListener>();
        this.healthMetrics = healthMetrics;
        this.profilingContextIntegration = profilingContextIntegration;
        this.log = LoggerFactory.getLogger(ContinuableScopeManager.class.getSimpleName(), internalLogger);
        this.ratelimitedLogger = new RatelimitedLogger(this.log, 1, TimeUnit.SECONDS);
        this.tlsScopeStack = new ScopeStackThreadLocal(profilingContextIntegration, this.ratelimitedLogger);
    }

    @Override
    public AgentScope activate(AgentSpan span, ScopeSource source) {
        return this.activate(span, source.id(), false, false);
    }

    @Override
    public AgentScope activate(AgentSpan span, ScopeSource source, boolean isAsyncPropagating) {
        return this.activate(span, source.id(), true, isAsyncPropagating);
    }

    @Override
    public AgentScope.Continuation captureSpan(AgentSpan span) {
        SingleContinuation continuation = new SingleContinuation(this, span, ScopeSource.INSTRUMENTATION.id(), this.log);
        continuation.register();
        this.healthMetrics.onCaptureContinuation();
        return continuation;
    }

    private AgentScope activate(AgentSpan span, byte source, boolean overrideAsyncPropagation, boolean isAsyncPropagating) {
        ScopeStack scopeStack = this.scopeStack();
        ContinuableScope top = scopeStack.top;
        if (top != null && top.span.equals(span)) {
            top.incrementReferences();
            return top;
        }
        int currentDepth = scopeStack.depth();
        if (this.depthLimit <= currentDepth) {
            this.healthMetrics.onScopeStackOverflow();
            this.log.debug("Scope depth limit exceeded ({}).  Returning NoopScope.", (Object)currentDepth);
            return AgentTracer.NoopAgentScope.INSTANCE;
        }
        assert (span != null);
        boolean asyncPropagation = overrideAsyncPropagation ? isAsyncPropagating : (this.inheritAsyncPropagation && top != null ? top.isAsyncPropagating() : true);
        ContinuableScope scope = new ContinuableScope(this, span, source, asyncPropagation, this.createScopeState(span), this.log, this.ratelimitedLogger);
        scopeStack.push(scope);
        this.healthMetrics.onActivateScope();
        return scope;
    }

    ContinuableScope continueSpan(AbstractContinuation continuation, AgentSpan span, byte source) {
        ScopeStack scopeStack = this.scopeStack();
        ContinuableScope top = scopeStack.top;
        if (top != null && top.span.equals(span)) {
            top.incrementReferences();
            if (continuation != null) {
                continuation.cancelFromContinuedScopeClose();
            }
            return top;
        }
        Stateful scopeState = this.createScopeState(span);
        ContinuableScope scope = continuation != null ? new ContinuingScope(this, span, source, true, continuation, scopeState, this.log, this.ratelimitedLogger) : new ContinuableScope(this, span, source, true, scopeState, this.log, this.ratelimitedLogger);
        scopeStack.push(scope);
        return scope;
    }

    @Override
    public void closePrevious(boolean finishSpan) {
        ScopeStack scopeStack = this.scopeStack();
        ContinuableScope top = scopeStack.top;
        if (top != null && top.source() == ScopeSource.ITERATION.id()) {
            if (iterationKeepAlive > 0L) {
                this.cancelRootIterationScopeCleanup(scopeStack, top);
            }
            top.close();
            scopeStack.cleanup();
            if (finishSpan) {
                top.span.finishWithEndToEnd();
                this.healthMetrics.onFinishContinuation();
            }
        }
    }

    @Override
    public AgentScope activateNext(AgentSpan span) {
        ScopeStack scopeStack = this.scopeStack();
        int currentDepth = scopeStack.depth();
        if (this.depthLimit <= currentDepth) {
            this.healthMetrics.onScopeStackOverflow();
            this.log.debug("Scope depth limit exceeded ({}).  Returning NoopScope.", (Object)currentDepth);
            return AgentTracer.NoopAgentScope.INSTANCE;
        }
        assert (span != null);
        ContinuableScope top = scopeStack.top;
        boolean asyncPropagation = this.inheritAsyncPropagation && top != null ? top.isAsyncPropagating() : true;
        ContinuableScope scope = new ContinuableScope(this, span, ScopeSource.ITERATION.id(), asyncPropagation, this.createScopeState(span), this.log, this.ratelimitedLogger);
        if (iterationKeepAlive > 0L && currentDepth == 0) {
            this.scheduleRootIterationScopeCleanup(scopeStack, scope);
        }
        scopeStack.push(scope);
        return scope;
    }

    @Override
    public AgentScope active() {
        return this.scopeStack().active();
    }

    @Override
    public AgentSpan activeSpan() {
        ContinuableScope active = this.scopeStack().active();
        return active == null ? null : active.span;
    }

    public void addScopeListener(ScopeListener listener) {
        if (listener instanceof ExtendedScopeListener) {
            this.addExtendedScopeListener((ExtendedScopeListener)listener);
        } else {
            this.scopeListeners.add(listener);
            this.log.debug("Added scope listener {}", (Object)listener);
            AgentSpan activeSpan = this.activeSpan();
            if (activeSpan != null) {
                listener.afterScopeActivated();
            }
        }
    }

    private void addExtendedScopeListener(ExtendedScopeListener listener) {
        this.extendedScopeListeners.add(listener);
        this.log.debug("Added scope listener {}", (Object)listener);
        AgentSpan activeSpan = this.activeSpan();
        if (activeSpan != null && activeSpan != AgentTracer.NoopAgentSpan.INSTANCE) {
            listener.afterScopeActivated(activeSpan.getTraceId(), activeSpan.getLocalRootSpan().getSpanId(), activeSpan.context().getSpanId(), activeSpan.traceConfig());
        }
    }

    private Stateful createScopeState(AgentSpan span) {
        if (span.context() instanceof ProfilerContext) {
            return this.profilingContextIntegration.newScopeState((ProfilerContext)((Object)span.context()));
        }
        return Stateful.DEFAULT;
    }

    ScopeStack scopeStack() {
        return (ScopeStack)this.tlsScopeStack.get();
    }

    @Override
    public ScopeState newScopeState() {
        return new ContinuableScopeState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleRootIterationScopeCleanup(ScopeStack scopeStack, ContinuableScope scope) {
        if (this.rootIterationScopes == null) {
            ContinuableScopeManager continuableScopeManager = this;
            synchronized (continuableScopeManager) {
                if (this.rootIterationScopes == null) {
                    this.rootIterationScopes = new ConcurrentHashMap<ScopeStack, ContinuableScope>();
                    RootIterationCleaner.scheduleFor(this.rootIterationScopes);
                }
            }
        }
        this.rootIterationScopes.put(scopeStack, scope);
    }

    private void cancelRootIterationScopeCleanup(ScopeStack scopeStack, ContinuableScope scope) {
        if (this.rootIterationScopes != null) {
            this.rootIterationScopes.remove(scopeStack, scope);
        }
    }

    static final class ScopeStackThreadLocal
    extends ThreadLocal<ScopeStack> {
        private final ProfilingContextIntegration profilingContextIntegration;
        private final RatelimitedLogger ratelimitedLogger;

        ScopeStackThreadLocal(ProfilingContextIntegration profilingContextIntegration, RatelimitedLogger ratelimitedLogger) {
            this.profilingContextIntegration = profilingContextIntegration;
            this.ratelimitedLogger = ratelimitedLogger;
        }

        @Override
        protected ScopeStack initialValue() {
            return new ScopeStack(this.profilingContextIntegration, this.ratelimitedLogger);
        }
    }

    private class ContinuableScopeState
    implements ScopeState {
        private ScopeStack localScopeStack;

        private ContinuableScopeState() {
            this.localScopeStack = ContinuableScopeManager.this.tlsScopeStack.initialValue();
        }

        @Override
        public void activate() {
            ContinuableScopeManager.this.tlsScopeStack.set(this.localScopeStack);
        }

        @Override
        public void fetchFromActive() {
            this.localScopeStack = (ScopeStack)ContinuableScopeManager.this.tlsScopeStack.get();
        }
    }

    private static final class RootIterationCleaner
    implements AgentTaskScheduler.Task<Map<ScopeStack, ContinuableScope>> {
        private static final RootIterationCleaner CLEANER = new RootIterationCleaner();

        private RootIterationCleaner() {
        }

        public static void scheduleFor(Map<ScopeStack, ContinuableScope> rootIterationScopes) {
            long period = Math.min(iterationKeepAlive, 10000L);
            AgentTaskScheduler.INSTANCE.scheduleAtFixedRate(CLEANER, rootIterationScopes, iterationKeepAlive, period, TimeUnit.MILLISECONDS);
        }

        @Override
        public void run(Map<ScopeStack, ContinuableScope> rootIterationScopes) {
            Iterator<Map.Entry<ScopeStack, ContinuableScope>> itr = rootIterationScopes.entrySet().iterator();
            long cutOff = System.currentTimeMillis() - iterationKeepAlive;
            while (itr.hasNext()) {
                Map.Entry<ScopeStack, ContinuableScope> entry = itr.next();
                ScopeStack scopeStack = entry.getKey();
                ContinuableScope rootScope = entry.getValue();
                if (!rootScope.alive()) {
                    itr.remove();
                    continue;
                }
                if (TimeUnit.NANOSECONDS.toMillis(rootScope.span.getStartTime()) >= cutOff) continue;
                scopeStack.overdueRootScope = rootScope;
                rootScope.span.finishWithEndToEnd();
                itr.remove();
            }
        }
    }
}

