/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.trace.core.scopemanager;

import com.datadog.trace.bootstrap.instrumentation.api.ProfilingContextIntegration;
import com.datadog.trace.bootstrap.instrumentation.api.ScopeSource;
import com.datadog.trace.core.scopemanager.ContinuableScope;
import com.datadog.trace.relocate.api.RatelimitedLogger;
import java.util.ArrayDeque;

final class ScopeStack {
    private final ProfilingContextIntegration profilingContextIntegration;
    private final ArrayDeque<ContinuableScope> stack = new ArrayDeque();
    ContinuableScope top;
    volatile ContinuableScope overdueRootScope;
    private final RatelimitedLogger ratelimitedLogger;

    ScopeStack(ProfilingContextIntegration profilingContextIntegration, RatelimitedLogger ratelimitedLogger) {
        this.profilingContextIntegration = profilingContextIntegration;
        this.ratelimitedLogger = ratelimitedLogger;
    }

    ContinuableScope active() {
        return this.top != this.overdueRootScope ? this.top : null;
    }

    void cleanup() {
        ContinuableScope curScope = this.top;
        boolean changedTop = false;
        while (curScope != null && !curScope.alive()) {
            curScope.onProperClose();
            changedTop = true;
            curScope = this.stack.poll();
        }
        if (curScope != null && curScope == this.overdueRootScope) {
            curScope.onProperClose();
            this.overdueRootScope = null;
            this.top = null;
        } else if (changedTop) {
            this.top = curScope;
            if (curScope != null) {
                curScope.beforeActivated();
                curScope.afterActivated();
            }
        }
        if (this.top == null) {
            this.onBecomeEmpty();
        }
    }

    void push(ContinuableScope scope) {
        scope.beforeActivated();
        if (this.top != null) {
            this.stack.push(this.top);
        } else {
            this.onBecomeNonEmpty();
        }
        this.top = scope;
        scope.afterActivated();
    }

    boolean checkTop(ContinuableScope expectedScope) {
        return expectedScope.equals(this.top);
    }

    final boolean checkOverdueScopes(ContinuableScope expectedScope) {
        if (this.top == null || this.top.source() != ScopeSource.ITERATION.id()) {
            return false;
        }
        this.top.clearReferences();
        this.top.span.finishWithEndToEnd();
        for (ContinuableScope scope : this.stack) {
            if (scope.source() != ScopeSource.ITERATION.id()) {
                return expectedScope.equals(scope);
            }
            scope.clearReferences();
            scope.span.finishWithEndToEnd();
        }
        return false;
    }

    int depth() {
        return this.top != null ? 1 + this.stack.size() : 0;
    }

    void clear() {
        this.stack.clear();
        this.top = null;
    }

    private void onBecomeNonEmpty() {
        try {
            this.profilingContextIntegration.onAttach();
        }
        catch (Throwable e) {
            this.ratelimitedLogger.warn("Unexpected profiling exception", e);
        }
    }

    private void onBecomeEmpty() {
        try {
            this.profilingContextIntegration.onDetach();
        }
        catch (Throwable e) {
            this.ratelimitedLogger.warn("Unexpected profiling exception", e);
        }
    }
}

