/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.trace.core.scopemanager;

import com.datadog.trace.bootstrap.instrumentation.api.AgentScope;
import com.datadog.trace.bootstrap.instrumentation.api.AgentSpan;
import com.datadog.trace.core.scopemanager.AbstractContinuation;
import com.datadog.trace.core.scopemanager.ContinuableScopeManager;
import com.datadog.trace.logger.Logger;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;

final class SingleContinuation
extends AbstractContinuation {
    private static final AtomicIntegerFieldUpdater<SingleContinuation> USED = AtomicIntegerFieldUpdater.newUpdater(SingleContinuation.class, "used");
    private volatile int used = 0;

    SingleContinuation(ContinuableScopeManager scopeManager, AgentSpan spanUnderScope, byte source, Logger logger) {
        super(scopeManager, spanUnderScope, source, logger);
    }

    @Override
    public AgentScope activate() {
        if (USED.compareAndSet(this, 0, 1)) {
            return this.scopeManager.continueSpan(this, this.spanUnderScope, this.source);
        }
        this.logger.debug("Failed to activate continuation. Reusing a continuation not allowed. Spans may be reported separately.");
        return this.scopeManager.continueSpan(null, this.spanUnderScope, this.source);
    }

    @Override
    public void cancel() {
        if (USED.compareAndSet(this, 0, 1)) {
            this.trace.cancelContinuation(this);
        } else {
            this.logger.debug("Failed to close continuation {}. Already used.", (Object)this);
        }
    }

    @Override
    public AgentSpan getSpan() {
        return this.spanUnderScope;
    }

    @Override
    void cancelFromContinuedScopeClose() {
        this.trace.cancelContinuation(this);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "@" + Integer.toHexString(this.hashCode()) + "->" + this.spanUnderScope;
    }
}

