/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.trace.core.tagprocessor;

import com.datadog.trace.core.DDSpanContext;
import com.datadog.trace.core.tagprocessor.TagsPostProcessor;
import java.util.Map;
import java.util.Objects;

public class PostProcessorChain
implements TagsPostProcessor {
    private final TagsPostProcessor[] chain;

    public PostProcessorChain(TagsPostProcessor ... processors) {
        this.chain = Objects.requireNonNull(processors);
    }

    @Override
    public Map<String, Object> processTags(Map<String, Object> unsafeTags) {
        return this.processTagsWithContext(unsafeTags, null);
    }

    @Override
    public Map<String, Object> processTagsWithContext(Map<String, Object> unsafeTags, DDSpanContext spanContext) {
        Map<String, Object> currentTags = unsafeTags;
        for (TagsPostProcessor tagsPostProcessor : this.chain) {
            currentTags = tagsPostProcessor.processTagsWithContext(currentTags, spanContext);
        }
        return currentTags;
    }
}

