/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.trace.core.util;

import com.datadog.android.trace.internal.compat.function.Function;
import com.google.gson.JsonObject;
import java.util.Map;
import java.util.Objects;

public class MapUtils {
    public static <V, K> V computeIfAbsent(K key, Map<K, V> originalMap, Function<? super K, ? extends V> mappingFunction) {
        V newValue;
        Objects.requireNonNull(mappingFunction);
        V v = originalMap.get(key);
        if (v == null && (newValue = mappingFunction.apply(key)) != null) {
            originalMap.put(key, newValue);
            return newValue;
        }
        return v;
    }

    public static JsonObject getAsJsonObject(Map<String, String> map2) {
        JsonObject jsonObject = new JsonObject();
        for (Map.Entry<String, String> entry : map2.entrySet()) {
            jsonObject.addProperty(entry.getKey(), entry.getValue());
        }
        return jsonObject;
    }
}

