/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.trace.logger;

import com.datadog.android.api.InternalLogger;
import com.datadog.trace.logger.Logger;
import java.util.Arrays;
import java.util.Locale;

public class DatadogCoreTracerLogger
implements Logger {
    private static final String LEGACY_ARG_PLACEHOLDER = "{}";
    private final InternalLogger internalLogger;
    private final String loggerName;

    static String generateLogMessage(String title, String format, Object ... args) {
        String sanitizedFormat = format.replace(LEGACY_ARG_PLACEHOLDER, "%s");
        return String.format(Locale.US, title + ": " + sanitizedFormat, args);
    }

    static String bundleMessageWithTitle(String title, String message) {
        return String.format(Locale.US, "%s: %s", title, message);
    }

    public DatadogCoreTracerLogger(String loggerName, InternalLogger internalLogger) {
        this.internalLogger = internalLogger;
        this.loggerName = loggerName;
    }

    @Override
    public boolean isDebugEnabled() {
        return false;
    }

    @Override
    public void debug(String msg) {
        this.internalLogger.log(InternalLogger.Level.DEBUG, InternalLogger.Target.MAINTAINER, () -> DatadogCoreTracerLogger.bundleMessageWithTitle(this.loggerName, msg), null, false, null);
    }

    @Override
    public void debug(String format, Object arg) {
        this.internalLogger.log(InternalLogger.Level.DEBUG, InternalLogger.Target.MAINTAINER, () -> DatadogCoreTracerLogger.generateLogMessage(this.loggerName, format, arg), null, false, null);
    }

    @Override
    public void debug(String format, Object arg1, Object arg2) {
        this.internalLogger.log(InternalLogger.Level.DEBUG, InternalLogger.Target.MAINTAINER, () -> DatadogCoreTracerLogger.generateLogMessage(this.loggerName, format, arg1, arg2), null, false, null);
    }

    @Override
    public void debug(String format, Object ... arguments) {
        this.internalLogger.log(InternalLogger.Level.DEBUG, InternalLogger.Target.MAINTAINER, () -> DatadogCoreTracerLogger.generateLogMessage(this.loggerName, format, arguments), null, false, null);
    }

    @Override
    public void debug(String msg, Throwable t) {
        this.internalLogger.log(InternalLogger.Level.DEBUG, Arrays.asList(InternalLogger.Target.MAINTAINER, InternalLogger.Target.TELEMETRY), () -> DatadogCoreTracerLogger.bundleMessageWithTitle(this.loggerName, msg), t, false, null);
    }

    @Override
    public boolean isInfoEnabled() {
        return true;
    }

    @Override
    public void info(String msg) {
        this.internalLogger.log(InternalLogger.Level.INFO, InternalLogger.Target.USER, () -> DatadogCoreTracerLogger.bundleMessageWithTitle(this.loggerName, msg), null, false, null);
    }

    @Override
    public void info(String format, Object arg) {
        this.internalLogger.log(InternalLogger.Level.INFO, InternalLogger.Target.USER, () -> DatadogCoreTracerLogger.generateLogMessage(this.loggerName, format, arg), null, false, null);
    }

    @Override
    public void info(String format, Object arg1, Object arg2) {
        this.internalLogger.log(InternalLogger.Level.INFO, InternalLogger.Target.USER, () -> DatadogCoreTracerLogger.generateLogMessage(this.loggerName, format, arg1, arg2), null, false, null);
    }

    @Override
    public void info(String format, Object ... arguments) {
        this.internalLogger.log(InternalLogger.Level.INFO, InternalLogger.Target.USER, () -> DatadogCoreTracerLogger.generateLogMessage(this.loggerName, format, arguments), null, false, null);
    }

    @Override
    public void info(String msg, Throwable t) {
        this.internalLogger.log(InternalLogger.Level.INFO, Arrays.asList(InternalLogger.Target.USER, InternalLogger.Target.TELEMETRY), () -> DatadogCoreTracerLogger.bundleMessageWithTitle(this.loggerName, msg), t, false, null);
    }

    @Override
    public boolean isWarnEnabled() {
        return true;
    }

    @Override
    public void warn(String msg) {
        this.internalLogger.log(InternalLogger.Level.WARN, InternalLogger.Target.USER, () -> DatadogCoreTracerLogger.bundleMessageWithTitle(this.loggerName, msg), null, false, null);
    }

    @Override
    public void warn(String format, Object arg) {
        this.internalLogger.log(InternalLogger.Level.WARN, InternalLogger.Target.USER, () -> DatadogCoreTracerLogger.generateLogMessage(this.loggerName, format, arg), null, false, null);
    }

    @Override
    public void warn(String format, Object arg1, Object arg2) {
        this.internalLogger.log(InternalLogger.Level.WARN, InternalLogger.Target.USER, () -> DatadogCoreTracerLogger.generateLogMessage(this.loggerName, format, arg1, arg2), null, false, null);
    }

    @Override
    public void warn(String format, Object ... arguments) {
        this.internalLogger.log(InternalLogger.Level.WARN, InternalLogger.Target.USER, () -> DatadogCoreTracerLogger.generateLogMessage(this.loggerName, format, arguments), null, false, null);
    }

    @Override
    public void warn(String msg, Throwable t) {
        this.internalLogger.log(InternalLogger.Level.WARN, Arrays.asList(InternalLogger.Target.USER, InternalLogger.Target.TELEMETRY), () -> DatadogCoreTracerLogger.bundleMessageWithTitle(this.loggerName, msg), t, false, null);
    }

    @Override
    public void error(String msg) {
        this.internalLogger.log(InternalLogger.Level.ERROR, Arrays.asList(InternalLogger.Target.USER, InternalLogger.Target.TELEMETRY), () -> DatadogCoreTracerLogger.bundleMessageWithTitle(this.loggerName, msg), null, false, null);
    }

    @Override
    public void error(String format, Object arg) {
        this.internalLogger.log(InternalLogger.Level.ERROR, Arrays.asList(InternalLogger.Target.USER, InternalLogger.Target.TELEMETRY), () -> DatadogCoreTracerLogger.generateLogMessage(this.loggerName, format, arg), null, false, null);
    }

    @Override
    public void error(String format, Object arg1, Object arg2) {
        this.internalLogger.log(InternalLogger.Level.ERROR, Arrays.asList(InternalLogger.Target.USER, InternalLogger.Target.TELEMETRY), () -> DatadogCoreTracerLogger.generateLogMessage(this.loggerName, format, arg1, arg2), null, false, null);
    }

    @Override
    public void error(String format, Object ... arguments) {
        this.internalLogger.log(InternalLogger.Level.ERROR, Arrays.asList(InternalLogger.Target.USER, InternalLogger.Target.TELEMETRY), () -> DatadogCoreTracerLogger.generateLogMessage(this.loggerName, format, arguments), null, false, null);
    }

    @Override
    public void error(String msg, Throwable t) {
        this.internalLogger.log(InternalLogger.Level.ERROR, Arrays.asList(InternalLogger.Target.USER, InternalLogger.Target.TELEMETRY), () -> DatadogCoreTracerLogger.bundleMessageWithTitle(this.loggerName, msg), t, false, null);
    }
}

