/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.trace.logger;

import androidx.annotation.NonNull;
import com.datadog.android.api.InternalLogger;
import com.datadog.trace.logger.DatadogCoreTracerLogger;
import com.datadog.trace.logger.ILoggerFactory;
import com.datadog.trace.logger.Logger;
import com.datadog.trace.logger.NoOpLogger;

public final class LoggerFactory {
    @NonNull
    public static Logger getLogger(String name) {
        return new NoOpLogger();
    }

    @NonNull
    public static Logger getLogger(String name, InternalLogger internalLogger) {
        return new DatadogCoreTracerLogger(name, internalLogger);
    }

    @NonNull
    public static Logger getLogger(Class<?> clazz) {
        return new NoOpLogger();
    }

    public static ILoggerFactory getILoggerFactory() {
        return new ILoggerFactory(){

            @Override
            public Logger getLogger(String name) {
                return new NoOpLogger();
            }

            @Override
            public Logger getLogger(String name, InternalLogger internalLogger) {
                return new DatadogCoreTracerLogger(name, internalLogger);
            }
        };
    }
}

