/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.trace.util;

import com.datadog.trace.logger.Logger;
import com.datadog.trace.logger.LoggerFactory;
import com.datadog.trace.util.AgentThreadFactory;
import java.lang.ref.WeakReference;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.Delayed;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class AgentTaskScheduler
implements Executor {
    private static final Logger log = LoggerFactory.getLogger(AgentTaskScheduler.class);
    public static final AgentTaskScheduler INSTANCE = new AgentTaskScheduler(AgentThreadFactory.AgentThread.TASK_SCHEDULER);
    private static final long SHUTDOWN_TIMEOUT = 5L;
    private final DelayQueue<PeriodicTask<?>> workQueue = new DelayQueue();
    private final AgentThreadFactory.AgentThread agentThread;
    private volatile Thread worker;
    private volatile boolean shutdown;
    private static final AtomicInteger TASK_SEQUENCE_GENERATOR = new AtomicInteger();

    public AgentTaskScheduler(AgentThreadFactory.AgentThread agentThread) {
        this.agentThread = agentThread;
    }

    @Override
    public void execute(Runnable target) {
        this.schedule(RunnableTask.INSTANCE, target, 0L, TimeUnit.MILLISECONDS);
    }

    public <T> Scheduled<T> schedule(Task<T> task, T target, long initialDelay, TimeUnit unit) {
        Scheduled<T> scheduled = new Scheduled<T>(target);
        this.scheduleTarget(task, scheduled, initialDelay, 0L, unit);
        return scheduled;
    }

    public Scheduled<Runnable> schedule(Runnable target, long initialDelay, TimeUnit unit) {
        return this.schedule(RunnableTask.INSTANCE, target, initialDelay, unit);
    }

    public <T> Scheduled<T> scheduleWithJitter(Task<T> task, T target, long initialDelay, TimeUnit unit) {
        long randomMillis = unit.toMillis(initialDelay) + Math.min((long)(1000.0 * Math.log(ThreadLocalRandom.current().nextDouble()) / Math.log(0.75)), 10000L);
        return this.schedule(task, target, randomMillis, TimeUnit.MILLISECONDS);
    }

    public Scheduled<Runnable> scheduleWithJitter(Runnable target, long initialDelay, TimeUnit unit) {
        return this.scheduleWithJitter(RunnableTask.INSTANCE, target, initialDelay, unit);
    }

    public <T> Scheduled<T> scheduleAtFixedRate(Task<T> task, T target, long initialDelay, long period, TimeUnit unit) {
        Scheduled<T> scheduled = new Scheduled<T>(target);
        this.scheduleTarget(task, scheduled, initialDelay, period, unit);
        return scheduled;
    }

    public Scheduled<Runnable> scheduleAtFixedRate(Runnable target, long initialDelay, long period, TimeUnit unit) {
        return this.scheduleAtFixedRate(RunnableTask.INSTANCE, target, initialDelay, period, unit);
    }

    public <T> void weakScheduleAtFixedRate(Task<T> task, T target, long initialDelay, long period, TimeUnit unit) {
        this.scheduleTarget(task, new WeakTarget<T>(target), initialDelay, period, unit);
    }

    public void weakScheduleAtFixedRate(Runnable target, long initialDelay, long period, TimeUnit unit) {
        this.weakScheduleAtFixedRate(RunnableTask.INSTANCE, target, initialDelay, period, unit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> void scheduleTarget(Task<T> task, Target<T> target, long initialDelay, long period, TimeUnit unit) {
        if (target == null || target.get() == null) {
            return;
        }
        if (!this.shutdown && this.worker == null) {
            DelayQueue<PeriodicTask<?>> delayQueue = this.workQueue;
            synchronized (delayQueue) {
                if (!this.shutdown && this.worker == null) {
                    this.prepareWorkQueue();
                    try {
                        this.worker = AgentThreadFactory.newAgentThread(this.agentThread, new Worker());
                        Runtime.getRuntime().addShutdownHook(new ShutdownHook());
                        this.worker.start();
                    }
                    catch (IllegalStateException e) {
                        this.shutdown = true;
                    }
                }
            }
        }
        if (!this.shutdown) {
            this.workQueue.offer(new PeriodicTask<T>(task, target, initialDelay, period, unit));
        } else {
            log.debug("Agent task scheduler is shutdown. Will not run {}", (Object)AgentTaskScheduler.describeTask(task, target));
        }
    }

    private void prepareWorkQueue() {
        try {
            this.workQueue.poll(1L, TimeUnit.NANOSECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    int taskCount() {
        return this.workQueue.size();
    }

    public boolean isShutdown() {
        return this.shutdown;
    }

    public static void initialize() {
        INSTANCE.placeholder();
    }

    private void placeholder() {
    }

    public void shutdown(long timeout, TimeUnit unit) {
        this.shutdown = true;
        Thread t = this.worker;
        if (t != null) {
            t.interrupt();
            if (timeout > 0L) {
                try {
                    t.join(unit.toMillis(timeout));
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    private static <T> String describeTask(Task<T> task, Target<T> target) {
        return "periodic task " + task.getClass().getSimpleName() + " with target " + target.get();
    }

    public static final class RunnableTask
    implements Task<Runnable> {
        public static final RunnableTask INSTANCE = new RunnableTask();

        @Override
        public void run(Runnable target) {
            target.run();
        }
    }

    public static interface Task<T> {
        public void run(T var1);
    }

    public static class Scheduled<T>
    implements Target<T> {
        private volatile T referent;

        private Scheduled(T referent) {
            this.referent = referent;
        }

        @Override
        public T get() {
            return this.referent;
        }

        public void cancel() {
            this.referent = null;
        }
    }

    public static interface Target<T> {
        public T get();
    }

    private static final class WeakTarget<T>
    extends WeakReference<T>
    implements Target<T> {
        private WeakTarget(T referent) {
            super(referent);
        }
    }

    private final class Worker
    implements Runnable {
        private Worker() {
        }

        @Override
        public void run() {
            while (!AgentTaskScheduler.this.shutdown) {
                PeriodicTask work = null;
                try {
                    work = (PeriodicTask)AgentTaskScheduler.this.workQueue.take();
                    work.run();
                }
                catch (Throwable e) {
                    if (work == null) continue;
                    log.debug("Uncaught exception from {}", (Object)work, (Object)e);
                }
                finally {
                    if (work == null || !work.reschedule()) continue;
                    AgentTaskScheduler.this.workQueue.offer(work);
                }
            }
            AgentTaskScheduler.this.workQueue.clear();
            AgentTaskScheduler.this.worker = null;
        }
    }

    private final class ShutdownHook
    extends Thread {
        ShutdownHook() {
            super(AgentThreadFactory.AGENT_THREAD_GROUP, AgentTaskScheduler.this.agentThread.threadName + "-shutdown-hook");
        }

        @Override
        public void run() {
            AgentTaskScheduler.this.shutdown(5L, TimeUnit.SECONDS);
        }
    }

    private static final class PeriodicTask<T>
    implements Delayed {
        private final Task<T> task;
        private final Target<T> target;
        private final long period;
        private final int taskSequence;
        private long nextFireTime;

        public PeriodicTask(Task<T> task, Target<T> target, long initialDelay, long period, TimeUnit unit) {
            this.task = task;
            this.target = target;
            this.period = unit.toNanos(period);
            this.taskSequence = TASK_SEQUENCE_GENERATOR.getAndIncrement();
            this.nextFireTime = System.nanoTime() + unit.toNanos(initialDelay);
        }

        public void run() {
            T t = this.target.get();
            if (t != null) {
                this.task.run(t);
            }
        }

        public boolean reschedule() {
            if (this.period > 0L && this.target.get() != null) {
                this.nextFireTime += this.period;
                return true;
            }
            return false;
        }

        @Override
        public long getDelay(TimeUnit unit) {
            return unit.convert(this.nextFireTime - System.nanoTime(), TimeUnit.NANOSECONDS);
        }

        @Override
        public int compareTo(Delayed other) {
            long taskOrder;
            if (this == other) {
                return 0;
            }
            if (other instanceof PeriodicTask) {
                PeriodicTask otherTask = (PeriodicTask)other;
                taskOrder = this.nextFireTime - otherTask.nextFireTime;
                if (taskOrder == 0L) {
                    taskOrder = this.taskSequence - otherTask.taskSequence;
                }
            } else {
                taskOrder = this.getDelay(TimeUnit.NANOSECONDS) - other.getDelay(TimeUnit.NANOSECONDS);
            }
            return taskOrder < 0L ? -1 : (taskOrder > 0L ? 1 : 0);
        }

        public boolean equals(Object obj) {
            try {
                return obj == null ? false : this.compareTo((Delayed)obj) == 0;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        public String toString() {
            return AgentTaskScheduler.describeTask(this.task, this.target);
        }
    }
}

