/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.webview.internal;

import androidx.annotation.WorkerThread;
import com.datadog.android.api.InternalLogger;
import com.datadog.android.webview.internal.WebViewEventConsumer;
import com.datadog.android.webview.internal.log.WebViewLogEventConsumer;
import com.datadog.android.webview.internal.replay.WebViewReplayEventConsumer;
import com.datadog.android.webview.internal.rum.WebViewRumEventConsumer;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00122\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0012BC\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00040\u0001\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0001\u0012\u0018\u0010\u0006\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00020\u00070\u0001\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0002H\u0017R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u0006\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00020\u00070\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00040\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\f\u00a8\u0006\u0013"}, d2={"Lcom/datadog/android/webview/internal/MixedWebViewEventConsumer;", "Lcom/datadog/android/webview/internal/WebViewEventConsumer;", "", "rumEventConsumer", "Lcom/google/gson/JsonObject;", "replayEventConsumer", "logsEventConsumer", "Lkotlin/Pair;", "internalLogger", "Lcom/datadog/android/api/InternalLogger;", "(Lcom/datadog/android/webview/internal/WebViewEventConsumer;Lcom/datadog/android/webview/internal/WebViewEventConsumer;Lcom/datadog/android/webview/internal/WebViewEventConsumer;Lcom/datadog/android/api/InternalLogger;)V", "getLogsEventConsumer$dd_sdk_android_webview_release", "()Lcom/datadog/android/webview/internal/WebViewEventConsumer;", "getReplayEventConsumer$dd_sdk_android_webview_release", "getRumEventConsumer$dd_sdk_android_webview_release", "consume", "", "event", "Companion", "dd-sdk-android-webview_release"})
public final class MixedWebViewEventConsumer
implements WebViewEventConsumer<String> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final WebViewEventConsumer<JsonObject> rumEventConsumer;
    @NotNull
    private final WebViewEventConsumer<JsonObject> replayEventConsumer;
    @NotNull
    private final WebViewEventConsumer<Pair<JsonObject, String>> logsEventConsumer;
    @NotNull
    private final InternalLogger internalLogger;
    @NotNull
    public static final String EVENT_TYPE_KEY = "eventType";
    @NotNull
    public static final String EVENT_KEY = "event";
    @NotNull
    public static final String LOG_EVENT_TYPE = "log";
    @NotNull
    public static final String WEB_EVENT_PARSING_ERROR_MESSAGE = "We could not deserialize the delegated browser event: %s.";
    @NotNull
    public static final String WEB_EVENT_MISSING_TYPE_ERROR_MESSAGE = "The web event: %s is missing the event type.";
    @NotNull
    public static final String WEB_EVENT_MISSING_WRAPPED_EVENT = "The web event: %s is missing the wrapped event object.";
    @NotNull
    public static final String WRONG_EVENT_TYPE_ERROR_MESSAGE = "The event type %s for the bundled web event is unknown.";

    public MixedWebViewEventConsumer(@NotNull WebViewEventConsumer<JsonObject> rumEventConsumer, @NotNull WebViewEventConsumer<JsonObject> replayEventConsumer, @NotNull WebViewEventConsumer<Pair<JsonObject, String>> logsEventConsumer, @NotNull InternalLogger internalLogger) {
        Intrinsics.checkNotNullParameter(rumEventConsumer, (String)"rumEventConsumer");
        Intrinsics.checkNotNullParameter(replayEventConsumer, (String)"replayEventConsumer");
        Intrinsics.checkNotNullParameter(logsEventConsumer, (String)"logsEventConsumer");
        Intrinsics.checkNotNullParameter((Object)internalLogger, (String)"internalLogger");
        this.rumEventConsumer = rumEventConsumer;
        this.replayEventConsumer = replayEventConsumer;
        this.logsEventConsumer = logsEventConsumer;
        this.internalLogger = internalLogger;
    }

    @NotNull
    public final WebViewEventConsumer<JsonObject> getRumEventConsumer$dd_sdk_android_webview_release() {
        return this.rumEventConsumer;
    }

    @NotNull
    public final WebViewEventConsumer<JsonObject> getReplayEventConsumer$dd_sdk_android_webview_release() {
        return this.replayEventConsumer;
    }

    @NotNull
    public final WebViewEventConsumer<Pair<JsonObject, String>> getLogsEventConsumer$dd_sdk_android_webview_release() {
        return this.logsEventConsumer;
    }

    @Override
    @WorkerThread
    public void consume(@NotNull String event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)EVENT_KEY);
        try {
            JsonObject webEvent = JsonParser.parseString((String)event).getAsJsonObject();
            if (!webEvent.has(EVENT_TYPE_KEY)) {
                Object[] objectArray = new InternalLogger.Target[]{InternalLogger.Target.MAINTAINER, InternalLogger.Target.TELEMETRY};
                InternalLogger.DefaultImpls.log$default((InternalLogger)this.internalLogger, (InternalLogger.Level)InternalLogger.Level.ERROR, (List)CollectionsKt.listOf((Object[])objectArray), (Function0)((Function0)new Function0<String>(event){
                    final /* synthetic */ String $event;
                    {
                        this.$event = $event;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        String string = "The web event: %s is missing the event type.";
                        Locale locale = Locale.US;
                        Object[] objectArray = new Object[]{this.$event};
                        String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
                        return string2;
                    }
                }), null, (boolean)false, null, (int)56, null);
                return;
            }
            if (!webEvent.has(EVENT_KEY)) {
                Object[] objectArray = new InternalLogger.Target[]{InternalLogger.Target.MAINTAINER, InternalLogger.Target.TELEMETRY};
                InternalLogger.DefaultImpls.log$default((InternalLogger)this.internalLogger, (InternalLogger.Level)InternalLogger.Level.ERROR, (List)CollectionsKt.listOf((Object[])objectArray), (Function0)((Function0)new Function0<String>(event){
                    final /* synthetic */ String $event;
                    {
                        this.$event = $event;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        String string = "The web event: %s is missing the wrapped event object.";
                        Locale locale = Locale.US;
                        Object[] objectArray = new Object[]{this.$event};
                        String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
                        return string2;
                    }
                }), null, (boolean)false, null, (int)56, null);
                return;
            }
            String eventType = webEvent.get(EVENT_TYPE_KEY).getAsString();
            JsonObject wrappedEvent = webEvent.get(EVENT_KEY).getAsJsonObject();
            String string = eventType;
            if (WebViewLogEventConsumer.Companion.getLOG_EVENT_TYPES().contains(string)) {
                this.logsEventConsumer.consume((Pair<JsonObject, String>)TuplesKt.to((Object)wrappedEvent, (Object)eventType));
            } else if (WebViewRumEventConsumer.Companion.getRUM_EVENT_TYPES().contains(string)) {
                Intrinsics.checkNotNullExpressionValue((Object)wrappedEvent, (String)"wrappedEvent");
                this.rumEventConsumer.consume(wrappedEvent);
            } else if (WebViewReplayEventConsumer.Companion.getREPLAY_EVENT_TYPES().contains(string)) {
                Intrinsics.checkNotNullExpressionValue((Object)webEvent, (String)"webEvent");
                this.replayEventConsumer.consume(webEvent);
            } else {
                InternalLogger.DefaultImpls.log$default((InternalLogger)this.internalLogger, (InternalLogger.Level)InternalLogger.Level.ERROR, (InternalLogger.Target)InternalLogger.Target.MAINTAINER, (Function0)((Function0)new Function0<String>(eventType){
                    final /* synthetic */ String $eventType;
                    {
                        this.$eventType = $eventType;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        String string = "The event type %s for the bundled web event is unknown.";
                        Locale locale = Locale.US;
                        Object[] objectArray = new Object[]{this.$eventType};
                        String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
                        return string2;
                    }
                }), null, (boolean)false, null, (int)56, null);
            }
        }
        catch (JsonParseException e) {
            Object[] objectArray = new InternalLogger.Target[]{InternalLogger.Target.MAINTAINER, InternalLogger.Target.TELEMETRY};
            InternalLogger.DefaultImpls.log$default((InternalLogger)this.internalLogger, (InternalLogger.Level)InternalLogger.Level.ERROR, (List)CollectionsKt.listOf((Object[])objectArray), (Function0)((Function0)new Function0<String>(event){
                final /* synthetic */ String $event;
                {
                    this.$event = $event;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    String string = "We could not deserialize the delegated browser event: %s.";
                    Locale locale = Locale.US;
                    Object[] objectArray = new Object[]{this.$event};
                    String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
                    return string2;
                }
            }), (Throwable)e, (boolean)false, null, (int)48, null);
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/datadog/android/webview/internal/MixedWebViewEventConsumer$Companion;", "", "()V", "EVENT_KEY", "", "EVENT_TYPE_KEY", "LOG_EVENT_TYPE", "WEB_EVENT_MISSING_TYPE_ERROR_MESSAGE", "WEB_EVENT_MISSING_WRAPPED_EVENT", "WEB_EVENT_PARSING_ERROR_MESSAGE", "WRONG_EVENT_TYPE_ERROR_MESSAGE", "dd-sdk-android-webview_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

