/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.webview.internal.log;

import com.datadog.android.api.InternalLogger;
import com.datadog.android.api.context.DatadogContext;
import com.datadog.android.api.feature.FeatureScope;
import com.datadog.android.api.feature.FeatureSdkCore;
import com.datadog.android.api.storage.DataWriter;
import com.datadog.android.api.storage.EventBatchWriter;
import com.datadog.android.api.storage.EventType;
import com.datadog.android.core.sampling.RateBasedSampler;
import com.datadog.android.core.sampling.Sampler;
import com.datadog.android.webview.internal.WebViewEventConsumer;
import com.datadog.android.webview.internal.log.WebViewLogEventConsumer;
import com.datadog.android.webview.internal.rum.WebViewRumEventContextProvider;
import com.datadog.android.webview.internal.rum.domain.RumContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u001e2\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00020\u0001:\u0001\u001eB+\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0018\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u001c\u0010\u0019\u001a\u00020\u00102\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002H\u0016J\u0018\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\"\u0010\u001b\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001f"}, d2={"Lcom/datadog/android/webview/internal/log/WebViewLogEventConsumer;", "Lcom/datadog/android/webview/internal/WebViewEventConsumer;", "Lkotlin/Pair;", "Lcom/google/gson/JsonObject;", "", "sdkCore", "Lcom/datadog/android/api/feature/FeatureSdkCore;", "userLogsWriter", "Lcom/datadog/android/api/storage/DataWriter;", "rumContextProvider", "Lcom/datadog/android/webview/internal/rum/WebViewRumEventContextProvider;", "sampleRate", "", "(Lcom/datadog/android/api/feature/FeatureSdkCore;Lcom/datadog/android/api/storage/DataWriter;Lcom/datadog/android/webview/internal/rum/WebViewRumEventContextProvider;F)V", "sampler", "Lcom/datadog/android/core/sampling/Sampler;", "", "getSampler", "()Lcom/datadog/android/core/sampling/Sampler;", "getUserLogsWriter$dd_sdk_android_webview_release", "()Lcom/datadog/android/api/storage/DataWriter;", "addDdTags", "event", "datadogContext", "Lcom/datadog/android/api/context/DatadogContext;", "consume", "correctDate", "map", "rumContext", "Lcom/datadog/android/webview/internal/rum/domain/RumContext;", "Companion", "dd-sdk-android-webview_release"})
public final class WebViewLogEventConsumer
implements WebViewEventConsumer<Pair<? extends JsonObject, ? extends String>> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FeatureSdkCore sdkCore;
    @NotNull
    private final DataWriter<JsonObject> userLogsWriter;
    @NotNull
    private final WebViewRumEventContextProvider rumContextProvider;
    @NotNull
    private final Sampler<Unit> sampler;
    @NotNull
    public static final String DDTAGS_SEPARATOR = ",";
    @NotNull
    public static final String DDTAGS_KEY_NAME = "ddtags";
    @NotNull
    public static final String DATE_KEY_NAME = "date";
    @NotNull
    public static final String USER_LOG_EVENT_TYPE = "log";
    @NotNull
    public static final String INTERNAL_LOG_EVENT_TYPE = "internal_log";
    @NotNull
    public static final String JSON_PARSING_ERROR_MESSAGE = "The bundled web log event could not be deserialized";
    @NotNull
    private static final Set<String> LOG_EVENT_TYPES = SetsKt.setOf((Object)"log");
    public static final float DEFAULT_SAMPLE_RATE = 100.0f;

    public WebViewLogEventConsumer(@NotNull FeatureSdkCore sdkCore, @NotNull DataWriter<JsonObject> userLogsWriter, @NotNull WebViewRumEventContextProvider rumContextProvider, float sampleRate) {
        Intrinsics.checkNotNullParameter((Object)sdkCore, (String)"sdkCore");
        Intrinsics.checkNotNullParameter(userLogsWriter, (String)"userLogsWriter");
        Intrinsics.checkNotNullParameter((Object)rumContextProvider, (String)"rumContextProvider");
        this.sdkCore = sdkCore;
        this.userLogsWriter = userLogsWriter;
        this.rumContextProvider = rumContextProvider;
        this.sampler = (Sampler)new RateBasedSampler(sampleRate);
    }

    @NotNull
    public final DataWriter<JsonObject> getUserLogsWriter$dd_sdk_android_webview_release() {
        return this.userLogsWriter;
    }

    @NotNull
    public final Sampler<Unit> getSampler() {
        return this.sampler;
    }

    @Override
    public void consume(@NotNull Pair<JsonObject, String> event) {
        FeatureScope featureScope;
        Intrinsics.checkNotNullParameter(event, (String)"event");
        if (Intrinsics.areEqual((Object)event.getSecond(), (Object)USER_LOG_EVENT_TYPE) && this.sampler.sample((Object)Unit.INSTANCE) && (featureScope = this.sdkCore.getFeature("web-logs")) != null) {
            FeatureScope.DefaultImpls.withWriteContext$default((FeatureScope)featureScope, (boolean)false, (Function2)((Function2)new Function2<DatadogContext, EventBatchWriter, Unit>(this, event){
                final /* synthetic */ WebViewLogEventConsumer this$0;
                final /* synthetic */ Pair<JsonObject, String> $event;
                {
                    this.this$0 = $receiver;
                    this.$event = $event;
                    super(2);
                }

                public final void invoke(@NotNull DatadogContext datadogContext, @NotNull EventBatchWriter eventBatchWriter) {
                    Intrinsics.checkNotNullParameter((Object)datadogContext, (String)"datadogContext");
                    Intrinsics.checkNotNullParameter((Object)eventBatchWriter, (String)"eventBatchWriter");
                    RumContext rumContext = WebViewLogEventConsumer.access$getRumContextProvider$p(this.this$0).getRumContext(datadogContext);
                    JsonObject mappedEvent = WebViewLogEventConsumer.access$map(this.this$0, (JsonObject)this.$event.getFirst(), datadogContext, rumContext);
                    this.this$0.getUserLogsWriter$dd_sdk_android_webview_release().write(eventBatchWriter, (Object)mappedEvent, EventType.DEFAULT);
                }
            }), (int)1, null);
        }
    }

    private final JsonObject map(JsonObject event, DatadogContext datadogContext, RumContext rumContext) {
        this.addDdTags(event, datadogContext);
        this.correctDate(event, datadogContext);
        if (rumContext != null) {
            event.addProperty("application_id", rumContext.getApplicationId());
            event.addProperty("session_id", rumContext.getSessionId());
        }
        return event;
    }

    private final void correctDate(JsonObject event, DatadogContext datadogContext) {
        try {
            JsonElement jsonElement = event.get(DATE_KEY_NAME);
            if (jsonElement != null) {
                long it = jsonElement.getAsLong();
                boolean bl = false;
                event.addProperty(DATE_KEY_NAME, (Number)(it + datadogContext.getTime().getServerTimeOffsetMs()));
            }
        }
        catch (ClassCastException e) {
            Object[] objectArray = new InternalLogger.Target[]{InternalLogger.Target.MAINTAINER, InternalLogger.Target.TELEMETRY};
            InternalLogger.DefaultImpls.log$default((InternalLogger)this.sdkCore.getInternalLogger(), (InternalLogger.Level)InternalLogger.Level.ERROR, (List)CollectionsKt.listOf((Object[])objectArray), (Function0)correctDate.2.INSTANCE, (Throwable)e, (boolean)false, null, (int)48, null);
        }
        catch (IllegalStateException e) {
            Object[] objectArray = new InternalLogger.Target[]{InternalLogger.Target.MAINTAINER, InternalLogger.Target.TELEMETRY};
            InternalLogger.DefaultImpls.log$default((InternalLogger)this.sdkCore.getInternalLogger(), (InternalLogger.Level)InternalLogger.Level.ERROR, (List)CollectionsKt.listOf((Object[])objectArray), (Function0)correctDate.3.INSTANCE, (Throwable)e, (boolean)false, null, (int)48, null);
        }
        catch (NumberFormatException e) {
            Object[] objectArray = new InternalLogger.Target[]{InternalLogger.Target.MAINTAINER, InternalLogger.Target.TELEMETRY};
            InternalLogger.DefaultImpls.log$default((InternalLogger)this.sdkCore.getInternalLogger(), (InternalLogger.Level)InternalLogger.Level.ERROR, (List)CollectionsKt.listOf((Object[])objectArray), (Function0)correctDate.4.INSTANCE, (Throwable)e, (boolean)false, null, (int)48, null);
        }
        catch (UnsupportedOperationException e) {
            Object[] objectArray = new InternalLogger.Target[]{InternalLogger.Target.MAINTAINER, InternalLogger.Target.TELEMETRY};
            InternalLogger.DefaultImpls.log$default((InternalLogger)this.sdkCore.getInternalLogger(), (InternalLogger.Level)InternalLogger.Level.ERROR, (List)CollectionsKt.listOf((Object[])objectArray), (Function0)correctDate.5.INSTANCE, (Throwable)e, (boolean)false, null, (int)48, null);
        }
    }

    private final void addDdTags(JsonObject event, DatadogContext datadogContext) {
        String sdkDdTags = "version:" + datadogContext.getVersion() + ",env:" + datadogContext.getEnv();
        String eventDdTags = null;
        try {
            JsonElement jsonElement = event.get(DDTAGS_KEY_NAME);
            eventDdTags = jsonElement != null ? jsonElement.getAsString() : null;
        }
        catch (ClassCastException e) {
            Object[] objectArray = new InternalLogger.Target[]{InternalLogger.Target.MAINTAINER, InternalLogger.Target.TELEMETRY};
            InternalLogger.DefaultImpls.log$default((InternalLogger)this.sdkCore.getInternalLogger(), (InternalLogger.Level)InternalLogger.Level.ERROR, (List)CollectionsKt.listOf((Object[])objectArray), (Function0)addDdTags.1.INSTANCE, (Throwable)e, (boolean)false, null, (int)48, null);
        }
        catch (IllegalStateException e) {
            Object[] objectArray = new InternalLogger.Target[]{InternalLogger.Target.MAINTAINER, InternalLogger.Target.TELEMETRY};
            InternalLogger.DefaultImpls.log$default((InternalLogger)this.sdkCore.getInternalLogger(), (InternalLogger.Level)InternalLogger.Level.ERROR, (List)CollectionsKt.listOf((Object[])objectArray), (Function0)addDdTags.2.INSTANCE, (Throwable)e, (boolean)false, null, (int)48, null);
        }
        catch (UnsupportedOperationException e) {
            Object[] objectArray = new InternalLogger.Target[]{InternalLogger.Target.MAINTAINER, InternalLogger.Target.TELEMETRY};
            InternalLogger.DefaultImpls.log$default((InternalLogger)this.sdkCore.getInternalLogger(), (InternalLogger.Level)InternalLogger.Level.ERROR, (List)CollectionsKt.listOf((Object[])objectArray), (Function0)addDdTags.3.INSTANCE, (Throwable)e, (boolean)false, null, (int)48, null);
        }
        CharSequence charSequence = eventDdTags;
        if (charSequence == null || charSequence.length() == 0) {
            event.addProperty(DDTAGS_KEY_NAME, sdkDdTags);
        } else {
            event.addProperty(DDTAGS_KEY_NAME, sdkDdTags + DDTAGS_SEPARATOR + eventDdTags);
        }
    }

    public static final /* synthetic */ WebViewRumEventContextProvider access$getRumContextProvider$p(WebViewLogEventConsumer $this) {
        return $this.rumContextProvider;
    }

    public static final /* synthetic */ JsonObject access$map(WebViewLogEventConsumer $this, JsonObject event, DatadogContext datadogContext, RumContext rumContext) {
        return $this.map(event, datadogContext, rumContext);
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/datadog/android/webview/internal/log/WebViewLogEventConsumer$Companion;", "", "()V", "DATE_KEY_NAME", "", "DDTAGS_KEY_NAME", "DDTAGS_SEPARATOR", "DEFAULT_SAMPLE_RATE", "", "INTERNAL_LOG_EVENT_TYPE", "JSON_PARSING_ERROR_MESSAGE", "LOG_EVENT_TYPES", "", "getLOG_EVENT_TYPES", "()Ljava/util/Set;", "USER_LOG_EVENT_TYPE", "dd-sdk-android-webview_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Set<String> getLOG_EVENT_TYPES() {
            return LOG_EVENT_TYPES;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

