/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android;

import com.datadog.android.core.internal.net.RequestUniqueIdentifierKt;
import com.datadog.android.rum.GlobalRum;
import com.datadog.android.rum.RumMonitor;
import com.datadog.android.rum.internal.domain.event.ResourceTiming;
import com.datadog.android.rum.internal.monitor.AdvancedRumMonitor;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Call;
import okhttp3.EventListener;
import okhttp3.Handshake;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u00015B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0018\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\b\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J*\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\"H\u0016J \u0010#\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016J&\u0010\u000b\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010$\u001a\u00020\u00032\f\u0010%\u001a\b\u0012\u0004\u0012\u00020'0&H\u0016J\u0018\u0010\f\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010$\u001a\u00020\u0003H\u0016J\u0018\u0010(\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010)\u001a\u00020\u0006H\u0016J\u0010\u0010*\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0018\u0010+\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010,\u001a\u00020-H\u0016J\u0010\u0010.\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u001a\u0010/\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\b\u00100\u001a\u0004\u0018\u000101H\u0016J\u0010\u00102\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u00103\u001a\u00020\u0016H\u0002J\b\u00104\u001a\u00020\u0016H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lcom/datadog/android/DatadogEventListener;", "Lokhttp3/EventListener;", "key", "", "(Ljava/lang/String;)V", "bodyEnd", "", "bodyStart", "callStart", "connEnd", "connStart", "dnsEnd", "dnsStart", "headersEnd", "headersStart", "getKey", "()Ljava/lang/String;", "sslEnd", "sslStart", "buildTiming", "Lcom/datadog/android/rum/internal/domain/event/ResourceTiming;", "callEnd", "", "call", "Lokhttp3/Call;", "callFailed", "ioe", "Ljava/io/IOException;", "connectEnd", "inetSocketAddress", "Ljava/net/InetSocketAddress;", "proxy", "Ljava/net/Proxy;", "protocol", "Lokhttp3/Protocol;", "connectStart", "domainName", "inetAddressList", "", "Ljava/net/InetAddress;", "responseBodyEnd", "byteCount", "responseBodyStart", "responseHeadersEnd", "response", "Lokhttp3/Response;", "responseHeadersStart", "secureConnectEnd", "handshake", "Lokhttp3/Handshake;", "secureConnectStart", "sendTiming", "sendWaitForResourceTimingEvent", "Factory", "dd-sdk-android_release"})
public final class DatadogEventListener
extends EventListener {
    @NotNull
    private final String key;
    private long callStart;
    private long dnsStart;
    private long dnsEnd;
    private long connStart;
    private long connEnd;
    private long sslStart;
    private long sslEnd;
    private long headersStart;
    private long headersEnd;
    private long bodyStart;
    private long bodyEnd;

    public DatadogEventListener(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.key = key;
    }

    @NotNull
    public final String getKey() {
        return this.key;
    }

    public void callStart(@NotNull Call call) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        super.callStart(call);
        this.sendWaitForResourceTimingEvent();
        this.callStart = System.nanoTime();
    }

    public void dnsStart(@NotNull Call call, @NotNull String domainName) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter((Object)domainName, (String)"domainName");
        super.dnsStart(call, domainName);
        this.sendWaitForResourceTimingEvent();
        this.dnsStart = System.nanoTime();
    }

    public void dnsEnd(@NotNull Call call, @NotNull String domainName, @NotNull List<InetAddress> inetAddressList) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter((Object)domainName, (String)"domainName");
        Intrinsics.checkNotNullParameter(inetAddressList, (String)"inetAddressList");
        super.dnsEnd(call, domainName, inetAddressList);
        this.dnsEnd = System.nanoTime();
    }

    public void connectStart(@NotNull Call call, @NotNull InetSocketAddress inetSocketAddress, @NotNull Proxy proxy) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter((Object)inetSocketAddress, (String)"inetSocketAddress");
        Intrinsics.checkNotNullParameter((Object)proxy, (String)"proxy");
        super.connectStart(call, inetSocketAddress, proxy);
        this.sendWaitForResourceTimingEvent();
        this.connStart = System.nanoTime();
    }

    public void connectEnd(@NotNull Call call, @NotNull InetSocketAddress inetSocketAddress, @NotNull Proxy proxy, @Nullable Protocol protocol) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter((Object)inetSocketAddress, (String)"inetSocketAddress");
        Intrinsics.checkNotNullParameter((Object)proxy, (String)"proxy");
        super.connectEnd(call, inetSocketAddress, proxy, protocol);
        this.connEnd = System.nanoTime();
    }

    public void secureConnectStart(@NotNull Call call) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        super.secureConnectStart(call);
        this.sendWaitForResourceTimingEvent();
        this.sslStart = System.nanoTime();
    }

    public void secureConnectEnd(@NotNull Call call, @Nullable Handshake handshake) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        super.secureConnectEnd(call, handshake);
        this.sslEnd = System.nanoTime();
    }

    public void responseHeadersStart(@NotNull Call call) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        super.responseHeadersStart(call);
        this.sendWaitForResourceTimingEvent();
        this.headersStart = System.nanoTime();
    }

    public void responseHeadersEnd(@NotNull Call call, @NotNull Response response) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        super.responseHeadersEnd(call, response);
        this.headersEnd = System.nanoTime();
        if (response.code() >= 400) {
            this.sendTiming();
        }
    }

    public void responseBodyStart(@NotNull Call call) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        super.responseBodyStart(call);
        this.sendWaitForResourceTimingEvent();
        this.bodyStart = System.nanoTime();
    }

    public void responseBodyEnd(@NotNull Call call, long byteCount) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        super.responseBodyEnd(call, byteCount);
        this.bodyEnd = System.nanoTime();
    }

    public void callEnd(@NotNull Call call) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        super.callEnd(call);
        this.sendTiming();
    }

    public void callFailed(@NotNull Call call, @NotNull IOException ioe) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter((Object)ioe, (String)"ioe");
        super.callFailed(call, ioe);
        this.sendTiming();
    }

    private final void sendWaitForResourceTimingEvent() {
        RumMonitor rumMonitor = GlobalRum.get();
        AdvancedRumMonitor advancedRumMonitor2 = rumMonitor instanceof AdvancedRumMonitor ? (AdvancedRumMonitor)rumMonitor : null;
        if (advancedRumMonitor2 != null) {
            advancedRumMonitor2.waitForResourceTiming(this.key);
        }
    }

    private final void sendTiming() {
        ResourceTiming timing = this.buildTiming();
        RumMonitor rumMonitor = GlobalRum.get();
        AdvancedRumMonitor advancedRumMonitor2 = rumMonitor instanceof AdvancedRumMonitor ? (AdvancedRumMonitor)rumMonitor : null;
        if (advancedRumMonitor2 != null) {
            advancedRumMonitor2.addResourceTiming(this.key, timing);
        }
    }

    private final ResourceTiming buildTiming() {
        Pair pair = this.dnsStart == 0L ? TuplesKt.to((Object)0L, (Object)0L) : TuplesKt.to((Object)(this.dnsStart - this.callStart), (Object)(this.dnsEnd - this.dnsStart));
        long dnsS = ((Number)pair.component1()).longValue();
        long dnsD = ((Number)pair.component2()).longValue();
        Pair pair2 = this.connStart == 0L ? TuplesKt.to((Object)0L, (Object)0L) : TuplesKt.to((Object)(this.connStart - this.callStart), (Object)(this.connEnd - this.connStart));
        long conS = ((Number)pair2.component1()).longValue();
        long conD = ((Number)pair2.component2()).longValue();
        Pair pair3 = this.sslStart == 0L ? TuplesKt.to((Object)0L, (Object)0L) : TuplesKt.to((Object)(this.sslStart - this.callStart), (Object)(this.sslEnd - this.sslStart));
        long sslS = ((Number)pair3.component1()).longValue();
        long sslD = ((Number)pair3.component2()).longValue();
        Pair pair4 = this.headersStart == 0L ? TuplesKt.to((Object)0L, (Object)0L) : TuplesKt.to((Object)(this.headersStart - this.callStart), (Object)(this.headersEnd - this.headersStart));
        long fbS = ((Number)pair4.component1()).longValue();
        long fbD = ((Number)pair4.component2()).longValue();
        Pair pair5 = this.bodyStart == 0L ? TuplesKt.to((Object)0L, (Object)0L) : TuplesKt.to((Object)(this.bodyStart - this.callStart), (Object)(this.bodyEnd - this.bodyStart));
        long dlS = ((Number)pair5.component1()).longValue();
        long dlD = ((Number)pair5.component2()).longValue();
        return new ResourceTiming(dnsS, dnsD, conS, conD, sslS, sslD, fbS, fbD, dlS, dlD);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/datadog/android/DatadogEventListener$Factory;", "Lokhttp3/EventListener$Factory;", "()V", "create", "Lokhttp3/EventListener;", "call", "Lokhttp3/Call;", "dd-sdk-android_release"})
    public static final class Factory
    implements EventListener.Factory {
        @NotNull
        public EventListener create(@NotNull Call call) {
            Intrinsics.checkNotNullParameter((Object)call, (String)"call");
            Request request = call.request();
            Intrinsics.checkNotNullExpressionValue((Object)request, (String)"call.request()");
            String key = RequestUniqueIdentifierKt.identifyRequest(request);
            return new DatadogEventListener(key);
        }
    }
}

