/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.core.configuration;

import android.os.Build;
import androidx.annotation.FloatRange;
import com.datadog.android.DatadogSite;
import com.datadog.android.core.configuration.BatchSize;
import com.datadog.android.core.configuration.Configuration;
import com.datadog.android.core.configuration.HostsSanitizer;
import com.datadog.android.core.configuration.UploadFrequency;
import com.datadog.android.core.configuration.VitalsUpdateFrequency;
import com.datadog.android.core.internal.event.NoOpEventMapper;
import com.datadog.android.core.internal.utils.RuntimeUtilsKt;
import com.datadog.android.event.EventMapper;
import com.datadog.android.event.NoOpSpanEventMapper;
import com.datadog.android.event.SpanEventMapper;
import com.datadog.android.event.ViewEventMapper;
import com.datadog.android.log.model.LogEvent;
import com.datadog.android.plugin.DatadogPlugin;
import com.datadog.android.rum.internal.domain.event.RumEventMapper;
import com.datadog.android.rum.internal.instrumentation.MainLooperLongTaskStrategy;
import com.datadog.android.rum.internal.instrumentation.UserActionTrackingStrategyApi29;
import com.datadog.android.rum.internal.instrumentation.UserActionTrackingStrategyLegacy;
import com.datadog.android.rum.internal.instrumentation.gestures.DatadogGesturesTracker;
import com.datadog.android.rum.internal.tracking.JetpackViewAttributesProvider;
import com.datadog.android.rum.internal.tracking.NoOpUserActionTrackingStrategy;
import com.datadog.android.rum.internal.tracking.UserActionTrackingStrategy;
import com.datadog.android.rum.model.ActionEvent;
import com.datadog.android.rum.model.ErrorEvent;
import com.datadog.android.rum.model.LongTaskEvent;
import com.datadog.android.rum.model.ResourceEvent;
import com.datadog.android.rum.tracking.ActivityViewTrackingStrategy;
import com.datadog.android.rum.tracking.InteractionPredicate;
import com.datadog.android.rum.tracking.NoOpInteractionPredicate;
import com.datadog.android.rum.tracking.TrackingStrategy;
import com.datadog.android.rum.tracking.ViewAttributesProvider;
import com.datadog.android.rum.tracking.ViewTrackingStrategy;
import com.datadog.android.security.Encryption;
import com.datadog.android.sessionreplay.SessionReplayPrivacy;
import com.datadog.android.telemetry.model.TelemetryConfigurationEvent;
import com.datadog.android.tracing.TracingHeaderType;
import com.datadog.android.v2.api.InternalLogger;
import java.net.Proxy;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import okhttp3.Authenticator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u001b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\b\u0086\b\u0018\u0000 02\u00020\u0001:\u0004/012BK\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00010\r\u00a2\u0006\u0002\u0010\u000fJ\u000e\u0010\u001c\u001a\u00020\u0003H\u00c0\u0003\u00a2\u0006\u0002\b\u001dJ\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u0005H\u00c0\u0003\u00a2\u0006\u0002\b\u001fJ\u0010\u0010 \u001a\u0004\u0018\u00010\u0007H\u00c0\u0003\u00a2\u0006\u0002\b!J\u0010\u0010\"\u001a\u0004\u0018\u00010\tH\u00c0\u0003\u00a2\u0006\u0002\b#J\u0010\u0010$\u001a\u0004\u0018\u00010\u000bH\u00c0\u0003\u00a2\u0006\u0002\b%J\u001a\u0010&\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00010\rH\u00c0\u0003\u00a2\u0006\u0002\b'JY\u0010(\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0014\b\u0002\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00010\rH\u00c6\u0001J\u0013\u0010)\u001a\u00020*2\b\u0010+\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010,\u001a\u00020-H\u00d6\u0001J\t\u0010.\u001a\u00020\u000eH\u00d6\u0001R \u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00010\rX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0016\u0010\b\u001a\u0004\u0018\u00010\tX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0016\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u00a8\u00063"}, d2={"Lcom/datadog/android/core/configuration/Configuration;", "", "coreConfig", "Lcom/datadog/android/core/configuration/Configuration$Core;", "logsConfig", "Lcom/datadog/android/core/configuration/Configuration$Feature$Logs;", "tracesConfig", "Lcom/datadog/android/core/configuration/Configuration$Feature$Tracing;", "crashReportConfig", "Lcom/datadog/android/core/configuration/Configuration$Feature$CrashReport;", "rumConfig", "Lcom/datadog/android/core/configuration/Configuration$Feature$RUM;", "additionalConfig", "", "", "(Lcom/datadog/android/core/configuration/Configuration$Core;Lcom/datadog/android/core/configuration/Configuration$Feature$Logs;Lcom/datadog/android/core/configuration/Configuration$Feature$Tracing;Lcom/datadog/android/core/configuration/Configuration$Feature$CrashReport;Lcom/datadog/android/core/configuration/Configuration$Feature$RUM;Ljava/util/Map;)V", "getAdditionalConfig$dd_sdk_android_release", "()Ljava/util/Map;", "getCoreConfig$dd_sdk_android_release", "()Lcom/datadog/android/core/configuration/Configuration$Core;", "getCrashReportConfig$dd_sdk_android_release", "()Lcom/datadog/android/core/configuration/Configuration$Feature$CrashReport;", "getLogsConfig$dd_sdk_android_release", "()Lcom/datadog/android/core/configuration/Configuration$Feature$Logs;", "getRumConfig$dd_sdk_android_release", "()Lcom/datadog/android/core/configuration/Configuration$Feature$RUM;", "getTracesConfig$dd_sdk_android_release", "()Lcom/datadog/android/core/configuration/Configuration$Feature$Tracing;", "component1", "component1$dd_sdk_android_release", "component2", "component2$dd_sdk_android_release", "component3", "component3$dd_sdk_android_release", "component4", "component4$dd_sdk_android_release", "component5", "component5$dd_sdk_android_release", "component6", "component6$dd_sdk_android_release", "copy", "equals", "", "other", "hashCode", "", "toString", "Builder", "Companion", "Core", "Feature", "dd-sdk-android_release"})
public final class Configuration {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Core coreConfig;
    @Nullable
    private final Feature.Logs logsConfig;
    @Nullable
    private final Feature.Tracing tracesConfig;
    @Nullable
    private final Feature.CrashReport crashReportConfig;
    @Nullable
    private final Feature.RUM rumConfig;
    @NotNull
    private final Map<String, Object> additionalConfig;
    public static final float DEFAULT_SAMPLING_RATE = 100.0f;
    public static final float DEFAULT_TELEMETRY_SAMPLING_RATE = 20.0f;
    public static final float DEFAULT_TELEMETRY_CONFIGURATION_SAMPLING_RATE = 20.0f;
    public static final long DEFAULT_LONG_TASK_THRESHOLD_MS = 100L;
    @NotNull
    public static final String PLUGINS_DEPRECATED_WARN_MESSAGE = "Datadog Plugins will be removed in SDK v2.0.0. You will then need to write your own Feature (check our own code for guidance).";
    @NotNull
    private static final Core DEFAULT_CORE_CONFIG;
    @NotNull
    private static final Feature.Logs DEFAULT_LOGS_CONFIG;
    @NotNull
    private static final Feature.CrashReport DEFAULT_CRASH_CONFIG;
    @NotNull
    private static final Feature.Tracing DEFAULT_TRACING_CONFIG;
    @NotNull
    private static final Feature.RUM DEFAULT_RUM_CONFIG;
    @NotNull
    public static final String ERROR_FEATURE_DISABLED = "The %s feature has been disabled in your Configuration.Builder, but you're trying to edit the RUM configuration with the %s() method.";
    @NotNull
    public static final String WEB_VIEW_TRACKING_FEATURE_NAME = "WebView";
    @NotNull
    public static final String NETWORK_REQUESTS_TRACKING_FEATURE_NAME = "Network requests";

    public Configuration(@NotNull Core coreConfig, @Nullable Feature.Logs logsConfig, @Nullable Feature.Tracing tracesConfig, @Nullable Feature.CrashReport crashReportConfig, @Nullable Feature.RUM rumConfig, @NotNull Map<String, ? extends Object> additionalConfig) {
        Intrinsics.checkNotNullParameter((Object)coreConfig, (String)"coreConfig");
        Intrinsics.checkNotNullParameter(additionalConfig, (String)"additionalConfig");
        this.coreConfig = coreConfig;
        this.logsConfig = logsConfig;
        this.tracesConfig = tracesConfig;
        this.crashReportConfig = crashReportConfig;
        this.rumConfig = rumConfig;
        this.additionalConfig = additionalConfig;
    }

    @NotNull
    public final Core getCoreConfig$dd_sdk_android_release() {
        return this.coreConfig;
    }

    @Nullable
    public final Feature.Logs getLogsConfig$dd_sdk_android_release() {
        return this.logsConfig;
    }

    @Nullable
    public final Feature.Tracing getTracesConfig$dd_sdk_android_release() {
        return this.tracesConfig;
    }

    @Nullable
    public final Feature.CrashReport getCrashReportConfig$dd_sdk_android_release() {
        return this.crashReportConfig;
    }

    @Nullable
    public final Feature.RUM getRumConfig$dd_sdk_android_release() {
        return this.rumConfig;
    }

    @NotNull
    public final Map<String, Object> getAdditionalConfig$dd_sdk_android_release() {
        return this.additionalConfig;
    }

    @NotNull
    public final Core component1$dd_sdk_android_release() {
        return this.coreConfig;
    }

    @Nullable
    public final Feature.Logs component2$dd_sdk_android_release() {
        return this.logsConfig;
    }

    @Nullable
    public final Feature.Tracing component3$dd_sdk_android_release() {
        return this.tracesConfig;
    }

    @Nullable
    public final Feature.CrashReport component4$dd_sdk_android_release() {
        return this.crashReportConfig;
    }

    @Nullable
    public final Feature.RUM component5$dd_sdk_android_release() {
        return this.rumConfig;
    }

    @NotNull
    public final Map<String, Object> component6$dd_sdk_android_release() {
        return this.additionalConfig;
    }

    @NotNull
    public final Configuration copy(@NotNull Core coreConfig, @Nullable Feature.Logs logsConfig, @Nullable Feature.Tracing tracesConfig, @Nullable Feature.CrashReport crashReportConfig, @Nullable Feature.RUM rumConfig, @NotNull Map<String, ? extends Object> additionalConfig) {
        Intrinsics.checkNotNullParameter((Object)coreConfig, (String)"coreConfig");
        Intrinsics.checkNotNullParameter(additionalConfig, (String)"additionalConfig");
        return new Configuration(coreConfig, logsConfig, tracesConfig, crashReportConfig, rumConfig, additionalConfig);
    }

    public static /* synthetic */ Configuration copy$default(Configuration configuration, Core core, Feature.Logs logs, Feature.Tracing tracing, Feature.CrashReport crashReport, Feature.RUM rUM, Map map, int n, Object object) {
        if ((n & 1) != 0) {
            core = configuration.coreConfig;
        }
        if ((n & 2) != 0) {
            logs = configuration.logsConfig;
        }
        if ((n & 4) != 0) {
            tracing = configuration.tracesConfig;
        }
        if ((n & 8) != 0) {
            crashReport = configuration.crashReportConfig;
        }
        if ((n & 0x10) != 0) {
            rUM = configuration.rumConfig;
        }
        if ((n & 0x20) != 0) {
            map = configuration.additionalConfig;
        }
        return configuration.copy(core, logs, tracing, crashReport, rUM, map);
    }

    @NotNull
    public String toString() {
        return "Configuration(coreConfig=" + this.coreConfig + ", logsConfig=" + this.logsConfig + ", tracesConfig=" + this.tracesConfig + ", crashReportConfig=" + this.crashReportConfig + ", rumConfig=" + this.rumConfig + ", additionalConfig=" + this.additionalConfig + ")";
    }

    public int hashCode() {
        int result = this.coreConfig.hashCode();
        result = result * 31 + (this.logsConfig == null ? 0 : this.logsConfig.hashCode());
        result = result * 31 + (this.tracesConfig == null ? 0 : this.tracesConfig.hashCode());
        result = result * 31 + (this.crashReportConfig == null ? 0 : this.crashReportConfig.hashCode());
        result = result * 31 + (this.rumConfig == null ? 0 : this.rumConfig.hashCode());
        result = result * 31 + ((Object)this.additionalConfig).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Configuration)) {
            return false;
        }
        Configuration configuration = (Configuration)other;
        if (!Intrinsics.areEqual((Object)this.coreConfig, (Object)configuration.coreConfig)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.logsConfig, (Object)configuration.logsConfig)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.tracesConfig, (Object)configuration.tracesConfig)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.crashReportConfig, (Object)configuration.crashReportConfig)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.rumConfig, (Object)configuration.rumConfig)) {
            return false;
        }
        return Intrinsics.areEqual(this.additionalConfig, configuration.additionalConfig);
    }

    static {
        Map map = MapsKt.emptyMap();
        Authenticator authenticator = Authenticator.NONE;
        Intrinsics.checkNotNullExpressionValue((Object)authenticator, (String)"NONE");
        DEFAULT_CORE_CONFIG = new Core(false, false, map, BatchSize.MEDIUM, UploadFrequency.AVERAGE, null, authenticator, null, CollectionsKt.emptyList(), DatadogSite.US1);
        DEFAULT_LOGS_CONFIG = new Feature.Logs(DatadogSite.US1.getIntakeEndpoint(), CollectionsKt.emptyList(), new NoOpEventMapper());
        DEFAULT_CRASH_CONFIG = new Feature.CrashReport(DatadogSite.US1.getIntakeEndpoint(), CollectionsKt.emptyList());
        DEFAULT_TRACING_CONFIG = new Feature.Tracing(DatadogSite.US1.getIntakeEndpoint(), CollectionsKt.emptyList(), new NoOpSpanEventMapper());
        boolean $i$f$emptyArray = false;
        DEFAULT_RUM_CONFIG = new Feature.RUM(DatadogSite.US1.getIntakeEndpoint(), CollectionsKt.emptyList(), 100.0f, 20.0f, 20.0f, Configuration.Companion.provideUserTrackingStrategy(new ViewAttributesProvider[0], new NoOpInteractionPredicate()), new ActivityViewTrackingStrategy(false, null, 2, null), new MainLooperLongTaskStrategy(100L), new NoOpEventMapper(), false, true, VitalsUpdateFrequency.AVERAGE);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\"\n\u0002\u0010\b\n\u0002\b\u0002\b\u0080\b\u0018\u00002\u00020\u0001Bq\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0018\u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0006\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013\u0012\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00070\u0015\u0012\u0006\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\u0002\u0010\u0018J\t\u0010,\u001a\u00020\u0003H\u00c6\u0003J\t\u0010-\u001a\u00020\u0017H\u00c6\u0003J\t\u0010.\u001a\u00020\u0003H\u00c6\u0003J\u001b\u0010/\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0006H\u00c6\u0003J\t\u00100\u001a\u00020\u000bH\u00c6\u0003J\t\u00101\u001a\u00020\rH\u00c6\u0003J\u000b\u00102\u001a\u0004\u0018\u00010\u000fH\u00c6\u0003J\t\u00103\u001a\u00020\u0011H\u00c6\u0003J\u000b\u00104\u001a\u0004\u0018\u00010\u0013H\u00c6\u0003J\u000f\u00105\u001a\b\u0012\u0004\u0012\u00020\u00070\u0015H\u00c6\u0003J\u0089\u0001\u00106\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\u001a\b\u0002\u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u00062\b\b\u0002\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\r2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u00112\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u000e\b\u0002\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00070\u00152\b\b\u0002\u0010\u0016\u001a\u00020\u0017H\u00c6\u0001J\u0013\u00107\u001a\u00020\u00032\b\u00108\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u00109\u001a\u00020:H\u00d6\u0001J\t\u0010;\u001a\u00020\u0007H\u00d6\u0001R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0013\u0010\u0012\u001a\u0004\u0018\u00010\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR#\u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u001cR\u0013\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0011\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u0017\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00070\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+\u00a8\u0006<"}, d2={"Lcom/datadog/android/core/configuration/Configuration$Core;", "", "needsClearTextHttp", "", "enableDeveloperModeWhenDebuggable", "firstPartyHostsWithHeaderTypes", "", "", "", "Lcom/datadog/android/tracing/TracingHeaderType;", "batchSize", "Lcom/datadog/android/core/configuration/BatchSize;", "uploadFrequency", "Lcom/datadog/android/core/configuration/UploadFrequency;", "proxy", "Ljava/net/Proxy;", "proxyAuth", "Lokhttp3/Authenticator;", "encryption", "Lcom/datadog/android/security/Encryption;", "webViewTrackingHosts", "", "site", "Lcom/datadog/android/DatadogSite;", "(ZZLjava/util/Map;Lcom/datadog/android/core/configuration/BatchSize;Lcom/datadog/android/core/configuration/UploadFrequency;Ljava/net/Proxy;Lokhttp3/Authenticator;Lcom/datadog/android/security/Encryption;Ljava/util/List;Lcom/datadog/android/DatadogSite;)V", "getBatchSize", "()Lcom/datadog/android/core/configuration/BatchSize;", "getEnableDeveloperModeWhenDebuggable", "()Z", "getEncryption", "()Lcom/datadog/android/security/Encryption;", "getFirstPartyHostsWithHeaderTypes", "()Ljava/util/Map;", "getNeedsClearTextHttp", "getProxy", "()Ljava/net/Proxy;", "getProxyAuth", "()Lokhttp3/Authenticator;", "getSite", "()Lcom/datadog/android/DatadogSite;", "getUploadFrequency", "()Lcom/datadog/android/core/configuration/UploadFrequency;", "getWebViewTrackingHosts", "()Ljava/util/List;", "component1", "component10", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "equals", "other", "hashCode", "", "toString", "dd-sdk-android_release"})
    public static final class Core {
        private final boolean needsClearTextHttp;
        private final boolean enableDeveloperModeWhenDebuggable;
        @NotNull
        private final Map<String, Set<TracingHeaderType>> firstPartyHostsWithHeaderTypes;
        @NotNull
        private final BatchSize batchSize;
        @NotNull
        private final UploadFrequency uploadFrequency;
        @Nullable
        private final Proxy proxy;
        @NotNull
        private final Authenticator proxyAuth;
        @Nullable
        private final Encryption encryption;
        @NotNull
        private final List<String> webViewTrackingHosts;
        @NotNull
        private final DatadogSite site;

        public Core(boolean needsClearTextHttp, boolean enableDeveloperModeWhenDebuggable, @NotNull Map<String, ? extends Set<? extends TracingHeaderType>> firstPartyHostsWithHeaderTypes, @NotNull BatchSize batchSize, @NotNull UploadFrequency uploadFrequency, @Nullable Proxy proxy, @NotNull Authenticator proxyAuth, @Nullable Encryption encryption, @NotNull List<String> webViewTrackingHosts, @NotNull DatadogSite site) {
            Intrinsics.checkNotNullParameter(firstPartyHostsWithHeaderTypes, (String)"firstPartyHostsWithHeaderTypes");
            Intrinsics.checkNotNullParameter((Object)((Object)batchSize), (String)"batchSize");
            Intrinsics.checkNotNullParameter((Object)((Object)uploadFrequency), (String)"uploadFrequency");
            Intrinsics.checkNotNullParameter((Object)proxyAuth, (String)"proxyAuth");
            Intrinsics.checkNotNullParameter(webViewTrackingHosts, (String)"webViewTrackingHosts");
            Intrinsics.checkNotNullParameter((Object)((Object)site), (String)"site");
            this.needsClearTextHttp = needsClearTextHttp;
            this.enableDeveloperModeWhenDebuggable = enableDeveloperModeWhenDebuggable;
            this.firstPartyHostsWithHeaderTypes = firstPartyHostsWithHeaderTypes;
            this.batchSize = batchSize;
            this.uploadFrequency = uploadFrequency;
            this.proxy = proxy;
            this.proxyAuth = proxyAuth;
            this.encryption = encryption;
            this.webViewTrackingHosts = webViewTrackingHosts;
            this.site = site;
        }

        public final boolean getNeedsClearTextHttp() {
            return this.needsClearTextHttp;
        }

        public final boolean getEnableDeveloperModeWhenDebuggable() {
            return this.enableDeveloperModeWhenDebuggable;
        }

        @NotNull
        public final Map<String, Set<TracingHeaderType>> getFirstPartyHostsWithHeaderTypes() {
            return this.firstPartyHostsWithHeaderTypes;
        }

        @NotNull
        public final BatchSize getBatchSize() {
            return this.batchSize;
        }

        @NotNull
        public final UploadFrequency getUploadFrequency() {
            return this.uploadFrequency;
        }

        @Nullable
        public final Proxy getProxy() {
            return this.proxy;
        }

        @NotNull
        public final Authenticator getProxyAuth() {
            return this.proxyAuth;
        }

        @Nullable
        public final Encryption getEncryption() {
            return this.encryption;
        }

        @NotNull
        public final List<String> getWebViewTrackingHosts() {
            return this.webViewTrackingHosts;
        }

        @NotNull
        public final DatadogSite getSite() {
            return this.site;
        }

        public final boolean component1() {
            return this.needsClearTextHttp;
        }

        public final boolean component2() {
            return this.enableDeveloperModeWhenDebuggable;
        }

        @NotNull
        public final Map<String, Set<TracingHeaderType>> component3() {
            return this.firstPartyHostsWithHeaderTypes;
        }

        @NotNull
        public final BatchSize component4() {
            return this.batchSize;
        }

        @NotNull
        public final UploadFrequency component5() {
            return this.uploadFrequency;
        }

        @Nullable
        public final Proxy component6() {
            return this.proxy;
        }

        @NotNull
        public final Authenticator component7() {
            return this.proxyAuth;
        }

        @Nullable
        public final Encryption component8() {
            return this.encryption;
        }

        @NotNull
        public final List<String> component9() {
            return this.webViewTrackingHosts;
        }

        @NotNull
        public final DatadogSite component10() {
            return this.site;
        }

        @NotNull
        public final Core copy(boolean needsClearTextHttp, boolean enableDeveloperModeWhenDebuggable, @NotNull Map<String, ? extends Set<? extends TracingHeaderType>> firstPartyHostsWithHeaderTypes, @NotNull BatchSize batchSize, @NotNull UploadFrequency uploadFrequency, @Nullable Proxy proxy, @NotNull Authenticator proxyAuth, @Nullable Encryption encryption, @NotNull List<String> webViewTrackingHosts, @NotNull DatadogSite site) {
            Intrinsics.checkNotNullParameter(firstPartyHostsWithHeaderTypes, (String)"firstPartyHostsWithHeaderTypes");
            Intrinsics.checkNotNullParameter((Object)((Object)batchSize), (String)"batchSize");
            Intrinsics.checkNotNullParameter((Object)((Object)uploadFrequency), (String)"uploadFrequency");
            Intrinsics.checkNotNullParameter((Object)proxyAuth, (String)"proxyAuth");
            Intrinsics.checkNotNullParameter(webViewTrackingHosts, (String)"webViewTrackingHosts");
            Intrinsics.checkNotNullParameter((Object)((Object)site), (String)"site");
            return new Core(needsClearTextHttp, enableDeveloperModeWhenDebuggable, firstPartyHostsWithHeaderTypes, batchSize, uploadFrequency, proxy, proxyAuth, encryption, webViewTrackingHosts, site);
        }

        public static /* synthetic */ Core copy$default(Core core, boolean bl, boolean bl2, Map map, BatchSize batchSize, UploadFrequency uploadFrequency, Proxy proxy, Authenticator authenticator, Encryption encryption, List list, DatadogSite datadogSite, int n, Object object) {
            if ((n & 1) != 0) {
                bl = core.needsClearTextHttp;
            }
            if ((n & 2) != 0) {
                bl2 = core.enableDeveloperModeWhenDebuggable;
            }
            if ((n & 4) != 0) {
                map = core.firstPartyHostsWithHeaderTypes;
            }
            if ((n & 8) != 0) {
                batchSize = core.batchSize;
            }
            if ((n & 0x10) != 0) {
                uploadFrequency = core.uploadFrequency;
            }
            if ((n & 0x20) != 0) {
                proxy = core.proxy;
            }
            if ((n & 0x40) != 0) {
                authenticator = core.proxyAuth;
            }
            if ((n & 0x80) != 0) {
                encryption = core.encryption;
            }
            if ((n & 0x100) != 0) {
                list = core.webViewTrackingHosts;
            }
            if ((n & 0x200) != 0) {
                datadogSite = core.site;
            }
            return core.copy(bl, bl2, map, batchSize, uploadFrequency, proxy, authenticator, encryption, list, datadogSite);
        }

        @NotNull
        public String toString() {
            return "Core(needsClearTextHttp=" + this.needsClearTextHttp + ", enableDeveloperModeWhenDebuggable=" + this.enableDeveloperModeWhenDebuggable + ", firstPartyHostsWithHeaderTypes=" + this.firstPartyHostsWithHeaderTypes + ", batchSize=" + this.batchSize + ", uploadFrequency=" + this.uploadFrequency + ", proxy=" + this.proxy + ", proxyAuth=" + this.proxyAuth + ", encryption=" + this.encryption + ", webViewTrackingHosts=" + this.webViewTrackingHosts + ", site=" + this.site + ")";
        }

        public int hashCode() {
            int n;
            int result;
            int n2 = this.needsClearTextHttp ? 1 : 0;
            if (n2 != 0) {
                n2 = result = 1;
            }
            if ((n = this.enableDeveloperModeWhenDebuggable) != 0) {
                n = 1;
            }
            result = result * 31 + n;
            result = result * 31 + ((Object)this.firstPartyHostsWithHeaderTypes).hashCode();
            result = result * 31 + this.batchSize.hashCode();
            result = result * 31 + this.uploadFrequency.hashCode();
            result = result * 31 + (this.proxy == null ? 0 : this.proxy.hashCode());
            result = result * 31 + this.proxyAuth.hashCode();
            result = result * 31 + (this.encryption == null ? 0 : this.encryption.hashCode());
            result = result * 31 + ((Object)this.webViewTrackingHosts).hashCode();
            result = result * 31 + this.site.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Core)) {
                return false;
            }
            Core core = (Core)other;
            if (this.needsClearTextHttp != core.needsClearTextHttp) {
                return false;
            }
            if (this.enableDeveloperModeWhenDebuggable != core.enableDeveloperModeWhenDebuggable) {
                return false;
            }
            if (!Intrinsics.areEqual(this.firstPartyHostsWithHeaderTypes, core.firstPartyHostsWithHeaderTypes)) {
                return false;
            }
            if (this.batchSize != core.batchSize) {
                return false;
            }
            if (this.uploadFrequency != core.uploadFrequency) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.proxy, (Object)core.proxy)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.proxyAuth, (Object)core.proxyAuth)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.encryption, (Object)core.encryption)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.webViewTrackingHosts, core.webViewTrackingHosts)) {
                return false;
            }
            return this.site == core.site;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b0\u0018\u00002\u00020\u0001:\u0005\f\r\u000e\u000f\u0010B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002R\u0012\u0010\u0003\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0018\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u0082\u0001\u0005\u0011\u0012\u0013\u0014\u0015\u00a8\u0006\u0016"}, d2={"Lcom/datadog/android/core/configuration/Configuration$Feature;", "", "()V", "endpointUrl", "", "getEndpointUrl", "()Ljava/lang/String;", "plugins", "", "Lcom/datadog/android/plugin/DatadogPlugin;", "getPlugins", "()Ljava/util/List;", "CrashReport", "Logs", "RUM", "SessionReplay", "Tracing", "Lcom/datadog/android/core/configuration/Configuration$Feature$Logs;", "Lcom/datadog/android/core/configuration/Configuration$Feature$CrashReport;", "Lcom/datadog/android/core/configuration/Configuration$Feature$Tracing;", "Lcom/datadog/android/core/configuration/Configuration$Feature$RUM;", "Lcom/datadog/android/core/configuration/Configuration$Feature$SessionReplay;", "dd-sdk-android_release"})
    public static abstract class Feature {
        private Feature() {
        }

        @NotNull
        public abstract String getEndpointUrl();

        @NotNull
        public abstract List<DatadogPlugin> getPlugins();

        public /* synthetic */ Feature(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0080\b\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J\u000f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u00c6\u0003J3\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001J\t\u0010\u001b\u001a\u00020\u0003H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001c"}, d2={"Lcom/datadog/android/core/configuration/Configuration$Feature$Logs;", "Lcom/datadog/android/core/configuration/Configuration$Feature;", "endpointUrl", "", "plugins", "", "Lcom/datadog/android/plugin/DatadogPlugin;", "logsEventMapper", "Lcom/datadog/android/event/EventMapper;", "Lcom/datadog/android/log/model/LogEvent;", "(Ljava/lang/String;Ljava/util/List;Lcom/datadog/android/event/EventMapper;)V", "getEndpointUrl", "()Ljava/lang/String;", "getLogsEventMapper", "()Lcom/datadog/android/event/EventMapper;", "getPlugins", "()Ljava/util/List;", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "", "toString", "dd-sdk-android_release"})
        public static final class Logs
        extends Feature {
            @NotNull
            private final String endpointUrl;
            @NotNull
            private final List<DatadogPlugin> plugins;
            @NotNull
            private final EventMapper<LogEvent> logsEventMapper;

            public Logs(@NotNull String endpointUrl, @NotNull List<? extends DatadogPlugin> plugins, @NotNull EventMapper<LogEvent> logsEventMapper) {
                Intrinsics.checkNotNullParameter((Object)endpointUrl, (String)"endpointUrl");
                Intrinsics.checkNotNullParameter(plugins, (String)"plugins");
                Intrinsics.checkNotNullParameter(logsEventMapper, (String)"logsEventMapper");
                super(null);
                this.endpointUrl = endpointUrl;
                this.plugins = plugins;
                this.logsEventMapper = logsEventMapper;
            }

            @Override
            @NotNull
            public String getEndpointUrl() {
                return this.endpointUrl;
            }

            @Override
            @NotNull
            public List<DatadogPlugin> getPlugins() {
                return this.plugins;
            }

            @NotNull
            public final EventMapper<LogEvent> getLogsEventMapper() {
                return this.logsEventMapper;
            }

            @NotNull
            public final String component1() {
                return this.getEndpointUrl();
            }

            @NotNull
            public final List<DatadogPlugin> component2() {
                return this.getPlugins();
            }

            @NotNull
            public final EventMapper<LogEvent> component3() {
                return this.logsEventMapper;
            }

            @NotNull
            public final Logs copy(@NotNull String endpointUrl, @NotNull List<? extends DatadogPlugin> plugins, @NotNull EventMapper<LogEvent> logsEventMapper) {
                Intrinsics.checkNotNullParameter((Object)endpointUrl, (String)"endpointUrl");
                Intrinsics.checkNotNullParameter(plugins, (String)"plugins");
                Intrinsics.checkNotNullParameter(logsEventMapper, (String)"logsEventMapper");
                return new Logs(endpointUrl, plugins, logsEventMapper);
            }

            public static /* synthetic */ Logs copy$default(Logs logs, String string, List list, EventMapper eventMapper, int n, Object object) {
                if ((n & 1) != 0) {
                    string = logs.getEndpointUrl();
                }
                if ((n & 2) != 0) {
                    list = logs.getPlugins();
                }
                if ((n & 4) != 0) {
                    eventMapper = logs.logsEventMapper;
                }
                return logs.copy(string, list, eventMapper);
            }

            @NotNull
            public String toString() {
                return "Logs(endpointUrl=" + this.getEndpointUrl() + ", plugins=" + this.getPlugins() + ", logsEventMapper=" + this.logsEventMapper + ")";
            }

            public int hashCode() {
                int result = this.getEndpointUrl().hashCode();
                result = result * 31 + ((Object)this.getPlugins()).hashCode();
                result = result * 31 + this.logsEventMapper.hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Logs)) {
                    return false;
                }
                Logs logs = (Logs)other;
                if (!Intrinsics.areEqual((Object)this.getEndpointUrl(), (Object)logs.getEndpointUrl())) {
                    return false;
                }
                if (!Intrinsics.areEqual(this.getPlugins(), logs.getPlugins())) {
                    return false;
                }
                return Intrinsics.areEqual(this.logsEventMapper, logs.logsEventMapper);
            }
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0080\b\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J#\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0003H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lcom/datadog/android/core/configuration/Configuration$Feature$CrashReport;", "Lcom/datadog/android/core/configuration/Configuration$Feature;", "endpointUrl", "", "plugins", "", "Lcom/datadog/android/plugin/DatadogPlugin;", "(Ljava/lang/String;Ljava/util/List;)V", "getEndpointUrl", "()Ljava/lang/String;", "getPlugins", "()Ljava/util/List;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "dd-sdk-android_release"})
        public static final class CrashReport
        extends Feature {
            @NotNull
            private final String endpointUrl;
            @NotNull
            private final List<DatadogPlugin> plugins;

            public CrashReport(@NotNull String endpointUrl, @NotNull List<? extends DatadogPlugin> plugins) {
                Intrinsics.checkNotNullParameter((Object)endpointUrl, (String)"endpointUrl");
                Intrinsics.checkNotNullParameter(plugins, (String)"plugins");
                super(null);
                this.endpointUrl = endpointUrl;
                this.plugins = plugins;
            }

            @Override
            @NotNull
            public String getEndpointUrl() {
                return this.endpointUrl;
            }

            @Override
            @NotNull
            public List<DatadogPlugin> getPlugins() {
                return this.plugins;
            }

            @NotNull
            public final String component1() {
                return this.getEndpointUrl();
            }

            @NotNull
            public final List<DatadogPlugin> component2() {
                return this.getPlugins();
            }

            @NotNull
            public final CrashReport copy(@NotNull String endpointUrl, @NotNull List<? extends DatadogPlugin> plugins) {
                Intrinsics.checkNotNullParameter((Object)endpointUrl, (String)"endpointUrl");
                Intrinsics.checkNotNullParameter(plugins, (String)"plugins");
                return new CrashReport(endpointUrl, plugins);
            }

            public static /* synthetic */ CrashReport copy$default(CrashReport crashReport, String string, List list, int n, Object object) {
                if ((n & 1) != 0) {
                    string = crashReport.getEndpointUrl();
                }
                if ((n & 2) != 0) {
                    list = crashReport.getPlugins();
                }
                return crashReport.copy(string, list);
            }

            @NotNull
            public String toString() {
                return "CrashReport(endpointUrl=" + this.getEndpointUrl() + ", plugins=" + this.getPlugins() + ")";
            }

            public int hashCode() {
                int result = this.getEndpointUrl().hashCode();
                result = result * 31 + ((Object)this.getPlugins()).hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof CrashReport)) {
                    return false;
                }
                CrashReport crashReport = (CrashReport)other;
                if (!Intrinsics.areEqual((Object)this.getEndpointUrl(), (Object)crashReport.getEndpointUrl())) {
                    return false;
                }
                return Intrinsics.areEqual(this.getPlugins(), crashReport.getPlugins());
            }
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0080\b\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\bH\u00c6\u0003J-\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u0003H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001b"}, d2={"Lcom/datadog/android/core/configuration/Configuration$Feature$Tracing;", "Lcom/datadog/android/core/configuration/Configuration$Feature;", "endpointUrl", "", "plugins", "", "Lcom/datadog/android/plugin/DatadogPlugin;", "spanEventMapper", "Lcom/datadog/android/event/SpanEventMapper;", "(Ljava/lang/String;Ljava/util/List;Lcom/datadog/android/event/SpanEventMapper;)V", "getEndpointUrl", "()Ljava/lang/String;", "getPlugins", "()Ljava/util/List;", "getSpanEventMapper", "()Lcom/datadog/android/event/SpanEventMapper;", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "", "toString", "dd-sdk-android_release"})
        public static final class Tracing
        extends Feature {
            @NotNull
            private final String endpointUrl;
            @NotNull
            private final List<DatadogPlugin> plugins;
            @NotNull
            private final SpanEventMapper spanEventMapper;

            public Tracing(@NotNull String endpointUrl, @NotNull List<? extends DatadogPlugin> plugins, @NotNull SpanEventMapper spanEventMapper) {
                Intrinsics.checkNotNullParameter((Object)endpointUrl, (String)"endpointUrl");
                Intrinsics.checkNotNullParameter(plugins, (String)"plugins");
                Intrinsics.checkNotNullParameter((Object)spanEventMapper, (String)"spanEventMapper");
                super(null);
                this.endpointUrl = endpointUrl;
                this.plugins = plugins;
                this.spanEventMapper = spanEventMapper;
            }

            @Override
            @NotNull
            public String getEndpointUrl() {
                return this.endpointUrl;
            }

            @Override
            @NotNull
            public List<DatadogPlugin> getPlugins() {
                return this.plugins;
            }

            @NotNull
            public final SpanEventMapper getSpanEventMapper() {
                return this.spanEventMapper;
            }

            @NotNull
            public final String component1() {
                return this.getEndpointUrl();
            }

            @NotNull
            public final List<DatadogPlugin> component2() {
                return this.getPlugins();
            }

            @NotNull
            public final SpanEventMapper component3() {
                return this.spanEventMapper;
            }

            @NotNull
            public final Tracing copy(@NotNull String endpointUrl, @NotNull List<? extends DatadogPlugin> plugins, @NotNull SpanEventMapper spanEventMapper) {
                Intrinsics.checkNotNullParameter((Object)endpointUrl, (String)"endpointUrl");
                Intrinsics.checkNotNullParameter(plugins, (String)"plugins");
                Intrinsics.checkNotNullParameter((Object)spanEventMapper, (String)"spanEventMapper");
                return new Tracing(endpointUrl, plugins, spanEventMapper);
            }

            public static /* synthetic */ Tracing copy$default(Tracing tracing, String string, List list, SpanEventMapper spanEventMapper, int n, Object object) {
                if ((n & 1) != 0) {
                    string = tracing.getEndpointUrl();
                }
                if ((n & 2) != 0) {
                    list = tracing.getPlugins();
                }
                if ((n & 4) != 0) {
                    spanEventMapper = tracing.spanEventMapper;
                }
                return tracing.copy(string, list, spanEventMapper);
            }

            @NotNull
            public String toString() {
                return "Tracing(endpointUrl=" + this.getEndpointUrl() + ", plugins=" + this.getPlugins() + ", spanEventMapper=" + this.spanEventMapper + ")";
            }

            public int hashCode() {
                int result = this.getEndpointUrl().hashCode();
                result = result * 31 + ((Object)this.getPlugins()).hashCode();
                result = result * 31 + this.spanEventMapper.hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Tracing)) {
                    return false;
                }
                Tracing tracing = (Tracing)other;
                if (!Intrinsics.areEqual((Object)this.getEndpointUrl(), (Object)tracing.getEndpointUrl())) {
                    return false;
                }
                if (!Intrinsics.areEqual(this.getPlugins(), tracing.getPlugins())) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.spanEventMapper, (Object)tracing.spanEventMapper);
            }
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b&\n\u0002\u0010\b\n\u0002\b\u0002\b\u0080\b\u0018\u00002\u00020\u0001Bw\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\b\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u000e\u0012\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u0012\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u0012\u0006\u0010\u0016\u001a\u00020\u0015\u0012\u0006\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\u0002\u0010\u0019J\t\u0010/\u001a\u00020\u0003H\u00c6\u0003J\t\u00100\u001a\u00020\u0015H\u00c6\u0003J\t\u00101\u001a\u00020\u0015H\u00c6\u0003J\t\u00102\u001a\u00020\u0018H\u00c6\u0003J\u000f\u00103\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J\t\u00104\u001a\u00020\bH\u00c6\u0003J\t\u00105\u001a\u00020\bH\u00c6\u0003J\t\u00106\u001a\u00020\bH\u00c6\u0003J\u000b\u00107\u001a\u0004\u0018\u00010\fH\u00c6\u0003J\u000b\u00108\u001a\u0004\u0018\u00010\u000eH\u00c6\u0003J\u000b\u00109\u001a\u0004\u0018\u00010\u0010H\u00c6\u0003J\u000f\u0010:\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u00c6\u0003J\u0093\u0001\u0010;\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\b2\b\b\u0002\u0010\n\u001a\u00020\b2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u000e\b\u0002\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\b\b\u0002\u0010\u0014\u001a\u00020\u00152\b\b\u0002\u0010\u0016\u001a\u00020\u00152\b\b\u0002\u0010\u0017\u001a\u00020\u0018H\u00c6\u0001J\u0013\u0010<\u001a\u00020\u00152\b\u0010=\u001a\u0004\u0018\u00010\u0013H\u00d6\u0003J\t\u0010>\u001a\u00020?H\u00d6\u0001J\t\u0010@\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0013\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0011\u0010\n\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010%R\u0011\u0010\t\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010%R\u0011\u0010\u0016\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010\u001bR\u0013\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u0013\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,R\u0011\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.\u00a8\u0006A"}, d2={"Lcom/datadog/android/core/configuration/Configuration$Feature$RUM;", "Lcom/datadog/android/core/configuration/Configuration$Feature;", "endpointUrl", "", "plugins", "", "Lcom/datadog/android/plugin/DatadogPlugin;", "samplingRate", "", "telemetrySamplingRate", "telemetryConfigurationSamplingRate", "userActionTrackingStrategy", "Lcom/datadog/android/rum/internal/tracking/UserActionTrackingStrategy;", "viewTrackingStrategy", "Lcom/datadog/android/rum/tracking/ViewTrackingStrategy;", "longTaskTrackingStrategy", "Lcom/datadog/android/rum/tracking/TrackingStrategy;", "rumEventMapper", "Lcom/datadog/android/event/EventMapper;", "", "backgroundEventTracking", "", "trackFrustrations", "vitalsMonitorUpdateFrequency", "Lcom/datadog/android/core/configuration/VitalsUpdateFrequency;", "(Ljava/lang/String;Ljava/util/List;FFFLcom/datadog/android/rum/internal/tracking/UserActionTrackingStrategy;Lcom/datadog/android/rum/tracking/ViewTrackingStrategy;Lcom/datadog/android/rum/tracking/TrackingStrategy;Lcom/datadog/android/event/EventMapper;ZZLcom/datadog/android/core/configuration/VitalsUpdateFrequency;)V", "getBackgroundEventTracking", "()Z", "getEndpointUrl", "()Ljava/lang/String;", "getLongTaskTrackingStrategy", "()Lcom/datadog/android/rum/tracking/TrackingStrategy;", "getPlugins", "()Ljava/util/List;", "getRumEventMapper", "()Lcom/datadog/android/event/EventMapper;", "getSamplingRate", "()F", "getTelemetryConfigurationSamplingRate", "getTelemetrySamplingRate", "getTrackFrustrations", "getUserActionTrackingStrategy", "()Lcom/datadog/android/rum/internal/tracking/UserActionTrackingStrategy;", "getViewTrackingStrategy", "()Lcom/datadog/android/rum/tracking/ViewTrackingStrategy;", "getVitalsMonitorUpdateFrequency", "()Lcom/datadog/android/core/configuration/VitalsUpdateFrequency;", "component1", "component10", "component11", "component12", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "equals", "other", "hashCode", "", "toString", "dd-sdk-android_release"})
        public static final class RUM
        extends Feature {
            @NotNull
            private final String endpointUrl;
            @NotNull
            private final List<DatadogPlugin> plugins;
            private final float samplingRate;
            private final float telemetrySamplingRate;
            private final float telemetryConfigurationSamplingRate;
            @Nullable
            private final UserActionTrackingStrategy userActionTrackingStrategy;
            @Nullable
            private final ViewTrackingStrategy viewTrackingStrategy;
            @Nullable
            private final TrackingStrategy longTaskTrackingStrategy;
            @NotNull
            private final EventMapper<Object> rumEventMapper;
            private final boolean backgroundEventTracking;
            private final boolean trackFrustrations;
            @NotNull
            private final VitalsUpdateFrequency vitalsMonitorUpdateFrequency;

            public RUM(@NotNull String endpointUrl, @NotNull List<? extends DatadogPlugin> plugins, float samplingRate, float telemetrySamplingRate, float telemetryConfigurationSamplingRate, @Nullable UserActionTrackingStrategy userActionTrackingStrategy, @Nullable ViewTrackingStrategy viewTrackingStrategy, @Nullable TrackingStrategy longTaskTrackingStrategy, @NotNull EventMapper<Object> rumEventMapper, boolean backgroundEventTracking, boolean trackFrustrations2, @NotNull VitalsUpdateFrequency vitalsMonitorUpdateFrequency) {
                Intrinsics.checkNotNullParameter((Object)endpointUrl, (String)"endpointUrl");
                Intrinsics.checkNotNullParameter(plugins, (String)"plugins");
                Intrinsics.checkNotNullParameter(rumEventMapper, (String)"rumEventMapper");
                Intrinsics.checkNotNullParameter((Object)((Object)vitalsMonitorUpdateFrequency), (String)"vitalsMonitorUpdateFrequency");
                super(null);
                this.endpointUrl = endpointUrl;
                this.plugins = plugins;
                this.samplingRate = samplingRate;
                this.telemetrySamplingRate = telemetrySamplingRate;
                this.telemetryConfigurationSamplingRate = telemetryConfigurationSamplingRate;
                this.userActionTrackingStrategy = userActionTrackingStrategy;
                this.viewTrackingStrategy = viewTrackingStrategy;
                this.longTaskTrackingStrategy = longTaskTrackingStrategy;
                this.rumEventMapper = rumEventMapper;
                this.backgroundEventTracking = backgroundEventTracking;
                this.trackFrustrations = trackFrustrations2;
                this.vitalsMonitorUpdateFrequency = vitalsMonitorUpdateFrequency;
            }

            @Override
            @NotNull
            public String getEndpointUrl() {
                return this.endpointUrl;
            }

            @Override
            @NotNull
            public List<DatadogPlugin> getPlugins() {
                return this.plugins;
            }

            public final float getSamplingRate() {
                return this.samplingRate;
            }

            public final float getTelemetrySamplingRate() {
                return this.telemetrySamplingRate;
            }

            public final float getTelemetryConfigurationSamplingRate() {
                return this.telemetryConfigurationSamplingRate;
            }

            @Nullable
            public final UserActionTrackingStrategy getUserActionTrackingStrategy() {
                return this.userActionTrackingStrategy;
            }

            @Nullable
            public final ViewTrackingStrategy getViewTrackingStrategy() {
                return this.viewTrackingStrategy;
            }

            @Nullable
            public final TrackingStrategy getLongTaskTrackingStrategy() {
                return this.longTaskTrackingStrategy;
            }

            @NotNull
            public final EventMapper<Object> getRumEventMapper() {
                return this.rumEventMapper;
            }

            public final boolean getBackgroundEventTracking() {
                return this.backgroundEventTracking;
            }

            public final boolean getTrackFrustrations() {
                return this.trackFrustrations;
            }

            @NotNull
            public final VitalsUpdateFrequency getVitalsMonitorUpdateFrequency() {
                return this.vitalsMonitorUpdateFrequency;
            }

            @NotNull
            public final String component1() {
                return this.getEndpointUrl();
            }

            @NotNull
            public final List<DatadogPlugin> component2() {
                return this.getPlugins();
            }

            public final float component3() {
                return this.samplingRate;
            }

            public final float component4() {
                return this.telemetrySamplingRate;
            }

            public final float component5() {
                return this.telemetryConfigurationSamplingRate;
            }

            @Nullable
            public final UserActionTrackingStrategy component6() {
                return this.userActionTrackingStrategy;
            }

            @Nullable
            public final ViewTrackingStrategy component7() {
                return this.viewTrackingStrategy;
            }

            @Nullable
            public final TrackingStrategy component8() {
                return this.longTaskTrackingStrategy;
            }

            @NotNull
            public final EventMapper<Object> component9() {
                return this.rumEventMapper;
            }

            public final boolean component10() {
                return this.backgroundEventTracking;
            }

            public final boolean component11() {
                return this.trackFrustrations;
            }

            @NotNull
            public final VitalsUpdateFrequency component12() {
                return this.vitalsMonitorUpdateFrequency;
            }

            @NotNull
            public final RUM copy(@NotNull String endpointUrl, @NotNull List<? extends DatadogPlugin> plugins, float samplingRate, float telemetrySamplingRate, float telemetryConfigurationSamplingRate, @Nullable UserActionTrackingStrategy userActionTrackingStrategy, @Nullable ViewTrackingStrategy viewTrackingStrategy, @Nullable TrackingStrategy longTaskTrackingStrategy, @NotNull EventMapper<Object> rumEventMapper, boolean backgroundEventTracking, boolean trackFrustrations2, @NotNull VitalsUpdateFrequency vitalsMonitorUpdateFrequency) {
                Intrinsics.checkNotNullParameter((Object)endpointUrl, (String)"endpointUrl");
                Intrinsics.checkNotNullParameter(plugins, (String)"plugins");
                Intrinsics.checkNotNullParameter(rumEventMapper, (String)"rumEventMapper");
                Intrinsics.checkNotNullParameter((Object)((Object)vitalsMonitorUpdateFrequency), (String)"vitalsMonitorUpdateFrequency");
                return new RUM(endpointUrl, plugins, samplingRate, telemetrySamplingRate, telemetryConfigurationSamplingRate, userActionTrackingStrategy, viewTrackingStrategy, longTaskTrackingStrategy, rumEventMapper, backgroundEventTracking, trackFrustrations2, vitalsMonitorUpdateFrequency);
            }

            public static /* synthetic */ RUM copy$default(RUM rUM, String string, List list, float f, float f2, float f3, UserActionTrackingStrategy userActionTrackingStrategy, ViewTrackingStrategy viewTrackingStrategy, TrackingStrategy trackingStrategy, EventMapper eventMapper, boolean bl, boolean bl2, VitalsUpdateFrequency vitalsUpdateFrequency, int n, Object object) {
                if ((n & 1) != 0) {
                    string = rUM.getEndpointUrl();
                }
                if ((n & 2) != 0) {
                    list = rUM.getPlugins();
                }
                if ((n & 4) != 0) {
                    f = rUM.samplingRate;
                }
                if ((n & 8) != 0) {
                    f2 = rUM.telemetrySamplingRate;
                }
                if ((n & 0x10) != 0) {
                    f3 = rUM.telemetryConfigurationSamplingRate;
                }
                if ((n & 0x20) != 0) {
                    userActionTrackingStrategy = rUM.userActionTrackingStrategy;
                }
                if ((n & 0x40) != 0) {
                    viewTrackingStrategy = rUM.viewTrackingStrategy;
                }
                if ((n & 0x80) != 0) {
                    trackingStrategy = rUM.longTaskTrackingStrategy;
                }
                if ((n & 0x100) != 0) {
                    eventMapper = rUM.rumEventMapper;
                }
                if ((n & 0x200) != 0) {
                    bl = rUM.backgroundEventTracking;
                }
                if ((n & 0x400) != 0) {
                    bl2 = rUM.trackFrustrations;
                }
                if ((n & 0x800) != 0) {
                    vitalsUpdateFrequency = rUM.vitalsMonitorUpdateFrequency;
                }
                return rUM.copy(string, list, f, f2, f3, userActionTrackingStrategy, viewTrackingStrategy, trackingStrategy, eventMapper, bl, bl2, vitalsUpdateFrequency);
            }

            @NotNull
            public String toString() {
                return "RUM(endpointUrl=" + this.getEndpointUrl() + ", plugins=" + this.getPlugins() + ", samplingRate=" + this.samplingRate + ", telemetrySamplingRate=" + this.telemetrySamplingRate + ", telemetryConfigurationSamplingRate=" + this.telemetryConfigurationSamplingRate + ", userActionTrackingStrategy=" + this.userActionTrackingStrategy + ", viewTrackingStrategy=" + this.viewTrackingStrategy + ", longTaskTrackingStrategy=" + this.longTaskTrackingStrategy + ", rumEventMapper=" + this.rumEventMapper + ", backgroundEventTracking=" + this.backgroundEventTracking + ", trackFrustrations=" + this.trackFrustrations + ", vitalsMonitorUpdateFrequency=" + this.vitalsMonitorUpdateFrequency + ")";
            }

            public int hashCode() {
                int result = this.getEndpointUrl().hashCode();
                result = result * 31 + ((Object)this.getPlugins()).hashCode();
                result = result * 31 + Float.hashCode(this.samplingRate);
                result = result * 31 + Float.hashCode(this.telemetrySamplingRate);
                result = result * 31 + Float.hashCode(this.telemetryConfigurationSamplingRate);
                result = result * 31 + (this.userActionTrackingStrategy == null ? 0 : this.userActionTrackingStrategy.hashCode());
                result = result * 31 + (this.viewTrackingStrategy == null ? 0 : this.viewTrackingStrategy.hashCode());
                result = result * 31 + (this.longTaskTrackingStrategy == null ? 0 : this.longTaskTrackingStrategy.hashCode());
                result = result * 31 + this.rumEventMapper.hashCode();
                int n = this.backgroundEventTracking ? 1 : 0;
                if (n != 0) {
                    n = 1;
                }
                result = result * 31 + n;
                int n2 = this.trackFrustrations ? 1 : 0;
                if (n2 != 0) {
                    n2 = 1;
                }
                result = result * 31 + n2;
                result = result * 31 + this.vitalsMonitorUpdateFrequency.hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof RUM)) {
                    return false;
                }
                RUM rUM = (RUM)other;
                if (!Intrinsics.areEqual((Object)this.getEndpointUrl(), (Object)rUM.getEndpointUrl())) {
                    return false;
                }
                if (!Intrinsics.areEqual(this.getPlugins(), rUM.getPlugins())) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)Float.valueOf(this.samplingRate), (Object)Float.valueOf(rUM.samplingRate))) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)Float.valueOf(this.telemetrySamplingRate), (Object)Float.valueOf(rUM.telemetrySamplingRate))) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)Float.valueOf(this.telemetryConfigurationSamplingRate), (Object)Float.valueOf(rUM.telemetryConfigurationSamplingRate))) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.userActionTrackingStrategy, (Object)rUM.userActionTrackingStrategy)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.viewTrackingStrategy, (Object)rUM.viewTrackingStrategy)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.longTaskTrackingStrategy, (Object)rUM.longTaskTrackingStrategy)) {
                    return false;
                }
                if (!Intrinsics.areEqual(this.rumEventMapper, rUM.rumEventMapper)) {
                    return false;
                }
                if (this.backgroundEventTracking != rUM.backgroundEventTracking) {
                    return false;
                }
                if (this.trackFrustrations != rUM.trackFrustrations) {
                    return false;
                }
                return this.vitalsMonitorUpdateFrequency == rUM.vitalsMonitorUpdateFrequency;
            }
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0080\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\bH\u00c6\u0003J-\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u0003H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001b"}, d2={"Lcom/datadog/android/core/configuration/Configuration$Feature$SessionReplay;", "Lcom/datadog/android/core/configuration/Configuration$Feature;", "endpointUrl", "", "plugins", "", "Lcom/datadog/android/plugin/DatadogPlugin;", "privacy", "Lcom/datadog/android/sessionreplay/SessionReplayPrivacy;", "(Ljava/lang/String;Ljava/util/List;Lcom/datadog/android/sessionreplay/SessionReplayPrivacy;)V", "getEndpointUrl", "()Ljava/lang/String;", "getPlugins", "()Ljava/util/List;", "getPrivacy", "()Lcom/datadog/android/sessionreplay/SessionReplayPrivacy;", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "", "toString", "dd-sdk-android_release"})
        public static final class SessionReplay
        extends Feature {
            @NotNull
            private final String endpointUrl;
            @NotNull
            private final List<DatadogPlugin> plugins;
            @NotNull
            private final SessionReplayPrivacy privacy;

            public SessionReplay(@NotNull String endpointUrl, @NotNull List<? extends DatadogPlugin> plugins, @NotNull SessionReplayPrivacy privacy) {
                Intrinsics.checkNotNullParameter((Object)endpointUrl, (String)"endpointUrl");
                Intrinsics.checkNotNullParameter(plugins, (String)"plugins");
                Intrinsics.checkNotNullParameter((Object)privacy, (String)"privacy");
                super(null);
                this.endpointUrl = endpointUrl;
                this.plugins = plugins;
                this.privacy = privacy;
            }

            public /* synthetic */ SessionReplay(String string, List list, SessionReplayPrivacy sessionReplayPrivacy, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 2) != 0) {
                    list = CollectionsKt.emptyList();
                }
                this(string, list, sessionReplayPrivacy);
            }

            @Override
            @NotNull
            public String getEndpointUrl() {
                return this.endpointUrl;
            }

            @Override
            @NotNull
            public List<DatadogPlugin> getPlugins() {
                return this.plugins;
            }

            @NotNull
            public final SessionReplayPrivacy getPrivacy() {
                return this.privacy;
            }

            @NotNull
            public final String component1() {
                return this.getEndpointUrl();
            }

            @NotNull
            public final List<DatadogPlugin> component2() {
                return this.getPlugins();
            }

            @NotNull
            public final SessionReplayPrivacy component3() {
                return this.privacy;
            }

            @NotNull
            public final SessionReplay copy(@NotNull String endpointUrl, @NotNull List<? extends DatadogPlugin> plugins, @NotNull SessionReplayPrivacy privacy) {
                Intrinsics.checkNotNullParameter((Object)endpointUrl, (String)"endpointUrl");
                Intrinsics.checkNotNullParameter(plugins, (String)"plugins");
                Intrinsics.checkNotNullParameter((Object)privacy, (String)"privacy");
                return new SessionReplay(endpointUrl, plugins, privacy);
            }

            public static /* synthetic */ SessionReplay copy$default(SessionReplay sessionReplay, String string, List list, SessionReplayPrivacy sessionReplayPrivacy, int n, Object object) {
                if ((n & 1) != 0) {
                    string = sessionReplay.getEndpointUrl();
                }
                if ((n & 2) != 0) {
                    list = sessionReplay.getPlugins();
                }
                if ((n & 4) != 0) {
                    sessionReplayPrivacy = sessionReplay.privacy;
                }
                return sessionReplay.copy(string, list, sessionReplayPrivacy);
            }

            @NotNull
            public String toString() {
                return "SessionReplay(endpointUrl=" + this.getEndpointUrl() + ", plugins=" + this.getPlugins() + ", privacy=" + this.privacy + ")";
            }

            public int hashCode() {
                int result = this.getEndpointUrl().hashCode();
                result = result * 31 + ((Object)this.getPlugins()).hashCode();
                result = result * 31 + this.privacy.hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof SessionReplay)) {
                    return false;
                }
                SessionReplay sessionReplay = (SessionReplay)other;
                if (!Intrinsics.areEqual((Object)this.getEndpointUrl(), (Object)sessionReplay.getEndpointUrl())) {
                    return false;
                }
                if (!Intrinsics.areEqual(this.getPlugins(), sessionReplay.getPlugins())) {
                    return false;
                }
                return this.privacy == sessionReplay.privacy;
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u009c\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010 \u001a\u00020\u00002\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0007J&\u0010%\u001a\u00020&2\u0006\u0010#\u001a\u00020$2\u0006\u0010'\u001a\u00020\n2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020&0)H\u0002J\u0006\u0010*\u001a\u00020+J\u0010\u0010,\u001a\u00020&2\u0006\u0010-\u001a\u00020\nH\u0002J\u0006\u0010.\u001a\u00020\u0000J\b\u0010/\u001a\u000200H\u0002J\u0010\u00101\u001a\u00020\u00002\b\b\u0001\u00102\u001a\u000203J\u0010\u00104\u001a\u00020\u00002\b\b\u0001\u00102\u001a\u000203J\u001a\u00105\u001a\u00020\u00002\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00010\tJ\u000e\u00106\u001a\u00020\u00002\u0006\u00107\u001a\u000208J\u000e\u00109\u001a\u00020\u00002\u0006\u0010:\u001a\u00020;J\u0014\u0010<\u001a\u00020\u00002\f\u0010=\u001a\b\u0012\u0004\u0012\u00020\n0>J \u0010?\u001a\u00020\u00002\u0018\u0010@\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020B0A0\tJ\u0014\u0010C\u001a\u00020\u00002\f\u0010D\u001a\b\u0012\u0004\u0012\u00020F0EJ\u0018\u0010G\u001a\u00020\u00002\u0006\u0010H\u001a\u00020I2\b\u0010J\u001a\u0004\u0018\u00010KJ\u0014\u0010L\u001a\u00020\u00002\f\u0010D\u001a\b\u0012\u0004\u0012\u00020M0EJ\u0014\u0010N\u001a\u00020\u00002\f\u0010D\u001a\b\u0012\u0004\u0012\u00020O0EJ\u0014\u0010P\u001a\u00020\u00002\f\u0010D\u001a\b\u0012\u0004\u0012\u00020Q0EJ\u0014\u0010R\u001a\u00020\u00002\f\u0010D\u001a\b\u0012\u0004\u0012\u00020S0EJ\u000e\u0010T\u001a\u00020\u00002\u0006\u0010D\u001a\u00020UJ\u000e\u0010V\u001a\u00020\u00002\u0006\u0010D\u001a\u00020WJ\u001b\u0010X\u001a\u00020\u00002\f\u0010D\u001a\b\u0012\u0004\u0012\u00020Y0EH\u0000\u00a2\u0006\u0002\bZJ\u000e\u0010[\u001a\u00020\u00002\u0006\u0010\\\u001a\u00020]J\u000e\u0010^\u001a\u00020\u00002\u0006\u0010_\u001a\u00020\u0003J\u000e\u0010`\u001a\u00020\u00002\u0006\u0010a\u001a\u00020bJ\u0014\u0010c\u001a\u00020\u00002\f\u0010=\u001a\b\u0012\u0004\u0012\u00020\n0>J\u000e\u0010d\u001a\u00020\u00002\u0006\u0010e\u001a\u00020\u0003J\u000e\u0010f\u001a\u00020\u00002\u0006\u0010e\u001a\u00020\u0003J'\u0010g\u001a\u00020\u00002\u000e\b\u0002\u0010h\u001a\b\u0012\u0004\u0012\u00020j0i2\b\b\u0002\u0010k\u001a\u00020lH\u0007\u00a2\u0006\u0002\u0010mJ\u0012\u0010n\u001a\u00020\u00002\b\b\u0002\u0010o\u001a\u00020pH\u0007J\u000e\u0010q\u001a\u00020\u00002\u0006\u0010-\u001a\u00020\nJ\u000e\u0010r\u001a\u00020\u00002\u0006\u0010-\u001a\u00020\nJ\u000e\u0010s\u001a\u00020\u00002\u0006\u0010-\u001a\u00020\nJ\u000e\u0010t\u001a\u00020\u00002\u0006\u0010-\u001a\u00020\nJ\u000e\u0010u\u001a\u00020\u00002\u0006\u0010v\u001a\u00020wJ\u0010\u0010x\u001a\u00020\u00002\b\u0010y\u001a\u0004\u0018\u00010zR\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u0012X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0010R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0010R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0010\u00a8\u0006{"}, d2={"Lcom/datadog/android/core/configuration/Configuration$Builder;", "", "logsEnabled", "", "tracesEnabled", "crashReportsEnabled", "rumEnabled", "(ZZZZ)V", "additionalConfig", "", "", "coreConfig", "Lcom/datadog/android/core/configuration/Configuration$Core;", "crashReportConfig", "Lcom/datadog/android/core/configuration/Configuration$Feature$CrashReport;", "getCrashReportsEnabled", "()Z", "hostsSanitizer", "Lcom/datadog/android/core/configuration/HostsSanitizer;", "getHostsSanitizer$dd_sdk_android_release", "()Lcom/datadog/android/core/configuration/HostsSanitizer;", "setHostsSanitizer$dd_sdk_android_release", "(Lcom/datadog/android/core/configuration/HostsSanitizer;)V", "logsConfig", "Lcom/datadog/android/core/configuration/Configuration$Feature$Logs;", "getLogsEnabled", "rumConfig", "Lcom/datadog/android/core/configuration/Configuration$Feature$RUM;", "getRumEnabled", "tracesConfig", "Lcom/datadog/android/core/configuration/Configuration$Feature$Tracing;", "getTracesEnabled", "addPlugin", "plugin", "Lcom/datadog/android/plugin/DatadogPlugin;", "feature", "Lcom/datadog/android/plugin/Feature;", "applyIfFeatureEnabled", "", "method", "block", "Lkotlin/Function0;", "build", "Lcom/datadog/android/core/configuration/Configuration;", "checkCustomEndpoint", "endpoint", "disableInteractionTracking", "getRumEventMapper", "Lcom/datadog/android/rum/internal/domain/event/RumEventMapper;", "sampleRumSessions", "samplingRate", "", "sampleTelemetry", "setAdditionalConfiguration", "setBatchSize", "batchSize", "Lcom/datadog/android/core/configuration/BatchSize;", "setEncryption", "dataEncryption", "Lcom/datadog/android/security/Encryption;", "setFirstPartyHosts", "hosts", "", "setFirstPartyHostsWithHeaderType", "hostsWithHeaderType", "", "Lcom/datadog/android/tracing/TracingHeaderType;", "setLogEventMapper", "eventMapper", "Lcom/datadog/android/event/EventMapper;", "Lcom/datadog/android/log/model/LogEvent;", "setProxy", "proxy", "Ljava/net/Proxy;", "authenticator", "Lokhttp3/Authenticator;", "setRumActionEventMapper", "Lcom/datadog/android/rum/model/ActionEvent;", "setRumErrorEventMapper", "Lcom/datadog/android/rum/model/ErrorEvent;", "setRumLongTaskEventMapper", "Lcom/datadog/android/rum/model/LongTaskEvent;", "setRumResourceEventMapper", "Lcom/datadog/android/rum/model/ResourceEvent;", "setRumViewEventMapper", "Lcom/datadog/android/event/ViewEventMapper;", "setSpanEventMapper", "Lcom/datadog/android/event/SpanEventMapper;", "setTelemetryConfigurationEventMapper", "Lcom/datadog/android/telemetry/model/TelemetryConfigurationEvent;", "setTelemetryConfigurationEventMapper$dd_sdk_android_release", "setUploadFrequency", "uploadFrequency", "Lcom/datadog/android/core/configuration/UploadFrequency;", "setUseDeveloperModeWhenDebuggable", "developerModeEnabled", "setVitalsUpdateFrequency", "frequency", "Lcom/datadog/android/core/configuration/VitalsUpdateFrequency;", "setWebViewTrackingHosts", "trackBackgroundRumEvents", "enabled", "trackFrustrations", "trackInteractions", "touchTargetExtraAttributesProviders", "", "Lcom/datadog/android/rum/tracking/ViewAttributesProvider;", "interactionPredicate", "Lcom/datadog/android/rum/tracking/InteractionPredicate;", "([Lcom/datadog/android/rum/tracking/ViewAttributesProvider;Lcom/datadog/android/rum/tracking/InteractionPredicate;)Lcom/datadog/android/core/configuration/Configuration$Builder;", "trackLongTasks", "longTaskThresholdMs", "", "useCustomCrashReportsEndpoint", "useCustomLogsEndpoint", "useCustomRumEndpoint", "useCustomTracesEndpoint", "useSite", "site", "Lcom/datadog/android/DatadogSite;", "useViewTrackingStrategy", "strategy", "Lcom/datadog/android/rum/tracking/ViewTrackingStrategy;", "dd-sdk-android_release"})
    public static final class Builder {
        private final boolean logsEnabled;
        private final boolean tracesEnabled;
        private final boolean crashReportsEnabled;
        private final boolean rumEnabled;
        @NotNull
        private Feature.Logs logsConfig;
        @NotNull
        private Feature.Tracing tracesConfig;
        @NotNull
        private Feature.CrashReport crashReportConfig;
        @NotNull
        private Feature.RUM rumConfig;
        @NotNull
        private Map<String, ? extends Object> additionalConfig;
        @NotNull
        private Core coreConfig;
        @NotNull
        private HostsSanitizer hostsSanitizer;

        public Builder(boolean logsEnabled, boolean tracesEnabled, boolean crashReportsEnabled, boolean rumEnabled) {
            this.logsEnabled = logsEnabled;
            this.tracesEnabled = tracesEnabled;
            this.crashReportsEnabled = crashReportsEnabled;
            this.rumEnabled = rumEnabled;
            this.logsConfig = Companion.getDEFAULT_LOGS_CONFIG$dd_sdk_android_release();
            this.tracesConfig = Companion.getDEFAULT_TRACING_CONFIG$dd_sdk_android_release();
            this.crashReportConfig = Companion.getDEFAULT_CRASH_CONFIG$dd_sdk_android_release();
            this.rumConfig = Companion.getDEFAULT_RUM_CONFIG$dd_sdk_android_release();
            this.additionalConfig = MapsKt.emptyMap();
            this.coreConfig = Companion.getDEFAULT_CORE_CONFIG$dd_sdk_android_release();
            this.hostsSanitizer = new HostsSanitizer();
        }

        public final boolean getLogsEnabled() {
            return this.logsEnabled;
        }

        public final boolean getTracesEnabled() {
            return this.tracesEnabled;
        }

        public final boolean getCrashReportsEnabled() {
            return this.crashReportsEnabled;
        }

        public final boolean getRumEnabled() {
            return this.rumEnabled;
        }

        @NotNull
        public final HostsSanitizer getHostsSanitizer$dd_sdk_android_release() {
            return this.hostsSanitizer;
        }

        public final void setHostsSanitizer$dd_sdk_android_release(@NotNull HostsSanitizer hostsSanitizer) {
            Intrinsics.checkNotNullParameter((Object)hostsSanitizer, (String)"<set-?>");
            this.hostsSanitizer = hostsSanitizer;
        }

        @NotNull
        public final Configuration build() {
            return new Configuration(this.coreConfig, this.logsEnabled ? this.logsConfig : null, this.tracesEnabled ? this.tracesConfig : null, this.crashReportsEnabled ? this.crashReportConfig : null, this.rumEnabled ? this.rumConfig : null, this.additionalConfig);
        }

        @NotNull
        public final Builder setUseDeveloperModeWhenDebuggable(boolean developerModeEnabled) {
            this.coreConfig = Core.copy$default(this.coreConfig, false, developerModeEnabled, null, null, null, null, null, null, null, null, 1021, null);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Builder setFirstPartyHosts(@NotNull List<String> hosts) {
            Map map;
            void $this$associateWith$iv;
            Intrinsics.checkNotNullParameter(hosts, (String)"hosts");
            List<String> sanitizedHosts = this.hostsSanitizer.sanitizeHosts$dd_sdk_android_release(hosts, Configuration.NETWORK_REQUESTS_TRACKING_FEATURE_NAME);
            Iterable iterable = sanitizedHosts;
            boolean bl = false;
            boolean bl2 = false;
            Core core = this.coreConfig;
            Builder builder = this;
            boolean $i$f$associateWith = false;
            LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
            void $this$associateWithTo$iv$iv = $this$associateWith$iv;
            boolean $i$f$associateWithTo = false;
            for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
                String string = (String)element$iv$iv;
                Object t = element$iv$iv;
                map = result$iv;
                boolean bl3 = false;
                Set set = SetsKt.setOf((Object)((Object)TracingHeaderType.DATADOG));
                map.put(t, set);
            }
            map = result$iv;
            builder.coreConfig = Core.copy$default(core, bl2, bl, map, null, null, null, null, null, null, null, 1019, null);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Builder setFirstPartyHostsWithHeaderType(@NotNull Map<String, ? extends Set<? extends TracingHeaderType>> hostsWithHeaderType) {
            void $this$filterKeys$iv;
            Intrinsics.checkNotNullParameter(hostsWithHeaderType, (String)"hostsWithHeaderType");
            List<String> sanitizedHosts = this.hostsSanitizer.sanitizeHosts$dd_sdk_android_release(CollectionsKt.toList((Iterable)hostsWithHeaderType.keySet()), Configuration.NETWORK_REQUESTS_TRACKING_FEATURE_NAME);
            Map<String, ? extends Set<? extends TracingHeaderType>> map = hostsWithHeaderType;
            boolean bl = false;
            boolean bl2 = false;
            Core core = this.coreConfig;
            Builder builder = this;
            boolean $i$f$filterKeys = false;
            LinkedHashMap result$iv = new LinkedHashMap();
            for (Map.Entry entry$iv : $this$filterKeys$iv.entrySet()) {
                String it = (String)entry$iv.getKey();
                boolean bl3 = false;
                if (!sanitizedHosts.contains(it)) continue;
                result$iv.put(entry$iv.getKey(), entry$iv.getValue());
            }
            Map map2 = result$iv;
            builder.coreConfig = Core.copy$default(core, bl2, bl, map2, null, null, null, null, null, null, null, 1019, null);
            return this;
        }

        @NotNull
        public final Builder setWebViewTrackingHosts(@NotNull List<String> hosts) {
            Intrinsics.checkNotNullParameter(hosts, (String)"hosts");
            this.coreConfig = Core.copy$default(this.coreConfig, false, false, null, null, null, null, null, null, this.hostsSanitizer.sanitizeHosts$dd_sdk_android_release(hosts, Configuration.WEB_VIEW_TRACKING_FEATURE_NAME), null, 767, null);
            return this;
        }

        @NotNull
        public final Builder useSite(@NotNull DatadogSite site) {
            Intrinsics.checkNotNullParameter((Object)((Object)site), (String)"site");
            this.logsConfig = Feature.Logs.copy$default(this.logsConfig, site.getIntakeEndpoint(), null, null, 6, null);
            this.tracesConfig = Feature.Tracing.copy$default(this.tracesConfig, site.getIntakeEndpoint(), null, null, 6, null);
            this.crashReportConfig = Feature.CrashReport.copy$default(this.crashReportConfig, site.getIntakeEndpoint(), null, 2, null);
            this.rumConfig = Feature.RUM.copy$default(this.rumConfig, site.getIntakeEndpoint(), null, 0.0f, 0.0f, 0.0f, null, null, null, null, false, false, null, 4094, null);
            this.coreConfig = Core.copy$default(this.coreConfig, false, false, null, null, null, null, null, null, null, site, 510, null);
            return this;
        }

        @NotNull
        public final Builder useCustomLogsEndpoint(@NotNull String endpoint) {
            Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
            this.applyIfFeatureEnabled(com.datadog.android.plugin.Feature.LOG, "useCustomLogsEndpoint", (Function0<Unit>)((Function0)new Function0<Unit>(this, endpoint){
                final /* synthetic */ Builder this$0;
                final /* synthetic */ String $endpoint;
                {
                    this.this$0 = $receiver;
                    this.$endpoint = $endpoint;
                    super(0);
                }

                public final void invoke() {
                    Builder.access$setLogsConfig$p(this.this$0, Feature.Logs.copy$default(Builder.access$getLogsConfig$p(this.this$0), this.$endpoint, null, null, 6, null));
                    Builder.access$checkCustomEndpoint(this.this$0, this.$endpoint);
                }
            }));
            return this;
        }

        @NotNull
        public final Builder useCustomTracesEndpoint(@NotNull String endpoint) {
            Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
            this.applyIfFeatureEnabled(com.datadog.android.plugin.Feature.TRACE, "useCustomTracesEndpoint", (Function0<Unit>)((Function0)new Function0<Unit>(this, endpoint){
                final /* synthetic */ Builder this$0;
                final /* synthetic */ String $endpoint;
                {
                    this.this$0 = $receiver;
                    this.$endpoint = $endpoint;
                    super(0);
                }

                public final void invoke() {
                    Builder.access$setTracesConfig$p(this.this$0, Feature.Tracing.copy$default(Builder.access$getTracesConfig$p(this.this$0), this.$endpoint, null, null, 6, null));
                    Builder.access$checkCustomEndpoint(this.this$0, this.$endpoint);
                }
            }));
            return this;
        }

        @NotNull
        public final Builder useCustomCrashReportsEndpoint(@NotNull String endpoint) {
            Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
            this.applyIfFeatureEnabled(com.datadog.android.plugin.Feature.CRASH, "useCustomCrashReportsEndpoint", (Function0<Unit>)((Function0)new Function0<Unit>(this, endpoint){
                final /* synthetic */ Builder this$0;
                final /* synthetic */ String $endpoint;
                {
                    this.this$0 = $receiver;
                    this.$endpoint = $endpoint;
                    super(0);
                }

                public final void invoke() {
                    Builder.access$setCrashReportConfig$p(this.this$0, Feature.CrashReport.copy$default(Builder.access$getCrashReportConfig$p(this.this$0), this.$endpoint, null, 2, null));
                    Builder.access$checkCustomEndpoint(this.this$0, this.$endpoint);
                }
            }));
            return this;
        }

        @NotNull
        public final Builder useCustomRumEndpoint(@NotNull String endpoint) {
            Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
            this.applyIfFeatureEnabled(com.datadog.android.plugin.Feature.RUM, "useCustomRumEndpoint", (Function0<Unit>)((Function0)new Function0<Unit>(this, endpoint){
                final /* synthetic */ Builder this$0;
                final /* synthetic */ String $endpoint;
                {
                    this.this$0 = $receiver;
                    this.$endpoint = $endpoint;
                    super(0);
                }

                public final void invoke() {
                    Builder.access$setRumConfig$p(this.this$0, Feature.RUM.copy$default(Builder.access$getRumConfig$p(this.this$0), this.$endpoint, null, 0.0f, 0.0f, 0.0f, null, null, null, null, false, false, null, 4094, null));
                    Builder.access$checkCustomEndpoint(this.this$0, this.$endpoint);
                }
            }));
            return this;
        }

        @JvmOverloads
        @NotNull
        public final Builder trackInteractions(@NotNull ViewAttributesProvider[] touchTargetExtraAttributesProviders, @NotNull InteractionPredicate interactionPredicate) {
            Intrinsics.checkNotNullParameter((Object)touchTargetExtraAttributesProviders, (String)"touchTargetExtraAttributesProviders");
            Intrinsics.checkNotNullParameter((Object)interactionPredicate, (String)"interactionPredicate");
            UserActionTrackingStrategy strategy = Companion.provideUserTrackingStrategy(touchTargetExtraAttributesProviders, interactionPredicate);
            this.applyIfFeatureEnabled(com.datadog.android.plugin.Feature.RUM, "trackInteractions", (Function0<Unit>)((Function0)new Function0<Unit>(this, strategy){
                final /* synthetic */ Builder this$0;
                final /* synthetic */ UserActionTrackingStrategy $strategy;
                {
                    this.this$0 = $receiver;
                    this.$strategy = $strategy;
                    super(0);
                }

                public final void invoke() {
                    Builder.access$setRumConfig$p(this.this$0, Feature.RUM.copy$default(Builder.access$getRumConfig$p(this.this$0), null, null, 0.0f, 0.0f, 0.0f, this.$strategy, null, null, null, false, false, null, 4063, null));
                }
            }));
            return this;
        }

        public static /* synthetic */ Builder trackInteractions$default(Builder builder, ViewAttributesProvider[] viewAttributesProviderArray, InteractionPredicate interactionPredicate, int n, Object object) {
            if ((n & 1) != 0) {
                boolean $i$f$emptyArray = false;
                viewAttributesProviderArray = new ViewAttributesProvider[]{};
            }
            if ((n & 2) != 0) {
                interactionPredicate = new NoOpInteractionPredicate();
            }
            return builder.trackInteractions(viewAttributesProviderArray, interactionPredicate);
        }

        @NotNull
        public final Builder disableInteractionTracking() {
            this.applyIfFeatureEnabled(com.datadog.android.plugin.Feature.RUM, "disableInteractionTracking", (Function0<Unit>)((Function0)new Function0<Unit>(this){
                final /* synthetic */ Builder this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                public final void invoke() {
                    Builder.access$setRumConfig$p(this.this$0, Feature.RUM.copy$default(Builder.access$getRumConfig$p(this.this$0), null, null, 0.0f, 0.0f, 0.0f, new NoOpUserActionTrackingStrategy(), null, null, null, false, false, null, 4063, null));
                }
            }));
            return this;
        }

        @JvmOverloads
        @NotNull
        public final Builder trackLongTasks(long longTaskThresholdMs) {
            this.applyIfFeatureEnabled(com.datadog.android.plugin.Feature.RUM, "trackLongTasks", (Function0<Unit>)((Function0)new Function0<Unit>(longTaskThresholdMs, this){
                final /* synthetic */ long $longTaskThresholdMs;
                final /* synthetic */ Builder this$0;
                {
                    this.$longTaskThresholdMs = $longTaskThresholdMs;
                    this.this$0 = $receiver;
                    super(0);
                }

                public final void invoke() {
                    MainLooperLongTaskStrategy strategy = this.$longTaskThresholdMs > 0L ? new MainLooperLongTaskStrategy(this.$longTaskThresholdMs) : (MainLooperLongTaskStrategy)null;
                    Builder.access$setRumConfig$p(this.this$0, Feature.RUM.copy$default(Builder.access$getRumConfig$p(this.this$0), null, null, 0.0f, 0.0f, 0.0f, null, null, strategy, null, false, false, null, 3967, null));
                }
            }));
            return this;
        }

        public static /* synthetic */ Builder trackLongTasks$default(Builder builder, long l, int n, Object object) {
            if ((n & 1) != 0) {
                l = 100L;
            }
            return builder.trackLongTasks(l);
        }

        @NotNull
        public final Builder useViewTrackingStrategy(@Nullable ViewTrackingStrategy strategy) {
            this.applyIfFeatureEnabled(com.datadog.android.plugin.Feature.RUM, "useViewTrackingStrategy", (Function0<Unit>)((Function0)new Function0<Unit>(this, strategy){
                final /* synthetic */ Builder this$0;
                final /* synthetic */ ViewTrackingStrategy $strategy;
                {
                    this.this$0 = $receiver;
                    this.$strategy = $strategy;
                    super(0);
                }

                public final void invoke() {
                    Builder.access$setRumConfig$p(this.this$0, Feature.RUM.copy$default(Builder.access$getRumConfig$p(this.this$0), null, null, 0.0f, 0.0f, 0.0f, null, this.$strategy, null, null, false, false, null, 4031, null));
                }
            }));
            return this;
        }

        @Deprecated(message="Datadog Plugins will be removed in SDK v2.0.0. You will then need to write your own Feature (check our own code for guidance).")
        @NotNull
        public final Builder addPlugin(@NotNull DatadogPlugin plugin, @NotNull com.datadog.android.plugin.Feature feature) {
            Intrinsics.checkNotNullParameter((Object)plugin, (String)"plugin");
            Intrinsics.checkNotNullParameter((Object)((Object)feature), (String)"feature");
            RuntimeUtilsKt.warnDeprecated$default("Configuration.Builder#addPlugin", "1.15.0", "2.0.0", null, 8, null);
            this.applyIfFeatureEnabled(feature, "addPlugin", (Function0<Unit>)((Function0)new Function0<Unit>(feature, this, plugin){
                final /* synthetic */ com.datadog.android.plugin.Feature $feature;
                final /* synthetic */ Builder this$0;
                final /* synthetic */ DatadogPlugin $plugin;
                {
                    this.$feature = $feature;
                    this.this$0 = $receiver;
                    this.$plugin = $plugin;
                    super(0);
                }

                public final void invoke() {
                    switch (addPlugin.WhenMappings.$EnumSwitchMapping$0[this.$feature.ordinal()]) {
                        case 1: {
                            Builder.access$setRumConfig$p(this.this$0, Feature.RUM.copy$default(Builder.access$getRumConfig$p(this.this$0), null, CollectionsKt.plus((Collection)Builder.access$getRumConfig$p(this.this$0).getPlugins(), (Object)this.$plugin), 0.0f, 0.0f, 0.0f, null, null, null, null, false, false, null, 4093, null));
                            break;
                        }
                        case 2: {
                            Builder.access$setTracesConfig$p(this.this$0, Feature.Tracing.copy$default(Builder.access$getTracesConfig$p(this.this$0), null, CollectionsKt.plus((Collection)Builder.access$getTracesConfig$p(this.this$0).getPlugins(), (Object)this.$plugin), null, 5, null));
                            break;
                        }
                        case 3: {
                            Builder.access$setLogsConfig$p(this.this$0, Feature.Logs.copy$default(Builder.access$getLogsConfig$p(this.this$0), null, CollectionsKt.plus((Collection)Builder.access$getLogsConfig$p(this.this$0).getPlugins(), (Object)this.$plugin), null, 5, null));
                            break;
                        }
                        case 4: {
                            Builder.access$setCrashReportConfig$p(this.this$0, Feature.CrashReport.copy$default(Builder.access$getCrashReportConfig$p(this.this$0), null, CollectionsKt.plus((Collection)Builder.access$getCrashReportConfig$p(this.this$0).getPlugins(), (Object)this.$plugin), 1, null));
                        }
                    }
                }
            }));
            return this;
        }

        @NotNull
        public final Builder setBatchSize(@NotNull BatchSize batchSize) {
            Intrinsics.checkNotNullParameter((Object)((Object)batchSize), (String)"batchSize");
            this.coreConfig = Core.copy$default(this.coreConfig, false, false, null, batchSize, null, null, null, null, null, null, 1015, null);
            return this;
        }

        @NotNull
        public final Builder setUploadFrequency(@NotNull UploadFrequency uploadFrequency) {
            Intrinsics.checkNotNullParameter((Object)((Object)uploadFrequency), (String)"uploadFrequency");
            this.coreConfig = Core.copy$default(this.coreConfig, false, false, null, null, uploadFrequency, null, null, null, null, null, 1007, null);
            return this;
        }

        @NotNull
        public final Builder sampleRumSessions(@FloatRange(from=0.0, to=100.0) float samplingRate) {
            this.applyIfFeatureEnabled(com.datadog.android.plugin.Feature.RUM, "sampleRumSessions", (Function0<Unit>)((Function0)new Function0<Unit>(this, samplingRate){
                final /* synthetic */ Builder this$0;
                final /* synthetic */ float $samplingRate;
                {
                    this.this$0 = $receiver;
                    this.$samplingRate = $samplingRate;
                    super(0);
                }

                public final void invoke() {
                    Builder.access$setRumConfig$p(this.this$0, Feature.RUM.copy$default(Builder.access$getRumConfig$p(this.this$0), null, null, this.$samplingRate, 0.0f, 0.0f, null, null, null, null, false, false, null, 4091, null));
                }
            }));
            return this;
        }

        @NotNull
        public final Builder sampleTelemetry(@FloatRange(from=0.0, to=100.0) float samplingRate) {
            this.applyIfFeatureEnabled(com.datadog.android.plugin.Feature.RUM, "sampleTelemetry", (Function0<Unit>)((Function0)new Function0<Unit>(this, samplingRate){
                final /* synthetic */ Builder this$0;
                final /* synthetic */ float $samplingRate;
                {
                    this.this$0 = $receiver;
                    this.$samplingRate = $samplingRate;
                    super(0);
                }

                public final void invoke() {
                    Builder.access$setRumConfig$p(this.this$0, Feature.RUM.copy$default(Builder.access$getRumConfig$p(this.this$0), null, null, 0.0f, this.$samplingRate, 0.0f, null, null, null, null, false, false, null, 4087, null));
                }
            }));
            return this;
        }

        @NotNull
        public final Builder trackBackgroundRumEvents(boolean enabled) {
            this.applyIfFeatureEnabled(com.datadog.android.plugin.Feature.RUM, "trackBackgroundRumEvents", (Function0<Unit>)((Function0)new Function0<Unit>(this, enabled){
                final /* synthetic */ Builder this$0;
                final /* synthetic */ boolean $enabled;
                {
                    this.this$0 = $receiver;
                    this.$enabled = $enabled;
                    super(0);
                }

                public final void invoke() {
                    Builder.access$setRumConfig$p(this.this$0, Feature.RUM.copy$default(Builder.access$getRumConfig$p(this.this$0), null, null, 0.0f, 0.0f, 0.0f, null, null, null, null, this.$enabled, false, null, 3583, null));
                }
            }));
            return this;
        }

        @NotNull
        public final Builder trackFrustrations(boolean enabled) {
            this.applyIfFeatureEnabled(com.datadog.android.plugin.Feature.RUM, "trackFrustrations", (Function0<Unit>)((Function0)new Function0<Unit>(this, enabled){
                final /* synthetic */ Builder this$0;
                final /* synthetic */ boolean $enabled;
                {
                    this.this$0 = $receiver;
                    this.$enabled = $enabled;
                    super(0);
                }

                public final void invoke() {
                    Builder.access$setRumConfig$p(this.this$0, Feature.RUM.copy$default(Builder.access$getRumConfig$p(this.this$0), null, null, 0.0f, 0.0f, 0.0f, null, null, null, null, false, this.$enabled, null, 3071, null));
                }
            }));
            return this;
        }

        @NotNull
        public final Builder setRumViewEventMapper(@NotNull ViewEventMapper eventMapper) {
            Intrinsics.checkNotNullParameter((Object)eventMapper, (String)"eventMapper");
            this.applyIfFeatureEnabled(com.datadog.android.plugin.Feature.RUM, "setRumViewEventMapper", (Function0<Unit>)((Function0)new Function0<Unit>(this, eventMapper){
                final /* synthetic */ Builder this$0;
                final /* synthetic */ ViewEventMapper $eventMapper;
                {
                    this.this$0 = $receiver;
                    this.$eventMapper = $eventMapper;
                    super(0);
                }

                public final void invoke() {
                    Builder.access$setRumConfig$p(this.this$0, Feature.RUM.copy$default(Builder.access$getRumConfig$p(this.this$0), null, null, 0.0f, 0.0f, 0.0f, null, null, null, RumEventMapper.copy$default(Builder.access$getRumEventMapper(this.this$0), this.$eventMapper, null, null, null, null, null, 62, null), false, false, null, 3839, null));
                }
            }));
            return this;
        }

        @NotNull
        public final Builder setRumResourceEventMapper(@NotNull EventMapper<ResourceEvent> eventMapper) {
            Intrinsics.checkNotNullParameter(eventMapper, (String)"eventMapper");
            this.applyIfFeatureEnabled(com.datadog.android.plugin.Feature.RUM, "setRumResourceEventMapper", (Function0<Unit>)((Function0)new Function0<Unit>(this, eventMapper){
                final /* synthetic */ Builder this$0;
                final /* synthetic */ EventMapper<ResourceEvent> $eventMapper;
                {
                    this.this$0 = $receiver;
                    this.$eventMapper = $eventMapper;
                    super(0);
                }

                public final void invoke() {
                    Builder.access$setRumConfig$p(this.this$0, Feature.RUM.copy$default(Builder.access$getRumConfig$p(this.this$0), null, null, 0.0f, 0.0f, 0.0f, null, null, null, RumEventMapper.copy$default(Builder.access$getRumEventMapper(this.this$0), null, null, this.$eventMapper, null, null, null, 59, null), false, false, null, 3839, null));
                }
            }));
            return this;
        }

        @NotNull
        public final Builder setRumActionEventMapper(@NotNull EventMapper<ActionEvent> eventMapper) {
            Intrinsics.checkNotNullParameter(eventMapper, (String)"eventMapper");
            this.applyIfFeatureEnabled(com.datadog.android.plugin.Feature.RUM, "setRumActionEventMapper", (Function0<Unit>)((Function0)new Function0<Unit>(this, eventMapper){
                final /* synthetic */ Builder this$0;
                final /* synthetic */ EventMapper<ActionEvent> $eventMapper;
                {
                    this.this$0 = $receiver;
                    this.$eventMapper = $eventMapper;
                    super(0);
                }

                public final void invoke() {
                    Builder.access$setRumConfig$p(this.this$0, Feature.RUM.copy$default(Builder.access$getRumConfig$p(this.this$0), null, null, 0.0f, 0.0f, 0.0f, null, null, null, RumEventMapper.copy$default(Builder.access$getRumEventMapper(this.this$0), null, null, null, this.$eventMapper, null, null, 55, null), false, false, null, 3839, null));
                }
            }));
            return this;
        }

        @NotNull
        public final Builder setRumErrorEventMapper(@NotNull EventMapper<ErrorEvent> eventMapper) {
            Intrinsics.checkNotNullParameter(eventMapper, (String)"eventMapper");
            this.applyIfFeatureEnabled(com.datadog.android.plugin.Feature.RUM, "setRumErrorEventMapper", (Function0<Unit>)((Function0)new Function0<Unit>(this, eventMapper){
                final /* synthetic */ Builder this$0;
                final /* synthetic */ EventMapper<ErrorEvent> $eventMapper;
                {
                    this.this$0 = $receiver;
                    this.$eventMapper = $eventMapper;
                    super(0);
                }

                public final void invoke() {
                    Builder.access$setRumConfig$p(this.this$0, Feature.RUM.copy$default(Builder.access$getRumConfig$p(this.this$0), null, null, 0.0f, 0.0f, 0.0f, null, null, null, RumEventMapper.copy$default(Builder.access$getRumEventMapper(this.this$0), null, this.$eventMapper, null, null, null, null, 61, null), false, false, null, 3839, null));
                }
            }));
            return this;
        }

        @NotNull
        public final Builder setRumLongTaskEventMapper(@NotNull EventMapper<LongTaskEvent> eventMapper) {
            Intrinsics.checkNotNullParameter(eventMapper, (String)"eventMapper");
            this.applyIfFeatureEnabled(com.datadog.android.plugin.Feature.RUM, "setRumLongTaskEventMapper", (Function0<Unit>)((Function0)new Function0<Unit>(this, eventMapper){
                final /* synthetic */ Builder this$0;
                final /* synthetic */ EventMapper<LongTaskEvent> $eventMapper;
                {
                    this.this$0 = $receiver;
                    this.$eventMapper = $eventMapper;
                    super(0);
                }

                public final void invoke() {
                    Builder.access$setRumConfig$p(this.this$0, Feature.RUM.copy$default(Builder.access$getRumConfig$p(this.this$0), null, null, 0.0f, 0.0f, 0.0f, null, null, null, RumEventMapper.copy$default(Builder.access$getRumEventMapper(this.this$0), null, null, null, null, this.$eventMapper, null, 47, null), false, false, null, 3839, null));
                }
            }));
            return this;
        }

        @NotNull
        public final Builder setSpanEventMapper(@NotNull SpanEventMapper eventMapper) {
            Intrinsics.checkNotNullParameter((Object)eventMapper, (String)"eventMapper");
            this.applyIfFeatureEnabled(com.datadog.android.plugin.Feature.TRACE, "setSpanEventMapper", (Function0<Unit>)((Function0)new Function0<Unit>(this, eventMapper){
                final /* synthetic */ Builder this$0;
                final /* synthetic */ SpanEventMapper $eventMapper;
                {
                    this.this$0 = $receiver;
                    this.$eventMapper = $eventMapper;
                    super(0);
                }

                public final void invoke() {
                    Builder.access$setTracesConfig$p(this.this$0, Feature.Tracing.copy$default(Builder.access$getTracesConfig$p(this.this$0), null, null, this.$eventMapper, 3, null));
                }
            }));
            return this;
        }

        @NotNull
        public final Builder setLogEventMapper(@NotNull EventMapper<LogEvent> eventMapper) {
            Intrinsics.checkNotNullParameter(eventMapper, (String)"eventMapper");
            this.applyIfFeatureEnabled(com.datadog.android.plugin.Feature.LOG, "setLogEventMapper", (Function0<Unit>)((Function0)new Function0<Unit>(this, eventMapper){
                final /* synthetic */ Builder this$0;
                final /* synthetic */ EventMapper<LogEvent> $eventMapper;
                {
                    this.this$0 = $receiver;
                    this.$eventMapper = $eventMapper;
                    super(0);
                }

                public final void invoke() {
                    Builder.access$setLogsConfig$p(this.this$0, Feature.Logs.copy$default(Builder.access$getLogsConfig$p(this.this$0), null, null, this.$eventMapper, 3, null));
                }
            }));
            return this;
        }

        @NotNull
        public final Builder setAdditionalConfiguration(@NotNull Map<String, ? extends Object> additionalConfig) {
            Builder builder;
            Intrinsics.checkNotNullParameter(additionalConfig, (String)"additionalConfig");
            Builder $this$setAdditionalConfiguration_u24lambda_u2d2 = builder = this;
            boolean bl = false;
            $this$setAdditionalConfiguration_u24lambda_u2d2.additionalConfig = additionalConfig;
            return builder;
        }

        @NotNull
        public final Builder setProxy(@NotNull Proxy proxy, @Nullable Authenticator authenticator) {
            Intrinsics.checkNotNullParameter((Object)proxy, (String)"proxy");
            Authenticator authenticator2 = authenticator;
            if (authenticator2 == null) {
                authenticator2 = Authenticator.NONE;
            }
            Authenticator authenticator3 = authenticator2;
            Intrinsics.checkNotNullExpressionValue((Object)authenticator3, (String)"authenticator ?: Authenticator.NONE");
            this.coreConfig = Core.copy$default(this.coreConfig, false, false, null, null, null, proxy, authenticator3, null, null, null, 927, null);
            return this;
        }

        @NotNull
        public final Builder setTelemetryConfigurationEventMapper$dd_sdk_android_release(@NotNull EventMapper<TelemetryConfigurationEvent> eventMapper) {
            Intrinsics.checkNotNullParameter(eventMapper, (String)"eventMapper");
            this.applyIfFeatureEnabled(com.datadog.android.plugin.Feature.RUM, "setTelemetryConfigurationEventMapper", (Function0<Unit>)((Function0)new Function0<Unit>(this, eventMapper){
                final /* synthetic */ Builder this$0;
                final /* synthetic */ EventMapper<TelemetryConfigurationEvent> $eventMapper;
                {
                    this.this$0 = $receiver;
                    this.$eventMapper = $eventMapper;
                    super(0);
                }

                public final void invoke() {
                    Builder.access$setRumConfig$p(this.this$0, Feature.RUM.copy$default(Builder.access$getRumConfig$p(this.this$0), null, null, 0.0f, 0.0f, 0.0f, null, null, null, RumEventMapper.copy$default(Builder.access$getRumEventMapper(this.this$0), null, null, null, null, null, this.$eventMapper, 31, null), false, false, null, 3839, null));
                }
            }));
            return this;
        }

        @NotNull
        public final Builder setEncryption(@NotNull Encryption dataEncryption) {
            Intrinsics.checkNotNullParameter((Object)dataEncryption, (String)"dataEncryption");
            this.coreConfig = Core.copy$default(this.coreConfig, false, false, null, null, null, null, null, dataEncryption, null, null, 895, null);
            return this;
        }

        private final void checkCustomEndpoint(String endpoint) {
            if (StringsKt.startsWith$default((String)endpoint, (String)"http://", (boolean)false, (int)2, null)) {
                this.coreConfig = Core.copy$default(this.coreConfig, true, false, null, null, null, null, null, null, null, null, 1022, null);
            }
        }

        private final RumEventMapper getRumEventMapper() {
            EventMapper<Object> rumEventMapper = this.rumConfig.getRumEventMapper();
            return rumEventMapper instanceof RumEventMapper ? (RumEventMapper)rumEventMapper : new RumEventMapper(null, null, null, null, null, null, 63, null);
        }

        private final void applyIfFeatureEnabled(com.datadog.android.plugin.Feature feature, String method, Function0<Unit> block) {
            boolean bl;
            switch (WhenMappings.$EnumSwitchMapping$0[feature.ordinal()]) {
                case 1: {
                    bl = this.logsEnabled;
                    break;
                }
                case 2: {
                    bl = this.tracesEnabled;
                    break;
                }
                case 3: {
                    bl = this.crashReportsEnabled;
                    break;
                }
                case 4: {
                    bl = this.rumEnabled;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            boolean featureEnabled = bl;
            if (featureEnabled) {
                block.invoke();
            } else {
                InternalLogger internalLogger = RuntimeUtilsKt.getInternalLogger();
                String string = Configuration.ERROR_FEATURE_DISABLED;
                Locale locale = Locale.US;
                Object[] objectArray = new Object[]{feature.getFeatureName$dd_sdk_android_release(), method};
                String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(locale, this, *args)");
                InternalLogger.DefaultImpls.log$default(internalLogger, InternalLogger.Level.ERROR, InternalLogger.Target.USER, string2, null, 8, null);
            }
        }

        @NotNull
        public final Builder setVitalsUpdateFrequency(@NotNull VitalsUpdateFrequency frequency) {
            Intrinsics.checkNotNullParameter((Object)((Object)frequency), (String)"frequency");
            this.rumConfig = Feature.RUM.copy$default(this.rumConfig, null, null, 0.0f, 0.0f, 0.0f, null, null, null, null, false, false, frequency, 2047, null);
            return this;
        }

        @JvmOverloads
        @NotNull
        public final Builder trackInteractions(@NotNull ViewAttributesProvider[] touchTargetExtraAttributesProviders) {
            Intrinsics.checkNotNullParameter((Object)touchTargetExtraAttributesProviders, (String)"touchTargetExtraAttributesProviders");
            return Builder.trackInteractions$default(this, touchTargetExtraAttributesProviders, null, 2, null);
        }

        @JvmOverloads
        @NotNull
        public final Builder trackInteractions() {
            return Builder.trackInteractions$default(this, null, null, 3, null);
        }

        @JvmOverloads
        @NotNull
        public final Builder trackLongTasks() {
            return Builder.trackLongTasks$default(this, 0L, 1, null);
        }

        public static final /* synthetic */ void access$setLogsConfig$p(Builder $this, Feature.Logs logs) {
            $this.logsConfig = logs;
        }

        public static final /* synthetic */ Feature.Logs access$getLogsConfig$p(Builder $this) {
            return $this.logsConfig;
        }

        public static final /* synthetic */ void access$checkCustomEndpoint(Builder $this, String endpoint) {
            $this.checkCustomEndpoint(endpoint);
        }

        public static final /* synthetic */ void access$setTracesConfig$p(Builder $this, Feature.Tracing tracing) {
            $this.tracesConfig = tracing;
        }

        public static final /* synthetic */ Feature.Tracing access$getTracesConfig$p(Builder $this) {
            return $this.tracesConfig;
        }

        public static final /* synthetic */ void access$setCrashReportConfig$p(Builder $this, Feature.CrashReport crashReport) {
            $this.crashReportConfig = crashReport;
        }

        public static final /* synthetic */ Feature.CrashReport access$getCrashReportConfig$p(Builder $this) {
            return $this.crashReportConfig;
        }

        public static final /* synthetic */ void access$setRumConfig$p(Builder $this, Feature.RUM rUM) {
            $this.rumConfig = rUM;
        }

        public static final /* synthetic */ Feature.RUM access$getRumConfig$p(Builder $this) {
            return $this.rumConfig;
        }

        public static final /* synthetic */ RumEventMapper access$getRumEventMapper(Builder $this) {
            return $this.getRumEventMapper();
        }

        @Metadata(mv={1, 6, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[com.datadog.android.plugin.Feature.values().length];
                nArray[com.datadog.android.plugin.Feature.LOG.ordinal()] = 1;
                nArray[com.datadog.android.plugin.Feature.TRACE.ordinal()] = 2;
                nArray[com.datadog.android.plugin.Feature.CRASH.ordinal()] = 3;
                nArray[com.datadog.android.plugin.Feature.RUM.ordinal()] = 4;
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J#\u0010\"\u001a\u00020#2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%2\u0006\u0010'\u001a\u00020(H\u0002\u00a2\u0006\u0002\u0010)J#\u0010*\u001a\u00020+2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020&0%2\u0006\u0010'\u001a\u00020(H\u0002\u00a2\u0006\u0002\u0010-R\u0014\u0010\u0003\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0080T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\u0012X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0016X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0016X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0016X\u0080T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\u00020\u001aX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u000e\u0010\u001d\u001a\u00020\u001eX\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u001eX\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u001eX\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u001eX\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lcom/datadog/android/core/configuration/Configuration$Companion;", "", "()V", "DEFAULT_CORE_CONFIG", "Lcom/datadog/android/core/configuration/Configuration$Core;", "getDEFAULT_CORE_CONFIG$dd_sdk_android_release", "()Lcom/datadog/android/core/configuration/Configuration$Core;", "DEFAULT_CRASH_CONFIG", "Lcom/datadog/android/core/configuration/Configuration$Feature$CrashReport;", "getDEFAULT_CRASH_CONFIG$dd_sdk_android_release", "()Lcom/datadog/android/core/configuration/Configuration$Feature$CrashReport;", "DEFAULT_LOGS_CONFIG", "Lcom/datadog/android/core/configuration/Configuration$Feature$Logs;", "getDEFAULT_LOGS_CONFIG$dd_sdk_android_release", "()Lcom/datadog/android/core/configuration/Configuration$Feature$Logs;", "DEFAULT_LONG_TASK_THRESHOLD_MS", "", "DEFAULT_RUM_CONFIG", "Lcom/datadog/android/core/configuration/Configuration$Feature$RUM;", "getDEFAULT_RUM_CONFIG$dd_sdk_android_release", "()Lcom/datadog/android/core/configuration/Configuration$Feature$RUM;", "DEFAULT_SAMPLING_RATE", "", "DEFAULT_TELEMETRY_CONFIGURATION_SAMPLING_RATE", "DEFAULT_TELEMETRY_SAMPLING_RATE", "DEFAULT_TRACING_CONFIG", "Lcom/datadog/android/core/configuration/Configuration$Feature$Tracing;", "getDEFAULT_TRACING_CONFIG$dd_sdk_android_release", "()Lcom/datadog/android/core/configuration/Configuration$Feature$Tracing;", "ERROR_FEATURE_DISABLED", "", "NETWORK_REQUESTS_TRACKING_FEATURE_NAME", "PLUGINS_DEPRECATED_WARN_MESSAGE", "WEB_VIEW_TRACKING_FEATURE_NAME", "provideGestureTracker", "Lcom/datadog/android/rum/internal/instrumentation/gestures/DatadogGesturesTracker;", "customProviders", "", "Lcom/datadog/android/rum/tracking/ViewAttributesProvider;", "interactionPredicate", "Lcom/datadog/android/rum/tracking/InteractionPredicate;", "([Lcom/datadog/android/rum/tracking/ViewAttributesProvider;Lcom/datadog/android/rum/tracking/InteractionPredicate;)Lcom/datadog/android/rum/internal/instrumentation/gestures/DatadogGesturesTracker;", "provideUserTrackingStrategy", "Lcom/datadog/android/rum/internal/tracking/UserActionTrackingStrategy;", "touchTargetExtraAttributesProviders", "([Lcom/datadog/android/rum/tracking/ViewAttributesProvider;Lcom/datadog/android/rum/tracking/InteractionPredicate;)Lcom/datadog/android/rum/internal/tracking/UserActionTrackingStrategy;", "dd-sdk-android_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Core getDEFAULT_CORE_CONFIG$dd_sdk_android_release() {
            return DEFAULT_CORE_CONFIG;
        }

        @NotNull
        public final Feature.Logs getDEFAULT_LOGS_CONFIG$dd_sdk_android_release() {
            return DEFAULT_LOGS_CONFIG;
        }

        @NotNull
        public final Feature.CrashReport getDEFAULT_CRASH_CONFIG$dd_sdk_android_release() {
            return DEFAULT_CRASH_CONFIG;
        }

        @NotNull
        public final Feature.Tracing getDEFAULT_TRACING_CONFIG$dd_sdk_android_release() {
            return DEFAULT_TRACING_CONFIG;
        }

        @NotNull
        public final Feature.RUM getDEFAULT_RUM_CONFIG$dd_sdk_android_release() {
            return DEFAULT_RUM_CONFIG;
        }

        private final UserActionTrackingStrategy provideUserTrackingStrategy(ViewAttributesProvider[] touchTargetExtraAttributesProviders, InteractionPredicate interactionPredicate) {
            DatadogGesturesTracker gesturesTracker = this.provideGestureTracker(touchTargetExtraAttributesProviders, interactionPredicate);
            return Build.VERSION.SDK_INT >= 29 ? (UserActionTrackingStrategy)new UserActionTrackingStrategyApi29(gesturesTracker) : (UserActionTrackingStrategy)new UserActionTrackingStrategyLegacy(gesturesTracker);
        }

        private final DatadogGesturesTracker provideGestureTracker(ViewAttributesProvider[] customProviders, InteractionPredicate interactionPredicate) {
            Object[] objectArray = new JetpackViewAttributesProvider[]{new JetpackViewAttributesProvider()};
            Object[] defaultProviders = objectArray;
            ViewAttributesProvider[] providers = (ViewAttributesProvider[])ArraysKt.plus((Object[])customProviders, (Object[])defaultProviders);
            return new DatadogGesturesTracker(providers, interactionPredicate);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

