/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.core.configuration;

import com.datadog.android.core.internal.utils.RuntimeUtilsKt;
import com.datadog.android.v2.api.InternalLogger;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0000\u0018\u0000 \t2\u00020\u0001:\u0001\tB\u0005\u00a2\u0006\u0002\u0010\u0002J)\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0007\u001a\u00020\u0005H\u0000\u00a2\u0006\u0002\b\b\u00a8\u0006\n"}, d2={"Lcom/datadog/android/core/configuration/HostsSanitizer;", "", "()V", "sanitizeHosts", "", "", "hosts", "feature", "sanitizeHosts$dd_sdk_android_release", "Companion", "dd-sdk-android_release"})
public final class HostsSanitizer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String VALID_IP_REGEX = "^(([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\\.){3}([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])$";
    @NotNull
    private static final String VALID_DOMAIN_REGEX = "^(([a-zA-Z0-9]|[a-zA-Z0-9][a-zA-Z0-9\\-]*[a-zA-Z0-9])\\.)+([A-Za-z]|[A-Za-z][A-Za-z0-9-]*[A-Za-z0-9])$";
    @NotNull
    private static final String VALID_HOSTNAME_REGEX = "^(([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\\.){3}([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])$|^(([a-zA-Z0-9]|[a-zA-Z0-9][a-zA-Z0-9\\-]*[a-zA-Z0-9])\\.)+([A-Za-z]|[A-Za-z][A-Za-z0-9-]*[A-Za-z0-9])$";
    @NotNull
    private static final String URL_REGEX = "^(http|https)://(.*)";
    @NotNull
    public static final String WARNING_USING_URL = "You are using a url \"%s\" instead of a host to setup %s tracking. You should use instead a valid host name: \"%s\"";
    @NotNull
    public static final String ERROR_MALFORMED_URL = "You are using a malformed url \"%s\" to setup %s tracking. It will be dropped. Please try using a host name instead, e.g.: \"example.com\"";
    @NotNull
    public static final String ERROR_MALFORMED_HOST_IP_ADDRESS = "You are using a malformed host or ip address \"%s\" to setup %s tracking. It will be dropped.";

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> sanitizeHosts$dd_sdk_android_release(@NotNull List<String> hosts, @NotNull String feature) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter(hosts, (String)"hosts");
        Intrinsics.checkNotNullParameter((Object)feature, (String)"feature");
        Regex validHostNameRegEx = new Regex(VALID_HOSTNAME_REGEX);
        Regex validUrlRegex = new Regex(URL_REGEX);
        Iterable $this$mapNotNull$iv = hosts;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            CharSequence charSequence;
            Object object;
            Object[] objectArray;
            Object object2;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            String it = (String)element$iv$iv;
            boolean bl2 = false;
            CharSequence charSequence2 = it;
            if (validUrlRegex.matches(charSequence2)) {
                Object object3;
                try {
                    URL parsedUrl = new URL(it);
                    InternalLogger internalLogger = RuntimeUtilsKt.getInternalLogger();
                    object2 = WARNING_USING_URL;
                    objectArray = Locale.US;
                    object = new Object[]{it, feature, parsedUrl.getHost()};
                    object3 = String.format((Locale)objectArray, (String)object2, Arrays.copyOf(object, ((Object[])object).length));
                    Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"format(locale, this, *args)");
                    InternalLogger.DefaultImpls.log$default(internalLogger, InternalLogger.Level.WARN, InternalLogger.Target.USER, (String)object3, null, 8, null);
                    charSequence2 = parsedUrl.getHost();
                }
                catch (MalformedURLException e) {
                    InternalLogger internalLogger = RuntimeUtilsKt.getInternalLogger();
                    objectArray = ERROR_MALFORMED_URL;
                    object = Locale.US;
                    object3 = new Object[]{it, feature};
                    String string = String.format((Locale)object, (String)objectArray, Arrays.copyOf(object3, ((Object[])object3).length));
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(locale, this, *args)");
                    internalLogger.log(InternalLogger.Level.ERROR, InternalLogger.Target.USER, string, (Throwable)e);
                    charSequence2 = null;
                }
                charSequence = charSequence2;
            } else {
                charSequence2 = it;
                if (validHostNameRegEx.matches(charSequence2)) {
                    charSequence = it;
                } else {
                    object2 = Locale.US;
                    Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"US");
                    objectArray = it.toLowerCase((Locale)object2);
                    Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"this as java.lang.String).toLowerCase(locale)");
                    if (Intrinsics.areEqual((Object)objectArray, (Object)"localhost")) {
                        charSequence = it;
                    } else {
                        InternalLogger internalLogger = RuntimeUtilsKt.getInternalLogger();
                        charSequence2 = ERROR_MALFORMED_HOST_IP_ADDRESS;
                        object2 = Locale.US;
                        objectArray = new Object[]{it, feature};
                        object = String.format((Locale)object2, (String)charSequence2, Arrays.copyOf(objectArray, objectArray.length));
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"format(locale, this, *args)");
                        InternalLogger.DefaultImpls.log$default(internalLogger, InternalLogger.Level.ERROR, InternalLogger.Target.USER, (String)object, null, 8, null);
                        charSequence = null;
                    }
                }
            }
            if (charSequence == null) continue;
            String it$iv$iv = charSequence;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/datadog/android/core/configuration/HostsSanitizer$Companion;", "", "()V", "ERROR_MALFORMED_HOST_IP_ADDRESS", "", "ERROR_MALFORMED_URL", "URL_REGEX", "VALID_DOMAIN_REGEX", "VALID_HOSTNAME_REGEX", "VALID_IP_REGEX", "WARNING_USING_URL", "dd-sdk-android_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

