/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.core.internal;

import android.content.Context;
import com.datadog.android.core.internal.CoreFeature;
import com.datadog.android.core.internal.data.upload.NoOpUploadScheduler;
import com.datadog.android.core.internal.data.upload.UploadScheduler;
import com.datadog.android.core.internal.persistence.file.FileMover;
import com.datadog.android.core.internal.persistence.file.FileOrchestrator;
import com.datadog.android.core.internal.persistence.file.FilePersistenceConfig;
import com.datadog.android.core.internal.persistence.file.FileReaderWriter;
import com.datadog.android.core.internal.persistence.file.NoOpFileOrchestrator;
import com.datadog.android.core.internal.persistence.file.advanced.FeatureFileOrchestrator;
import com.datadog.android.core.internal.persistence.file.batch.BatchFileReaderWriter;
import com.datadog.android.core.internal.privacy.ConsentProvider;
import com.datadog.android.core.internal.utils.RuntimeUtilsKt;
import com.datadog.android.plugin.DatadogPlugin;
import com.datadog.android.plugin.DatadogPluginConfig;
import com.datadog.android.v2.api.EventBatchWriter;
import com.datadog.android.v2.api.FeatureEventReceiver;
import com.datadog.android.v2.api.FeatureScope;
import com.datadog.android.v2.api.FeatureStorageConfiguration;
import com.datadog.android.v2.api.FeatureUploadConfiguration;
import com.datadog.android.v2.api.InternalLogger;
import com.datadog.android.v2.api.context.DatadogContext;
import com.datadog.android.v2.core.internal.ContextProvider;
import com.datadog.android.v2.core.internal.NoOpContextProvider;
import com.datadog.android.v2.core.internal.data.upload.DataFlusher;
import com.datadog.android.v2.core.internal.data.upload.DataUploadScheduler;
import com.datadog.android.v2.core.internal.net.DataOkHttpUploader;
import com.datadog.android.v2.core.internal.net.DataUploader;
import com.datadog.android.v2.core.internal.net.NoOpDataUploader;
import com.datadog.android.v2.core.internal.storage.ConsentAwareStorage;
import com.datadog.android.v2.core.internal.storage.NoOpStorage;
import com.datadog.android.v2.core.internal.storage.Storage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Call;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00a8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 T2\u00020\u0001:\u0001TB%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0006\u00101\u001a\u000202J\u0018\u00103\u001a\u00020 2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u00104\u001a\u00020,2\u0006\u0010\b\u001a\u00020\tH\u0002J\r\u00105\u001a\u000202H\u0000\u00a2\u0006\u0002\b6J\u000e\u00107\u001a\b\u0012\u0004\u0012\u00020\u001408H\u0007J\u001c\u00109\u001a\u0002022\u0006\u0010:\u001a\u00020;2\f\u0010<\u001a\b\u0012\u0004\u0012\u00020\u001408J\u0006\u0010=\u001a\u00020>J\u0006\u0010?\u001a\u000202J\u0006\u0010@\u001a\u000202J\u0006\u0010A\u001a\u000202J\u0006\u0010B\u001a\u000202J&\u0010C\u001a\u0002022\f\u0010<\u001a\b\u0012\u0004\u0012\u00020\u0014082\u0006\u0010D\u001a\u00020E2\u0006\u0010F\u001a\u00020GH\u0002J\u0010\u0010H\u001a\u0002022\u0006\u0010I\u001a\u00020JH\u0016J\b\u0010K\u001a\u000202H\u0002J\u0006\u0010L\u001a\u000202J\b\u0010M\u001a\u000202H\u0002J*\u0010N\u001a\u0002022\u0006\u0010O\u001a\u00020>2\u0018\u0010P\u001a\u0014\u0012\u0004\u0012\u00020R\u0012\u0004\u0012\u00020S\u0012\u0004\u0012\u0002020QH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0015\u001a\u00020\u0016X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\u001cX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u001a\u0010\u001f\u001a\u00020 X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010%\u001a\u00020&X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*R\u001a\u0010+\u001a\u00020,X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010.\"\u0004\b/\u00100\u00a8\u0006U"}, d2={"Lcom/datadog/android/core/internal/SdkFeature;", "Lcom/datadog/android/v2/api/FeatureScope;", "coreFeature", "Lcom/datadog/android/core/internal/CoreFeature;", "featureName", "", "storageConfiguration", "Lcom/datadog/android/v2/api/FeatureStorageConfiguration;", "uploadConfiguration", "Lcom/datadog/android/v2/api/FeatureUploadConfiguration;", "(Lcom/datadog/android/core/internal/CoreFeature;Ljava/lang/String;Lcom/datadog/android/v2/api/FeatureStorageConfiguration;Lcom/datadog/android/v2/api/FeatureUploadConfiguration;)V", "getCoreFeature$dd_sdk_android_release", "()Lcom/datadog/android/core/internal/CoreFeature;", "eventReceiver", "Ljava/util/concurrent/atomic/AtomicReference;", "Lcom/datadog/android/v2/api/FeatureEventReceiver;", "getEventReceiver$dd_sdk_android_release", "()Ljava/util/concurrent/atomic/AtomicReference;", "featurePlugins", "", "Lcom/datadog/android/plugin/DatadogPlugin;", "fileOrchestrator", "Lcom/datadog/android/core/internal/persistence/file/FileOrchestrator;", "getFileOrchestrator$dd_sdk_android_release", "()Lcom/datadog/android/core/internal/persistence/file/FileOrchestrator;", "setFileOrchestrator$dd_sdk_android_release", "(Lcom/datadog/android/core/internal/persistence/file/FileOrchestrator;)V", "initialized", "Ljava/util/concurrent/atomic/AtomicBoolean;", "getInitialized$dd_sdk_android_release", "()Ljava/util/concurrent/atomic/AtomicBoolean;", "storage", "Lcom/datadog/android/v2/core/internal/storage/Storage;", "getStorage$dd_sdk_android_release", "()Lcom/datadog/android/v2/core/internal/storage/Storage;", "setStorage$dd_sdk_android_release", "(Lcom/datadog/android/v2/core/internal/storage/Storage;)V", "uploadScheduler", "Lcom/datadog/android/core/internal/data/upload/UploadScheduler;", "getUploadScheduler$dd_sdk_android_release", "()Lcom/datadog/android/core/internal/data/upload/UploadScheduler;", "setUploadScheduler$dd_sdk_android_release", "(Lcom/datadog/android/core/internal/data/upload/UploadScheduler;)V", "uploader", "Lcom/datadog/android/v2/core/internal/net/DataUploader;", "getUploader$dd_sdk_android_release", "()Lcom/datadog/android/v2/core/internal/net/DataUploader;", "setUploader$dd_sdk_android_release", "(Lcom/datadog/android/v2/core/internal/net/DataUploader;)V", "clearAllData", "", "createStorage", "createUploader", "flushStoredData", "flushStoredData$dd_sdk_android_release", "getPlugins", "", "initialize", "context", "Landroid/content/Context;", "plugins", "isInitialized", "", "onInitialize", "onPostInitialized", "onPostStopped", "onStop", "registerPlugins", "config", "Lcom/datadog/android/plugin/DatadogPluginConfig;", "trackingConsentProvider", "Lcom/datadog/android/core/internal/privacy/ConsentProvider;", "sendEvent", "event", "", "setupUploader", "stop", "unregisterPlugins", "withWriteContext", "forceNewBatch", "callback", "Lkotlin/Function2;", "Lcom/datadog/android/v2/api/context/DatadogContext;", "Lcom/datadog/android/v2/api/EventBatchWriter;", "Companion", "dd-sdk-android_release"})
public final class SdkFeature
implements FeatureScope {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CoreFeature coreFeature;
    @NotNull
    private final String featureName;
    @NotNull
    private final FeatureStorageConfiguration storageConfiguration;
    @NotNull
    private final FeatureUploadConfiguration uploadConfiguration;
    @NotNull
    private final AtomicBoolean initialized;
    @NotNull
    private final AtomicReference<FeatureEventReceiver> eventReceiver;
    @NotNull
    private Storage storage;
    @NotNull
    private DataUploader uploader;
    @NotNull
    private UploadScheduler uploadScheduler;
    @NotNull
    private FileOrchestrator fileOrchestrator;
    @NotNull
    private final List<DatadogPlugin> featurePlugins;
    @NotNull
    public static final String NO_EVENT_RECEIVER = "Feature \"%s\" has no event receiver registered, ignoring event.";

    public SdkFeature(@NotNull CoreFeature coreFeature, @NotNull String featureName, @NotNull FeatureStorageConfiguration storageConfiguration, @NotNull FeatureUploadConfiguration uploadConfiguration) {
        Intrinsics.checkNotNullParameter((Object)coreFeature, (String)"coreFeature");
        Intrinsics.checkNotNullParameter((Object)featureName, (String)"featureName");
        Intrinsics.checkNotNullParameter((Object)storageConfiguration, (String)"storageConfiguration");
        Intrinsics.checkNotNullParameter((Object)uploadConfiguration, (String)"uploadConfiguration");
        this.coreFeature = coreFeature;
        this.featureName = featureName;
        this.storageConfiguration = storageConfiguration;
        this.uploadConfiguration = uploadConfiguration;
        this.initialized = new AtomicBoolean(false);
        this.eventReceiver = new AtomicReference<Object>(null);
        this.storage = new NoOpStorage();
        this.uploader = new NoOpDataUploader();
        this.uploadScheduler = new NoOpUploadScheduler();
        this.fileOrchestrator = new NoOpFileOrchestrator();
        this.featurePlugins = new ArrayList();
    }

    @NotNull
    public final CoreFeature getCoreFeature$dd_sdk_android_release() {
        return this.coreFeature;
    }

    @NotNull
    public final AtomicBoolean getInitialized$dd_sdk_android_release() {
        return this.initialized;
    }

    @NotNull
    public final AtomicReference<FeatureEventReceiver> getEventReceiver$dd_sdk_android_release() {
        return this.eventReceiver;
    }

    @NotNull
    public final Storage getStorage$dd_sdk_android_release() {
        return this.storage;
    }

    public final void setStorage$dd_sdk_android_release(@NotNull Storage storage) {
        Intrinsics.checkNotNullParameter((Object)storage, (String)"<set-?>");
        this.storage = storage;
    }

    @NotNull
    public final DataUploader getUploader$dd_sdk_android_release() {
        return this.uploader;
    }

    public final void setUploader$dd_sdk_android_release(@NotNull DataUploader dataUploader) {
        Intrinsics.checkNotNullParameter((Object)dataUploader, (String)"<set-?>");
        this.uploader = dataUploader;
    }

    @NotNull
    public final UploadScheduler getUploadScheduler$dd_sdk_android_release() {
        return this.uploadScheduler;
    }

    public final void setUploadScheduler$dd_sdk_android_release(@NotNull UploadScheduler uploadScheduler) {
        Intrinsics.checkNotNullParameter((Object)uploadScheduler, (String)"<set-?>");
        this.uploadScheduler = uploadScheduler;
    }

    @NotNull
    public final FileOrchestrator getFileOrchestrator$dd_sdk_android_release() {
        return this.fileOrchestrator;
    }

    public final void setFileOrchestrator$dd_sdk_android_release(@NotNull FileOrchestrator fileOrchestrator) {
        Intrinsics.checkNotNullParameter((Object)fileOrchestrator, (String)"<set-?>");
        this.fileOrchestrator = fileOrchestrator;
    }

    public final void initialize(@NotNull Context context, @NotNull List<? extends DatadogPlugin> plugins) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(plugins, (String)"plugins");
        if (this.initialized.get()) {
            return;
        }
        this.storage = this.createStorage(this.featureName, this.storageConfiguration);
        this.setupUploader();
        this.registerPlugins(plugins, new DatadogPluginConfig(context, this.coreFeature.getStorageDir$dd_sdk_android_release(), this.coreFeature.getEnvName$dd_sdk_android_release(), this.coreFeature.getServiceName$dd_sdk_android_release(), this.coreFeature.getTrackingConsentProvider$dd_sdk_android_release().getConsent()), this.coreFeature.getTrackingConsentProvider$dd_sdk_android_release());
        this.onInitialize();
        this.initialized.set(true);
        this.onPostInitialized();
    }

    public final boolean isInitialized() {
        return this.initialized.get();
    }

    public final void clearAllData() {
        this.storage.dropAll();
    }

    public final void stop() {
        if (this.initialized.get()) {
            this.unregisterPlugins();
            this.uploadScheduler.stopScheduling();
            this.uploadScheduler = new NoOpUploadScheduler();
            this.storage = new NoOpStorage();
            this.uploader = new NoOpDataUploader();
            this.fileOrchestrator = new NoOpFileOrchestrator();
            this.onStop();
            this.initialized.set(false);
            this.onPostStopped();
        }
    }

    @Deprecated(message="Datadog Plugins will be removed in SDK v2.0.0. You will then need to write your own Feature (check our own code for guidance).")
    @NotNull
    public final List<DatadogPlugin> getPlugins() {
        return this.featurePlugins;
    }

    @Override
    public void withWriteContext(boolean forceNewBatch, @NotNull Function2<? super DatadogContext, ? super EventBatchWriter, Unit> callback) {
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        ContextProvider contextProvider = this.coreFeature.getContextProvider$dd_sdk_android_release();
        if (contextProvider instanceof NoOpContextProvider) {
            return;
        }
        DatadogContext context = contextProvider.getContext();
        this.storage.writeCurrentBatch(context, forceNewBatch, (Function1<? super EventBatchWriter, Unit>)((Function1)new Function1<EventBatchWriter, Unit>(callback, context){
            final /* synthetic */ Function2<DatadogContext, EventBatchWriter, Unit> $callback;
            final /* synthetic */ DatadogContext $context;
            {
                this.$callback = $callback;
                this.$context = $context;
                super(1);
            }

            public final void invoke(@NotNull EventBatchWriter it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.$callback.invoke((Object)this.$context, (Object)it);
            }
        }));
    }

    @Override
    public void sendEvent(@NotNull Object event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        FeatureEventReceiver receiver = this.eventReceiver.get();
        if (receiver == null) {
            InternalLogger internalLogger = RuntimeUtilsKt.getInternalLogger();
            String string = NO_EVENT_RECEIVER;
            Locale locale = Locale.US;
            Object[] objectArray = new Object[]{this.featureName};
            String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(locale, this, *args)");
            InternalLogger.DefaultImpls.log$default(internalLogger, InternalLogger.Level.INFO, InternalLogger.Target.USER, string2, null, 8, null);
        } else {
            receiver.onReceive(event);
        }
    }

    public final void onInitialize() {
    }

    public final void onPostInitialized() {
    }

    public final void onStop() {
    }

    public final void onPostStopped() {
    }

    private final void registerPlugins(List<? extends DatadogPlugin> plugins, DatadogPluginConfig config, ConsentProvider trackingConsentProvider) {
        Iterable $this$forEach$iv = plugins;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DatadogPlugin it = (DatadogPlugin)element$iv;
            boolean bl = false;
            this.featurePlugins.add(it);
            it.register(config);
            trackingConsentProvider.registerCallback(it);
        }
    }

    private final void unregisterPlugins() {
        Iterable $this$forEach$iv = this.featurePlugins;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DatadogPlugin it = (DatadogPlugin)element$iv;
            boolean bl = false;
            it.unregister();
        }
        this.featurePlugins.clear();
    }

    private final void setupUploader() {
        UploadScheduler uploadScheduler;
        if (this.coreFeature.isMainProcess$dd_sdk_android_release()) {
            this.uploader = this.createUploader(this.uploadConfiguration);
            uploadScheduler = new DataUploadScheduler(this.storage, this.uploader, this.coreFeature.getContextProvider$dd_sdk_android_release(), this.coreFeature.getNetworkInfoProvider$dd_sdk_android_release(), this.coreFeature.getSystemInfoProvider$dd_sdk_android_release(), this.coreFeature.getUploadFrequency$dd_sdk_android_release(), this.coreFeature.getUploadExecutorService$dd_sdk_android_release());
        } else {
            uploadScheduler = new NoOpUploadScheduler();
        }
        this.uploadScheduler = uploadScheduler;
        this.uploadScheduler.startScheduling();
    }

    private final Storage createStorage(String featureName, FeatureStorageConfiguration storageConfiguration) {
        FeatureFileOrchestrator fileOrchestrator = new FeatureFileOrchestrator(this.coreFeature.getTrackingConsentProvider$dd_sdk_android_release(), this.coreFeature.getStorageDir$dd_sdk_android_release(), featureName, this.coreFeature.getPersistenceExecutorService$dd_sdk_android_release(), RuntimeUtilsKt.getInternalLogger());
        this.fileOrchestrator = fileOrchestrator;
        return new ConsentAwareStorage(this.coreFeature.getPersistenceExecutorService$dd_sdk_android_release(), fileOrchestrator.getGrantedOrchestrator$dd_sdk_android_release(), fileOrchestrator.getPendingOrchestrator$dd_sdk_android_release(), BatchFileReaderWriter.Companion.create(RuntimeUtilsKt.getInternalLogger(), this.coreFeature.getLocalDataEncryption$dd_sdk_android_release()), FileReaderWriter.Companion.create(RuntimeUtilsKt.getInternalLogger(), this.coreFeature.getLocalDataEncryption$dd_sdk_android_release()), new FileMover(RuntimeUtilsKt.getInternalLogger()), RuntimeUtilsKt.getInternalLogger(), FilePersistenceConfig.copy$default(this.coreFeature.buildFilePersistenceConfig(), 0L, storageConfiguration.getMaxBatchSize(), storageConfiguration.getMaxItemSize(), storageConfiguration.getMaxItemsPerBatch(), storageConfiguration.getOldBatchThreshold(), 0L, 33, null));
    }

    private final DataUploader createUploader(FeatureUploadConfiguration uploadConfiguration) {
        return new DataOkHttpUploader(uploadConfiguration.getRequestFactory(), RuntimeUtilsKt.getInternalLogger(), (Call.Factory)this.coreFeature.getOkHttpClient$dd_sdk_android_release(), this.coreFeature.getSdkVersion$dd_sdk_android_release(), this.coreFeature.getAndroidInfoProvider$dd_sdk_android_release());
    }

    public final void flushStoredData$dd_sdk_android_release() {
        DataFlusher flusher = new DataFlusher(this.coreFeature.getContextProvider$dd_sdk_android_release(), this.fileOrchestrator, BatchFileReaderWriter.Companion.create(RuntimeUtilsKt.getInternalLogger(), this.coreFeature.getLocalDataEncryption$dd_sdk_android_release()), FileReaderWriter.Companion.create(RuntimeUtilsKt.getInternalLogger(), this.coreFeature.getLocalDataEncryption$dd_sdk_android_release()), new FileMover(RuntimeUtilsKt.getInternalLogger()));
        flusher.flush(this.uploader);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/datadog/android/core/internal/SdkFeature$Companion;", "", "()V", "NO_EVENT_RECEIVER", "", "dd-sdk-android_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

