/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.core.internal.data.upload;

import androidx.annotation.WorkerThread;
import com.datadog.android.core.configuration.UploadFrequency;
import com.datadog.android.core.internal.data.upload.UploadRunnable;
import com.datadog.android.core.internal.net.DataUploader;
import com.datadog.android.core.internal.net.UploadStatus;
import com.datadog.android.core.internal.net.info.NetworkInfoProvider;
import com.datadog.android.core.internal.persistence.Batch;
import com.datadog.android.core.internal.persistence.DataReader;
import com.datadog.android.core.internal.system.SystemInfo;
import com.datadog.android.core.internal.system.SystemInfoProvider;
import com.datadog.android.core.internal.utils.ConcurrencyExtKt;
import com.datadog.android.v2.api.context.NetworkInfo;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0000\u0018\u0000 &2\u00020\u0001:\u0001&B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0003J\b\u0010\u001f\u001a\u00020\u001cH\u0002J\b\u0010 \u001a\u00020\u001cH\u0002J\b\u0010!\u001a\u00020\"H\u0002J\b\u0010#\u001a\u00020\"H\u0002J\b\u0010$\u001a\u00020\u001cH\u0017J\b\u0010%\u001a\u00020\u001cH\u0002R\u001a\u0010\u000f\u001a\u00020\u0010X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0015\u001a\u00020\u0010X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0012\"\u0004\b\u0017\u0010\u0014R\u001a\u0010\u0018\u001a\u00020\u0010X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u0012\"\u0004\b\u001a\u0010\u0014R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/datadog/android/core/internal/data/upload/DataUploadRunnable;", "Lcom/datadog/android/core/internal/data/upload/UploadRunnable;", "threadPoolExecutor", "Ljava/util/concurrent/ScheduledThreadPoolExecutor;", "reader", "Lcom/datadog/android/core/internal/persistence/DataReader;", "dataUploader", "Lcom/datadog/android/core/internal/net/DataUploader;", "networkInfoProvider", "Lcom/datadog/android/core/internal/net/info/NetworkInfoProvider;", "systemInfoProvider", "Lcom/datadog/android/core/internal/system/SystemInfoProvider;", "uploadFrequency", "Lcom/datadog/android/core/configuration/UploadFrequency;", "(Ljava/util/concurrent/ScheduledThreadPoolExecutor;Lcom/datadog/android/core/internal/persistence/DataReader;Lcom/datadog/android/core/internal/net/DataUploader;Lcom/datadog/android/core/internal/net/info/NetworkInfoProvider;Lcom/datadog/android/core/internal/system/SystemInfoProvider;Lcom/datadog/android/core/configuration/UploadFrequency;)V", "currentDelayIntervalMs", "", "getCurrentDelayIntervalMs$dd_sdk_android_release", "()J", "setCurrentDelayIntervalMs$dd_sdk_android_release", "(J)V", "maxDelayMs", "getMaxDelayMs$dd_sdk_android_release", "setMaxDelayMs$dd_sdk_android_release", "minDelayMs", "getMinDelayMs$dd_sdk_android_release", "setMinDelayMs$dd_sdk_android_release", "consumeBatch", "", "batch", "Lcom/datadog/android/core/internal/persistence/Batch;", "decreaseInterval", "increaseInterval", "isNetworkAvailable", "", "isSystemReady", "run", "scheduleNextUpload", "Companion", "dd-sdk-android_release"})
public final class DataUploadRunnable
implements UploadRunnable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ScheduledThreadPoolExecutor threadPoolExecutor;
    @NotNull
    private final DataReader reader;
    @NotNull
    private final DataUploader dataUploader;
    @NotNull
    private final NetworkInfoProvider networkInfoProvider;
    @NotNull
    private final SystemInfoProvider systemInfoProvider;
    private long currentDelayIntervalMs;
    private long minDelayMs;
    private long maxDelayMs;
    public static final int LOW_BATTERY_THRESHOLD = 10;
    public static final int MIN_DELAY_FACTOR = 1;
    public static final int DEFAULT_DELAY_FACTOR = 5;
    public static final int MAX_DELAY_FACTOR = 10;
    public static final double DECREASE_PERCENT = 0.9;
    public static final double INCREASE_PERCENT = 1.1;

    public DataUploadRunnable(@NotNull ScheduledThreadPoolExecutor threadPoolExecutor, @NotNull DataReader reader2, @NotNull DataUploader dataUploader, @NotNull NetworkInfoProvider networkInfoProvider, @NotNull SystemInfoProvider systemInfoProvider, @NotNull UploadFrequency uploadFrequency) {
        Intrinsics.checkNotNullParameter((Object)threadPoolExecutor, (String)"threadPoolExecutor");
        Intrinsics.checkNotNullParameter((Object)reader2, (String)"reader");
        Intrinsics.checkNotNullParameter((Object)dataUploader, (String)"dataUploader");
        Intrinsics.checkNotNullParameter((Object)networkInfoProvider, (String)"networkInfoProvider");
        Intrinsics.checkNotNullParameter((Object)systemInfoProvider, (String)"systemInfoProvider");
        Intrinsics.checkNotNullParameter((Object)((Object)uploadFrequency), (String)"uploadFrequency");
        this.threadPoolExecutor = threadPoolExecutor;
        this.reader = reader2;
        this.dataUploader = dataUploader;
        this.networkInfoProvider = networkInfoProvider;
        this.systemInfoProvider = systemInfoProvider;
        this.currentDelayIntervalMs = (long)5 * uploadFrequency.getBaseStepMs$dd_sdk_android_release();
        this.minDelayMs = 1L * uploadFrequency.getBaseStepMs$dd_sdk_android_release();
        this.maxDelayMs = (long)10 * uploadFrequency.getBaseStepMs$dd_sdk_android_release();
    }

    public final long getCurrentDelayIntervalMs$dd_sdk_android_release() {
        return this.currentDelayIntervalMs;
    }

    public final void setCurrentDelayIntervalMs$dd_sdk_android_release(long l) {
        this.currentDelayIntervalMs = l;
    }

    public final long getMinDelayMs$dd_sdk_android_release() {
        return this.minDelayMs;
    }

    public final void setMinDelayMs$dd_sdk_android_release(long l) {
        this.minDelayMs = l;
    }

    public final long getMaxDelayMs$dd_sdk_android_release() {
        return this.maxDelayMs;
    }

    public final void setMaxDelayMs$dd_sdk_android_release(long l) {
        this.maxDelayMs = l;
    }

    @Override
    @WorkerThread
    public void run() {
        Batch batch;
        Batch batch2 = batch = this.isNetworkAvailable() && this.isSystemReady() ? this.reader.lockAndReadNext() : (Batch)null;
        if (batch != null) {
            this.consumeBatch(batch);
        } else {
            this.increaseInterval();
        }
        this.scheduleNextUpload();
    }

    private final boolean isNetworkAvailable() {
        NetworkInfo networkInfo = this.networkInfoProvider.getLatestNetworkInfo();
        return networkInfo.getConnectivity() != NetworkInfo.Connectivity.NETWORK_NOT_CONNECTED;
    }

    private final boolean isSystemReady() {
        SystemInfo systemInfo = this.systemInfoProvider.getLatestSystemInfo();
        boolean hasEnoughPower = systemInfo.getBatteryFullOrCharging() || systemInfo.getOnExternalPowerSource() || systemInfo.getBatteryLevel() > 10;
        return hasEnoughPower && !systemInfo.getPowerSaveMode();
    }

    private final void scheduleNextUpload() {
        this.threadPoolExecutor.remove(this);
        ConcurrencyExtKt.scheduleSafe(this.threadPoolExecutor, "Data upload", this.currentDelayIntervalMs, TimeUnit.MILLISECONDS, this);
    }

    @WorkerThread
    private final void consumeBatch(Batch batch) {
        UploadStatus status = this.dataUploader.upload(batch.getData());
        if (status.getShouldRetry()) {
            this.reader.release(batch);
            this.increaseInterval();
        } else {
            this.reader.drop(batch);
            this.decreaseInterval();
        }
    }

    private final void decreaseInterval() {
        this.currentDelayIntervalMs = Math.max(this.minDelayMs, MathKt.roundToLong((double)((double)this.currentDelayIntervalMs * 0.9)));
    }

    private final void increaseInterval() {
        this.currentDelayIntervalMs = Math.min(this.maxDelayMs, MathKt.roundToLong((double)((double)this.currentDelayIntervalMs * 1.1)));
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/datadog/android/core/internal/data/upload/DataUploadRunnable$Companion;", "", "()V", "DECREASE_PERCENT", "", "DEFAULT_DELAY_FACTOR", "", "INCREASE_PERCENT", "LOW_BATTERY_THRESHOLD", "MAX_DELAY_FACTOR", "MIN_DELAY_FACTOR", "dd-sdk-android_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

