/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.core.internal.data.upload;

import android.content.Context;
import androidx.annotation.WorkerThread;
import androidx.work.ListenableWorker;
import androidx.work.Worker;
import androidx.work.WorkerParameters;
import com.datadog.android.Datadog;
import com.datadog.android.core.internal.SdkFeature;
import com.datadog.android.core.internal.net.UploadStatus;
import com.datadog.android.core.internal.utils.RuntimeUtilsKt;
import com.datadog.android.v2.api.FeatureScope;
import com.datadog.android.v2.api.InternalLogger;
import com.datadog.android.v2.api.SdkCore;
import com.datadog.android.v2.api.context.DatadogContext;
import com.datadog.android.v2.core.DatadogCore;
import com.datadog.android.v2.core.internal.ContextProvider;
import com.datadog.android.v2.core.internal.net.DataUploader;
import com.datadog.android.v2.core.internal.storage.BatchConfirmation;
import com.datadog.android.v2.core.internal.storage.BatchId;
import com.datadog.android.v2.core.internal.storage.BatchReader;
import com.datadog.android.v2.core.internal.storage.Storage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \t2\u00020\u0001:\u0002\t\nB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0017\u00a8\u0006\u000b"}, d2={"Lcom/datadog/android/core/internal/data/upload/UploadWorker;", "Landroidx/work/Worker;", "appContext", "Landroid/content/Context;", "workerParams", "Landroidx/work/WorkerParameters;", "(Landroid/content/Context;Landroidx/work/WorkerParameters;)V", "doWork", "Landroidx/work/ListenableWorker$Result;", "Companion", "UploadNextBatchTask", "dd-sdk-android_release"})
public final class UploadWorker
extends Worker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final long LOCK_AWAIT_SECONDS = 30L;

    public UploadWorker(@NotNull Context appContext, @NotNull WorkerParameters workerParams) {
        Intrinsics.checkNotNullParameter((Object)appContext, (String)"appContext");
        Intrinsics.checkNotNullParameter((Object)workerParams, (String)"workerParams");
        super(appContext, workerParams);
    }

    /*
     * WARNING - void declaration
     */
    @WorkerThread
    @NotNull
    public ListenableWorker.Result doWork() {
        DatadogCore globalSdkCore;
        if (!Datadog.isInitialized()) {
            InternalLogger.DefaultImpls.log$default(RuntimeUtilsKt.getInternalLogger(), InternalLogger.Level.ERROR, InternalLogger.Target.USER, "Datadog has not been initialized.\n Please add the following code in your application's onCreate() method:\nval credentials = Credentials(\"<CLIENT_TOKEN>\", \"<ENVIRONMENT>\", \"<VARIANT>\", \"<APPLICATION_ID>\")\nDatadog.initialize(context, credentials, configuration, trackingConsent);", null, 8, null);
            ListenableWorker.Result result = ListenableWorker.Result.success();
            Intrinsics.checkNotNullExpressionValue((Object)result, (String)"success()");
            return result;
        }
        SdkCore sdkCore = Datadog.INSTANCE.getGlobalSdkCore$dd_sdk_android_release();
        DatadogCore datadogCore = globalSdkCore = sdkCore instanceof DatadogCore ? (DatadogCore)sdkCore : null;
        if (globalSdkCore != null) {
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv = globalSdkCore.getAllFeatures();
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                SdkFeature it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                FeatureScope it = (FeatureScope)element$iv$iv;
                boolean bl2 = false;
                if ((it instanceof SdkFeature ? (SdkFeature)it : null) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List features = CollectionsKt.shuffled((Iterable)((List)destination$iv$iv));
            LinkedList<UploadNextBatchTask> tasksQueue = new LinkedList<UploadNextBatchTask>();
            Iterable $this$forEach$iv = features;
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv) {
                SdkFeature it = (SdkFeature)element$iv;
                boolean bl = false;
                tasksQueue.offer(new UploadNextBatchTask((Queue<UploadNextBatchTask>)tasksQueue, globalSdkCore, it));
            }
            while (!tasksQueue.isEmpty()) {
                UploadNextBatchTask uploadNextBatchTask = (UploadNextBatchTask)tasksQueue.poll();
                if (uploadNextBatchTask == null) continue;
                uploadNextBatchTask.run();
            }
        }
        sdkCore = ListenableWorker.Result.success();
        Intrinsics.checkNotNullExpressionValue((Object)sdkCore, (String)"success()");
        return sdkCore;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B#\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00000\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ0\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\b\u0010\u0010\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0017R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00000\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/datadog/android/core/internal/data/upload/UploadWorker$UploadNextBatchTask;", "Ljava/lang/Runnable;", "taskQueue", "Ljava/util/Queue;", "datadogCore", "Lcom/datadog/android/v2/core/DatadogCore;", "feature", "Lcom/datadog/android/core/internal/SdkFeature;", "(Ljava/util/Queue;Lcom/datadog/android/v2/core/DatadogCore;Lcom/datadog/android/core/internal/SdkFeature;)V", "consumeBatch", "", "context", "Lcom/datadog/android/v2/api/context/DatadogContext;", "batch", "", "", "batchMeta", "uploader", "Lcom/datadog/android/v2/core/internal/net/DataUploader;", "run", "", "dd-sdk-android_release"})
    public static final class UploadNextBatchTask
    implements Runnable {
        @NotNull
        private final Queue<UploadNextBatchTask> taskQueue;
        @NotNull
        private final DatadogCore datadogCore;
        @NotNull
        private final SdkFeature feature;

        public UploadNextBatchTask(@NotNull Queue<UploadNextBatchTask> taskQueue, @NotNull DatadogCore datadogCore, @NotNull SdkFeature feature) {
            Intrinsics.checkNotNullParameter(taskQueue, (String)"taskQueue");
            Intrinsics.checkNotNullParameter((Object)datadogCore, (String)"datadogCore");
            Intrinsics.checkNotNullParameter((Object)feature, (String)"feature");
            this.taskQueue = taskQueue;
            this.datadogCore = datadogCore;
            this.feature = feature;
        }

        @Override
        @WorkerThread
        public void run() {
            ContextProvider contextProvider = this.datadogCore.getContextProvider$dd_sdk_android_release();
            DatadogContext datadogContext = contextProvider == null ? null : contextProvider.getContext();
            if (datadogContext == null) {
                return;
            }
            DatadogContext context = datadogContext;
            Storage storage = this.feature.getStorage$dd_sdk_android_release();
            DataUploader uploader = this.feature.getUploader$dd_sdk_android_release();
            CountDownLatch lock = new CountDownLatch(1);
            storage.readNextBatch((Function0<Unit>)((Function0)new Function0<Unit>(lock){
                final /* synthetic */ CountDownLatch $lock;
                {
                    this.$lock = $lock;
                    super(0);
                }

                public final void invoke() {
                    this.$lock.countDown();
                }
            }), (Function2<? super BatchId, ? super BatchReader, Unit>)((Function2)new Function2<BatchId, BatchReader, Unit>(this, context, uploader, storage, lock){
                final /* synthetic */ UploadNextBatchTask this$0;
                final /* synthetic */ DatadogContext $context;
                final /* synthetic */ DataUploader $uploader;
                final /* synthetic */ Storage $storage;
                final /* synthetic */ CountDownLatch $lock;
                {
                    this.this$0 = $receiver;
                    this.$context = $context;
                    this.$uploader = $uploader;
                    this.$storage = $storage;
                    this.$lock = $lock;
                    super(2);
                }

                public final void invoke(@NotNull BatchId batchId, @NotNull BatchReader reader2) {
                    Intrinsics.checkNotNullParameter((Object)batchId, (String)"batchId");
                    Intrinsics.checkNotNullParameter((Object)reader2, (String)"reader");
                    List<byte[]> batch = reader2.read();
                    byte[] batchMeta = reader2.currentMetadata();
                    boolean success = UploadNextBatchTask.access$consumeBatch(this.this$0, this.$context, batch, batchMeta, this.$uploader);
                    this.$storage.confirmBatchRead(batchId, (Function1<? super BatchConfirmation, Unit>)((Function1)new Function1<BatchConfirmation, Unit>(success, this.this$0, this.$lock){
                        final /* synthetic */ boolean $success;
                        final /* synthetic */ UploadNextBatchTask this$0;
                        final /* synthetic */ CountDownLatch $lock;
                        {
                            this.$success = $success;
                            this.this$0 = $receiver;
                            this.$lock = $lock;
                            super(1);
                        }

                        public final void invoke(@NotNull BatchConfirmation confirmation2) {
                            Intrinsics.checkNotNullParameter((Object)confirmation2, (String)"confirmation");
                            confirmation2.markAsRead(this.$success);
                            UploadNextBatchTask.access$getTaskQueue$p(this.this$0).offer(new UploadNextBatchTask(UploadNextBatchTask.access$getTaskQueue$p(this.this$0), UploadNextBatchTask.access$getDatadogCore$p(this.this$0), UploadNextBatchTask.access$getFeature$p(this.this$0)));
                            this.$lock.countDown();
                        }
                    }));
                }
            }));
            lock.await(30L, TimeUnit.SECONDS);
        }

        private final boolean consumeBatch(DatadogContext context, List<byte[]> batch, byte[] batchMeta, DataUploader uploader) {
            UploadStatus status = uploader.upload(context, batch, batchMeta);
            return status == UploadStatus.SUCCESS;
        }

        public static final /* synthetic */ boolean access$consumeBatch(UploadNextBatchTask $this, DatadogContext context, List batch, byte[] batchMeta, DataUploader uploader) {
            return $this.consumeBatch(context, batch, batchMeta, uploader);
        }

        public static final /* synthetic */ Queue access$getTaskQueue$p(UploadNextBatchTask $this) {
            return $this.taskQueue;
        }

        public static final /* synthetic */ DatadogCore access$getDatadogCore$p(UploadNextBatchTask $this) {
            return $this.datadogCore;
        }

        public static final /* synthetic */ SdkFeature access$getFeature$p(UploadNextBatchTask $this) {
            return $this.feature;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/datadog/android/core/internal/data/upload/UploadWorker$Companion;", "", "()V", "LOCK_AWAIT_SECONDS", "", "dd-sdk-android_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

