/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.core.internal.net;

import com.datadog.android.tracing.TracingHeaderType;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import okhttp3.HttpUrl;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0018\u0010\u0002\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0003\u00a2\u0006\u0002\u0010\u0007J\u0014\u0010\f\u001a\u00020\r2\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u000eJ \u0010\u000f\u001a\u00020\r2\u0018\u0010\u0010\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0003J\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005J\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0013\u001a\u00020\u0004J\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0013\u001a\u00020\u0014J\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u0004J\u000e\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u0014RB\u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u00032\u0018\u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0003@BX\u0080\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0018"}, d2={"Lcom/datadog/android/core/internal/net/FirstPartyHostHeaderTypeResolver;", "", "hosts", "", "", "", "Lcom/datadog/android/tracing/TracingHeaderType;", "(Ljava/util/Map;)V", "<set-?>", "knownHosts", "getKnownHosts$dd_sdk_android_release", "()Ljava/util/Map;", "addKnownHosts", "", "", "addKnownHostsWithHeaderTypes", "hostsWithHeaderTypes", "getAllHeaderTypes", "headerTypesForUrl", "url", "Lokhttp3/HttpUrl;", "isEmpty", "", "isFirstPartyUrl", "dd-sdk-android_release"})
public final class FirstPartyHostHeaderTypeResolver {
    @NotNull
    private Map<String, ? extends Set<? extends TracingHeaderType>> knownHosts;

    /*
     * WARNING - void declaration
     */
    public FirstPartyHostHeaderTypeResolver(@NotNull Map<String, ? extends Set<? extends TracingHeaderType>> hosts) {
        void $this$associateTo$iv$iv;
        void $this$associate$iv;
        Intrinsics.checkNotNullParameter(hosts, (String)"hosts");
        Iterable iterable = hosts.entrySet();
        FirstPartyHostHeaderTypeResolver firstPartyHostHeaderTypeResolver = this;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        void var5_6 = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv;
            Map.Entry it = (Map.Entry)element$iv$iv;
            boolean bl = false;
            String string = (String)it.getKey();
            Locale locale = Locale.US;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
            String string2 = string.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(locale)");
            Pair pair = TuplesKt.to((Object)string2, it.getValue());
            map.put(pair.getFirst(), pair.getSecond());
        }
        firstPartyHostHeaderTypeResolver.knownHosts = destination$iv$iv;
    }

    @NotNull
    public final Map<String, Set<TracingHeaderType>> getKnownHosts$dd_sdk_android_release() {
        return this.knownHosts;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isFirstPartyUrl(@NotNull HttpUrl url) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        String host = url.host();
        Iterable $this$any$iv = this.knownHosts.keySet();
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            if (!iterator.hasNext()) return false;
            Object element$iv = iterator.next();
            String it = (String)element$iv;
            boolean bl2 = false;
            if (Intrinsics.areEqual((Object)it, (Object)"*")) return true;
            if (Intrinsics.areEqual((Object)host, (Object)it)) return true;
            Intrinsics.checkNotNullExpressionValue((Object)host, (String)"host");
            if (StringsKt.endsWith$default((String)host, (String)("." + it), (boolean)false, (int)2, null)) {
                return true;
            }
            bl = false;
        } while (!bl);
        return true;
    }

    public final boolean isFirstPartyUrl(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        HttpUrl httpUrl = HttpUrl.parse((String)url);
        if (httpUrl == null) {
            return false;
        }
        HttpUrl httpUrl2 = httpUrl;
        return this.isFirstPartyUrl(httpUrl2);
    }

    @NotNull
    public final Set<TracingHeaderType> headerTypesForUrl(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        HttpUrl httpUrl = HttpUrl.parse((String)url);
        if (httpUrl == null) {
            return SetsKt.emptySet();
        }
        HttpUrl httpUrl2 = httpUrl;
        return this.headerTypesForUrl(httpUrl2);
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public final Set<TracingHeaderType> headerTypesForUrl(@NotNull HttpUrl url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        host = url.host();
        $this$filter$iv = this.knownHosts;
        $i$f$filter = false;
        var6_5 = $this$filter$iv;
        destination$iv$iv = new LinkedHashMap<K, V>();
        $i$f$filterTo = false;
        var9_8 = $this$filterTo$iv$iv.entrySet().iterator();
        while (var9_8.hasNext()) {
            it = element$iv$iv = var9_8.next();
            $i$a$-filter-FirstPartyHostHeaderTypeResolver$headerTypesForUrl$filteredHosts$1 = false;
            if (Intrinsics.areEqual(it.getKey(), (Object)"*") || Intrinsics.areEqual(it.getKey(), (Object)host)) ** GOTO lbl-1000
            Intrinsics.checkNotNullExpressionValue((Object)host, (String)"host");
            if (StringsKt.endsWith$default((String)host, (String)("." + it.getKey()), (boolean)false, (int)2, null)) lbl-1000:
            // 2 sources

            {
                v0 = true;
            } else {
                v0 = false;
            }
            if (!v0) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        filteredHosts = destination$iv$iv;
        return CollectionsKt.toSet((Iterable)CollectionsKt.flatten((Iterable)filteredHosts.values()));
    }

    @NotNull
    public final Set<TracingHeaderType> getAllHeaderTypes() {
        return CollectionsKt.toSet((Iterable)CollectionsKt.flatten((Iterable)this.knownHosts.values()));
    }

    public final boolean isEmpty() {
        return this.knownHosts.isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    public final void addKnownHosts(@NotNull List<String> hosts) {
        void $this$associateTo$iv$iv;
        void $this$associate$iv;
        Intrinsics.checkNotNullParameter(hosts, (String)"hosts");
        Iterable iterable = hosts;
        Map<String, ? extends Set<? extends TracingHeaderType>> map = this.knownHosts;
        FirstPartyHostHeaderTypeResolver firstPartyHostHeaderTypeResolver = this;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        void var5_7 = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map2 = destination$iv$iv;
            String it = (String)element$iv$iv;
            boolean bl = false;
            Locale locale = Locale.US;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
            String string = it.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(locale)");
            Pair pair = TuplesKt.to((Object)string, (Object)SetsKt.setOf((Object)((Object)TracingHeaderType.DATADOG)));
            map2.put(pair.getFirst(), pair.getSecond());
        }
        Map map3 = destination$iv$iv;
        firstPartyHostHeaderTypeResolver.knownHosts = MapsKt.plus(map, (Map)map3);
    }

    /*
     * WARNING - void declaration
     */
    public final void addKnownHostsWithHeaderTypes(@NotNull Map<String, ? extends Set<? extends TracingHeaderType>> hostsWithHeaderTypes) {
        void $this$associateTo$iv$iv;
        void $this$associate$iv;
        Intrinsics.checkNotNullParameter(hostsWithHeaderTypes, (String)"hostsWithHeaderTypes");
        Iterable iterable = hostsWithHeaderTypes.entrySet();
        Map<String, ? extends Set<? extends TracingHeaderType>> map = this.knownHosts;
        FirstPartyHostHeaderTypeResolver firstPartyHostHeaderTypeResolver = this;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        void var5_7 = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map2 = destination$iv$iv;
            Map.Entry it = (Map.Entry)element$iv$iv;
            boolean bl = false;
            String string = (String)it.getKey();
            Locale locale = Locale.US;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
            String string2 = string.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(locale)");
            Pair pair = TuplesKt.to((Object)string2, it.getValue());
            map2.put(pair.getFirst(), pair.getSecond());
        }
        Map map3 = destination$iv$iv;
        firstPartyHostHeaderTypeResolver.knownHosts = MapsKt.plus(map, (Map)map3);
    }
}

