/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.core.internal.persistence;

import com.datadog.android.core.internal.persistence.Deserializer;
import com.datadog.android.core.internal.utils.RuntimeUtilsKt;
import com.datadog.android.v2.api.InternalLogger;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 \u00072\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0006\u001a\u00020\u0002H\u0016\u00a8\u0006\b"}, d2={"Lcom/datadog/android/core/internal/persistence/JsonObjectDeserializer;", "Lcom/datadog/android/core/internal/persistence/Deserializer;", "", "Lcom/google/gson/JsonObject;", "()V", "deserialize", "model", "Companion", "dd-sdk-android_release"})
public final class JsonObjectDeserializer
implements Deserializer<String, JsonObject> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String DESERIALIZE_ERROR_MESSAGE_FORMAT = "Error while trying to deserialize the serialized RumEvent: %s";

    @Override
    @Nullable
    public JsonObject deserialize(@NotNull String model) {
        JsonObject jsonObject;
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        try {
            jsonObject = JsonParser.parseString((String)model).getAsJsonObject();
        }
        catch (JsonParseException jpe) {
            InternalLogger internalLogger = RuntimeUtilsKt.getInternalLogger();
            Object object = new InternalLogger.Target[]{InternalLogger.Target.MAINTAINER, InternalLogger.Target.TELEMETRY};
            List list = CollectionsKt.listOf((Object[])object);
            object = DESERIALIZE_ERROR_MESSAGE_FORMAT;
            Locale locale = Locale.US;
            Object[] objectArray = new Object[]{model};
            String string = String.format(locale, (String)object, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(locale, this, *args)");
            internalLogger.log(InternalLogger.Level.ERROR, list, string, (Throwable)jpe);
            jsonObject = null;
        }
        catch (IllegalStateException ise) {
            InternalLogger internalLogger = RuntimeUtilsKt.getInternalLogger();
            Object object = new InternalLogger.Target[]{InternalLogger.Target.MAINTAINER, InternalLogger.Target.TELEMETRY};
            List list = CollectionsKt.listOf((Object[])object);
            object = DESERIALIZE_ERROR_MESSAGE_FORMAT;
            Locale locale = Locale.US;
            Object[] objectArray = new Object[]{model};
            String string = String.format(locale, (String)object, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(locale, this, *args)");
            internalLogger.log(InternalLogger.Level.ERROR, list, string, (Throwable)ise);
            jsonObject = null;
        }
        return jsonObject;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/datadog/android/core/internal/persistence/JsonObjectDeserializer$Companion;", "", "()V", "DESERIALIZE_ERROR_MESSAGE_FORMAT", "", "dd-sdk-android_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

