/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.core.internal.persistence.file;

import com.datadog.android.core.internal.persistence.file.FileExtKt;
import com.datadog.android.core.internal.utils.RuntimeUtilsKt;
import com.datadog.android.v2.api.InternalLogger;
import java.io.File;
import java.io.FileFilter;
import java.nio.charset.Charset;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000H\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0002H\u0000\u001a\f\u0010\u0003\u001a\u00020\u0001*\u00020\u0002H\u0000\u001a\f\u0010\u0004\u001a\u00020\u0001*\u00020\u0002H\u0000\u001a\f\u0010\u0005\u001a\u00020\u0001*\u00020\u0002H\u0000\u001a\f\u0010\u0006\u001a\u00020\u0001*\u00020\u0002H\u0000\u001a\f\u0010\u0007\u001a\u00020\u0001*\u00020\u0002H\u0000\u001a\f\u0010\b\u001a\u00020\t*\u00020\u0002H\u0000\u001a\u0019\u0010\n\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u000b*\u00020\u0002H\u0000\u00a2\u0006\u0002\u0010\f\u001a!\u0010\n\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u000b*\u00020\u00022\u0006\u0010\r\u001a\u00020\u000eH\u0000\u00a2\u0006\u0002\u0010\u000f\u001a\f\u0010\u0010\u001a\u00020\u0001*\u00020\u0002H\u0000\u001a\u000e\u0010\u0011\u001a\u0004\u0018\u00010\u0012*\u00020\u0002H\u0000\u001a\u001e\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u0014*\u00020\u00022\b\b\u0002\u0010\u0016\u001a\u00020\u0017H\u0000\u001a\u0018\u0010\u0018\u001a\u0004\u0018\u00010\u0015*\u00020\u00022\b\b\u0002\u0010\u0016\u001a\u00020\u0017H\u0000\u001a\u0014\u0010\u0019\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u001a\u001a\u00020\u0002H\u0000\u001a8\u0010\u001b\u001a\u0002H\u001c\"\u0004\b\u0000\u0010\u001c*\u00020\u00022\u0006\u0010\u001d\u001a\u0002H\u001c2\u0017\u0010\u001e\u001a\u0013\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u0002H\u001c0\u001f\u00a2\u0006\u0002\b H\u0002\u00a2\u0006\u0002\u0010!\u00a8\u0006\""}, d2={"canReadSafe", "", "Ljava/io/File;", "canWriteSafe", "deleteSafe", "existsSafe", "isDirectorySafe", "isFileSafe", "lengthSafe", "", "listFilesSafe", "", "(Ljava/io/File;)[Ljava/io/File;", "filter", "Ljava/io/FileFilter;", "(Ljava/io/File;Ljava/io/FileFilter;)[Ljava/io/File;", "mkdirsSafe", "readBytesSafe", "", "readLinesSafe", "", "", "charset", "Ljava/nio/charset/Charset;", "readTextSafe", "renameToSafe", "dest", "safeCall", "T", "default", "lambda", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "(Ljava/io/File;Ljava/lang/Object;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "dd-sdk-android_release"})
public final class FileExtKt {
    private static final <T> T safeCall(File $this$safeCall, T t, Function1<? super File, ? extends T> lambda) {
        Object object;
        try {
            object = lambda.invoke((Object)$this$safeCall);
        }
        catch (SecurityException e) {
            InternalLogger.Target[] targetArray = new InternalLogger.Target[]{InternalLogger.Target.MAINTAINER, InternalLogger.Target.TELEMETRY};
            RuntimeUtilsKt.getInternalLogger().log(InternalLogger.Level.ERROR, CollectionsKt.listOf((Object[])targetArray), "Security exception was thrown for file " + $this$safeCall.getPath(), (Throwable)e);
            object = t;
        }
        catch (Exception e) {
            InternalLogger.Target[] targetArray = new InternalLogger.Target[]{InternalLogger.Target.MAINTAINER, InternalLogger.Target.TELEMETRY};
            RuntimeUtilsKt.getInternalLogger().log(InternalLogger.Level.ERROR, CollectionsKt.listOf((Object[])targetArray), "Unexpected exception was thrown for file " + $this$safeCall.getPath(), (Throwable)e);
            object = t;
        }
        return (T)object;
    }

    public static final boolean canWriteSafe(@NotNull File $this$canWriteSafe) {
        Intrinsics.checkNotNullParameter((Object)$this$canWriteSafe, (String)"<this>");
        return FileExtKt.safeCall($this$canWriteSafe, false, canWriteSafe.1.INSTANCE);
    }

    public static final boolean canReadSafe(@NotNull File $this$canReadSafe) {
        Intrinsics.checkNotNullParameter((Object)$this$canReadSafe, (String)"<this>");
        return FileExtKt.safeCall($this$canReadSafe, false, canReadSafe.1.INSTANCE);
    }

    public static final boolean deleteSafe(@NotNull File $this$deleteSafe) {
        Intrinsics.checkNotNullParameter((Object)$this$deleteSafe, (String)"<this>");
        return FileExtKt.safeCall($this$deleteSafe, false, deleteSafe.1.INSTANCE);
    }

    public static final boolean existsSafe(@NotNull File $this$existsSafe) {
        Intrinsics.checkNotNullParameter((Object)$this$existsSafe, (String)"<this>");
        return FileExtKt.safeCall($this$existsSafe, false, existsSafe.1.INSTANCE);
    }

    public static final boolean isFileSafe(@NotNull File $this$isFileSafe) {
        Intrinsics.checkNotNullParameter((Object)$this$isFileSafe, (String)"<this>");
        return FileExtKt.safeCall($this$isFileSafe, false, isFileSafe.1.INSTANCE);
    }

    public static final boolean isDirectorySafe(@NotNull File $this$isDirectorySafe) {
        Intrinsics.checkNotNullParameter((Object)$this$isDirectorySafe, (String)"<this>");
        return FileExtKt.safeCall($this$isDirectorySafe, false, isDirectorySafe.1.INSTANCE);
    }

    @Nullable
    public static final File[] listFilesSafe(@NotNull File $this$listFilesSafe) {
        Intrinsics.checkNotNullParameter((Object)$this$listFilesSafe, (String)"<this>");
        return FileExtKt.safeCall($this$listFilesSafe, null, listFilesSafe.1.INSTANCE);
    }

    @Nullable
    public static final File[] listFilesSafe(@NotNull File $this$listFilesSafe, @NotNull FileFilter filter) {
        Intrinsics.checkNotNullParameter((Object)$this$listFilesSafe, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
        return FileExtKt.safeCall($this$listFilesSafe, null, (Function1)new Function1<File, File[]>(filter){
            final /* synthetic */ FileFilter $filter;
            {
                this.$filter = $filter;
                super(1);
            }

            @Nullable
            public final File[] invoke(@NotNull File $this$safeCall) {
                Intrinsics.checkNotNullParameter((Object)$this$safeCall, (String)"$this$safeCall");
                return $this$safeCall.listFiles(this.$filter);
            }
        });
    }

    public static final long lengthSafe(@NotNull File $this$lengthSafe) {
        Intrinsics.checkNotNullParameter((Object)$this$lengthSafe, (String)"<this>");
        return ((Number)FileExtKt.safeCall($this$lengthSafe, 0L, lengthSafe.1.INSTANCE)).longValue();
    }

    public static final boolean mkdirsSafe(@NotNull File $this$mkdirsSafe) {
        Intrinsics.checkNotNullParameter((Object)$this$mkdirsSafe, (String)"<this>");
        return FileExtKt.safeCall($this$mkdirsSafe, false, mkdirsSafe.1.INSTANCE);
    }

    public static final boolean renameToSafe(@NotNull File $this$renameToSafe, @NotNull File dest) {
        Intrinsics.checkNotNullParameter((Object)$this$renameToSafe, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        return FileExtKt.safeCall($this$renameToSafe, false, (Function1)new Function1<File, Boolean>(dest){
            final /* synthetic */ File $dest;
            {
                this.$dest = $dest;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull File $this$safeCall) {
                Intrinsics.checkNotNullParameter((Object)$this$safeCall, (String)"$this$safeCall");
                return $this$safeCall.renameTo(this.$dest);
            }
        });
    }

    @Nullable
    public static final String readTextSafe(@NotNull File $this$readTextSafe, @NotNull Charset charset) {
        Intrinsics.checkNotNullParameter((Object)$this$readTextSafe, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        return FileExtKt.existsSafe($this$readTextSafe) && FileExtKt.canReadSafe($this$readTextSafe) ? (String)FileExtKt.safeCall($this$readTextSafe, null, (Function1)new Function1<File, String>(charset){
            final /* synthetic */ Charset $charset;
            {
                this.$charset = $charset;
                super(1);
            }

            @Nullable
            public final String invoke(@NotNull File $this$safeCall) {
                Intrinsics.checkNotNullParameter((Object)$this$safeCall, (String)"$this$safeCall");
                return FilesKt.readText((File)$this$safeCall, (Charset)this.$charset);
            }
        }) : (String)null;
    }

    public static /* synthetic */ String readTextSafe$default(File file, Charset charset, int n, Object object) {
        if ((n & 1) != 0) {
            charset = Charsets.UTF_8;
        }
        return FileExtKt.readTextSafe(file, charset);
    }

    @Nullable
    public static final byte[] readBytesSafe(@NotNull File $this$readBytesSafe) {
        Intrinsics.checkNotNullParameter((Object)$this$readBytesSafe, (String)"<this>");
        return FileExtKt.existsSafe($this$readBytesSafe) && FileExtKt.canReadSafe($this$readBytesSafe) ? (byte[])FileExtKt.safeCall($this$readBytesSafe, null, readBytesSafe.1.INSTANCE) : (byte[])null;
    }

    @Nullable
    public static final List<String> readLinesSafe(@NotNull File $this$readLinesSafe, @NotNull Charset charset) {
        Intrinsics.checkNotNullParameter((Object)$this$readLinesSafe, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        return FileExtKt.existsSafe($this$readLinesSafe) && FileExtKt.canReadSafe($this$readLinesSafe) ? (List)FileExtKt.safeCall($this$readLinesSafe, null, (Function1)new Function1<File, List<? extends String>>(charset){
            final /* synthetic */ Charset $charset;
            {
                this.$charset = $charset;
                super(1);
            }

            @Nullable
            public final List<String> invoke(@NotNull File $this$safeCall) {
                Intrinsics.checkNotNullParameter((Object)$this$safeCall, (String)"$this$safeCall");
                return FilesKt.readLines((File)$this$safeCall, (Charset)this.$charset);
            }
        }) : (List)null;
    }

    public static /* synthetic */ List readLinesSafe$default(File file, Charset charset, int n, Object object) {
        if ((n & 1) != 0) {
            charset = Charsets.UTF_8;
        }
        return FileExtKt.readLinesSafe(file, charset);
    }
}

