/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.core.internal.persistence.file;

import androidx.annotation.WorkerThread;
import com.datadog.android.core.internal.persistence.file.FileExtKt;
import com.datadog.android.v2.api.InternalLogger;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007J\u0018\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\nH\u0002J\u0018\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\nH\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lcom/datadog/android/core/internal/persistence/file/FileMover;", "", "internalLogger", "Lcom/datadog/android/v2/api/InternalLogger;", "(Lcom/datadog/android/v2/api/InternalLogger;)V", "getInternalLogger", "()Lcom/datadog/android/v2/api/InternalLogger;", "delete", "", "target", "Ljava/io/File;", "moveFile", "file", "destDir", "moveFiles", "srcDir", "Companion", "dd-sdk-android_release"})
public final class FileMover {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final InternalLogger internalLogger;
    @NotNull
    public static final String ERROR_DELETE = "Unable to delete file: %s";
    @NotNull
    public static final String INFO_MOVE_NO_SRC = "Unable to move files; source directory does not exist: %s";
    @NotNull
    public static final String ERROR_MOVE_NOT_DIR = "Unable to move files; file is not a directory: %s";
    @NotNull
    public static final String ERROR_MOVE_NO_DST = "Unable to move files; could not create directory: %s";

    public FileMover(@NotNull InternalLogger internalLogger) {
        Intrinsics.checkNotNullParameter((Object)internalLogger, (String)"internalLogger");
        this.internalLogger = internalLogger;
    }

    @NotNull
    public final InternalLogger getInternalLogger() {
        return this.internalLogger;
    }

    @WorkerThread
    public final boolean delete(@NotNull File target) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        try {
            bl = FilesKt.deleteRecursively((File)target);
        }
        catch (FileNotFoundException e) {
            Object object = new InternalLogger.Target[]{InternalLogger.Target.MAINTAINER, InternalLogger.Target.TELEMETRY};
            List list = CollectionsKt.listOf((Object[])object);
            object = ERROR_DELETE;
            Locale locale = Locale.US;
            Object[] objectArray = new Object[]{target.getPath()};
            String string = String.format(locale, (String)object, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(locale, this, *args)");
            this.internalLogger.log(InternalLogger.Level.ERROR, list, string, (Throwable)e);
            bl = false;
        }
        catch (SecurityException e) {
            Object object = new InternalLogger.Target[]{InternalLogger.Target.MAINTAINER, InternalLogger.Target.TELEMETRY};
            List list = CollectionsKt.listOf((Object[])object);
            object = ERROR_DELETE;
            Locale locale = Locale.US;
            Object[] objectArray = new Object[]{target.getPath()};
            String string = String.format(locale, (String)object, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(locale, this, *args)");
            this.internalLogger.log(InternalLogger.Level.ERROR, list, string, (Throwable)e);
            bl = false;
        }
        return bl;
    }

    @WorkerThread
    public final boolean moveFiles(@NotNull File srcDir, @NotNull File destDir) {
        boolean bl;
        block9: {
            File[] srcFiles;
            File[] fileArray;
            Intrinsics.checkNotNullParameter((Object)srcDir, (String)"srcDir");
            Intrinsics.checkNotNullParameter((Object)destDir, (String)"destDir");
            if (!FileExtKt.existsSafe(srcDir)) {
                String string = INFO_MOVE_NO_SRC;
                Locale locale = Locale.US;
                Object[] objectArray = new Object[]{srcDir.getPath()};
                String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(locale, this, *args)");
                InternalLogger.DefaultImpls.log$default(this.internalLogger, InternalLogger.Level.INFO, InternalLogger.Target.MAINTAINER, string2, null, 8, null);
                return true;
            }
            if (!FileExtKt.isDirectorySafe(srcDir)) {
                Object object = new InternalLogger.Target[]{InternalLogger.Target.MAINTAINER, InternalLogger.Target.TELEMETRY};
                List list = CollectionsKt.listOf((Object[])object);
                object = ERROR_MOVE_NOT_DIR;
                Locale locale = Locale.US;
                Object[] objectArray = new Object[]{srcDir.getPath()};
                String string = String.format(locale, (String)object, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(locale, this, *args)");
                InternalLogger.DefaultImpls.log$default(this.internalLogger, InternalLogger.Level.ERROR, list, string, null, 8, null);
                return false;
            }
            if (!FileExtKt.existsSafe(destDir)) {
                if (!FileExtKt.mkdirsSafe(destDir)) {
                    Object object = new InternalLogger.Target[]{InternalLogger.Target.MAINTAINER, InternalLogger.Target.TELEMETRY};
                    List list = CollectionsKt.listOf((Object[])object);
                    object = ERROR_MOVE_NO_DST;
                    Locale locale = Locale.US;
                    Object[] objectArray = new Object[]{srcDir.getPath()};
                    String string = String.format(locale, (String)object, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(locale, this, *args)");
                    InternalLogger.DefaultImpls.log$default(this.internalLogger, InternalLogger.Level.ERROR, list, string, null, 8, null);
                    return false;
                }
            } else if (!FileExtKt.isDirectorySafe(destDir)) {
                Object object = new InternalLogger.Target[]{InternalLogger.Target.MAINTAINER, InternalLogger.Target.TELEMETRY};
                List list = CollectionsKt.listOf((Object[])object);
                object = ERROR_MOVE_NOT_DIR;
                Locale locale = Locale.US;
                Object[] objectArray = new Object[]{destDir.getPath()};
                String string = String.format(locale, (String)object, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(locale, this, *args)");
                InternalLogger.DefaultImpls.log$default(this.internalLogger, InternalLogger.Level.ERROR, list, string, null, 8, null);
                return false;
            }
            File[] $this$orEmpty$iv = FileExtKt.listFilesSafe(srcDir);
            boolean $i$f$orEmpty = false;
            File[] fileArray2 = $this$orEmpty$iv;
            if (fileArray2 == null) {
                boolean $i$f$emptyArray = false;
                fileArray = new File[]{};
            } else {
                fileArray = fileArray2;
            }
            File[] $this$all$iv = srcFiles = fileArray;
            boolean $i$f$all = false;
            for (File element$iv : $this$all$iv) {
                File file = element$iv;
                boolean bl2 = false;
                if (this.moveFile(file, destDir)) continue;
                bl = false;
                break block9;
            }
            bl = true;
        }
        return bl;
    }

    private final boolean moveFile(File file, File destDir) {
        File destFile = new File(destDir, file.getName());
        return FileExtKt.renameToSafe(file, destFile);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/datadog/android/core/internal/persistence/file/FileMover$Companion;", "", "()V", "ERROR_DELETE", "", "ERROR_MOVE_NOT_DIR", "ERROR_MOVE_NO_DST", "INFO_MOVE_NO_SRC", "dd-sdk-android_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

