/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.core.internal.persistence.file.advanced;

import androidx.annotation.WorkerThread;
import com.datadog.android.core.internal.persistence.file.FileOrchestrator;
import com.datadog.android.core.internal.persistence.file.NoOpFileOrchestrator;
import com.datadog.android.core.internal.persistence.file.advanced.DataMigrator;
import com.datadog.android.core.internal.privacy.ConsentProvider;
import com.datadog.android.privacy.TrackingConsent;
import com.datadog.android.privacy.TrackingConsentProviderCallback;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u0010\u0018\u0000 %2\u00020\u00012\u00020\u0002:\u0001%B+\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0001\u0012\u0006\u0010\u0006\u001a\u00020\u0001\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0002\u0010\nJ\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0017J\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0017J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0016\u001a\u00020\u0013H\u0017J\u0018\u0010\u0017\u001a\u0004\u0018\u00010\u00132\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00130\u0019H\u0017J\n\u0010\u001a\u001a\u0004\u0018\u00010\u0013H\u0017J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u001c\u001a\u00020\u001dH\u0017J\u001a\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010\t2\u0006\u0010!\u001a\u00020\tH\u0003J\u0018\u0010\"\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\t2\u0006\u0010!\u001a\u00020\tH\u0016J\u0012\u0010#\u001a\u00020\u00012\b\u0010$\u001a\u0004\u0018\u00010\tH\u0002R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u0001X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0005\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000f\u00a8\u0006&"}, d2={"Lcom/datadog/android/core/internal/persistence/file/advanced/ConsentAwareFileOrchestrator;", "Lcom/datadog/android/core/internal/persistence/file/FileOrchestrator;", "Lcom/datadog/android/privacy/TrackingConsentProviderCallback;", "consentProvider", "Lcom/datadog/android/core/internal/privacy/ConsentProvider;", "pendingOrchestrator", "grantedOrchestrator", "dataMigrator", "Lcom/datadog/android/core/internal/persistence/file/advanced/DataMigrator;", "Lcom/datadog/android/privacy/TrackingConsent;", "(Lcom/datadog/android/core/internal/privacy/ConsentProvider;Lcom/datadog/android/core/internal/persistence/file/FileOrchestrator;Lcom/datadog/android/core/internal/persistence/file/FileOrchestrator;Lcom/datadog/android/core/internal/persistence/file/advanced/DataMigrator;)V", "getDataMigrator$dd_sdk_android_release", "()Lcom/datadog/android/core/internal/persistence/file/advanced/DataMigrator;", "delegateOrchestrator", "getGrantedOrchestrator$dd_sdk_android_release", "()Lcom/datadog/android/core/internal/persistence/file/FileOrchestrator;", "getPendingOrchestrator$dd_sdk_android_release", "getAllFiles", "", "Ljava/io/File;", "getFlushableFiles", "getMetadataFile", "file", "getReadableFile", "excludeFiles", "", "getRootDir", "getWritableFile", "forceNewFile", "", "handleConsentChange", "", "previousConsent", "newConsent", "onConsentUpdated", "resolveDelegateOrchestrator", "consent", "Companion", "dd-sdk-android_release"})
public class ConsentAwareFileOrchestrator
implements FileOrchestrator,
TrackingConsentProviderCallback {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FileOrchestrator pendingOrchestrator;
    @NotNull
    private final FileOrchestrator grantedOrchestrator;
    @NotNull
    private final DataMigrator<TrackingConsent> dataMigrator;
    private FileOrchestrator delegateOrchestrator;
    @NotNull
    private static final FileOrchestrator NO_OP_ORCHESTRATOR = new NoOpFileOrchestrator();

    public ConsentAwareFileOrchestrator(@NotNull ConsentProvider consentProvider, @NotNull FileOrchestrator pendingOrchestrator, @NotNull FileOrchestrator grantedOrchestrator, @NotNull DataMigrator<TrackingConsent> dataMigrator) {
        Intrinsics.checkNotNullParameter((Object)consentProvider, (String)"consentProvider");
        Intrinsics.checkNotNullParameter((Object)pendingOrchestrator, (String)"pendingOrchestrator");
        Intrinsics.checkNotNullParameter((Object)grantedOrchestrator, (String)"grantedOrchestrator");
        Intrinsics.checkNotNullParameter(dataMigrator, (String)"dataMigrator");
        this.pendingOrchestrator = pendingOrchestrator;
        this.grantedOrchestrator = grantedOrchestrator;
        this.dataMigrator = dataMigrator;
        this.handleConsentChange(null, consentProvider.getConsent());
        consentProvider.registerCallback(this);
    }

    @NotNull
    public final FileOrchestrator getPendingOrchestrator$dd_sdk_android_release() {
        return this.pendingOrchestrator;
    }

    @NotNull
    public final FileOrchestrator getGrantedOrchestrator$dd_sdk_android_release() {
        return this.grantedOrchestrator;
    }

    @NotNull
    public final DataMigrator<TrackingConsent> getDataMigrator$dd_sdk_android_release() {
        return this.dataMigrator;
    }

    @Override
    @WorkerThread
    @Nullable
    public File getWritableFile(boolean forceNewFile) {
        FileOrchestrator fileOrchestrator = this.delegateOrchestrator;
        if (fileOrchestrator == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"delegateOrchestrator");
            fileOrchestrator = null;
        }
        return fileOrchestrator.getWritableFile(forceNewFile);
    }

    @Override
    @WorkerThread
    @Nullable
    public File getReadableFile(@NotNull Set<? extends File> excludeFiles) {
        Intrinsics.checkNotNullParameter(excludeFiles, (String)"excludeFiles");
        return this.grantedOrchestrator.getReadableFile(excludeFiles);
    }

    @Override
    @WorkerThread
    @NotNull
    public List<File> getAllFiles() {
        return CollectionsKt.plus((Collection)this.pendingOrchestrator.getAllFiles(), (Iterable)this.grantedOrchestrator.getAllFiles());
    }

    @Override
    @WorkerThread
    @Nullable
    public File getRootDir() {
        return null;
    }

    @Override
    @WorkerThread
    @NotNull
    public List<File> getFlushableFiles() {
        return this.grantedOrchestrator.getFlushableFiles();
    }

    @Override
    @WorkerThread
    @Nullable
    public File getMetadataFile(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        FileOrchestrator fileOrchestrator = this.delegateOrchestrator;
        if (fileOrchestrator == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"delegateOrchestrator");
            fileOrchestrator = null;
        }
        return fileOrchestrator.getMetadataFile(file);
    }

    @Override
    public void onConsentUpdated(@NotNull TrackingConsent previousConsent, @NotNull TrackingConsent newConsent) {
        Intrinsics.checkNotNullParameter((Object)((Object)previousConsent), (String)"previousConsent");
        Intrinsics.checkNotNullParameter((Object)((Object)newConsent), (String)"newConsent");
        this.handleConsentChange(previousConsent, newConsent);
    }

    @WorkerThread
    private final void handleConsentChange(TrackingConsent previousConsent, TrackingConsent newConsent) {
        FileOrchestrator previousOrchestrator = this.resolveDelegateOrchestrator(previousConsent);
        FileOrchestrator newOrchestrator = this.resolveDelegateOrchestrator(newConsent);
        this.dataMigrator.migrateData(previousConsent, previousOrchestrator, newConsent, newOrchestrator);
        this.delegateOrchestrator = newOrchestrator;
    }

    private final FileOrchestrator resolveDelegateOrchestrator(TrackingConsent consent) {
        FileOrchestrator fileOrchestrator;
        TrackingConsent trackingConsent = consent;
        switch (trackingConsent == null ? -1 : WhenMappings.$EnumSwitchMapping$0[trackingConsent.ordinal()]) {
            case -1: 
            case 1: {
                fileOrchestrator = this.pendingOrchestrator;
                break;
            }
            case 2: {
                fileOrchestrator = this.grantedOrchestrator;
                break;
            }
            case 3: {
                fileOrchestrator = NO_OP_ORCHESTRATOR;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return fileOrchestrator;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/datadog/android/core/internal/persistence/file/advanced/ConsentAwareFileOrchestrator$Companion;", "", "()V", "NO_OP_ORCHESTRATOR", "Lcom/datadog/android/core/internal/persistence/file/FileOrchestrator;", "getNO_OP_ORCHESTRATOR$dd_sdk_android_release", "()Lcom/datadog/android/core/internal/persistence/file/FileOrchestrator;", "dd-sdk-android_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final FileOrchestrator getNO_OP_ORCHESTRATOR$dd_sdk_android_release() {
            return NO_OP_ORCHESTRATOR;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TrackingConsent.values().length];
            nArray[TrackingConsent.PENDING.ordinal()] = 1;
            nArray[TrackingConsent.GRANTED.ordinal()] = 2;
            nArray[TrackingConsent.NOT_GRANTED.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

