/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.core.internal.persistence.file.single;

import androidx.annotation.WorkerThread;
import com.datadog.android.core.internal.persistence.file.FileExtKt;
import com.datadog.android.core.internal.persistence.file.FileOrchestrator;
import java.io.File;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006H\u0017J\u000e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006H\u0017J\u0012\u0010\b\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0002\u001a\u00020\u0003H\u0017J\u0018\u0010\t\u001a\u0004\u0018\u00010\u00032\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\u000bH\u0017J\n\u0010\f\u001a\u0004\u0018\u00010\u0003H\u0017J\u0012\u0010\r\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u000e\u001a\u00020\u000fH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/datadog/android/core/internal/persistence/file/single/SingleFileOrchestrator;", "Lcom/datadog/android/core/internal/persistence/file/FileOrchestrator;", "file", "Ljava/io/File;", "(Ljava/io/File;)V", "getAllFiles", "", "getFlushableFiles", "getMetadataFile", "getReadableFile", "excludeFiles", "", "getRootDir", "getWritableFile", "forceNewFile", "", "dd-sdk-android_release"})
public final class SingleFileOrchestrator
implements FileOrchestrator {
    @NotNull
    private final File file;

    public SingleFileOrchestrator(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.file = file;
    }

    @Override
    @WorkerThread
    @Nullable
    public File getWritableFile(boolean forceNewFile) {
        File file = this.file.getParentFile();
        if (file != null) {
            FileExtKt.mkdirsSafe(file);
        }
        return this.file;
    }

    @Override
    @WorkerThread
    @Nullable
    public File getReadableFile(@NotNull Set<? extends File> excludeFiles) {
        Intrinsics.checkNotNullParameter(excludeFiles, (String)"excludeFiles");
        File file = this.file.getParentFile();
        if (file != null) {
            FileExtKt.mkdirsSafe(file);
        }
        return excludeFiles.contains(this.file) ? (File)null : this.file;
    }

    @Override
    @WorkerThread
    @NotNull
    public List<File> getAllFiles() {
        File file = this.file.getParentFile();
        if (file != null) {
            FileExtKt.mkdirsSafe(file);
        }
        return CollectionsKt.listOf((Object)this.file);
    }

    @Override
    @WorkerThread
    @Nullable
    public File getRootDir() {
        return null;
    }

    @Override
    @WorkerThread
    @NotNull
    public List<File> getFlushableFiles() {
        return this.getAllFiles();
    }

    @Override
    @WorkerThread
    @Nullable
    public File getMetadataFile(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return null;
    }
}

