/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.core.internal.privacy;

import com.datadog.android.core.internal.privacy.ConsentProvider;
import com.datadog.android.privacy.TrackingConsent;
import com.datadog.android.privacy.TrackingConsentProviderCallback;
import java.util.LinkedList;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u0003H\u0002J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u0007H\u0016J\u0010\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0002\u001a\u00020\u0003H\u0016J\b\u0010\u0010\u001a\u00020\nH\u0016R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/datadog/android/core/internal/privacy/TrackingConsentProvider;", "Lcom/datadog/android/core/internal/privacy/ConsentProvider;", "consent", "Lcom/datadog/android/privacy/TrackingConsent;", "(Lcom/datadog/android/privacy/TrackingConsent;)V", "callbacks", "Ljava/util/LinkedList;", "Lcom/datadog/android/privacy/TrackingConsentProviderCallback;", "getConsent", "notifyCallbacks", "", "previous", "new", "registerCallback", "callback", "setConsent", "unregisterAllCallbacks", "dd-sdk-android_release"})
public final class TrackingConsentProvider
implements ConsentProvider {
    @NotNull
    private final LinkedList<TrackingConsentProviderCallback> callbacks;
    @NotNull
    private volatile TrackingConsent consent;

    public TrackingConsentProvider(@NotNull TrackingConsent consent) {
        Intrinsics.checkNotNullParameter((Object)((Object)consent), (String)"consent");
        this.callbacks = new LinkedList();
        this.consent = consent;
    }

    @Override
    @NotNull
    public TrackingConsent getConsent() {
        return this.consent;
    }

    @Override
    public synchronized void setConsent(@NotNull TrackingConsent consent) {
        Intrinsics.checkNotNullParameter((Object)((Object)consent), (String)"consent");
        if (consent == this.consent) {
            return;
        }
        TrackingConsent previous = this.consent;
        this.consent = consent;
        this.notifyCallbacks(previous, consent);
    }

    @Override
    public synchronized void registerCallback(@NotNull TrackingConsentProviderCallback callback) {
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        this.callbacks.add(callback);
    }

    @Override
    public synchronized void unregisterAllCallbacks() {
        this.callbacks.clear();
    }

    private final void notifyCallbacks(TrackingConsent previous, TrackingConsent trackingConsent) {
        Iterable $this$forEach$iv = this.callbacks;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TrackingConsentProviderCallback it = (TrackingConsentProviderCallback)element$iv;
            boolean bl = false;
            it.onConsentUpdated(previous, trackingConsent);
        }
    }
}

