/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.core.internal.system;

import android.app.UiModeManager;
import android.content.Context;
import android.content.pm.PackageManager;
import android.os.Build;
import android.telephony.TelephonyManager;
import com.datadog.android.core.internal.system.AndroidInfoProvider;
import com.datadog.android.core.internal.system.BuildSdkVersionProvider;
import com.datadog.android.core.internal.system.DefaultAndroidInfoProvider;
import com.datadog.android.core.internal.system.DefaultBuildSdkVersionProvider;
import com.datadog.android.v2.api.context.DeviceType;
import java.util.List;
import java.util.Locale;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\r\b\u0000\u0018\u0000 &2\u00020\u0001:\u0001&B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u001b\u0010\u0007\u001a\u00020\b8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\nR\u001b\u0010\r\u001a\u00020\b8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\f\u001a\u0004\b\u000e\u0010\nR\u001b\u0010\u0010\u001a\u00020\b8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\f\u001a\u0004\b\u0011\u0010\nR\u001b\u0010\u0013\u001a\u00020\b8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\f\u001a\u0004\b\u0014\u0010\nR\u001b\u0010\u0016\u001a\u00020\b8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0018\u0010\f\u001a\u0004\b\u0017\u0010\nR\u001b\u0010\u0019\u001a\u00020\u001a8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001d\u0010\f\u001a\u0004\b\u001b\u0010\u001cR\u001b\u0010\u001e\u001a\u00020\b8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b \u0010\f\u001a\u0004\b\u001f\u0010\nR\u0014\u0010!\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\nR\u001b\u0010#\u001a\u00020\b8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b%\u0010\f\u001a\u0004\b$\u0010\n\u00a8\u0006'"}, d2={"Lcom/datadog/android/core/internal/system/DefaultAndroidInfoProvider;", "Lcom/datadog/android/core/internal/system/AndroidInfoProvider;", "appContext", "Landroid/content/Context;", "sdkVersionProvider", "Lcom/datadog/android/core/internal/system/BuildSdkVersionProvider;", "(Landroid/content/Context;Lcom/datadog/android/core/internal/system/BuildSdkVersionProvider;)V", "architecture", "", "getArchitecture", "()Ljava/lang/String;", "architecture$delegate", "Lkotlin/Lazy;", "deviceBrand", "getDeviceBrand", "deviceBrand$delegate", "deviceBuildId", "getDeviceBuildId", "deviceBuildId$delegate", "deviceModel", "getDeviceModel", "deviceModel$delegate", "deviceName", "getDeviceName", "deviceName$delegate", "deviceType", "Lcom/datadog/android/v2/api/context/DeviceType;", "getDeviceType", "()Lcom/datadog/android/v2/api/context/DeviceType;", "deviceType$delegate", "osMajorVersion", "getOsMajorVersion", "osMajorVersion$delegate", "osName", "getOsName", "osVersion", "getOsVersion", "osVersion$delegate", "Companion", "dd-sdk-android_release"})
public final class DefaultAndroidInfoProvider
implements AndroidInfoProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lazy deviceType$delegate;
    @NotNull
    private final Lazy deviceName$delegate;
    @NotNull
    private final Lazy deviceBrand$delegate;
    @NotNull
    private final Lazy deviceModel$delegate;
    @NotNull
    private final Lazy deviceBuildId$delegate;
    @NotNull
    private final String osName;
    @NotNull
    private final Lazy osVersion$delegate;
    @NotNull
    private final Lazy osMajorVersion$delegate;
    @NotNull
    private final Lazy architecture$delegate;
    @NotNull
    public static final String FEATURE_GOOGLE_ANDROID_TV = "com.google.android.tv";
    public static final int MIN_TABLET_WIDTH_DP = 800;

    public DefaultAndroidInfoProvider(@NotNull Context appContext, @NotNull BuildSdkVersionProvider sdkVersionProvider) {
        Intrinsics.checkNotNullParameter((Object)appContext, (String)"appContext");
        Intrinsics.checkNotNullParameter((Object)sdkVersionProvider, (String)"sdkVersionProvider");
        this.deviceType$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, (Function0)((Function0)new Function0<DeviceType>(appContext, sdkVersionProvider){
            final /* synthetic */ Context $appContext;
            final /* synthetic */ BuildSdkVersionProvider $sdkVersionProvider;
            {
                this.$appContext = $appContext;
                this.$sdkVersionProvider = $sdkVersionProvider;
                super(0);
            }

            @NotNull
            public final DeviceType invoke() {
                return com.datadog.android.core.internal.system.DefaultAndroidInfoProvider$Companion.access$resolveDeviceType(DefaultAndroidInfoProvider.Companion, this.$appContext, this.$sdkVersionProvider);
            }
        }));
        this.deviceName$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, (Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ DefaultAndroidInfoProvider this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return ((CharSequence)this.this$0.getDeviceBrand()).length() == 0 ? this.this$0.getDeviceModel() : (StringsKt.contains$default((CharSequence)this.this$0.getDeviceModel(), (CharSequence)this.this$0.getDeviceBrand(), (boolean)false, (int)2, null) ? this.this$0.getDeviceModel() : this.this$0.getDeviceBrand() + " " + this.this$0.getDeviceModel());
            }
        }));
        this.deviceBrand$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, (Function0)deviceBrand.2.INSTANCE);
        this.deviceModel$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, (Function0)deviceModel.2.INSTANCE);
        this.deviceBuildId$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, (Function0)deviceBuildId.2.INSTANCE);
        this.osName = "Android";
        this.osVersion$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, (Function0)osVersion.2.INSTANCE);
        this.osMajorVersion$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, (Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ DefaultAndroidInfoProvider this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final String invoke() {
                char[] cArray = new char[]{'.'};
                return (String)CollectionsKt.first((List)StringsKt.split$default((CharSequence)this.this$0.getOsVersion(), (char[])cArray, (boolean)false, (int)0, (int)6, null));
            }
        }));
        this.architecture$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, (Function0)architecture.2.INSTANCE);
    }

    public /* synthetic */ DefaultAndroidInfoProvider(Context context, BuildSdkVersionProvider buildSdkVersionProvider, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            buildSdkVersionProvider = new DefaultBuildSdkVersionProvider();
        }
        this(context, buildSdkVersionProvider);
    }

    @Override
    @NotNull
    public DeviceType getDeviceType() {
        Lazy lazy = this.deviceType$delegate;
        return (DeviceType)((Object)lazy.getValue());
    }

    @Override
    @NotNull
    public String getDeviceName() {
        Lazy lazy = this.deviceName$delegate;
        return (String)lazy.getValue();
    }

    @Override
    @NotNull
    public String getDeviceBrand() {
        Lazy lazy = this.deviceBrand$delegate;
        return (String)lazy.getValue();
    }

    @Override
    @NotNull
    public String getDeviceModel() {
        Lazy lazy = this.deviceModel$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-deviceModel>(...)");
        return (String)object;
    }

    @Override
    @NotNull
    public String getDeviceBuildId() {
        Lazy lazy = this.deviceBuildId$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-deviceBuildId>(...)");
        return (String)object;
    }

    @Override
    @NotNull
    public String getOsName() {
        return this.osName;
    }

    @Override
    @NotNull
    public String getOsVersion() {
        Lazy lazy = this.osVersion$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-osVersion>(...)");
        return (String)object;
    }

    @Override
    @NotNull
    public String getOsMajorVersion() {
        Lazy lazy = this.osMajorVersion$delegate;
        return (String)lazy.getValue();
    }

    @Override
    @NotNull
    public String getArchitecture() {
        Lazy lazy = this.architecture$delegate;
        return (String)lazy.getValue();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010\u0011\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/datadog/android/core/internal/system/DefaultAndroidInfoProvider$Companion;", "", "()V", "FEATURE_GOOGLE_ANDROID_TV", "", "MIN_TABLET_WIDTH_DP", "", "hasTvFeature", "", "packageManager", "Landroid/content/pm/PackageManager;", "sdkVersionProvider", "Lcom/datadog/android/core/internal/system/BuildSdkVersionProvider;", "isMobile", "appContext", "Landroid/content/Context;", "isTablet", "isTv", "resolveDeviceType", "Lcom/datadog/android/v2/api/context/DeviceType;", "dd-sdk-android_release"})
    public static final class Companion {
        private Companion() {
        }

        private final DeviceType resolveDeviceType(Context appContext, BuildSdkVersionProvider sdkVersionProvider) {
            return this.isTv(appContext, sdkVersionProvider) ? DeviceType.TV : (this.isTablet(appContext) ? DeviceType.TABLET : (this.isMobile(appContext) ? DeviceType.MOBILE : DeviceType.OTHER));
        }

        private final boolean isTv(Context appContext, BuildSdkVersionProvider sdkVersionProvider) {
            UiModeManager uiModeManager;
            Object object = appContext.getSystemService("uimode");
            UiModeManager uiModeManager2 = uiModeManager = object instanceof UiModeManager ? (UiModeManager)object : null;
            if (uiModeManager2 == null ? false : uiModeManager2.getCurrentModeType() == 4) {
                return true;
            }
            object = appContext.getPackageManager();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"appContext.packageManager");
            return this.hasTvFeature((PackageManager)object, sdkVersionProvider);
        }

        private final boolean hasTvFeature(PackageManager packageManager, BuildSdkVersionProvider sdkVersionProvider) {
            int sdkVersion = sdkVersionProvider.version();
            return sdkVersion >= 21 && packageManager.hasSystemFeature("android.software.leanback") ? true : (sdkVersion < 21 && packageManager.hasSystemFeature("android.hardware.type.television") ? true : packageManager.hasSystemFeature(DefaultAndroidInfoProvider.FEATURE_GOOGLE_ANDROID_TV));
        }

        private final boolean isTablet(Context appContext) {
            String string = Build.MODEL;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"MODEL");
            Locale locale = Locale.US;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
            String string2 = string.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(locale)");
            String $this$isTablet_u24lambda_u2d0 = string2;
            boolean bl = false;
            if (StringsKt.contains$default((CharSequence)$this$isTablet_u24lambda_u2d0, (CharSequence)"tablet", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)$this$isTablet_u24lambda_u2d0, (CharSequence)"sm-t", (boolean)false, (int)2, null)) {
                return true;
            }
            return appContext.getResources().getConfiguration().smallestScreenWidthDp >= 800;
        }

        private final boolean isMobile(Context appContext) {
            TelephonyManager telephonyManager;
            String string = Build.MODEL;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"MODEL");
            Object object = Locale.US;
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"US");
            String string2 = string.toLowerCase((Locale)object);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(locale)");
            if (StringsKt.contains$default((CharSequence)string2, (CharSequence)"phone", (boolean)false, (int)2, null)) {
                return true;
            }
            object = appContext.getSystemService("phone");
            TelephonyManager telephonyManager2 = telephonyManager = object instanceof TelephonyManager ? (TelephonyManager)object : null;
            return !(telephonyManager2 == null ? false : telephonyManager2.getPhoneType() == 0);
        }

        public static final /* synthetic */ DeviceType access$resolveDeviceType(Companion $this, Context appContext, BuildSdkVersionProvider sdkVersionProvider) {
            return $this.resolveDeviceType(appContext, sdkVersionProvider);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

