/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.core.internal.utils;

import com.datadog.android.core.internal.utils.MapUtilsKt;
import com.datadog.android.core.internal.utils.RuntimeUtilsKt;
import com.datadog.android.v2.api.InternalLogger;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONObject;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000F\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a*\u0010\u0000\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0080\b\u00f8\u0001\u0000\u001a&\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00072\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003H\u0000\u001a\u001c\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0006\u0012\u0004\u0018\u00010\f0\n*\u0004\u0018\u00010\rH\u0000\u001a\u001a\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0006\u0012\u0004\u0018\u00010\f0\n*\u00020\u000eH\u0000\u001a\u0010\u0010\u000f\u001a\u0004\u0018\u00010\f*\u0004\u0018\u00010\fH\u0000\u001a\u0010\u0010\u0010\u001a\u00020\r*\u0006\u0012\u0002\b\u00030\u0011H\u0000\u001a\f\u0010\u0010\u001a\u00020\r*\u00020\u0012H\u0000\u001a\u000e\u0010\u0013\u001a\u00020\r*\u0004\u0018\u00010\fH\u0000\u001a\u0014\u0010\u0014\u001a\u00020\r*\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\nH\u0000\u001a\f\u0010\u0014\u001a\u00020\r*\u00020\u0015H\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u0016"}, d2={"retryWithDelay", "", "block", "Lkotlin/Function0;", "times", "", "loopsDelayInNanos", "", "retryDelayNs", "asMap", "", "", "", "Lcom/google/gson/JsonElement;", "Lcom/google/gson/JsonObject;", "fromJsonElement", "toJsonArray", "", "Lorg/json/JSONArray;", "toJsonElement", "toJsonObject", "Lorg/json/JSONObject;", "dd-sdk-android_release"})
public final class MiscUtilsKt {
    public static final boolean retryWithDelay(int times, long retryDelayNs, @NotNull Function0<Boolean> block) {
        int n;
        block3: {
            Intrinsics.checkNotNullParameter(block, (String)"block");
            boolean $i$f$retryWithDelay = false;
            int retryCounter$iv = 1;
            int wasSuccessful$iv = 0;
            long loopTimeOrigin$iv = System.nanoTime() - retryDelayNs;
            while (retryCounter$iv <= times && wasSuccessful$iv == 0) {
                int n2;
                if (System.nanoTime() - loopTimeOrigin$iv < retryDelayNs) continue;
                try {
                    n2 = ((Boolean)block.invoke()).booleanValue();
                }
                catch (Exception e$iv) {
                    InternalLogger.Target[] targetArray = new InternalLogger.Target[]{InternalLogger.Target.MAINTAINER, InternalLogger.Target.TELEMETRY};
                    RuntimeUtilsKt.getInternalLogger().log(InternalLogger.Level.ERROR, CollectionsKt.listOf((Object[])targetArray), "Internal operation failed", (Throwable)e$iv);
                    n = 0;
                    break block3;
                }
                wasSuccessful$iv = n2;
                loopTimeOrigin$iv = System.nanoTime();
                n2 = retryCounter$iv;
                retryCounter$iv = n2 + 1;
            }
            n = wasSuccessful$iv;
        }
        return n != 0;
    }

    public static final boolean retryWithDelay(@NotNull Function0<Boolean> block, int times, long loopsDelayInNanos) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        boolean $i$f$retryWithDelay = false;
        int retryCounter = 1;
        int wasSuccessful = 0;
        long loopTimeOrigin = System.nanoTime() - loopsDelayInNanos;
        while (retryCounter <= times && wasSuccessful == 0) {
            int n;
            if (System.nanoTime() - loopTimeOrigin < loopsDelayInNanos) continue;
            try {
                n = ((Boolean)block.invoke()).booleanValue();
            }
            catch (Exception e) {
                InternalLogger.Target[] targetArray = new InternalLogger.Target[]{InternalLogger.Target.MAINTAINER, InternalLogger.Target.TELEMETRY};
                RuntimeUtilsKt.getInternalLogger().log(InternalLogger.Level.ERROR, CollectionsKt.listOf((Object[])targetArray), "Internal operation failed", (Throwable)e);
                return false;
            }
            wasSuccessful = n;
            loopTimeOrigin = System.nanoTime();
            n = retryCounter;
            retryCounter = n + 1;
        }
        return wasSuccessful != 0;
    }

    @NotNull
    public static final JsonElement toJsonElement(@Nullable Object $this$toJsonElement) {
        JsonElement jsonElement;
        Object object = $this$toJsonElement;
        if (Intrinsics.areEqual((Object)object, (Object)MapUtilsKt.getNULL_MAP_VALUE())) {
            JsonNull jsonNull = JsonNull.INSTANCE;
            Intrinsics.checkNotNullExpressionValue((Object)jsonNull, (String)"INSTANCE");
            jsonElement = (JsonElement)jsonNull;
        } else if (object == null) {
            JsonNull jsonNull = JsonNull.INSTANCE;
            Intrinsics.checkNotNullExpressionValue((Object)jsonNull, (String)"INSTANCE");
            jsonElement = (JsonElement)jsonNull;
        } else if (Intrinsics.areEqual((Object)object, (Object)JsonNull.INSTANCE)) {
            JsonNull jsonNull = JsonNull.INSTANCE;
            Intrinsics.checkNotNullExpressionValue((Object)jsonNull, (String)"INSTANCE");
            jsonElement = (JsonElement)jsonNull;
        } else {
            jsonElement = object instanceof Boolean ? (JsonElement)new JsonPrimitive((Boolean)$this$toJsonElement) : (object instanceof Integer ? (JsonElement)new JsonPrimitive((Number)$this$toJsonElement) : (object instanceof Long ? (JsonElement)new JsonPrimitive((Number)$this$toJsonElement) : (object instanceof Float ? (JsonElement)new JsonPrimitive((Number)$this$toJsonElement) : (object instanceof Double ? (JsonElement)new JsonPrimitive((Number)$this$toJsonElement) : (object instanceof String ? (JsonElement)new JsonPrimitive((String)$this$toJsonElement) : (object instanceof Date ? (JsonElement)new JsonPrimitive((Number)((Date)$this$toJsonElement).getTime()) : (object instanceof JsonArray ? (JsonElement)$this$toJsonElement : (object instanceof Iterable ? MiscUtilsKt.toJsonArray((Iterable)$this$toJsonElement) : (object instanceof Map ? MiscUtilsKt.toJsonObject((Map)$this$toJsonElement) : (object instanceof JsonObject ? (JsonElement)$this$toJsonElement : (object instanceof JsonPrimitive ? (JsonElement)$this$toJsonElement : (object instanceof JSONObject ? MiscUtilsKt.toJsonObject((JSONObject)$this$toJsonElement) : (object instanceof JSONArray ? MiscUtilsKt.toJsonArray((JSONArray)$this$toJsonElement) : (JsonElement)new JsonPrimitive($this$toJsonElement.toString()))))))))))))));
        }
        return jsonElement;
    }

    @Nullable
    public static final Object fromJsonElement(@Nullable Object $this$fromJsonElement) {
        Map<String, Object> map = $this$fromJsonElement;
        return map instanceof JsonNull ? null : (map instanceof JsonPrimitive ? (((JsonPrimitive)$this$fromJsonElement).isBoolean() ? Boolean.valueOf(((JsonPrimitive)$this$fromJsonElement).getAsBoolean()) : (((JsonPrimitive)$this$fromJsonElement).isNumber() ? ((JsonPrimitive)$this$fromJsonElement).getAsNumber() : (((JsonPrimitive)$this$fromJsonElement).isString() ? ((JsonPrimitive)$this$fromJsonElement).getAsString() : $this$fromJsonElement))) : (map instanceof JsonObject ? MiscUtilsKt.asMap((JsonObject)$this$fromJsonElement) : $this$fromJsonElement));
    }

    @NotNull
    public static final JsonElement toJsonArray(@NotNull Iterable<?> $this$toJsonArray) {
        Intrinsics.checkNotNullParameter($this$toJsonArray, (String)"<this>");
        JsonArray array = new JsonArray();
        Iterable<?> $this$forEach$iv = $this$toJsonArray;
        boolean $i$f$forEach = false;
        Iterator<?> iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv;
            Object it = element$iv = iterator.next();
            boolean bl = false;
            array.add(MiscUtilsKt.toJsonElement(it));
        }
        return (JsonElement)array;
    }

    @NotNull
    public static final JsonElement toJsonObject(@NotNull Map<?, ?> $this$toJsonObject) {
        Intrinsics.checkNotNullParameter($this$toJsonObject, (String)"<this>");
        JsonObject obj = new JsonObject();
        Map<?, ?> $this$forEach$iv = $this$toJsonObject;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<?, ?>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<?, ?> element$iv;
            Map.Entry<?, ?> it = element$iv = iterator.next();
            boolean bl = false;
            obj.add(String.valueOf(it.getKey()), MiscUtilsKt.toJsonElement(it.getValue()));
        }
        return (JsonElement)obj;
    }

    @NotNull
    public static final JsonElement toJsonObject(@NotNull JSONObject $this$toJsonObject) {
        Intrinsics.checkNotNullParameter((Object)$this$toJsonObject, (String)"<this>");
        JsonObject obj = new JsonObject();
        Iterator iterator = $this$toJsonObject.keys();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"keys()");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            String key = (String)iterator2.next();
            obj.add(key, MiscUtilsKt.toJsonElement($this$toJsonObject.get(key)));
        }
        return (JsonElement)obj;
    }

    @NotNull
    public static final JsonElement toJsonArray(@NotNull JSONArray $this$toJsonArray) {
        Intrinsics.checkNotNullParameter((Object)$this$toJsonArray, (String)"<this>");
        JsonArray obj = new JsonArray();
        int n = 0;
        int n2 = $this$toJsonArray.length();
        while (n < n2) {
            int index = n++;
            obj.add(MiscUtilsKt.toJsonElement($this$toJsonArray.get(index)));
        }
        return (JsonElement)obj;
    }

    @NotNull
    public static final Map<String, Object> asMap(@NotNull JsonObject $this$asMap) {
        Intrinsics.checkNotNullParameter((Object)$this$asMap, (String)"<this>");
        Map map = new LinkedHashMap();
        Set set = $this$asMap.entrySet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"entrySet()");
        Iterable $this$forEach$iv = set;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map.Entry it = (Map.Entry)element$iv;
            boolean bl = false;
            Object k = it.getKey();
            Intrinsics.checkNotNullExpressionValue(k, (String)"it.key");
            map.put(k, MiscUtilsKt.fromJsonElement(it.getValue()));
        }
        return map;
    }

    @NotNull
    public static final Map<String, Object> asMap(@Nullable JsonElement $this$asMap) {
        return $this$asMap instanceof JsonObject ? MiscUtilsKt.asMap((JsonObject)$this$asMap) : MapsKt.emptyMap();
    }
}

