/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.core.internal.utils;

import com.datadog.android.telemetry.internal.Telemetry;
import com.datadog.android.v2.api.InternalLogger;
import com.datadog.android.v2.core.SdkInternalLogger;
import java.util.Arrays;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\u001a,\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u00012\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u001a\u0010\u0003\u001a\u00020\u0004X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\"\u0014\u0010\t\u001a\u00020\nX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0013"}, d2={"WARN_DEPRECATED", "", "WARN_DEPRECATED_WITH_ALT", "internalLogger", "Lcom/datadog/android/v2/api/InternalLogger;", "getInternalLogger", "()Lcom/datadog/android/v2/api/InternalLogger;", "setInternalLogger", "(Lcom/datadog/android/v2/api/InternalLogger;)V", "telemetry", "Lcom/datadog/android/telemetry/internal/Telemetry;", "getTelemetry", "()Lcom/datadog/android/telemetry/internal/Telemetry;", "warnDeprecated", "", "target", "deprecatedSince", "removedInVersion", "alternative", "dd-sdk-android_release"})
public final class RuntimeUtilsKt {
    @NotNull
    private static InternalLogger internalLogger = new SdkInternalLogger(null, null, 3, null);
    @NotNull
    private static final Telemetry telemetry = new Telemetry();
    @NotNull
    public static final String WARN_DEPRECATED = "%s has been deprecated since version %s, and will be removed in version %s.";
    @NotNull
    public static final String WARN_DEPRECATED_WITH_ALT = "%s has been deprecated since version %s, and will be removed in version %s. Please use %s instead";

    @NotNull
    public static final InternalLogger getInternalLogger() {
        return internalLogger;
    }

    public static final void setInternalLogger(@NotNull InternalLogger internalLogger) {
        Intrinsics.checkNotNullParameter((Object)internalLogger, (String)"<set-?>");
        RuntimeUtilsKt.internalLogger = internalLogger;
    }

    @NotNull
    public static final Telemetry getTelemetry() {
        return telemetry;
    }

    public static final void warnDeprecated(@NotNull String target, @NotNull String deprecatedSince, @NotNull String removedInVersion, @Nullable String alternative) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)deprecatedSince, (String)"deprecatedSince");
        Intrinsics.checkNotNullParameter((Object)removedInVersion, (String)"removedInVersion");
        if (alternative == null) {
            String string = WARN_DEPRECATED;
            Locale locale = Locale.US;
            Object[] objectArray = new Object[]{target, deprecatedSince, removedInVersion};
            String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(locale, this, *args)");
            InternalLogger.DefaultImpls.log$default(internalLogger, InternalLogger.Level.WARN, InternalLogger.Target.USER, string2, null, 8, null);
        } else {
            String string = WARN_DEPRECATED_WITH_ALT;
            Locale locale = Locale.US;
            Object[] objectArray = new Object[]{target, deprecatedSince, removedInVersion, alternative};
            String string3 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(locale, this, *args)");
            InternalLogger.DefaultImpls.log$default(internalLogger, InternalLogger.Level.WARN, InternalLogger.Target.USER, string3, null, 8, null);
        }
    }

    public static /* synthetic */ void warnDeprecated$default(String string, String string2, String string3, String string4, int n, Object object) {
        if ((n & 8) != 0) {
            string4 = null;
        }
        RuntimeUtilsKt.warnDeprecated(string, string2, string3, string4);
    }
}

