/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.error.internal;

import android.content.Context;
import com.datadog.android.error.internal.DatadogExceptionHandler;
import com.datadog.android.v2.api.SdkCore;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\b\u0010\u0014\u001a\u00020\u0011H\u0002J\u0010\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0013H\u0002J\u0006\u0010\u0017\u001a\u00020\u0011R\u0014\u0010\u0005\u001a\u00020\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\"\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/datadog/android/error/internal/CrashReportsFeature;", "", "sdkCore", "Lcom/datadog/android/v2/api/SdkCore;", "(Lcom/datadog/android/v2/api/SdkCore;)V", "initialized", "Ljava/util/concurrent/atomic/AtomicBoolean;", "getInitialized$dd_sdk_android_release", "()Ljava/util/concurrent/atomic/AtomicBoolean;", "originalUncaughtExceptionHandler", "Ljava/lang/Thread$UncaughtExceptionHandler;", "kotlin.jvm.PlatformType", "getOriginalUncaughtExceptionHandler$dd_sdk_android_release", "()Ljava/lang/Thread$UncaughtExceptionHandler;", "setOriginalUncaughtExceptionHandler$dd_sdk_android_release", "(Ljava/lang/Thread$UncaughtExceptionHandler;)V", "initialize", "", "context", "Landroid/content/Context;", "resetOriginalExceptionHandler", "setupExceptionHandler", "appContext", "stop", "Companion", "dd-sdk-android_release"})
public final class CrashReportsFeature {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SdkCore sdkCore;
    @NotNull
    private final AtomicBoolean initialized;
    private Thread.UncaughtExceptionHandler originalUncaughtExceptionHandler;
    @NotNull
    public static final String CRASH_FEATURE_NAME = "crash";

    public CrashReportsFeature(@NotNull SdkCore sdkCore) {
        Intrinsics.checkNotNullParameter((Object)sdkCore, (String)"sdkCore");
        this.sdkCore = sdkCore;
        this.initialized = new AtomicBoolean(false);
        this.originalUncaughtExceptionHandler = Thread.getDefaultUncaughtExceptionHandler();
    }

    @NotNull
    public final AtomicBoolean getInitialized$dd_sdk_android_release() {
        return this.initialized;
    }

    public final Thread.UncaughtExceptionHandler getOriginalUncaughtExceptionHandler$dd_sdk_android_release() {
        return this.originalUncaughtExceptionHandler;
    }

    public final void setOriginalUncaughtExceptionHandler$dd_sdk_android_release(Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
        this.originalUncaughtExceptionHandler = uncaughtExceptionHandler;
    }

    public final void initialize(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.setupExceptionHandler(context);
        this.initialized.set(true);
    }

    public final void stop() {
        this.resetOriginalExceptionHandler();
        this.initialized.set(false);
    }

    private final void setupExceptionHandler(Context appContext) {
        this.originalUncaughtExceptionHandler = Thread.getDefaultUncaughtExceptionHandler();
        new DatadogExceptionHandler(this.sdkCore, appContext).register();
    }

    private final void resetOriginalExceptionHandler() {
        Thread.setDefaultUncaughtExceptionHandler(this.originalUncaughtExceptionHandler);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/datadog/android/error/internal/CrashReportsFeature$Companion;", "", "()V", "CRASH_FEATURE_NAME", "", "dd-sdk-android_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

