/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.error.internal;

import android.content.Context;
import com.datadog.android.Datadog;
import com.datadog.android.core.internal.CoreFeature;
import com.datadog.android.core.internal.thread.ThreadPoolExecutorExtKt;
import com.datadog.android.core.internal.utils.RuntimeUtilsKt;
import com.datadog.android.core.internal.utils.WorkManagerUtilsKt;
import com.datadog.android.v2.api.FeatureScope;
import com.datadog.android.v2.api.InternalLogger;
import com.datadog.android.v2.api.SdkCore;
import com.datadog.android.v2.core.DatadogCore;
import java.lang.ref.WeakReference;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0006\u0010\u000f\u001a\u00020\u0010J\u0018\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000eH\u0016R\u001c\u0010\u0007\u001a\u0010\u0012\f\u0012\n \t*\u0004\u0018\u00010\u00050\u00050\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/datadog/android/error/internal/DatadogExceptionHandler;", "Ljava/lang/Thread$UncaughtExceptionHandler;", "sdkCore", "Lcom/datadog/android/v2/api/SdkCore;", "appContext", "Landroid/content/Context;", "(Lcom/datadog/android/v2/api/SdkCore;Landroid/content/Context;)V", "contextRef", "Ljava/lang/ref/WeakReference;", "kotlin.jvm.PlatformType", "previousHandler", "createCrashMessage", "", "throwable", "", "register", "", "uncaughtException", "t", "Ljava/lang/Thread;", "e", "Companion", "dd-sdk-android_release"})
public final class DatadogExceptionHandler
implements Thread.UncaughtExceptionHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SdkCore sdkCore;
    @NotNull
    private final WeakReference<Context> contextRef;
    @Nullable
    private Thread.UncaughtExceptionHandler previousHandler;
    @NotNull
    public static final String LOGGER_NAME = "crash";
    @NotNull
    public static final String MESSAGE = "Application crash detected";
    public static final long MAX_WAIT_FOR_IDLE_TIME_IN_MS = 100L;
    @NotNull
    public static final String EXECUTOR_NOT_IDLED_WARNING_MESSAGE = "Datadog SDK is in an unexpected state due to an ongoing crash. Some events could be lost.";
    @NotNull
    public static final String MISSING_LOGS_FEATURE_INFO = "Logs feature is not registered, won't report crash as log.";
    @NotNull
    public static final String MISSING_RUM_FEATURE_INFO = "RUM feature is not registered, won't report crash as RUM event.";

    public DatadogExceptionHandler(@NotNull SdkCore sdkCore, @NotNull Context appContext) {
        Intrinsics.checkNotNullParameter((Object)sdkCore, (String)"sdkCore");
        Intrinsics.checkNotNullParameter((Object)appContext, (String)"appContext");
        this.sdkCore = sdkCore;
        this.contextRef = new WeakReference<Context>(appContext);
    }

    @Override
    public void uncaughtException(@NotNull Thread t, @NotNull Throwable e) {
        CoreFeature coreFeature;
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        FeatureScope logsFeature = this.sdkCore.getFeature("logs");
        if (logsFeature != null) {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"threadName", (Object)t.getName()), TuplesKt.to((Object)"throwable", (Object)e), TuplesKt.to((Object)"timestamp", (Object)System.currentTimeMillis()), TuplesKt.to((Object)"message", (Object)this.createCrashMessage(e)), TuplesKt.to((Object)"type", (Object)"jvm_crash"), TuplesKt.to((Object)"loggerName", (Object)LOGGER_NAME)};
            logsFeature.sendEvent(MapsKt.mapOf((Pair[])pairArray));
        } else {
            InternalLogger.DefaultImpls.log$default(RuntimeUtilsKt.getInternalLogger(), InternalLogger.Level.INFO, InternalLogger.Target.USER, MISSING_LOGS_FEATURE_INFO, null, 8, null);
        }
        FeatureScope rumFeature = this.sdkCore.getFeature("rum");
        if (rumFeature != null) {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"type", (Object)"jvm_crash"), TuplesKt.to((Object)"throwable", (Object)e), TuplesKt.to((Object)"message", (Object)this.createCrashMessage(e))};
            rumFeature.sendEvent(MapsKt.mapOf((Pair[])pairArray));
        } else {
            InternalLogger.DefaultImpls.log$default(RuntimeUtilsKt.getInternalLogger(), InternalLogger.Level.INFO, InternalLogger.Target.USER, MISSING_RUM_FEATURE_INFO, null, 8, null);
        }
        Object object = Datadog.INSTANCE.getGlobalSdkCore$dd_sdk_android_release();
        DatadogCore datadogCore = object instanceof DatadogCore ? (DatadogCore)object : null;
        CoreFeature coreFeature2 = coreFeature = datadogCore == null ? null : datadogCore.getCoreFeature$dd_sdk_android_release();
        if (coreFeature != null) {
            boolean bl;
            boolean idled;
            ExecutorService executorService = coreFeature.getPersistenceExecutorService$dd_sdk_android_release();
            object = executorService instanceof ThreadPoolExecutor ? (ThreadPoolExecutor)executorService : null;
            boolean bl2 = idled = object == null ? true : (bl = ThreadPoolExecutorExtKt.waitToIdle((ThreadPoolExecutor)object, 100L));
            if (!idled) {
                InternalLogger.DefaultImpls.log$default(RuntimeUtilsKt.getInternalLogger(), InternalLogger.Level.WARN, InternalLogger.Target.USER, EXECUTOR_NOT_IDLED_WARNING_MESSAGE, null, 8, null);
            }
        }
        Context context = (Context)this.contextRef.get();
        if (context != null) {
            Context it = context;
            boolean bl = false;
            if (WorkManagerUtilsKt.isWorkManagerInitialized(it)) {
                WorkManagerUtilsKt.triggerUploadWorker(it);
            }
        }
        Thread.UncaughtExceptionHandler uncaughtExceptionHandler = this.previousHandler;
        if (uncaughtExceptionHandler != null) {
            uncaughtExceptionHandler.uncaughtException(t, e);
        }
    }

    public final void register() {
        this.previousHandler = Thread.getDefaultUncaughtExceptionHandler();
        Thread.setDefaultUncaughtExceptionHandler(this);
    }

    private final String createCrashMessage(Throwable throwable) {
        Object object;
        String rawMessage = throwable.getMessage();
        CharSequence charSequence = rawMessage;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            String string = throwable.getClass().getCanonicalName();
            if (string == null) {
                string = throwable.getClass().getSimpleName();
            }
            String className = string;
            object = "Application crash detected: " + className;
        } else {
            object = rawMessage;
        }
        return object;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/datadog/android/error/internal/DatadogExceptionHandler$Companion;", "", "()V", "EXECUTOR_NOT_IDLED_WARNING_MESSAGE", "", "LOGGER_NAME", "MAX_WAIT_FOR_IDLE_TIME_IN_MS", "", "MESSAGE", "MISSING_LOGS_FEATURE_INFO", "MISSING_RUM_FEATURE_INFO", "dd-sdk-android_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

