/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.log.internal.domain;

import com.datadog.android.log.internal.domain.LogGenerator;
import com.datadog.android.log.internal.utils.LogUtilsKt;
import com.datadog.android.log.model.LogEvent;
import com.datadog.android.v2.api.context.DatadogContext;
import com.datadog.android.v2.api.context.NetworkInfo;
import com.datadog.android.v2.api.context.UserInfo;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 82\u00020\u0001:\u00018B\u0011\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\t\u001a\u0004\u0018\u00010\u00032\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0012\u0010\f\u001a\u0004\u0018\u00010\u00032\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u00a6\u0001\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00032\b\u0010\u0012\u001a\u0004\u0018\u00010\u00032\b\u0010\u0013\u001a\u0004\u0018\u00010\u00032\b\u0010\u0014\u001a\u0004\u0018\u00010\u00032\u0014\u0010\u0015\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00170\u00162\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00030\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00032\u0006\u0010 \u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\u001e2\b\u0010\"\u001a\u0004\u0018\u00010#2\b\u0010$\u001a\u0004\u0018\u00010%H\u0016J\u0092\u0001\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00032\b\u0010&\u001a\u0004\u0018\u00010'2\u0014\u0010\u0015\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00170\u00162\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00030\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00032\u0006\u0010 \u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\u001e2\b\u0010\"\u001a\u0004\u0018\u00010#2\b\u0010$\u001a\u0004\u0018\u00010%H\u0016J\u0092\u0001\u0010(\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00032\b\u0010)\u001a\u0004\u0018\u00010*2\u0014\u0010\u0015\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00170\u00162\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00030\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00032\u0006\u0010 \u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\u001e2\b\u0010\"\u001a\u0004\u0018\u00010#2\b\u0010$\u001a\u0004\u0018\u00010%H\u0002JL\u0010+\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00170,2\u0006\u0010\n\u001a\u00020\u000b2\u0014\u0010\u0015\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00170\u00162\u0006\u0010 \u001a\u00020\u001e2\u0006\u0010\u001c\u001a\u00020\u00032\u0006\u0010!\u001a\u00020\u001eH\u0002J\u0010\u0010-\u001a\u00020.2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u001a\u0010/\u001a\u0002002\u0006\u0010\n\u001a\u00020\u000b2\b\u0010$\u001a\u0004\u0018\u00010%H\u0002J\u0012\u00101\u001a\u0004\u0018\u0001022\u0006\u0010$\u001a\u00020%H\u0002J$\u00103\u001a\b\u0012\u0004\u0012\u00020\u0003042\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00030\u0019H\u0002J\u001a\u00105\u001a\u0002062\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\"\u001a\u0004\u0018\u00010#H\u0002J\u0012\u00107\u001a\u0004\u0018\u00010\u00032\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u0016\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Lcom/datadog/android/log/internal/domain/DatadogLogGenerator;", "Lcom/datadog/android/log/internal/domain/LogGenerator;", "serviceName", "", "(Ljava/lang/String;)V", "getServiceName$dd_sdk_android_release", "()Ljava/lang/String;", "simpleDateFormat", "Ljava/text/SimpleDateFormat;", "appVersionTag", "datadogContext", "Lcom/datadog/android/v2/api/context/DatadogContext;", "envTag", "generateLog", "Lcom/datadog/android/log/model/LogEvent;", "level", "", "message", "errorKind", "errorMessage", "errorStack", "attributes", "", "", "tags", "", "timestamp", "", "threadName", "attachNetworkInfo", "", "loggerName", "bundleWithTraces", "bundleWithRum", "userInfo", "Lcom/datadog/android/v2/api/context/UserInfo;", "networkInfo", "Lcom/datadog/android/v2/api/context/NetworkInfo;", "throwable", "", "internalGenerateLog", "error", "Lcom/datadog/android/log/model/LogEvent$Error;", "resolveAttributes", "", "resolveLogLevelStatus", "Lcom/datadog/android/log/model/LogEvent$Status;", "resolveNetworkInfo", "Lcom/datadog/android/log/model/LogEvent$Network;", "resolveSimCarrier", "Lcom/datadog/android/log/model/LogEvent$SimCarrier;", "resolveTags", "", "resolveUserInfo", "Lcom/datadog/android/log/model/LogEvent$Usr;", "variantTag", "Companion", "dd-sdk-android_release"})
public final class DatadogLogGenerator
implements LogGenerator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final String serviceName;
    @NotNull
    private final SimpleDateFormat simpleDateFormat;
    @NotNull
    public static final String ISO_8601 = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    public static final int CRASH = 9;

    public DatadogLogGenerator(@Nullable String serviceName) {
        this.serviceName = serviceName;
        this.simpleDateFormat = LogUtilsKt.buildLogDateFormat();
    }

    public /* synthetic */ DatadogLogGenerator(String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = null;
        }
        this(string);
    }

    @Nullable
    public final String getServiceName$dd_sdk_android_release() {
        return this.serviceName;
    }

    @Override
    @NotNull
    public LogEvent generateLog(int level, @NotNull String message, @Nullable Throwable throwable, @NotNull Map<String, ? extends Object> attributes, @NotNull Set<String> tags, long timestamp, @NotNull String threadName, @NotNull DatadogContext datadogContext, boolean attachNetworkInfo, @NotNull String loggerName, boolean bundleWithTraces, boolean bundleWithRum, @Nullable UserInfo userInfo, @Nullable NetworkInfo networkInfo) {
        LogEvent.Error error;
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
        Intrinsics.checkNotNullParameter(tags, (String)"tags");
        Intrinsics.checkNotNullParameter((Object)threadName, (String)"threadName");
        Intrinsics.checkNotNullParameter((Object)datadogContext, (String)"datadogContext");
        Intrinsics.checkNotNullParameter((Object)loggerName, (String)"loggerName");
        Throwable throwable2 = throwable;
        if (throwable2 == null) {
            error = null;
        } else {
            Throwable it = throwable2;
            boolean bl = false;
            String string = it.getClass().getCanonicalName();
            if (string == null) {
                string = it.getClass().getSimpleName();
            }
            String kind = string;
            String string2 = ExceptionsKt.stackTraceToString((Throwable)it);
            String string3 = it.getMessage();
            error = new LogEvent.Error(kind, string3, string2);
        }
        LogEvent.Error error2 = error;
        return this.internalGenerateLog(level, message, error2, attributes, tags, timestamp, threadName, datadogContext, attachNetworkInfo, loggerName, bundleWithTraces, bundleWithRum, userInfo, networkInfo);
    }

    @Override
    @NotNull
    public LogEvent generateLog(int level, @NotNull String message, @Nullable String errorKind, @Nullable String errorMessage, @Nullable String errorStack, @NotNull Map<String, ? extends Object> attributes, @NotNull Set<String> tags, long timestamp, @NotNull String threadName, @NotNull DatadogContext datadogContext, boolean attachNetworkInfo, @NotNull String loggerName, boolean bundleWithTraces, boolean bundleWithRum, @Nullable UserInfo userInfo, @Nullable NetworkInfo networkInfo) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
        Intrinsics.checkNotNullParameter(tags, (String)"tags");
        Intrinsics.checkNotNullParameter((Object)threadName, (String)"threadName");
        Intrinsics.checkNotNullParameter((Object)datadogContext, (String)"datadogContext");
        Intrinsics.checkNotNullParameter((Object)loggerName, (String)"loggerName");
        LogEvent.Error error = errorKind != null || errorMessage != null || errorStack != null ? new LogEvent.Error(errorKind, errorMessage, errorStack) : (LogEvent.Error)null;
        return this.internalGenerateLog(level, message, error, attributes, tags, timestamp, threadName, datadogContext, attachNetworkInfo, loggerName, bundleWithTraces, bundleWithRum, userInfo, networkInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final LogEvent internalGenerateLog(int level, String message, LogEvent.Error error, Map<String, ? extends Object> attributes, Set<String> tags, long timestamp, String threadName, DatadogContext datadogContext, boolean attachNetworkInfo, String loggerName, boolean bundleWithTraces, boolean bundleWithRum, UserInfo userInfo, NetworkInfo networkInfo) {
        String $i$a$-synchronized-DatadogLogGenerator$internalGenerateLog$formattedDate$22;
        long resolvedTimestamp = timestamp + datadogContext.getTime().getServerTimeOffsetMs();
        Map<String, Object> combinedAttributes = this.resolveAttributes(datadogContext, attributes, bundleWithTraces, threadName, bundleWithRum);
        SimpleDateFormat simpleDateFormat = this.simpleDateFormat;
        synchronized (simpleDateFormat) {
            boolean $i$a$-synchronized-DatadogLogGenerator$internalGenerateLog$formattedDate$22 = false;
            $i$a$-synchronized-DatadogLogGenerator$internalGenerateLog$formattedDate$22 = this.simpleDateFormat.format(new Date(resolvedTimestamp));
        }
        String formattedDate = $i$a$-synchronized-DatadogLogGenerator$internalGenerateLog$formattedDate$22;
        Set<String> combinedTags = this.resolveTags(datadogContext, tags);
        LogEvent.Usr usr = this.resolveUserInfo(datadogContext, userInfo);
        LogEvent.Network network = networkInfo != null || attachNetworkInfo ? this.resolveNetworkInfo(datadogContext, networkInfo) : (LogEvent.Network)null;
        LogEvent.Logger loggerInfo = new LogEvent.Logger(loggerName, threadName, datadogContext.getSdkVersion());
        String string = this.serviceName;
        if (string == null) {
            string = datadogContext.getService();
        }
        String string2 = string;
        LogEvent.Status status = this.resolveLogLevelStatus(level);
        LogEvent.Dd dd = new LogEvent.Dd(new LogEvent.Device(datadogContext.getDeviceInfo().getArchitecture()));
        String string3 = CollectionsKt.joinToString$default((Iterable)combinedTags, (CharSequence)",", null, null, (int)0, null, null, (int)62, null);
        Intrinsics.checkNotNullExpressionValue((Object)formattedDate, (String)"formattedDate");
        return new LogEvent(status, string2, message, formattedDate, loggerInfo, dd, usr, network, error, string3, combinedAttributes);
    }

    private final String envTag(DatadogContext datadogContext) {
        String envName = datadogContext.getEnv();
        return ((CharSequence)envName).length() > 0 ? "env:" + envName : (String)null;
    }

    private final String appVersionTag(DatadogContext datadogContext) {
        String appVersion = datadogContext.getVersion();
        return ((CharSequence)appVersion).length() > 0 ? "version:" + appVersion : (String)null;
    }

    private final String variantTag(DatadogContext datadogContext) {
        String variant = datadogContext.getVariant();
        return ((CharSequence)variant).length() > 0 ? "variant:" + variant : (String)null;
    }

    private final LogEvent.Network resolveNetworkInfo(DatadogContext datadogContext, NetworkInfo networkInfo) {
        NetworkInfo networkInfo2 = networkInfo;
        if (networkInfo2 == null) {
            networkInfo2 = datadogContext.getNetworkInfo();
        }
        NetworkInfo $this$resolveNetworkInfo_u24lambda_u2d2 = networkInfo2;
        boolean bl = false;
        Long l = $this$resolveNetworkInfo_u24lambda_u2d2.getStrength();
        Long l2 = $this$resolveNetworkInfo_u24lambda_u2d2.getDownKbps();
        Long l3 = $this$resolveNetworkInfo_u24lambda_u2d2.getUpKbps();
        return new LogEvent.Network(new LogEvent.Client(this.resolveSimCarrier($this$resolveNetworkInfo_u24lambda_u2d2), (String)(l == null ? null : l.toString()), (String)(l2 == null ? null : l2.toString()), (String)(l3 == null ? null : l3.toString()), $this$resolveNetworkInfo_u24lambda_u2d2.getConnectivity().toString()));
    }

    private final LogEvent.Usr resolveUserInfo(DatadogContext datadogContext, UserInfo userInfo) {
        UserInfo userInfo2 = userInfo;
        if (userInfo2 == null) {
            userInfo2 = datadogContext.getUserInfo();
        }
        UserInfo $this$resolveUserInfo_u24lambda_u2d3 = userInfo2;
        boolean bl = false;
        String string = $this$resolveUserInfo_u24lambda_u2d3.getName();
        String string2 = $this$resolveUserInfo_u24lambda_u2d3.getEmail();
        String string3 = $this$resolveUserInfo_u24lambda_u2d3.getId();
        Map map = MapsKt.toMutableMap($this$resolveUserInfo_u24lambda_u2d3.getAdditionalProperties());
        return new LogEvent.Usr(string3, string, string2, map);
    }

    private final Set<String> resolveTags(DatadogContext datadogContext, Set<String> tags) {
        Set set;
        Set $this$resolveTags_u24lambda_u2d4 = set = (Set)new LinkedHashSet();
        boolean bl = false;
        $this$resolveTags_u24lambda_u2d4.addAll((Collection)tags);
        Set combinedTags = set;
        String string = this.envTag(datadogContext);
        if (string != null) {
            String it = string;
            boolean bl2 = false;
            combinedTags.add(it);
        }
        String string2 = this.appVersionTag(datadogContext);
        if (string2 != null) {
            String it = string2;
            boolean bl3 = false;
            combinedTags.add(it);
        }
        String string3 = this.variantTag(datadogContext);
        if (string3 != null) {
            String it = string3;
            boolean bl4 = false;
            combinedTags.add(it);
        }
        return combinedTags;
    }

    private final Map<String, Object> resolveAttributes(DatadogContext datadogContext, Map<String, ? extends Object> attributes, boolean bundleWithTraces, String threadName, boolean bundleWithRum) {
        Map map;
        Map $this$resolveAttributes_u24lambda_u2d8 = map = (Map)new LinkedHashMap();
        boolean bl = false;
        $this$resolveAttributes_u24lambda_u2d8.putAll(attributes);
        Map combinedAttributes = map;
        if (bundleWithTraces) {
            Map<String, Object> map2 = datadogContext.getFeaturesContext().get("tracing");
            if (map2 != null) {
                Map threadLocalContext;
                Map<String, Object> it = map2;
                boolean bl2 = false;
                Object object = it.get("context@" + threadName);
                Map map3 = threadLocalContext = object instanceof Map ? (Map)object : null;
                if (threadLocalContext != null) {
                    combinedAttributes.put("dd.trace_id", threadLocalContext.get("trace_id"));
                    combinedAttributes.put("dd.span_id", threadLocalContext.get("span_id"));
                }
            }
        }
        if (bundleWithRum) {
            Map<String, Object> map4 = datadogContext.getFeaturesContext().get("rum");
            if (map4 != null) {
                Map<String, Object> it = map4;
                boolean bl3 = false;
                combinedAttributes.put("application_id", it.get("application_id"));
                combinedAttributes.put("session_id", it.get("session_id"));
                combinedAttributes.put("view.id", it.get("view_id"));
                combinedAttributes.put("user_action.id", it.get("action_id"));
            }
        }
        return combinedAttributes;
    }

    private final LogEvent.Status resolveLogLevelStatus(int level) {
        LogEvent.Status status;
        switch (level) {
            case 7: {
                status = LogEvent.Status.CRITICAL;
                break;
            }
            case 6: {
                status = LogEvent.Status.ERROR;
                break;
            }
            case 5: {
                status = LogEvent.Status.WARN;
                break;
            }
            case 4: {
                status = LogEvent.Status.INFO;
                break;
            }
            case 3: {
                status = LogEvent.Status.DEBUG;
                break;
            }
            case 2: {
                status = LogEvent.Status.TRACE;
                break;
            }
            case 9: {
                status = LogEvent.Status.EMERGENCY;
                break;
            }
            default: {
                status = LogEvent.Status.DEBUG;
            }
        }
        return status;
    }

    private final LogEvent.SimCarrier resolveSimCarrier(NetworkInfo networkInfo) {
        LogEvent.SimCarrier simCarrier;
        if (networkInfo.getCarrierId() != null || networkInfo.getCarrierName() != null) {
            Long l = networkInfo.getCarrierId();
            simCarrier = new LogEvent.SimCarrier((String)(l == null ? null : l.toString()), networkInfo.getCarrierName());
        } else {
            simCarrier = null;
        }
        return simCarrier;
    }

    public DatadogLogGenerator() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/datadog/android/log/internal/domain/DatadogLogGenerator$Companion;", "", "()V", "CRASH", "", "ISO_8601", "", "dd-sdk-android_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

