/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.log.internal.logger;

import com.datadog.android.core.internal.sampling.RateBasedSampler;
import com.datadog.android.core.internal.sampling.Sampler;
import com.datadog.android.core.internal.utils.RuntimeUtilsKt;
import com.datadog.android.log.internal.domain.LogGenerator;
import com.datadog.android.log.internal.logger.LogHandler;
import com.datadog.android.log.model.LogEvent;
import com.datadog.android.rum.GlobalRum;
import com.datadog.android.rum.RumErrorSource;
import com.datadog.android.v2.api.EventBatchWriter;
import com.datadog.android.v2.api.FeatureScope;
import com.datadog.android.v2.api.InternalLogger;
import com.datadog.android.v2.api.SdkCore;
import com.datadog.android.v2.api.context.DatadogContext;
import com.datadog.android.v2.core.internal.storage.DataWriter;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B[\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\b\b\u0002\u0010\r\u001a\u00020\f\u0012\b\b\u0002\u0010\u000e\u001a\u00020\f\u0012\b\b\u0002\u0010\u000f\u001a\u00020\u0010\u0012\b\b\u0002\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\u0002\u0010\u0013Jt\u0010$\u001a\u0004\u0018\u00010\n2\u0006\u0010%\u001a\u00020\u00122\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u00032\b\u0010)\u001a\u0004\u0018\u00010\u00032\b\u0010*\u001a\u0004\u0018\u00010\u00032\b\u0010+\u001a\u0004\u0018\u00010\u00032\u0014\u0010,\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010.0-2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\u0003002\u0006\u00101\u001a\u00020\u00032\u0006\u00102\u001a\u000203H\u0002J`\u0010$\u001a\u0004\u0018\u00010\n2\u0006\u0010%\u001a\u00020\u00122\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u00032\b\u00104\u001a\u0004\u0018\u0001052\u0014\u0010,\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010.0-2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\u0003002\u0006\u00101\u001a\u00020\u00032\u0006\u00102\u001a\u000203H\u0002Ji\u00106\u001a\u0002072\u0006\u0010%\u001a\u00020\u00122\u0006\u0010(\u001a\u00020\u00032\b\u0010)\u001a\u0004\u0018\u00010\u00032\b\u0010*\u001a\u0004\u0018\u00010\u00032\b\u00108\u001a\u0004\u0018\u00010\u00032\u0014\u0010,\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010.0-2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\u0003002\b\u00102\u001a\u0004\u0018\u000103H\u0016\u00a2\u0006\u0002\u00109JU\u00106\u001a\u0002072\u0006\u0010%\u001a\u00020\u00122\u0006\u0010(\u001a\u00020\u00032\b\u00104\u001a\u0004\u0018\u0001052\u0014\u0010,\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010.0-2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\u0003002\b\u00102\u001a\u0004\u0018\u000103H\u0016\u00a2\u0006\u0002\u0010:R\u0014\u0010\u000b\u001a\u00020\fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u000e\u001a\u00020\fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0015R\u0014\u0010\r\u001a\u00020\fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0015R\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u0011\u001a\u00020\u0012X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010\u000f\u001a\u00020\u0010X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0014\u0010\u0006\u001a\u00020\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#\u00a8\u0006;"}, d2={"Lcom/datadog/android/log/internal/logger/DatadogLogHandler;", "Lcom/datadog/android/log/internal/logger/LogHandler;", "loggerName", "", "logGenerator", "Lcom/datadog/android/log/internal/domain/LogGenerator;", "sdkCore", "Lcom/datadog/android/v2/api/SdkCore;", "writer", "Lcom/datadog/android/v2/core/internal/storage/DataWriter;", "Lcom/datadog/android/log/model/LogEvent;", "attachNetworkInfo", "", "bundleWithTraces", "bundleWithRum", "sampler", "Lcom/datadog/android/core/internal/sampling/Sampler;", "minLogPriority", "", "(Ljava/lang/String;Lcom/datadog/android/log/internal/domain/LogGenerator;Lcom/datadog/android/v2/api/SdkCore;Lcom/datadog/android/v2/core/internal/storage/DataWriter;ZZZLcom/datadog/android/core/internal/sampling/Sampler;I)V", "getAttachNetworkInfo$dd_sdk_android_release", "()Z", "getBundleWithRum$dd_sdk_android_release", "getBundleWithTraces$dd_sdk_android_release", "getLogGenerator$dd_sdk_android_release", "()Lcom/datadog/android/log/internal/domain/LogGenerator;", "getLoggerName$dd_sdk_android_release", "()Ljava/lang/String;", "getMinLogPriority$dd_sdk_android_release", "()I", "getSampler$dd_sdk_android_release", "()Lcom/datadog/android/core/internal/sampling/Sampler;", "getSdkCore$dd_sdk_android_release", "()Lcom/datadog/android/v2/api/SdkCore;", "getWriter$dd_sdk_android_release", "()Lcom/datadog/android/v2/core/internal/storage/DataWriter;", "createLog", "level", "datadogContext", "Lcom/datadog/android/v2/api/context/DatadogContext;", "message", "errorKind", "errorMessage", "errorStack", "attributes", "", "", "tags", "", "threadName", "timestamp", "", "throwable", "", "handleLog", "", "errorStacktrace", "(ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/Map;Ljava/util/Set;Ljava/lang/Long;)V", "(ILjava/lang/String;Ljava/lang/Throwable;Ljava/util/Map;Ljava/util/Set;Ljava/lang/Long;)V", "dd-sdk-android_release"})
public final class DatadogLogHandler
implements LogHandler {
    @NotNull
    private final String loggerName;
    @NotNull
    private final LogGenerator logGenerator;
    @NotNull
    private final SdkCore sdkCore;
    @NotNull
    private final DataWriter<LogEvent> writer;
    private final boolean attachNetworkInfo;
    private final boolean bundleWithTraces;
    private final boolean bundleWithRum;
    @NotNull
    private final Sampler sampler;
    private final int minLogPriority;

    public DatadogLogHandler(@NotNull String loggerName, @NotNull LogGenerator logGenerator, @NotNull SdkCore sdkCore, @NotNull DataWriter<LogEvent> writer, boolean attachNetworkInfo, boolean bundleWithTraces, boolean bundleWithRum, @NotNull Sampler sampler, int minLogPriority) {
        Intrinsics.checkNotNullParameter((Object)loggerName, (String)"loggerName");
        Intrinsics.checkNotNullParameter((Object)logGenerator, (String)"logGenerator");
        Intrinsics.checkNotNullParameter((Object)sdkCore, (String)"sdkCore");
        Intrinsics.checkNotNullParameter(writer, (String)"writer");
        Intrinsics.checkNotNullParameter((Object)sampler, (String)"sampler");
        this.loggerName = loggerName;
        this.logGenerator = logGenerator;
        this.sdkCore = sdkCore;
        this.writer = writer;
        this.attachNetworkInfo = attachNetworkInfo;
        this.bundleWithTraces = bundleWithTraces;
        this.bundleWithRum = bundleWithRum;
        this.sampler = sampler;
        this.minLogPriority = minLogPriority;
    }

    public /* synthetic */ DatadogLogHandler(String string, LogGenerator logGenerator, SdkCore sdkCore, DataWriter dataWriter, boolean bl, boolean bl2, boolean bl3, Sampler sampler, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 0x20) != 0) {
            bl2 = true;
        }
        if ((n2 & 0x40) != 0) {
            bl3 = true;
        }
        if ((n2 & 0x80) != 0) {
            sampler = new RateBasedSampler(1.0f);
        }
        if ((n2 & 0x100) != 0) {
            n = -1;
        }
        this(string, logGenerator, sdkCore, dataWriter, bl, bl2, bl3, sampler, n);
    }

    @NotNull
    public final String getLoggerName$dd_sdk_android_release() {
        return this.loggerName;
    }

    @NotNull
    public final LogGenerator getLogGenerator$dd_sdk_android_release() {
        return this.logGenerator;
    }

    @NotNull
    public final SdkCore getSdkCore$dd_sdk_android_release() {
        return this.sdkCore;
    }

    @NotNull
    public final DataWriter<LogEvent> getWriter$dd_sdk_android_release() {
        return this.writer;
    }

    public final boolean getAttachNetworkInfo$dd_sdk_android_release() {
        return this.attachNetworkInfo;
    }

    public final boolean getBundleWithTraces$dd_sdk_android_release() {
        return this.bundleWithTraces;
    }

    public final boolean getBundleWithRum$dd_sdk_android_release() {
        return this.bundleWithRum;
    }

    @NotNull
    public final Sampler getSampler$dd_sdk_android_release() {
        return this.sampler;
    }

    public final int getMinLogPriority$dd_sdk_android_release() {
        return this.minLogPriority;
    }

    @Override
    public void handleLog(int level, @NotNull String message, @Nullable Throwable throwable, @NotNull Map<String, ? extends Object> attributes, @NotNull Set<String> tags, @Nullable Long timestamp) {
        long resolvedTimeStamp;
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
        Intrinsics.checkNotNullParameter(tags, (String)"tags");
        if (level < this.minLogPriority) {
            return;
        }
        Long l = timestamp;
        long l2 = resolvedTimeStamp = l == null ? System.currentTimeMillis() : l;
        if (this.sampler.sample()) {
            FeatureScope logsFeature = this.sdkCore.getFeature("logs");
            if (logsFeature != null) {
                String threadName = Thread.currentThread().getName();
                FeatureScope.DefaultImpls.withWriteContext$default(logsFeature, false, (Function2)new Function2<DatadogContext, EventBatchWriter, Unit>(this, level, message, throwable, attributes, tags, threadName, resolvedTimeStamp){
                    final /* synthetic */ DatadogLogHandler this$0;
                    final /* synthetic */ int $level;
                    final /* synthetic */ String $message;
                    final /* synthetic */ Throwable $throwable;
                    final /* synthetic */ Map<String, Object> $attributes;
                    final /* synthetic */ Set<String> $tags;
                    final /* synthetic */ String $threadName;
                    final /* synthetic */ long $resolvedTimeStamp;
                    {
                        this.this$0 = $receiver;
                        this.$level = $level;
                        this.$message = $message;
                        this.$throwable = $throwable;
                        this.$attributes = $attributes;
                        this.$tags = $tags;
                        this.$threadName = $threadName;
                        this.$resolvedTimeStamp = $resolvedTimeStamp;
                        super(2);
                    }

                    public final void invoke(@NotNull DatadogContext datadogContext, @NotNull EventBatchWriter eventBatchWriter) {
                        Intrinsics.checkNotNullParameter((Object)datadogContext, (String)"datadogContext");
                        Intrinsics.checkNotNullParameter((Object)eventBatchWriter, (String)"eventBatchWriter");
                        String string = this.$threadName;
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"threadName");
                        LogEvent log = DatadogLogHandler.access$createLog(this.this$0, this.$level, datadogContext, this.$message, this.$throwable, this.$attributes, this.$tags, string, this.$resolvedTimeStamp);
                        if (log != null) {
                            this.this$0.getWriter$dd_sdk_android_release().write(eventBatchWriter, log);
                        }
                    }
                }, 1, null);
            } else {
                InternalLogger.DefaultImpls.log$default(RuntimeUtilsKt.getInternalLogger(), InternalLogger.Level.INFO, InternalLogger.Target.USER, "Requested to write log, but Logs feature is not registered.", null, 8, null);
            }
        }
        if (level >= 6) {
            GlobalRum.get().addError(message, RumErrorSource.LOGGER, throwable, attributes);
        }
    }

    @Override
    public void handleLog(int level, @NotNull String message, @Nullable String errorKind, @Nullable String errorMessage, @Nullable String errorStacktrace, @NotNull Map<String, ? extends Object> attributes, @NotNull Set<String> tags, @Nullable Long timestamp) {
        long resolvedTimeStamp;
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
        Intrinsics.checkNotNullParameter(tags, (String)"tags");
        if (level < this.minLogPriority) {
            return;
        }
        Long l = timestamp;
        long l2 = resolvedTimeStamp = l == null ? System.currentTimeMillis() : l;
        if (this.sampler.sample()) {
            FeatureScope logsFeature = this.sdkCore.getFeature("logs");
            if (logsFeature != null) {
                String threadName = Thread.currentThread().getName();
                FeatureScope.DefaultImpls.withWriteContext$default(logsFeature, false, (Function2)new Function2<DatadogContext, EventBatchWriter, Unit>(this, level, message, errorKind, errorMessage, errorStacktrace, attributes, tags, threadName, resolvedTimeStamp){
                    final /* synthetic */ DatadogLogHandler this$0;
                    final /* synthetic */ int $level;
                    final /* synthetic */ String $message;
                    final /* synthetic */ String $errorKind;
                    final /* synthetic */ String $errorMessage;
                    final /* synthetic */ String $errorStacktrace;
                    final /* synthetic */ Map<String, Object> $attributes;
                    final /* synthetic */ Set<String> $tags;
                    final /* synthetic */ String $threadName;
                    final /* synthetic */ long $resolvedTimeStamp;
                    {
                        this.this$0 = $receiver;
                        this.$level = $level;
                        this.$message = $message;
                        this.$errorKind = $errorKind;
                        this.$errorMessage = $errorMessage;
                        this.$errorStacktrace = $errorStacktrace;
                        this.$attributes = $attributes;
                        this.$tags = $tags;
                        this.$threadName = $threadName;
                        this.$resolvedTimeStamp = $resolvedTimeStamp;
                        super(2);
                    }

                    public final void invoke(@NotNull DatadogContext datadogContext, @NotNull EventBatchWriter eventBatchWriter) {
                        Intrinsics.checkNotNullParameter((Object)datadogContext, (String)"datadogContext");
                        Intrinsics.checkNotNullParameter((Object)eventBatchWriter, (String)"eventBatchWriter");
                        String string = this.$threadName;
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"threadName");
                        LogEvent log = DatadogLogHandler.access$createLog(this.this$0, this.$level, datadogContext, this.$message, this.$errorKind, this.$errorMessage, this.$errorStacktrace, this.$attributes, this.$tags, string, this.$resolvedTimeStamp);
                        if (log != null) {
                            this.this$0.getWriter$dd_sdk_android_release().write(eventBatchWriter, log);
                        }
                    }
                }, 1, null);
            } else {
                InternalLogger.DefaultImpls.log$default(RuntimeUtilsKt.getInternalLogger(), InternalLogger.Level.INFO, InternalLogger.Target.USER, "Requested to write log, but Logs feature is not registered.", null, 8, null);
            }
        }
        if (level >= 6) {
            GlobalRum.get().addErrorWithStacktrace(message, RumErrorSource.LOGGER, errorStacktrace, attributes);
        }
    }

    private final LogEvent createLog(int level, DatadogContext datadogContext, String message, Throwable throwable, Map<String, ? extends Object> attributes, Set<String> tags, String threadName, long timestamp) {
        LogGenerator logGenerator = this.logGenerator;
        boolean bl = this.attachNetworkInfo;
        String string = this.loggerName;
        boolean bl2 = this.bundleWithRum;
        boolean bl3 = this.bundleWithTraces;
        return LogGenerator.DefaultImpls.generateLog$default(logGenerator, level, message, throwable, attributes, tags, timestamp, threadName, datadogContext, bl, string, bl3, bl2, null, null, 12288, null);
    }

    private final LogEvent createLog(int level, DatadogContext datadogContext, String message, String errorKind, String errorMessage, String errorStack, Map<String, ? extends Object> attributes, Set<String> tags, String threadName, long timestamp) {
        LogGenerator logGenerator = this.logGenerator;
        boolean bl = this.attachNetworkInfo;
        String string = this.loggerName;
        boolean bl2 = this.bundleWithRum;
        boolean bl3 = this.bundleWithTraces;
        return LogGenerator.DefaultImpls.generateLog$default(logGenerator, level, message, errorKind, errorMessage, errorStack, attributes, tags, timestamp, threadName, datadogContext, bl, string, bl3, bl2, null, null, 49152, null);
    }

    public static final /* synthetic */ LogEvent access$createLog(DatadogLogHandler $this, int level, DatadogContext datadogContext, String message, Throwable throwable, Map attributes, Set tags, String threadName, long timestamp) {
        return $this.createLog(level, datadogContext, message, throwable, attributes, tags, threadName, timestamp);
    }

    public static final /* synthetic */ LogEvent access$createLog(DatadogLogHandler $this, int level, DatadogContext datadogContext, String message, String errorKind, String errorMessage, String errorStack, Map attributes, Set tags, String threadName, long timestamp) {
        return $this.createLog(level, datadogContext, message, errorKind, errorMessage, errorStack, attributes, tags, threadName, timestamp);
    }
}

