/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.rum.internal.debug;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.graphics.Color;
import android.os.Bundle;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.AnyThread;
import androidx.annotation.UiThread;
import com.datadog.android.core.internal.utils.RuntimeUtilsKt;
import com.datadog.android.rum.internal.debug.RumDebugListener;
import com.datadog.android.rum.internal.debug.UiRumDebugListener;
import com.datadog.android.rum.internal.monitor.AdvancedRumMonitor;
import com.datadog.android.rum.internal.monitor.NoOpAdvancedRumMonitor;
import com.datadog.android.v2.api.InternalLogger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010 \n\u0002\b\u0003\b\u0000\u0018\u0000 02\u00020\u00012\u00020\u0002:\u00010B\u0005\u00a2\u0006\u0002\u0010\u0003J \u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0018\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u001a\u0010!\u001a\u00020\"2\u0006\u0010\u001f\u001a\u00020 2\b\u0010#\u001a\u0004\u0018\u00010$H\u0016J\u0010\u0010%\u001a\u00020\"2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010&\u001a\u00020\"2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010'\u001a\u00020\"2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0018\u0010(\u001a\u00020\"2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010)\u001a\u00020$H\u0016J\u0010\u0010*\u001a\u00020\"2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010+\u001a\u00020\"2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0016\u0010,\u001a\u00020\"2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00120.H\u0017J\u0016\u0010/\u001a\u00020\"2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00120.H\u0003R\u001b\u0010\u0004\u001a\u00020\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007R\u001c\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lcom/datadog/android/rum/internal/debug/UiRumDebugListener;", "Landroid/app/Application$ActivityLifecycleCallbacks;", "Lcom/datadog/android/rum/internal/debug/RumDebugListener;", "()V", "advancedRumMonitor", "Lcom/datadog/android/rum/internal/monitor/AdvancedRumMonitor;", "getAdvancedRumMonitor", "()Lcom/datadog/android/rum/internal/monitor/AdvancedRumMonitor;", "advancedRumMonitor$delegate", "Lkotlin/Lazy;", "rumViewsContainer", "Landroid/widget/LinearLayout;", "getRumViewsContainer$dd_sdk_android_release", "()Landroid/widget/LinearLayout;", "setRumViewsContainer$dd_sdk_android_release", "(Landroid/widget/LinearLayout;)V", "viewsSnapshot", "", "", "createDebugTextView", "Landroid/widget/TextView;", "context", "Landroid/content/Context;", "viewName", "alpha", "", "dpToPx", "dp", "", "findContentView", "Landroid/widget/FrameLayout;", "activity", "Landroid/app/Activity;", "onActivityCreated", "", "savedInstanceState", "Landroid/os/Bundle;", "onActivityDestroyed", "onActivityPaused", "onActivityResumed", "onActivitySaveInstanceState", "outState", "onActivityStarted", "onActivityStopped", "onReceiveRumActiveViews", "viewNames", "", "showRumViewsInfo", "Companion", "dd-sdk-android_release"})
public final class UiRumDebugListener
implements Application.ActivityLifecycleCallbacks,
RumDebugListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private LinearLayout rumViewsContainer;
    @NotNull
    private final List<String> viewsSnapshot = new ArrayList();
    @NotNull
    private final Lazy advancedRumMonitor$delegate = LazyKt.lazy((Function0)advancedRumMonitor.2.INSTANCE);
    @NotNull
    public static final String CANNOT_FIND_CONTENT_VIEW_MESSAGE = "Cannot enable RUM debugging, because cannot find root content view";
    @NotNull
    public static final String MISSING_RUM_MONITOR_TYPE = "Cannot enable RUM debugging, because global RUM monitor doesn't implement %s";
    public static final int DEFAULT_ALPHA = 200;
    private static final int ACTIVE_COLOR = Color.rgb((int)99, (int)44, (int)166);

    @Nullable
    public final LinearLayout getRumViewsContainer$dd_sdk_android_release() {
        return this.rumViewsContainer;
    }

    public final void setRumViewsContainer$dd_sdk_android_release(@Nullable LinearLayout linearLayout) {
        this.rumViewsContainer = linearLayout;
    }

    private final AdvancedRumMonitor getAdvancedRumMonitor() {
        Lazy lazy = this.advancedRumMonitor$delegate;
        return (AdvancedRumMonitor)lazy.getValue();
    }

    public void onActivityCreated(@NotNull Activity activity, @Nullable Bundle savedInstanceState) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
    }

    public void onActivityStarted(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
    }

    public void onActivityResumed(@NotNull Activity activity) {
        LinearLayout $this$onActivityResumed_u24lambda_u2d0;
        LinearLayout linearLayout;
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        if (this.getAdvancedRumMonitor() instanceof NoOpAdvancedRumMonitor) {
            return;
        }
        FrameLayout contentView = this.findContentView(activity);
        if (contentView == null) {
            InternalLogger.DefaultImpls.log$default(RuntimeUtilsKt.getInternalLogger(), InternalLogger.Level.WARN, InternalLogger.Target.USER, CANNOT_FIND_CONTENT_VIEW_MESSAGE, null, 8, null);
            return;
        }
        LinearLayout linearLayout2 = linearLayout = new LinearLayout((Context)activity);
        UiRumDebugListener uiRumDebugListener = this;
        boolean bl = false;
        $this$onActivityResumed_u24lambda_u2d0.setOrientation(1);
        uiRumDebugListener.rumViewsContainer = linearLayout;
        $this$onActivityResumed_u24lambda_u2d0 = linearLayout = new FrameLayout.LayoutParams(-1, -2);
        View view = (View)this.rumViewsContainer;
        uiRumDebugListener = contentView;
        boolean bl2 = false;
        $this$onActivityResumed_u24lambda_u2d1.gravity = 80;
        Unit unit = Unit.INSTANCE;
        uiRumDebugListener.addView(view, (ViewGroup.LayoutParams)linearLayout);
        this.getAdvancedRumMonitor().setDebugListener(this);
    }

    public void onActivityPaused(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        if (this.getAdvancedRumMonitor() instanceof NoOpAdvancedRumMonitor) {
            return;
        }
        FrameLayout frameLayout = this.findContentView(activity);
        if (frameLayout != null) {
            frameLayout.removeView((View)this.rumViewsContainer);
        }
        this.rumViewsContainer = null;
        this.getAdvancedRumMonitor().setDebugListener(null);
        this.viewsSnapshot.clear();
    }

    public void onActivityStopped(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
    }

    public void onActivitySaveInstanceState(@NotNull Activity activity, @NotNull Bundle outState) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intrinsics.checkNotNullParameter((Object)outState, (String)"outState");
    }

    public void onActivityDestroyed(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @AnyThread
    public void onReceiveRumActiveViews(@NotNull List<String> viewNames) {
        Intrinsics.checkNotNullParameter(viewNames, (String)"viewNames");
        List<String> list = this.viewsSnapshot;
        synchronized (list) {
            block13: {
                block12: {
                    boolean bl;
                    block11: {
                        boolean bl2 = false;
                        if (this.viewsSnapshot.isEmpty() || this.viewsSnapshot.size() != viewNames.size()) break block12;
                        Iterable $this$any$iv = CollectionsKt.withIndex((Iterable)this.viewsSnapshot);
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                IndexedValue it = (IndexedValue)element$iv;
                                boolean bl3 = false;
                                if (!(!Intrinsics.areEqual((Object)it.getValue(), (Object)CollectionsKt.getOrNull(viewNames, (int)it.getIndex())))) continue;
                                bl = true;
                                break block11;
                            }
                            bl = false;
                        }
                    }
                    if (!bl) break block13;
                }
                this.viewsSnapshot.clear();
                this.viewsSnapshot.addAll((Collection<String>)viewNames);
                LinearLayout linearLayout = this.getRumViewsContainer$dd_sdk_android_release();
                if (linearLayout != null) {
                    linearLayout.post(() -> UiRumDebugListener.onReceiveRumActiveViews$lambda-4$lambda-3(this, viewNames));
                }
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    @UiThread
    private final void showRumViewsInfo(List<String> viewNames) {
        LinearLayout linearLayout = this.rumViewsContainer;
        if (linearLayout != null) {
            LinearLayout $this$showRumViewsInfo_u24lambda_u2d5 = linearLayout;
            boolean bl = false;
            $this$showRumViewsInfo_u24lambda_u2d5.removeAllViews();
            if (viewNames.isEmpty()) {
                Context context = $this$showRumViewsInfo_u24lambda_u2d5.getContext();
                Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
                $this$showRumViewsInfo_u24lambda_u2d5.addView((View)this.createDebugTextView(context, "No active RUM View", 200));
            } else {
                for (IndexedValue viewName : CollectionsKt.withIndex((Iterable)CollectionsKt.reversed((Iterable)viewNames))) {
                    Context context = $this$showRumViewsInfo_u24lambda_u2d5.getContext();
                    Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
                    $this$showRumViewsInfo_u24lambda_u2d5.addView((View)this.createDebugTextView(context, (String)viewName.getValue(), (int)((double)255 * Math.pow(0.75, viewName.getIndex() + 1))));
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final TextView createDebugTextView(Context context, String viewName, int alpha) {
        void $this$setPadding$iv;
        TextView textView;
        TextView $this$createDebugTextView_u24lambda_u2d6 = textView = new TextView(context);
        boolean bl = false;
        $this$createDebugTextView_u24lambda_u2d6.setGravity(1);
        int $this$red$iv = ACTIVE_COLOR;
        boolean $i$f$getRed = false;
        int $this$green$iv = ACTIVE_COLOR;
        boolean $i$f$getGreen = false;
        int $this$blue$iv22 = ACTIVE_COLOR;
        boolean $i$f$getBlue = false;
        $this$createDebugTextView_u24lambda_u2d6.setBackgroundColor(Color.argb((int)alpha, (int)($this$red$iv >> 16 & 0xFF), (int)($this$green$iv >> 8 & 0xFF), (int)($this$blue$iv22 & 0xFF)));
        $this$createDebugTextView_u24lambda_u2d6.setTextColor(-1);
        View $this$blue$iv22 = (View)$this$createDebugTextView_u24lambda_u2d6;
        int size$iv = this.dpToPx(2.0f, context);
        boolean $i$f$setPadding = false;
        $this$setPadding$iv.setPadding(size$iv, size$iv, size$iv, size$iv);
        $this$createDebugTextView_u24lambda_u2d6.setText((CharSequence)viewName);
        return textView;
    }

    private final FrameLayout findContentView(Activity activity) {
        View view = activity.getWindow().getDecorView();
        ViewGroup viewGroup = view instanceof ViewGroup ? (ViewGroup)view : null;
        View view2 = viewGroup == null ? null : viewGroup.findViewById(0x1020002);
        return view2 instanceof FrameLayout ? (FrameLayout)view2 : null;
    }

    private final int dpToPx(float dp, Context context) {
        DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
        return (int)((double)(dp * displayMetrics.density) + 0.5);
    }

    private static final void onReceiveRumActiveViews$lambda-4$lambda-3(UiRumDebugListener this$0, List $viewNames) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$viewNames, (String)"$viewNames");
        this$0.showRumViewsInfo($viewNames);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/datadog/android/rum/internal/debug/UiRumDebugListener$Companion;", "", "()V", "ACTIVE_COLOR", "", "getACTIVE_COLOR", "()I", "CANNOT_FIND_CONTENT_VIEW_MESSAGE", "", "DEFAULT_ALPHA", "MISSING_RUM_MONITOR_TYPE", "dd-sdk-android_release"})
    public static final class Companion {
        private Companion() {
        }

        public final int getACTIVE_COLOR() {
            return ACTIVE_COLOR;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

