/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.rum.internal.domain;

import com.datadog.android.rum.internal.domain.scope.RumSessionScope;
import com.datadog.android.rum.internal.domain.scope.RumViewScope;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u001a\n\u0002\u0010\b\n\u0000\n\u0002\u0010$\n\u0002\b\u0003\b\u0080\b\u0018\u0000 -2\u00020\u0001:\u0001-Bg\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u0012\b\b\u0002\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\t\u0010\u001c\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\u0006H\u00c6\u0003J\u000b\u0010\u001f\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010 \u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010!\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\"\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010#\u001a\u00020\fH\u00c6\u0003J\t\u0010$\u001a\u00020\u000eH\u00c6\u0003Jk\u0010%\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\u000eH\u00c6\u0001J\u0013\u0010&\u001a\u00020\u00062\b\u0010'\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010(\u001a\u00020)H\u00d6\u0001J\u0014\u0010*\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00010+J\t\u0010,\u001a\u00020\u0003H\u00d6\u0001R\u0013\u0010\n\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0013R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0011R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0011R\u0013\u0010\b\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0011R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0013\u0010\t\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0011\u00a8\u0006."}, d2={"Lcom/datadog/android/rum/internal/domain/RumContext;", "", "applicationId", "", "sessionId", "isSessionActive", "", "viewId", "viewName", "viewUrl", "actionId", "sessionState", "Lcom/datadog/android/rum/internal/domain/scope/RumSessionScope$State;", "viewType", "Lcom/datadog/android/rum/internal/domain/scope/RumViewScope$RumViewType;", "(Ljava/lang/String;Ljava/lang/String;ZLjava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lcom/datadog/android/rum/internal/domain/scope/RumSessionScope$State;Lcom/datadog/android/rum/internal/domain/scope/RumViewScope$RumViewType;)V", "getActionId", "()Ljava/lang/String;", "getApplicationId", "()Z", "getSessionId", "getSessionState", "()Lcom/datadog/android/rum/internal/domain/scope/RumSessionScope$State;", "getViewId", "getViewName", "getViewType", "()Lcom/datadog/android/rum/internal/domain/scope/RumViewScope$RumViewType;", "getViewUrl", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "equals", "other", "hashCode", "", "toMap", "", "toString", "Companion", "dd-sdk-android_release"})
public final class RumContext {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String applicationId;
    @NotNull
    private final String sessionId;
    private final boolean isSessionActive;
    @Nullable
    private final String viewId;
    @Nullable
    private final String viewName;
    @Nullable
    private final String viewUrl;
    @Nullable
    private final String actionId;
    @NotNull
    private final RumSessionScope.State sessionState;
    @NotNull
    private final RumViewScope.RumViewType viewType;
    @NotNull
    private static final String NULL_UUID;
    @NotNull
    public static final String APPLICATION_ID = "application_id";
    @NotNull
    public static final String SESSION_ID = "session_id";
    @NotNull
    public static final String SESSION_STATE = "session_state";
    @NotNull
    public static final String VIEW_ID = "view_id";
    @NotNull
    public static final String VIEW_NAME = "view_name";
    @NotNull
    public static final String VIEW_URL = "view_url";
    @NotNull
    public static final String VIEW_TYPE = "view_type";
    @NotNull
    public static final String ACTION_ID = "action_id";

    public RumContext(@NotNull String applicationId, @NotNull String sessionId, boolean isSessionActive, @Nullable String viewId, @Nullable String viewName, @Nullable String viewUrl, @Nullable String actionId, @NotNull RumSessionScope.State sessionState, @NotNull RumViewScope.RumViewType viewType) {
        Intrinsics.checkNotNullParameter((Object)applicationId, (String)"applicationId");
        Intrinsics.checkNotNullParameter((Object)sessionId, (String)"sessionId");
        Intrinsics.checkNotNullParameter((Object)((Object)sessionState), (String)"sessionState");
        Intrinsics.checkNotNullParameter((Object)((Object)viewType), (String)"viewType");
        this.applicationId = applicationId;
        this.sessionId = sessionId;
        this.isSessionActive = isSessionActive;
        this.viewId = viewId;
        this.viewName = viewName;
        this.viewUrl = viewUrl;
        this.actionId = actionId;
        this.sessionState = sessionState;
        this.viewType = viewType;
    }

    public /* synthetic */ RumContext(String string, String string2, boolean bl, String string3, String string4, String string5, String string6, RumSessionScope.State state, RumViewScope.RumViewType rumViewType, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = NULL_UUID;
        }
        if ((n & 2) != 0) {
            string2 = NULL_UUID;
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        if ((n & 8) != 0) {
            string3 = null;
        }
        if ((n & 0x10) != 0) {
            string4 = null;
        }
        if ((n & 0x20) != 0) {
            string5 = null;
        }
        if ((n & 0x40) != 0) {
            string6 = null;
        }
        if ((n & 0x80) != 0) {
            state = RumSessionScope.State.NOT_TRACKED;
        }
        if ((n & 0x100) != 0) {
            rumViewType = RumViewScope.RumViewType.NONE;
        }
        this(string, string2, bl, string3, string4, string5, string6, state, rumViewType);
    }

    @NotNull
    public final String getApplicationId() {
        return this.applicationId;
    }

    @NotNull
    public final String getSessionId() {
        return this.sessionId;
    }

    public final boolean isSessionActive() {
        return this.isSessionActive;
    }

    @Nullable
    public final String getViewId() {
        return this.viewId;
    }

    @Nullable
    public final String getViewName() {
        return this.viewName;
    }

    @Nullable
    public final String getViewUrl() {
        return this.viewUrl;
    }

    @Nullable
    public final String getActionId() {
        return this.actionId;
    }

    @NotNull
    public final RumSessionScope.State getSessionState() {
        return this.sessionState;
    }

    @NotNull
    public final RumViewScope.RumViewType getViewType() {
        return this.viewType;
    }

    @NotNull
    public final Map<String, Object> toMap() {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)APPLICATION_ID, (Object)this.applicationId), TuplesKt.to((Object)SESSION_ID, (Object)this.sessionId), TuplesKt.to((Object)SESSION_STATE, (Object)((Object)this.sessionState)), TuplesKt.to((Object)VIEW_ID, (Object)this.viewId), TuplesKt.to((Object)VIEW_NAME, (Object)this.viewName), TuplesKt.to((Object)VIEW_URL, (Object)this.viewUrl), TuplesKt.to((Object)VIEW_TYPE, (Object)((Object)this.viewType)), TuplesKt.to((Object)ACTION_ID, (Object)this.actionId)};
        return MapsKt.mapOf((Pair[])pairArray);
    }

    @NotNull
    public final String component1() {
        return this.applicationId;
    }

    @NotNull
    public final String component2() {
        return this.sessionId;
    }

    public final boolean component3() {
        return this.isSessionActive;
    }

    @Nullable
    public final String component4() {
        return this.viewId;
    }

    @Nullable
    public final String component5() {
        return this.viewName;
    }

    @Nullable
    public final String component6() {
        return this.viewUrl;
    }

    @Nullable
    public final String component7() {
        return this.actionId;
    }

    @NotNull
    public final RumSessionScope.State component8() {
        return this.sessionState;
    }

    @NotNull
    public final RumViewScope.RumViewType component9() {
        return this.viewType;
    }

    @NotNull
    public final RumContext copy(@NotNull String applicationId, @NotNull String sessionId, boolean isSessionActive, @Nullable String viewId, @Nullable String viewName, @Nullable String viewUrl, @Nullable String actionId, @NotNull RumSessionScope.State sessionState, @NotNull RumViewScope.RumViewType viewType) {
        Intrinsics.checkNotNullParameter((Object)applicationId, (String)"applicationId");
        Intrinsics.checkNotNullParameter((Object)sessionId, (String)"sessionId");
        Intrinsics.checkNotNullParameter((Object)((Object)sessionState), (String)"sessionState");
        Intrinsics.checkNotNullParameter((Object)((Object)viewType), (String)"viewType");
        return new RumContext(applicationId, sessionId, isSessionActive, viewId, viewName, viewUrl, actionId, sessionState, viewType);
    }

    public static /* synthetic */ RumContext copy$default(RumContext rumContext, String string, String string2, boolean bl, String string3, String string4, String string5, String string6, RumSessionScope.State state, RumViewScope.RumViewType rumViewType, int n, Object object) {
        if ((n & 1) != 0) {
            string = rumContext.applicationId;
        }
        if ((n & 2) != 0) {
            string2 = rumContext.sessionId;
        }
        if ((n & 4) != 0) {
            bl = rumContext.isSessionActive;
        }
        if ((n & 8) != 0) {
            string3 = rumContext.viewId;
        }
        if ((n & 0x10) != 0) {
            string4 = rumContext.viewName;
        }
        if ((n & 0x20) != 0) {
            string5 = rumContext.viewUrl;
        }
        if ((n & 0x40) != 0) {
            string6 = rumContext.actionId;
        }
        if ((n & 0x80) != 0) {
            state = rumContext.sessionState;
        }
        if ((n & 0x100) != 0) {
            rumViewType = rumContext.viewType;
        }
        return rumContext.copy(string, string2, bl, string3, string4, string5, string6, state, rumViewType);
    }

    @NotNull
    public String toString() {
        return "RumContext(applicationId=" + this.applicationId + ", sessionId=" + this.sessionId + ", isSessionActive=" + this.isSessionActive + ", viewId=" + this.viewId + ", viewName=" + this.viewName + ", viewUrl=" + this.viewUrl + ", actionId=" + this.actionId + ", sessionState=" + this.sessionState + ", viewType=" + this.viewType + ")";
    }

    public int hashCode() {
        int result = this.applicationId.hashCode();
        result = result * 31 + this.sessionId.hashCode();
        int n = this.isSessionActive ? 1 : 0;
        if (n != 0) {
            n = 1;
        }
        result = result * 31 + n;
        result = result * 31 + (this.viewId == null ? 0 : this.viewId.hashCode());
        result = result * 31 + (this.viewName == null ? 0 : this.viewName.hashCode());
        result = result * 31 + (this.viewUrl == null ? 0 : this.viewUrl.hashCode());
        result = result * 31 + (this.actionId == null ? 0 : this.actionId.hashCode());
        result = result * 31 + this.sessionState.hashCode();
        result = result * 31 + this.viewType.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof RumContext)) {
            return false;
        }
        RumContext rumContext = (RumContext)other;
        if (!Intrinsics.areEqual((Object)this.applicationId, (Object)rumContext.applicationId)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.sessionId, (Object)rumContext.sessionId)) {
            return false;
        }
        if (this.isSessionActive != rumContext.isSessionActive) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.viewId, (Object)rumContext.viewId)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.viewName, (Object)rumContext.viewName)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.viewUrl, (Object)rumContext.viewUrl)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.actionId, (Object)rumContext.actionId)) {
            return false;
        }
        if (this.sessionState != rumContext.sessionState) {
            return false;
        }
        return this.viewType == rumContext.viewType;
    }

    public RumContext() {
        this(null, null, false, null, null, null, null, null, null, 511, null);
    }

    static {
        String string = new UUID(0L, 0L).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"UUID(0, 0).toString()");
        NULL_UUID = string;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u000f\u001a\u00020\u00102\u0014\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0012R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/datadog/android/rum/internal/domain/RumContext$Companion;", "", "()V", "ACTION_ID", "", "APPLICATION_ID", "NULL_UUID", "getNULL_UUID", "()Ljava/lang/String;", "SESSION_ID", "SESSION_STATE", "VIEW_ID", "VIEW_NAME", "VIEW_TYPE", "VIEW_URL", "fromFeatureContext", "Lcom/datadog/android/rum/internal/domain/RumContext;", "featureContext", "", "dd-sdk-android_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getNULL_UUID() {
            return NULL_UUID;
        }

        @NotNull
        public final RumContext fromFeatureContext(@NotNull Map<String, ? extends Object> featureContext) {
            String string;
            Intrinsics.checkNotNullParameter(featureContext, (String)"featureContext");
            Object object = featureContext.get(RumContext.APPLICATION_ID);
            String applicationId = object instanceof String ? (String)object : null;
            Object object2 = featureContext.get(RumContext.SESSION_ID);
            String sessionId = object2 instanceof String ? (String)object2 : null;
            Object object3 = featureContext.get(RumContext.SESSION_STATE);
            RumSessionScope.State state = object3 instanceof RumSessionScope.State ? (RumSessionScope.State)((Object)object3) : null;
            RumSessionScope.State sessionState = state == null ? RumSessionScope.State.NOT_TRACKED : state;
            object3 = featureContext.get(RumContext.VIEW_ID);
            String viewId = object3 instanceof String ? (String)object3 : null;
            Object object4 = featureContext.get(RumContext.VIEW_NAME);
            String viewName = object4 instanceof String ? (String)object4 : null;
            Object object5 = featureContext.get(RumContext.VIEW_URL);
            String viewUrl = object5 instanceof String ? (String)object5 : null;
            Object object6 = featureContext.get(RumContext.VIEW_TYPE);
            RumViewScope.RumViewType rumViewType = object6 instanceof RumViewScope.RumViewType ? (RumViewScope.RumViewType)((Object)object6) : null;
            RumViewScope.RumViewType viewType = rumViewType == null ? RumViewScope.RumViewType.NONE : rumViewType;
            object6 = featureContext.get(RumContext.ACTION_ID);
            String actionId = object6 instanceof String ? (String)object6 : null;
            Object object7 = applicationId;
            if (object7 == null) {
                object7 = object6 = this.getNULL_UUID();
            }
            if ((string = sessionId) == null) {
                string = this.getNULL_UUID();
            }
            String string2 = string;
            return new RumContext((String)object6, string2, false, viewId, viewName, viewUrl, actionId, sessionState, viewType, 4, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

