/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.rum.internal.domain.scope;

import androidx.annotation.WorkerThread;
import com.datadog.android.rum.GlobalRum;
import com.datadog.android.rum.RumActionType;
import com.datadog.android.rum.internal.FeaturesContextResolver;
import com.datadog.android.rum.internal.domain.RumContext;
import com.datadog.android.rum.internal.domain.Time;
import com.datadog.android.rum.internal.domain.scope.RumActionScope;
import com.datadog.android.rum.internal.domain.scope.RumEventExtKt;
import com.datadog.android.rum.internal.domain.scope.RumRawEvent;
import com.datadog.android.rum.internal.domain.scope.RumScope;
import com.datadog.android.rum.model.ActionEvent;
import com.datadog.android.v2.api.EventBatchWriter;
import com.datadog.android.v2.api.FeatureScope;
import com.datadog.android.v2.api.SdkCore;
import com.datadog.android.v2.api.context.DatadogContext;
import com.datadog.android.v2.api.context.NetworkInfo;
import com.datadog.android.v2.api.context.UserInfo;
import com.datadog.android.v2.core.internal.ContextProvider;
import com.datadog.android.v2.core.internal.storage.DataWriter;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010%\n\u0002\b\u0017\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 e2\u00020\u0001:\u0001eB\u0081\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0014\u0010\r\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\u000e\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\b\b\u0002\u0010\u0012\u001a\u00020\u0011\u0012\b\b\u0002\u0010\u0013\u001a\u00020\u0011\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u0012\b\b\u0002\u0010\u0016\u001a\u00020\u0017\u0012\u0006\u0010\u0018\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0019J\b\u0010L\u001a\u00020MH\u0016J \u0010N\u001a\u0004\u0018\u00010\u00012\u0006\u0010O\u001a\u00020P2\f\u0010Q\u001a\b\u0012\u0004\u0012\u00020\u000f0RH\u0017J\b\u0010S\u001a\u00020\u0006H\u0016J&\u0010T\u001a\u00020U2\u0006\u0010O\u001a\u00020V2\u0006\u0010W\u001a\u00020\u00112\f\u0010Q\u001a\b\u0012\u0004\u0012\u00020\u000f0RH\u0003J\u0010\u0010X\u001a\u00020U2\u0006\u0010W\u001a\u00020\u0011H\u0002J\u0018\u0010Y\u001a\u00020U2\u0006\u0010Z\u001a\u00020\f2\u0006\u0010W\u001a\u00020\u0011H\u0002J\u0018\u0010[\u001a\u00020U2\u0006\u0010O\u001a\u00020\\2\u0006\u0010W\u001a\u00020\u0011H\u0002J\u001e\u0010]\u001a\u00020U2\u0006\u0010W\u001a\u00020\u00112\f\u0010Q\u001a\b\u0012\u0004\u0012\u00020\u000f0RH\u0003J\u0018\u0010^\u001a\u00020U2\u0006\u0010O\u001a\u00020_2\u0006\u0010W\u001a\u00020\u0011H\u0002J\u0018\u0010`\u001a\u00020U2\u0006\u0010O\u001a\u00020a2\u0006\u0010W\u001a\u00020\u0011H\u0002J\u001e\u0010b\u001a\u00020U2\u0006\u0010W\u001a\u00020\u00112\f\u0010Q\u001a\b\u0012\u0004\u0012\u00020\u000f0RH\u0003J\u001e\u0010c\u001a\u00020U2\u0006\u0010d\u001a\u00020\u00112\f\u0010Q\u001a\b\u0012\u0004\u0012\u00020\u000f0RH\u0002R\u0014\u0010\u001a\u001a\u00020\fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\"\u0010\u001d\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\u001eX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u001a\u0010!\u001a\u00020\u0011X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R\u001a\u0010&\u001a\u00020\u0011X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010#\"\u0004\b(\u0010%R\u0014\u0010)\u001a\u00020\u0011X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010#R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010-\u001a\u00020\u0011X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010#\"\u0004\b/\u0010%R\u000e\u00100\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u00101\u001a\u00020\fX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u0010\u001c\"\u0004\b3\u00104R\u000e\u00105\u001a\u000206X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u00107\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0908X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b:\u0010;R\u001a\u0010<\u001a\u00020\u0011X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b=\u0010#\"\u0004\b>\u0010%R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010?\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010@\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010A\u001a\u00020\u0006X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bB\u0010C\"\u0004\bD\u0010ER\u000e\u0010\u0018\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010F\u001a\u00020\nX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bG\u0010H\"\u0004\bI\u0010JR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\bK\u0010C\u00a8\u0006f"}, d2={"Lcom/datadog/android/rum/internal/domain/scope/RumActionScope;", "Lcom/datadog/android/rum/internal/domain/scope/RumScope;", "parentScope", "sdkCore", "Lcom/datadog/android/v2/api/SdkCore;", "waitForStop", "", "eventTime", "Lcom/datadog/android/rum/internal/domain/Time;", "initialType", "Lcom/datadog/android/rum/RumActionType;", "initialName", "", "initialAttributes", "", "", "serverTimeOffsetInMs", "", "inactivityThresholdMs", "maxDurationMs", "contextProvider", "Lcom/datadog/android/v2/core/internal/ContextProvider;", "featuresContextResolver", "Lcom/datadog/android/rum/internal/FeaturesContextResolver;", "trackFrustrations", "(Lcom/datadog/android/rum/internal/domain/scope/RumScope;Lcom/datadog/android/v2/api/SdkCore;ZLcom/datadog/android/rum/internal/domain/Time;Lcom/datadog/android/rum/RumActionType;Ljava/lang/String;Ljava/util/Map;JJJLcom/datadog/android/v2/core/internal/ContextProvider;Lcom/datadog/android/rum/internal/FeaturesContextResolver;Z)V", "actionId", "getActionId$dd_sdk_android_release", "()Ljava/lang/String;", "attributes", "", "getAttributes$dd_sdk_android_release", "()Ljava/util/Map;", "crashCount", "getCrashCount$dd_sdk_android_release", "()J", "setCrashCount$dd_sdk_android_release", "(J)V", "errorCount", "getErrorCount$dd_sdk_android_release", "setErrorCount$dd_sdk_android_release", "eventTimestamp", "getEventTimestamp$dd_sdk_android_release", "inactivityThresholdNs", "lastInteractionNanos", "longTaskCount", "getLongTaskCount$dd_sdk_android_release", "setLongTaskCount$dd_sdk_android_release", "maxDurationNs", "name", "getName$dd_sdk_android_release", "setName$dd_sdk_android_release", "(Ljava/lang/String;)V", "networkInfo", "Lcom/datadog/android/v2/api/context/NetworkInfo;", "ongoingResourceKeys", "", "Ljava/lang/ref/WeakReference;", "getParentScope", "()Lcom/datadog/android/rum/internal/domain/scope/RumScope;", "resourceCount", "getResourceCount$dd_sdk_android_release", "setResourceCount$dd_sdk_android_release", "sent", "startedNanos", "stopped", "getStopped$dd_sdk_android_release", "()Z", "setStopped$dd_sdk_android_release", "(Z)V", "type", "getType$dd_sdk_android_release", "()Lcom/datadog/android/rum/RumActionType;", "setType$dd_sdk_android_release", "(Lcom/datadog/android/rum/RumActionType;)V", "getWaitForStop", "getRumContext", "Lcom/datadog/android/rum/internal/domain/RumContext;", "handleEvent", "event", "Lcom/datadog/android/rum/internal/domain/scope/RumRawEvent;", "writer", "Lcom/datadog/android/v2/core/internal/storage/DataWriter;", "isActive", "onError", "", "Lcom/datadog/android/rum/internal/domain/scope/RumRawEvent$AddError;", "now", "onLongTask", "onResourceError", "eventKey", "onStartResource", "Lcom/datadog/android/rum/internal/domain/scope/RumRawEvent$StartResource;", "onStartView", "onStopAction", "Lcom/datadog/android/rum/internal/domain/scope/RumRawEvent$StopAction;", "onStopResource", "Lcom/datadog/android/rum/internal/domain/scope/RumRawEvent$StopResource;", "onStopView", "sendAction", "endNanos", "Companion", "dd-sdk-android_release"})
public final class RumActionScope
implements RumScope {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final RumScope parentScope;
    @NotNull
    private final SdkCore sdkCore;
    private final boolean waitForStop;
    @NotNull
    private final FeaturesContextResolver featuresContextResolver;
    private final boolean trackFrustrations;
    private final long inactivityThresholdNs;
    private final long maxDurationNs;
    private final long eventTimestamp;
    @NotNull
    private final String actionId;
    @NotNull
    private RumActionType type;
    @NotNull
    private String name;
    private final long startedNanos;
    private long lastInteractionNanos;
    @NotNull
    private final NetworkInfo networkInfo;
    @NotNull
    private final Map<String, Object> attributes;
    @NotNull
    private final List<WeakReference<Object>> ongoingResourceKeys;
    private long resourceCount;
    private long errorCount;
    private long crashCount;
    private long longTaskCount;
    private boolean sent;
    private boolean stopped;
    public static final long ACTION_INACTIVITY_MS = 100L;
    public static final long ACTION_MAX_DURATION_MS = 5000L;

    /*
     * WARNING - void declaration
     */
    public RumActionScope(@NotNull RumScope parentScope, @NotNull SdkCore sdkCore, boolean waitForStop, @NotNull Time eventTime, @NotNull RumActionType initialType, @NotNull String initialName, @NotNull Map<String, ? extends Object> initialAttributes, long serverTimeOffsetInMs, long inactivityThresholdMs, long maxDurationMs, @NotNull ContextProvider contextProvider, @NotNull FeaturesContextResolver featuresContextResolver, boolean trackFrustrations2) {
        void $this$attributes_u24lambda_u2d0;
        Intrinsics.checkNotNullParameter((Object)parentScope, (String)"parentScope");
        Intrinsics.checkNotNullParameter((Object)sdkCore, (String)"sdkCore");
        Intrinsics.checkNotNullParameter((Object)eventTime, (String)"eventTime");
        Intrinsics.checkNotNullParameter((Object)((Object)initialType), (String)"initialType");
        Intrinsics.checkNotNullParameter((Object)initialName, (String)"initialName");
        Intrinsics.checkNotNullParameter(initialAttributes, (String)"initialAttributes");
        Intrinsics.checkNotNullParameter((Object)contextProvider, (String)"contextProvider");
        Intrinsics.checkNotNullParameter((Object)featuresContextResolver, (String)"featuresContextResolver");
        this.parentScope = parentScope;
        this.sdkCore = sdkCore;
        this.waitForStop = waitForStop;
        this.featuresContextResolver = featuresContextResolver;
        this.trackFrustrations = trackFrustrations2;
        this.inactivityThresholdNs = TimeUnit.MILLISECONDS.toNanos(inactivityThresholdMs);
        this.maxDurationNs = TimeUnit.MILLISECONDS.toNanos(maxDurationMs);
        this.eventTimestamp = eventTime.getTimestamp() + serverTimeOffsetInMs;
        Object object = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"randomUUID().toString()");
        this.actionId = object;
        this.type = initialType;
        this.name = initialName;
        this.lastInteractionNanos = this.startedNanos = eventTime.getNanoTime();
        this.networkInfo = contextProvider.getContext().getNetworkInfo();
        Object object2 = object = MapsKt.toMutableMap(initialAttributes);
        RumActionScope rumActionScope = this;
        boolean bl = false;
        $this$attributes_u24lambda_u2d0.putAll(GlobalRum.INSTANCE.getGlobalAttributes$dd_sdk_android_release());
        rumActionScope.attributes = object;
        this.ongoingResourceKeys = new ArrayList();
    }

    public /* synthetic */ RumActionScope(RumScope rumScope, SdkCore sdkCore, boolean bl, Time time, RumActionType rumActionType, String string, Map map, long l, long l2, long l3, ContextProvider contextProvider, FeaturesContextResolver featuresContextResolver, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x100) != 0) {
            l2 = 100L;
        }
        if ((n & 0x200) != 0) {
            l3 = 5000L;
        }
        if ((n & 0x800) != 0) {
            featuresContextResolver = new FeaturesContextResolver();
        }
        this(rumScope, sdkCore, bl, time, rumActionType, string, map, l, l2, l3, contextProvider, featuresContextResolver, bl2);
    }

    @NotNull
    public final RumScope getParentScope() {
        return this.parentScope;
    }

    public final boolean getWaitForStop() {
        return this.waitForStop;
    }

    public final long getEventTimestamp$dd_sdk_android_release() {
        return this.eventTimestamp;
    }

    @NotNull
    public final String getActionId$dd_sdk_android_release() {
        return this.actionId;
    }

    @NotNull
    public final RumActionType getType$dd_sdk_android_release() {
        return this.type;
    }

    public final void setType$dd_sdk_android_release(@NotNull RumActionType rumActionType) {
        Intrinsics.checkNotNullParameter((Object)((Object)rumActionType), (String)"<set-?>");
        this.type = rumActionType;
    }

    @NotNull
    public final String getName$dd_sdk_android_release() {
        return this.name;
    }

    public final void setName$dd_sdk_android_release(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.name = string;
    }

    @NotNull
    public final Map<String, Object> getAttributes$dd_sdk_android_release() {
        return this.attributes;
    }

    public final long getResourceCount$dd_sdk_android_release() {
        return this.resourceCount;
    }

    public final void setResourceCount$dd_sdk_android_release(long l) {
        this.resourceCount = l;
    }

    public final long getErrorCount$dd_sdk_android_release() {
        return this.errorCount;
    }

    public final void setErrorCount$dd_sdk_android_release(long l) {
        this.errorCount = l;
    }

    public final long getCrashCount$dd_sdk_android_release() {
        return this.crashCount;
    }

    public final void setCrashCount$dd_sdk_android_release(long l) {
        this.crashCount = l;
    }

    public final long getLongTaskCount$dd_sdk_android_release() {
        return this.longTaskCount;
    }

    public final void setLongTaskCount$dd_sdk_android_release(long l) {
        this.longTaskCount = l;
    }

    public final boolean getStopped$dd_sdk_android_release() {
        return this.stopped;
    }

    public final void setStopped$dd_sdk_android_release(boolean bl) {
        this.stopped = bl;
    }

    @Override
    @WorkerThread
    @Nullable
    public RumScope handleEvent(@NotNull RumRawEvent event, @NotNull DataWriter<Object> writer) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter(writer, (String)"writer");
        long now = event.getEventTime().getNanoTime();
        boolean isInactive = now - this.lastInteractionNanos > this.inactivityThresholdNs;
        boolean isLongDuration = now - this.startedNanos > this.maxDurationNs;
        CollectionsKt.removeAll(this.ongoingResourceKeys, (Function1)handleEvent.1.INSTANCE);
        boolean isOngoing = this.waitForStop && !this.stopped;
        boolean shouldStop = isInactive && this.ongoingResourceKeys.isEmpty() && !isOngoing;
        if (shouldStop) {
            this.sendAction(this.lastInteractionNanos, writer);
        } else if (isLongDuration) {
            this.sendAction(now, writer);
        } else if (event instanceof RumRawEvent.SendCustomActionNow) {
            this.sendAction(this.lastInteractionNanos, writer);
        } else if (event instanceof RumRawEvent.StartView) {
            this.onStartView(now, writer);
        } else if (event instanceof RumRawEvent.StopView) {
            this.onStopView(now, writer);
        } else if (event instanceof RumRawEvent.StopAction) {
            this.onStopAction((RumRawEvent.StopAction)event, now);
        } else if (event instanceof RumRawEvent.StartResource) {
            this.onStartResource((RumRawEvent.StartResource)event, now);
        } else if (event instanceof RumRawEvent.StopResource) {
            this.onStopResource((RumRawEvent.StopResource)event, now);
        } else if (event instanceof RumRawEvent.AddError) {
            this.onError((RumRawEvent.AddError)event, now, writer);
        } else if (event instanceof RumRawEvent.StopResourceWithError) {
            this.onResourceError(((RumRawEvent.StopResourceWithError)event).getKey(), now);
        } else if (event instanceof RumRawEvent.StopResourceWithStackTrace) {
            this.onResourceError(((RumRawEvent.StopResourceWithStackTrace)event).getKey(), now);
        } else if (event instanceof RumRawEvent.AddLongTask) {
            this.onLongTask(now);
        }
        return this.sent ? null : (RumScope)this;
    }

    @Override
    @NotNull
    public RumContext getRumContext() {
        return this.parentScope.getRumContext();
    }

    @Override
    public boolean isActive() {
        return !this.stopped;
    }

    @WorkerThread
    private final void onStartView(long now, DataWriter<Object> writer) {
        this.ongoingResourceKeys.clear();
        this.sendAction(now, writer);
    }

    @WorkerThread
    private final void onStopView(long now, DataWriter<Object> writer) {
        this.ongoingResourceKeys.clear();
        this.sendAction(now, writer);
    }

    private final void onStopAction(RumRawEvent.StopAction event, long now) {
        Object it;
        RumActionType rumActionType = event.getType();
        if (rumActionType != null) {
            it = rumActionType;
            boolean bl = false;
            this.setType$dd_sdk_android_release((RumActionType)((Object)it));
        }
        String string = event.getName();
        if (string != null) {
            it = string;
            boolean bl = false;
            this.setName$dd_sdk_android_release((String)it);
        }
        this.attributes.putAll(event.getAttributes());
        this.stopped = true;
        this.lastInteractionNanos = now;
    }

    private final void onStartResource(RumRawEvent.StartResource event, long now) {
        this.lastInteractionNanos = now;
        long l = this.resourceCount;
        this.resourceCount = l + 1L;
        this.ongoingResourceKeys.add(new WeakReference<String>(event.getKey()));
    }

    private final void onStopResource(RumRawEvent.StopResource event, long now) {
        Object v0;
        block2: {
            Iterable $this$firstOrNull$iv = this.ongoingResourceKeys;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                WeakReference it = (WeakReference)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual(it.get(), (Object)event.getKey())) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        WeakReference keyRef = v0;
        if (keyRef != null) {
            this.ongoingResourceKeys.remove(keyRef);
            this.lastInteractionNanos = now;
        }
    }

    @WorkerThread
    private final void onError(RumRawEvent.AddError event, long now, DataWriter<Object> writer) {
        this.lastInteractionNanos = now;
        long l = this.errorCount;
        this.errorCount = l + 1L;
        if (event.isFatal()) {
            l = this.crashCount;
            this.crashCount = l + 1L;
            this.sendAction(now, writer);
        }
    }

    private final void onResourceError(String eventKey, long now) {
        Object v0;
        block2: {
            Iterable $this$firstOrNull$iv = this.ongoingResourceKeys;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                WeakReference it = (WeakReference)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual(it.get(), (Object)eventKey)) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        WeakReference keyRef = v0;
        if (keyRef != null) {
            this.ongoingResourceKeys.remove(keyRef);
            this.lastInteractionNanos = now;
            long l = this.resourceCount;
            this.resourceCount = l + -1L;
            l = this.errorCount;
            this.errorCount = l + 1L;
        }
    }

    private final void onLongTask(long now) {
        this.lastInteractionNanos = now;
        long l = this.longTaskCount;
        this.longTaskCount = l + 1L;
    }

    private final void sendAction(long endNanos, DataWriter<Object> writer) {
        if (this.sent) {
            return;
        }
        RumActionType actualType = this.type;
        this.attributes.putAll(GlobalRum.INSTANCE.getGlobalAttributes$dd_sdk_android_release());
        RumContext rumContext = this.getRumContext();
        String eventName = this.name;
        long eventErrorCount = this.errorCount;
        long eventCrashCount = this.crashCount;
        long eventLongTaskCount = this.longTaskCount;
        long eventResourceCount = this.resourceCount;
        FeatureScope featureScope = this.sdkCore.getFeature("rum");
        if (featureScope != null) {
            FeatureScope.DefaultImpls.withWriteContext$default(featureScope, false, (Function2)new Function2<DatadogContext, EventBatchWriter, Unit>(this, eventErrorCount, actualType, eventName, eventCrashCount, eventLongTaskCount, eventResourceCount, endNanos, rumContext, writer){
                final /* synthetic */ RumActionScope this$0;
                final /* synthetic */ long $eventErrorCount;
                final /* synthetic */ RumActionType $actualType;
                final /* synthetic */ String $eventName;
                final /* synthetic */ long $eventCrashCount;
                final /* synthetic */ long $eventLongTaskCount;
                final /* synthetic */ long $eventResourceCount;
                final /* synthetic */ long $endNanos;
                final /* synthetic */ RumContext $rumContext;
                final /* synthetic */ DataWriter<Object> $writer;
                {
                    this.this$0 = $receiver;
                    this.$eventErrorCount = $eventErrorCount;
                    this.$actualType = $actualType;
                    this.$eventName = $eventName;
                    this.$eventCrashCount = $eventCrashCount;
                    this.$eventLongTaskCount = $eventLongTaskCount;
                    this.$eventResourceCount = $eventResourceCount;
                    this.$endNanos = $endNanos;
                    this.$rumContext = $rumContext;
                    this.$writer = $writer;
                    super(2);
                }

                public final void invoke(@NotNull DatadogContext datadogContext, @NotNull EventBatchWriter eventBatchWriter) {
                    Intrinsics.checkNotNullParameter((Object)datadogContext, (String)"datadogContext");
                    Intrinsics.checkNotNullParameter((Object)eventBatchWriter, (String)"eventBatchWriter");
                    UserInfo user = datadogContext.getUserInfo();
                    boolean hasReplay = RumActionScope.access$getFeaturesContextResolver$p(this.this$0).resolveHasReplay(datadogContext);
                    List frustrations = new ArrayList<E>();
                    if (RumActionScope.access$getTrackFrustrations$p(this.this$0) && this.$eventErrorCount > 0L && this.$actualType == RumActionType.TAP) {
                        frustrations.add(ActionEvent.Type.ERROR_TAP);
                    }
                    long l = this.this$0.getEventTimestamp$dd_sdk_android_release();
                    Object object = RumEventExtKt.toSchemaType(this.$actualType);
                    Object object2 = this.this$0.getActionId$dd_sdk_android_release();
                    Object object3 = new ActionEvent.ActionEventActionTarget(this.$eventName);
                    Object object4 = new ActionEvent.Error(this.$eventErrorCount);
                    Object object5 = new ActionEvent.Crash(this.$eventCrashCount);
                    Object object6 = new ActionEvent.LongTask(this.$eventLongTaskCount);
                    Object object7 = new ActionEvent.Resource(this.$eventResourceCount);
                    long l2 = Math.max(this.$endNanos - RumActionScope.access$getStartedNanos$p(this.this$0), 1L);
                    Object object8 = !((Collection)frustrations).isEmpty() ? new ActionEvent.Frustration(frustrations) : (ActionEvent.Frustration)null;
                    ActionEvent.ActionEventAction actionEventAction = new ActionEvent.ActionEventAction((ActionEvent.ActionEventActionType)((Object)object), (String)object2, l2, (ActionEvent.ActionEventActionTarget)object3, (ActionEvent.Frustration)object8, (ActionEvent.Error)object4, (ActionEvent.Crash)object5, (ActionEvent.LongTask)object6, (ActionEvent.Resource)object7);
                    String string = this.$rumContext.getViewId();
                    if (string == null) {
                        string = "";
                    }
                    object2 = string;
                    object3 = this.$rumContext.getViewName();
                    String string2 = this.$rumContext.getViewUrl();
                    if (string2 == null) {
                        string2 = "";
                    }
                    object4 = string2;
                    object = new ActionEvent.View((String)object2, null, (String)object4, (String)object3, null, 18, null);
                    object2 = new ActionEvent.Application(this.$rumContext.getApplicationId());
                    object3 = new ActionEvent.ActionEventSession(this.$rumContext.getSessionId(), ActionEvent.ActionEventSessionType.USER, hasReplay);
                    object4 = RumEventExtKt.tryFromSource(ActionEvent.Source.Companion, datadogContext.getSource());
                    object5 = user.hasUserData$dd_sdk_android_release() ? new ActionEvent.Usr(user.getId(), user.getName(), user.getEmail(), MapsKt.toMutableMap(user.getAdditionalProperties())) : (ActionEvent.Usr)null;
                    object6 = new ActionEvent.Os(datadogContext.getDeviceInfo().getOsName(), datadogContext.getDeviceInfo().getOsVersion(), datadogContext.getDeviceInfo().getOsMajorVersion());
                    object7 = new ActionEvent.Device(RumEventExtKt.toActionSchemaType(datadogContext.getDeviceInfo().getDeviceType()), datadogContext.getDeviceInfo().getDeviceName(), datadogContext.getDeviceInfo().getDeviceModel(), datadogContext.getDeviceInfo().getDeviceBrand(), datadogContext.getDeviceInfo().getArchitecture());
                    ActionEvent.Context context = new ActionEvent.Context(this.this$0.getAttributes$dd_sdk_android_release());
                    ActionEvent.Dd dd = new ActionEvent.Dd(new ActionEvent.DdSession(ActionEvent.Plan.PLAN_1), null, null, 6, null);
                    object8 = RumEventExtKt.toActionConnectivity(RumActionScope.access$getNetworkInfo$p(this.this$0));
                    String string3 = datadogContext.getService();
                    String string4 = datadogContext.getVersion();
                    ActionEvent actionEvent = new ActionEvent(l, (ActionEvent.Application)object2, string3, string4, (ActionEvent.ActionEventSession)object3, (ActionEvent.Source)((Object)object4), (ActionEvent.View)object, (ActionEvent.Usr)object5, (ActionEvent.Connectivity)object8, null, null, null, (ActionEvent.Os)object6, (ActionEvent.Device)object7, dd, context, actionEventAction, 3584, null);
                    this.$writer.write(eventBatchWriter, actionEvent);
                }
            }, 1, null);
        }
        this.sent = true;
    }

    public static final /* synthetic */ FeaturesContextResolver access$getFeaturesContextResolver$p(RumActionScope $this) {
        return $this.featuresContextResolver;
    }

    public static final /* synthetic */ boolean access$getTrackFrustrations$p(RumActionScope $this) {
        return $this.trackFrustrations;
    }

    public static final /* synthetic */ long access$getStartedNanos$p(RumActionScope $this) {
        return $this.startedNanos;
    }

    public static final /* synthetic */ NetworkInfo access$getNetworkInfo$p(RumActionScope $this) {
        return $this.networkInfo;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J>\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/datadog/android/rum/internal/domain/scope/RumActionScope$Companion;", "", "()V", "ACTION_INACTIVITY_MS", "", "ACTION_MAX_DURATION_MS", "fromEvent", "Lcom/datadog/android/rum/internal/domain/scope/RumScope;", "parentScope", "sdkCore", "Lcom/datadog/android/v2/api/SdkCore;", "event", "Lcom/datadog/android/rum/internal/domain/scope/RumRawEvent$StartAction;", "timestampOffset", "contextProvider", "Lcom/datadog/android/v2/core/internal/ContextProvider;", "featuresContextResolver", "Lcom/datadog/android/rum/internal/FeaturesContextResolver;", "trackFrustrations", "", "dd-sdk-android_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final RumScope fromEvent(@NotNull RumScope parentScope, @NotNull SdkCore sdkCore, @NotNull RumRawEvent.StartAction event, long timestampOffset, @NotNull ContextProvider contextProvider, @NotNull FeaturesContextResolver featuresContextResolver, boolean trackFrustrations2) {
            Intrinsics.checkNotNullParameter((Object)parentScope, (String)"parentScope");
            Intrinsics.checkNotNullParameter((Object)sdkCore, (String)"sdkCore");
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Intrinsics.checkNotNullParameter((Object)contextProvider, (String)"contextProvider");
            Intrinsics.checkNotNullParameter((Object)featuresContextResolver, (String)"featuresContextResolver");
            return new RumActionScope(parentScope, sdkCore, event.getWaitForStop(), event.getEventTime(), event.getType(), event.getName(), event.getAttributes(), timestampOffset, 0L, 0L, contextProvider, featuresContextResolver, trackFrustrations2, 768, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

