/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.rum.internal.domain.scope;

import com.datadog.android.core.internal.utils.RuntimeUtilsKt;
import com.datadog.android.rum.RumActionType;
import com.datadog.android.rum.RumErrorSource;
import com.datadog.android.rum.RumResourceKind;
import com.datadog.android.rum.internal.RumErrorSourceType;
import com.datadog.android.rum.internal.domain.event.ResourceTiming;
import com.datadog.android.rum.model.ActionEvent;
import com.datadog.android.rum.model.ErrorEvent;
import com.datadog.android.rum.model.LongTaskEvent;
import com.datadog.android.rum.model.ResourceEvent;
import com.datadog.android.rum.model.ViewEvent;
import com.datadog.android.v2.api.InternalLogger;
import com.datadog.android.v2.api.context.DeviceType;
import com.datadog.android.v2.api.context.NetworkInfo;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\u00d2\u0001\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0002\u001a\u0004\u0018\u00010\u0003*\u00020\u0004H\u0000\u001a\u000e\u0010\u0005\u001a\u0004\u0018\u00010\u0006*\u00020\u0004H\u0000\u001a\u000e\u0010\u0007\u001a\u0004\u0018\u00010\b*\u00020\u0004H\u0000\u001a\u000e\u0010\t\u001a\u0004\u0018\u00010\n*\u00020\u0004H\u0000\u001a\f\u0010\u000b\u001a\u00020\f*\u00020\rH\u0000\u001a\u000e\u0010\u000e\u001a\u0004\u0018\u00010\u000f*\u00020\u0004H\u0000\u001a\f\u0010\u0010\u001a\u00020\u0011*\u00020\rH\u0000\u001a\f\u0010\u0012\u001a\u00020\u0013*\u00020\u0014H\u0000\u001a\f\u0010\u0015\u001a\u00020\u0016*\u00020\rH\u0000\u001a\f\u0010\u0017\u001a\u00020\u0018*\u00020\u0001H\u0000\u001a\f\u0010\u0019\u001a\u00020\u001a*\u00020\u0014H\u0000\u001a\f\u0010\u001b\u001a\u00020\u001c*\u00020\rH\u0000\u001a\f\u0010\u001d\u001a\u00020\u001e*\u00020\u0014H\u0000\u001a\f\u0010\u001f\u001a\u00020 *\u00020\u0001H\u0000\u001a\f\u0010!\u001a\u00020\"*\u00020\rH\u0000\u001a\f\u0010#\u001a\u00020$*\u00020\u0014H\u0000\u001a\f\u0010%\u001a\u00020&*\u00020'H\u0000\u001a\f\u0010(\u001a\u00020)*\u00020*H\u0000\u001a\f\u0010+\u001a\u00020,*\u00020-H\u0000\u001a\f\u0010+\u001a\u00020.*\u00020/H\u0000\u001a\f\u00100\u001a\u000201*\u00020\rH\u0000\u001a\f\u00102\u001a\u000203*\u00020\u0014H\u0000\u001a\u0016\u00104\u001a\u0004\u0018\u000105*\u0002062\u0006\u00107\u001a\u00020\u0001H\u0000\u001a\u0016\u00104\u001a\u0004\u0018\u000108*\u0002092\u0006\u00107\u001a\u00020\u0001H\u0000\u001a\u0016\u00104\u001a\u0004\u0018\u00010:*\u00020;2\u0006\u00107\u001a\u00020\u0001H\u0000\u001a\u0016\u00104\u001a\u0004\u0018\u00010<*\u00020=2\u0006\u00107\u001a\u00020\u0001H\u0000\u001a\u0016\u00104\u001a\u0004\u0018\u00010>*\u00020?2\u0006\u00107\u001a\u00020\u0001H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006@"}, d2={"UNKNOWN_SOURCE_WARNING_MESSAGE_FORMAT", "", "connect", "Lcom/datadog/android/rum/model/ResourceEvent$Connect;", "Lcom/datadog/android/rum/internal/domain/event/ResourceTiming;", "dns", "Lcom/datadog/android/rum/model/ResourceEvent$Dns;", "download", "Lcom/datadog/android/rum/model/ResourceEvent$Download;", "firstByte", "Lcom/datadog/android/rum/model/ResourceEvent$FirstByte;", "isConnected", "", "Lcom/datadog/android/v2/api/context/NetworkInfo;", "ssl", "Lcom/datadog/android/rum/model/ResourceEvent$Ssl;", "toActionConnectivity", "Lcom/datadog/android/rum/model/ActionEvent$Connectivity;", "toActionSchemaType", "Lcom/datadog/android/rum/model/ActionEvent$DeviceType;", "Lcom/datadog/android/v2/api/context/DeviceType;", "toErrorConnectivity", "Lcom/datadog/android/rum/model/ErrorEvent$Connectivity;", "toErrorMethod", "Lcom/datadog/android/rum/model/ErrorEvent$Method;", "toErrorSchemaType", "Lcom/datadog/android/rum/model/ErrorEvent$DeviceType;", "toLongTaskConnectivity", "Lcom/datadog/android/rum/model/LongTaskEvent$Connectivity;", "toLongTaskSchemaType", "Lcom/datadog/android/rum/model/LongTaskEvent$DeviceType;", "toMethod", "Lcom/datadog/android/rum/model/ResourceEvent$Method;", "toResourceConnectivity", "Lcom/datadog/android/rum/model/ResourceEvent$Connectivity;", "toResourceSchemaType", "Lcom/datadog/android/rum/model/ResourceEvent$DeviceType;", "toSchemaSource", "Lcom/datadog/android/rum/model/ErrorEvent$ErrorSource;", "Lcom/datadog/android/rum/RumErrorSource;", "toSchemaSourceType", "Lcom/datadog/android/rum/model/ErrorEvent$SourceType;", "Lcom/datadog/android/rum/internal/RumErrorSourceType;", "toSchemaType", "Lcom/datadog/android/rum/model/ActionEvent$ActionEventActionType;", "Lcom/datadog/android/rum/RumActionType;", "Lcom/datadog/android/rum/model/ResourceEvent$ResourceType;", "Lcom/datadog/android/rum/RumResourceKind;", "toViewConnectivity", "Lcom/datadog/android/rum/model/ViewEvent$Connectivity;", "toViewSchemaType", "Lcom/datadog/android/rum/model/ViewEvent$DeviceType;", "tryFromSource", "Lcom/datadog/android/rum/model/ActionEvent$Source;", "Lcom/datadog/android/rum/model/ActionEvent$Source$Companion;", "source", "Lcom/datadog/android/rum/model/ErrorEvent$ErrorEventSource;", "Lcom/datadog/android/rum/model/ErrorEvent$ErrorEventSource$Companion;", "Lcom/datadog/android/rum/model/LongTaskEvent$Source;", "Lcom/datadog/android/rum/model/LongTaskEvent$Source$Companion;", "Lcom/datadog/android/rum/model/ResourceEvent$Source;", "Lcom/datadog/android/rum/model/ResourceEvent$Source$Companion;", "Lcom/datadog/android/rum/model/ViewEvent$Source;", "Lcom/datadog/android/rum/model/ViewEvent$Source$Companion;", "dd-sdk-android_release"})
public final class RumEventExtKt {
    @NotNull
    public static final String UNKNOWN_SOURCE_WARNING_MESSAGE_FORMAT = "You are using an unknown source %s for your events";

    @NotNull
    public static final ResourceEvent.Method toMethod(@NotNull String $this$toMethod) {
        ResourceEvent.Method method;
        Intrinsics.checkNotNullParameter((Object)$this$toMethod, (String)"<this>");
        try {
            Locale locale = Locale.US;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
            String string = $this$toMethod.toUpperCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toUpperCase(locale)");
            method = ResourceEvent.Method.valueOf(string);
        }
        catch (IllegalArgumentException e) {
            InternalLogger.Target[] targetArray = new InternalLogger.Target[]{InternalLogger.Target.MAINTAINER, InternalLogger.Target.TELEMETRY};
            RuntimeUtilsKt.getInternalLogger().log(InternalLogger.Level.ERROR, CollectionsKt.listOf((Object[])targetArray), "Unable to convert [" + $this$toMethod + "] to a valid http method", (Throwable)e);
            method = ResourceEvent.Method.GET;
        }
        return method;
    }

    @NotNull
    public static final ErrorEvent.Method toErrorMethod(@NotNull String $this$toErrorMethod) {
        ErrorEvent.Method method;
        Intrinsics.checkNotNullParameter((Object)$this$toErrorMethod, (String)"<this>");
        try {
            Locale locale = Locale.US;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
            String string = $this$toErrorMethod.toUpperCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toUpperCase(locale)");
            method = ErrorEvent.Method.valueOf(string);
        }
        catch (IllegalArgumentException e) {
            InternalLogger.Target[] targetArray = new InternalLogger.Target[]{InternalLogger.Target.MAINTAINER, InternalLogger.Target.TELEMETRY};
            RuntimeUtilsKt.getInternalLogger().log(InternalLogger.Level.ERROR, CollectionsKt.listOf((Object[])targetArray), "Unable to convert [" + $this$toErrorMethod + "] to a valid http method", (Throwable)e);
            method = ErrorEvent.Method.GET;
        }
        return method;
    }

    @NotNull
    public static final ResourceEvent.ResourceType toSchemaType(@NotNull RumResourceKind $this$toSchemaType) {
        ResourceEvent.ResourceType resourceType;
        Intrinsics.checkNotNullParameter((Object)((Object)$this$toSchemaType), (String)"<this>");
        switch (WhenMappings.$EnumSwitchMapping$0[$this$toSchemaType.ordinal()]) {
            case 1: {
                resourceType = ResourceEvent.ResourceType.BEACON;
                break;
            }
            case 2: {
                resourceType = ResourceEvent.ResourceType.FETCH;
                break;
            }
            case 3: {
                resourceType = ResourceEvent.ResourceType.XHR;
                break;
            }
            case 4: {
                resourceType = ResourceEvent.ResourceType.DOCUMENT;
                break;
            }
            case 5: {
                resourceType = ResourceEvent.ResourceType.IMAGE;
                break;
            }
            case 6: {
                resourceType = ResourceEvent.ResourceType.JS;
                break;
            }
            case 7: {
                resourceType = ResourceEvent.ResourceType.FONT;
                break;
            }
            case 8: {
                resourceType = ResourceEvent.ResourceType.CSS;
                break;
            }
            case 9: {
                resourceType = ResourceEvent.ResourceType.MEDIA;
                break;
            }
            case 10: {
                resourceType = ResourceEvent.ResourceType.NATIVE;
                break;
            }
            case 11: 
            case 12: {
                resourceType = ResourceEvent.ResourceType.OTHER;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return resourceType;
    }

    @NotNull
    public static final ErrorEvent.ErrorSource toSchemaSource(@NotNull RumErrorSource $this$toSchemaSource) {
        ErrorEvent.ErrorSource errorSource;
        Intrinsics.checkNotNullParameter((Object)((Object)$this$toSchemaSource), (String)"<this>");
        switch (WhenMappings.$EnumSwitchMapping$1[$this$toSchemaSource.ordinal()]) {
            case 1: {
                errorSource = ErrorEvent.ErrorSource.NETWORK;
                break;
            }
            case 2: {
                errorSource = ErrorEvent.ErrorSource.SOURCE;
                break;
            }
            case 3: {
                errorSource = ErrorEvent.ErrorSource.CONSOLE;
                break;
            }
            case 4: {
                errorSource = ErrorEvent.ErrorSource.LOGGER;
                break;
            }
            case 5: {
                errorSource = ErrorEvent.ErrorSource.AGENT;
                break;
            }
            case 6: {
                errorSource = ErrorEvent.ErrorSource.WEBVIEW;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return errorSource;
    }

    @NotNull
    public static final ErrorEvent.SourceType toSchemaSourceType(@NotNull RumErrorSourceType $this$toSchemaSourceType) {
        ErrorEvent.SourceType sourceType;
        Intrinsics.checkNotNullParameter((Object)((Object)$this$toSchemaSourceType), (String)"<this>");
        switch (WhenMappings.$EnumSwitchMapping$2[$this$toSchemaSourceType.ordinal()]) {
            case 1: {
                sourceType = ErrorEvent.SourceType.ANDROID;
                break;
            }
            case 2: {
                sourceType = ErrorEvent.SourceType.BROWSER;
                break;
            }
            case 3: {
                sourceType = ErrorEvent.SourceType.REACT_NATIVE;
                break;
            }
            case 4: {
                sourceType = ErrorEvent.SourceType.FLUTTER;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return sourceType;
    }

    @Nullable
    public static final ResourceEvent.Dns dns(@NotNull ResourceTiming $this$dns) {
        Intrinsics.checkNotNullParameter((Object)$this$dns, (String)"<this>");
        return $this$dns.getDnsStart() > 0L ? new ResourceEvent.Dns($this$dns.getDnsDuration(), $this$dns.getDnsStart()) : (ResourceEvent.Dns)null;
    }

    @Nullable
    public static final ResourceEvent.Connect connect(@NotNull ResourceTiming $this$connect) {
        Intrinsics.checkNotNullParameter((Object)$this$connect, (String)"<this>");
        return $this$connect.getConnectStart() > 0L ? new ResourceEvent.Connect($this$connect.getConnectDuration(), $this$connect.getConnectStart()) : (ResourceEvent.Connect)null;
    }

    @Nullable
    public static final ResourceEvent.Ssl ssl(@NotNull ResourceTiming $this$ssl) {
        Intrinsics.checkNotNullParameter((Object)$this$ssl, (String)"<this>");
        return $this$ssl.getSslStart() > 0L ? new ResourceEvent.Ssl($this$ssl.getSslDuration(), $this$ssl.getSslStart()) : (ResourceEvent.Ssl)null;
    }

    @Nullable
    public static final ResourceEvent.FirstByte firstByte(@NotNull ResourceTiming $this$firstByte) {
        Intrinsics.checkNotNullParameter((Object)$this$firstByte, (String)"<this>");
        return $this$firstByte.getFirstByteStart() >= 0L && $this$firstByte.getFirstByteDuration() > 0L ? new ResourceEvent.FirstByte($this$firstByte.getFirstByteDuration(), $this$firstByte.getFirstByteStart()) : (ResourceEvent.FirstByte)null;
    }

    @Nullable
    public static final ResourceEvent.Download download(@NotNull ResourceTiming $this$download) {
        Intrinsics.checkNotNullParameter((Object)$this$download, (String)"<this>");
        return $this$download.getDownloadStart() > 0L ? new ResourceEvent.Download($this$download.getDownloadDuration(), $this$download.getDownloadStart()) : (ResourceEvent.Download)null;
    }

    @NotNull
    public static final ActionEvent.ActionEventActionType toSchemaType(@NotNull RumActionType $this$toSchemaType) {
        ActionEvent.ActionEventActionType actionEventActionType;
        Intrinsics.checkNotNullParameter((Object)((Object)$this$toSchemaType), (String)"<this>");
        switch (WhenMappings.$EnumSwitchMapping$3[$this$toSchemaType.ordinal()]) {
            case 1: {
                actionEventActionType = ActionEvent.ActionEventActionType.TAP;
                break;
            }
            case 2: {
                actionEventActionType = ActionEvent.ActionEventActionType.SCROLL;
                break;
            }
            case 3: {
                actionEventActionType = ActionEvent.ActionEventActionType.SWIPE;
                break;
            }
            case 4: {
                actionEventActionType = ActionEvent.ActionEventActionType.CLICK;
                break;
            }
            case 5: {
                actionEventActionType = ActionEvent.ActionEventActionType.BACK;
                break;
            }
            case 6: {
                actionEventActionType = ActionEvent.ActionEventActionType.CUSTOM;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return actionEventActionType;
    }

    @NotNull
    public static final ResourceEvent.Connectivity toResourceConnectivity(@NotNull NetworkInfo $this$toResourceConnectivity) {
        List list;
        Intrinsics.checkNotNullParameter((Object)$this$toResourceConnectivity, (String)"<this>");
        ResourceEvent.Status status = RumEventExtKt.isConnected($this$toResourceConnectivity) ? ResourceEvent.Status.CONNECTED : ResourceEvent.Status.NOT_CONNECTED;
        switch (WhenMappings.$EnumSwitchMapping$4[$this$toResourceConnectivity.getConnectivity().ordinal()]) {
            case 1: {
                list = CollectionsKt.listOf((Object)((Object)ResourceEvent.Interface.ETHERNET));
                break;
            }
            case 2: {
                list = CollectionsKt.listOf((Object)((Object)ResourceEvent.Interface.WIFI));
                break;
            }
            case 3: {
                list = CollectionsKt.listOf((Object)((Object)ResourceEvent.Interface.WIMAX));
                break;
            }
            case 4: {
                list = CollectionsKt.listOf((Object)((Object)ResourceEvent.Interface.BLUETOOTH));
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                list = CollectionsKt.listOf((Object)((Object)ResourceEvent.Interface.CELLULAR));
                break;
            }
            case 11: {
                list = CollectionsKt.listOf((Object)((Object)ResourceEvent.Interface.OTHER));
                break;
            }
            case 12: {
                list = CollectionsKt.emptyList();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        List interfaces = list;
        ResourceEvent.Cellular cellular = $this$toResourceConnectivity.getCellularTechnology() != null || $this$toResourceConnectivity.getCarrierName() != null ? new ResourceEvent.Cellular($this$toResourceConnectivity.getCellularTechnology(), $this$toResourceConnectivity.getCarrierName()) : (ResourceEvent.Cellular)null;
        return new ResourceEvent.Connectivity(status, interfaces, cellular);
    }

    @NotNull
    public static final ErrorEvent.Connectivity toErrorConnectivity(@NotNull NetworkInfo $this$toErrorConnectivity) {
        List list;
        Intrinsics.checkNotNullParameter((Object)$this$toErrorConnectivity, (String)"<this>");
        ErrorEvent.Status status = RumEventExtKt.isConnected($this$toErrorConnectivity) ? ErrorEvent.Status.CONNECTED : ErrorEvent.Status.NOT_CONNECTED;
        switch (WhenMappings.$EnumSwitchMapping$4[$this$toErrorConnectivity.getConnectivity().ordinal()]) {
            case 1: {
                list = CollectionsKt.listOf((Object)((Object)ErrorEvent.Interface.ETHERNET));
                break;
            }
            case 2: {
                list = CollectionsKt.listOf((Object)((Object)ErrorEvent.Interface.WIFI));
                break;
            }
            case 3: {
                list = CollectionsKt.listOf((Object)((Object)ErrorEvent.Interface.WIMAX));
                break;
            }
            case 4: {
                list = CollectionsKt.listOf((Object)((Object)ErrorEvent.Interface.BLUETOOTH));
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                list = CollectionsKt.listOf((Object)((Object)ErrorEvent.Interface.CELLULAR));
                break;
            }
            case 11: {
                list = CollectionsKt.listOf((Object)((Object)ErrorEvent.Interface.OTHER));
                break;
            }
            case 12: {
                list = CollectionsKt.emptyList();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        List interfaces = list;
        ErrorEvent.Cellular cellular = $this$toErrorConnectivity.getCellularTechnology() != null || $this$toErrorConnectivity.getCarrierName() != null ? new ErrorEvent.Cellular($this$toErrorConnectivity.getCellularTechnology(), $this$toErrorConnectivity.getCarrierName()) : (ErrorEvent.Cellular)null;
        return new ErrorEvent.Connectivity(status, interfaces, cellular);
    }

    @NotNull
    public static final LongTaskEvent.Connectivity toLongTaskConnectivity(@NotNull NetworkInfo $this$toLongTaskConnectivity) {
        List list;
        Intrinsics.checkNotNullParameter((Object)$this$toLongTaskConnectivity, (String)"<this>");
        LongTaskEvent.Status status = RumEventExtKt.isConnected($this$toLongTaskConnectivity) ? LongTaskEvent.Status.CONNECTED : LongTaskEvent.Status.NOT_CONNECTED;
        switch (WhenMappings.$EnumSwitchMapping$4[$this$toLongTaskConnectivity.getConnectivity().ordinal()]) {
            case 1: {
                list = CollectionsKt.listOf((Object)((Object)LongTaskEvent.Interface.ETHERNET));
                break;
            }
            case 2: {
                list = CollectionsKt.listOf((Object)((Object)LongTaskEvent.Interface.WIFI));
                break;
            }
            case 3: {
                list = CollectionsKt.listOf((Object)((Object)LongTaskEvent.Interface.WIMAX));
                break;
            }
            case 4: {
                list = CollectionsKt.listOf((Object)((Object)LongTaskEvent.Interface.BLUETOOTH));
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                list = CollectionsKt.listOf((Object)((Object)LongTaskEvent.Interface.CELLULAR));
                break;
            }
            case 11: {
                list = CollectionsKt.listOf((Object)((Object)LongTaskEvent.Interface.OTHER));
                break;
            }
            case 12: {
                list = CollectionsKt.emptyList();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        List interfaces = list;
        LongTaskEvent.Cellular cellular = $this$toLongTaskConnectivity.getCellularTechnology() != null || $this$toLongTaskConnectivity.getCarrierName() != null ? new LongTaskEvent.Cellular($this$toLongTaskConnectivity.getCellularTechnology(), $this$toLongTaskConnectivity.getCarrierName()) : (LongTaskEvent.Cellular)null;
        return new LongTaskEvent.Connectivity(status, interfaces, cellular);
    }

    @NotNull
    public static final ViewEvent.Connectivity toViewConnectivity(@NotNull NetworkInfo $this$toViewConnectivity) {
        List list;
        Intrinsics.checkNotNullParameter((Object)$this$toViewConnectivity, (String)"<this>");
        ViewEvent.Status status = RumEventExtKt.isConnected($this$toViewConnectivity) ? ViewEvent.Status.CONNECTED : ViewEvent.Status.NOT_CONNECTED;
        switch (WhenMappings.$EnumSwitchMapping$4[$this$toViewConnectivity.getConnectivity().ordinal()]) {
            case 1: {
                list = CollectionsKt.listOf((Object)((Object)ViewEvent.Interface.ETHERNET));
                break;
            }
            case 2: {
                list = CollectionsKt.listOf((Object)((Object)ViewEvent.Interface.WIFI));
                break;
            }
            case 3: {
                list = CollectionsKt.listOf((Object)((Object)ViewEvent.Interface.WIMAX));
                break;
            }
            case 4: {
                list = CollectionsKt.listOf((Object)((Object)ViewEvent.Interface.BLUETOOTH));
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                list = CollectionsKt.listOf((Object)((Object)ViewEvent.Interface.CELLULAR));
                break;
            }
            case 11: {
                list = CollectionsKt.listOf((Object)((Object)ViewEvent.Interface.OTHER));
                break;
            }
            case 12: {
                list = CollectionsKt.emptyList();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        List interfaces = list;
        ViewEvent.Cellular cellular = $this$toViewConnectivity.getCellularTechnology() != null || $this$toViewConnectivity.getCarrierName() != null ? new ViewEvent.Cellular($this$toViewConnectivity.getCellularTechnology(), $this$toViewConnectivity.getCarrierName()) : (ViewEvent.Cellular)null;
        return new ViewEvent.Connectivity(status, interfaces, cellular);
    }

    @NotNull
    public static final ActionEvent.Connectivity toActionConnectivity(@NotNull NetworkInfo $this$toActionConnectivity) {
        List list;
        Intrinsics.checkNotNullParameter((Object)$this$toActionConnectivity, (String)"<this>");
        ActionEvent.Status status = RumEventExtKt.isConnected($this$toActionConnectivity) ? ActionEvent.Status.CONNECTED : ActionEvent.Status.NOT_CONNECTED;
        switch (WhenMappings.$EnumSwitchMapping$4[$this$toActionConnectivity.getConnectivity().ordinal()]) {
            case 1: {
                list = CollectionsKt.listOf((Object)((Object)ActionEvent.Interface.ETHERNET));
                break;
            }
            case 2: {
                list = CollectionsKt.listOf((Object)((Object)ActionEvent.Interface.WIFI));
                break;
            }
            case 3: {
                list = CollectionsKt.listOf((Object)((Object)ActionEvent.Interface.WIMAX));
                break;
            }
            case 4: {
                list = CollectionsKt.listOf((Object)((Object)ActionEvent.Interface.BLUETOOTH));
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                list = CollectionsKt.listOf((Object)((Object)ActionEvent.Interface.CELLULAR));
                break;
            }
            case 11: {
                list = CollectionsKt.listOf((Object)((Object)ActionEvent.Interface.OTHER));
                break;
            }
            case 12: {
                list = CollectionsKt.emptyList();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        List interfaces = list;
        ActionEvent.Cellular cellular = $this$toActionConnectivity.getCellularTechnology() != null || $this$toActionConnectivity.getCarrierName() != null ? new ActionEvent.Cellular($this$toActionConnectivity.getCellularTechnology(), $this$toActionConnectivity.getCarrierName()) : (ActionEvent.Cellular)null;
        return new ActionEvent.Connectivity(status, interfaces, cellular);
    }

    public static final boolean isConnected(@NotNull NetworkInfo $this$isConnected) {
        Intrinsics.checkNotNullParameter((Object)$this$isConnected, (String)"<this>");
        return $this$isConnected.getConnectivity() != NetworkInfo.Connectivity.NETWORK_NOT_CONNECTED;
    }

    @NotNull
    public static final ViewEvent.DeviceType toViewSchemaType(@NotNull DeviceType $this$toViewSchemaType) {
        ViewEvent.DeviceType deviceType2;
        Intrinsics.checkNotNullParameter((Object)((Object)$this$toViewSchemaType), (String)"<this>");
        switch (WhenMappings.$EnumSwitchMapping$5[$this$toViewSchemaType.ordinal()]) {
            case 1: {
                deviceType2 = ViewEvent.DeviceType.MOBILE;
                break;
            }
            case 2: {
                deviceType2 = ViewEvent.DeviceType.TABLET;
                break;
            }
            case 3: {
                deviceType2 = ViewEvent.DeviceType.TV;
                break;
            }
            case 4: {
                deviceType2 = ViewEvent.DeviceType.DESKTOP;
                break;
            }
            default: {
                deviceType2 = ViewEvent.DeviceType.OTHER;
            }
        }
        return deviceType2;
    }

    @NotNull
    public static final ActionEvent.DeviceType toActionSchemaType(@NotNull DeviceType $this$toActionSchemaType) {
        ActionEvent.DeviceType deviceType2;
        Intrinsics.checkNotNullParameter((Object)((Object)$this$toActionSchemaType), (String)"<this>");
        switch (WhenMappings.$EnumSwitchMapping$5[$this$toActionSchemaType.ordinal()]) {
            case 1: {
                deviceType2 = ActionEvent.DeviceType.MOBILE;
                break;
            }
            case 2: {
                deviceType2 = ActionEvent.DeviceType.TABLET;
                break;
            }
            case 3: {
                deviceType2 = ActionEvent.DeviceType.TV;
                break;
            }
            case 4: {
                deviceType2 = ActionEvent.DeviceType.DESKTOP;
                break;
            }
            default: {
                deviceType2 = ActionEvent.DeviceType.OTHER;
            }
        }
        return deviceType2;
    }

    @NotNull
    public static final LongTaskEvent.DeviceType toLongTaskSchemaType(@NotNull DeviceType $this$toLongTaskSchemaType) {
        LongTaskEvent.DeviceType deviceType2;
        Intrinsics.checkNotNullParameter((Object)((Object)$this$toLongTaskSchemaType), (String)"<this>");
        switch (WhenMappings.$EnumSwitchMapping$5[$this$toLongTaskSchemaType.ordinal()]) {
            case 1: {
                deviceType2 = LongTaskEvent.DeviceType.MOBILE;
                break;
            }
            case 2: {
                deviceType2 = LongTaskEvent.DeviceType.TABLET;
                break;
            }
            case 3: {
                deviceType2 = LongTaskEvent.DeviceType.TV;
                break;
            }
            case 4: {
                deviceType2 = LongTaskEvent.DeviceType.DESKTOP;
                break;
            }
            default: {
                deviceType2 = LongTaskEvent.DeviceType.OTHER;
            }
        }
        return deviceType2;
    }

    @NotNull
    public static final ResourceEvent.DeviceType toResourceSchemaType(@NotNull DeviceType $this$toResourceSchemaType) {
        ResourceEvent.DeviceType deviceType2;
        Intrinsics.checkNotNullParameter((Object)((Object)$this$toResourceSchemaType), (String)"<this>");
        switch (WhenMappings.$EnumSwitchMapping$5[$this$toResourceSchemaType.ordinal()]) {
            case 1: {
                deviceType2 = ResourceEvent.DeviceType.MOBILE;
                break;
            }
            case 2: {
                deviceType2 = ResourceEvent.DeviceType.TABLET;
                break;
            }
            case 3: {
                deviceType2 = ResourceEvent.DeviceType.TV;
                break;
            }
            case 4: {
                deviceType2 = ResourceEvent.DeviceType.DESKTOP;
                break;
            }
            default: {
                deviceType2 = ResourceEvent.DeviceType.OTHER;
            }
        }
        return deviceType2;
    }

    @NotNull
    public static final ErrorEvent.DeviceType toErrorSchemaType(@NotNull DeviceType $this$toErrorSchemaType) {
        ErrorEvent.DeviceType deviceType2;
        Intrinsics.checkNotNullParameter((Object)((Object)$this$toErrorSchemaType), (String)"<this>");
        switch (WhenMappings.$EnumSwitchMapping$5[$this$toErrorSchemaType.ordinal()]) {
            case 1: {
                deviceType2 = ErrorEvent.DeviceType.MOBILE;
                break;
            }
            case 2: {
                deviceType2 = ErrorEvent.DeviceType.TABLET;
                break;
            }
            case 3: {
                deviceType2 = ErrorEvent.DeviceType.TV;
                break;
            }
            case 4: {
                deviceType2 = ErrorEvent.DeviceType.DESKTOP;
                break;
            }
            default: {
                deviceType2 = ErrorEvent.DeviceType.OTHER;
            }
        }
        return deviceType2;
    }

    @Nullable
    public static final ViewEvent.Source tryFromSource(@NotNull ViewEvent.Source.Companion $this$tryFromSource, @NotNull String source) {
        ViewEvent.Source source2;
        Intrinsics.checkNotNullParameter((Object)$this$tryFromSource, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        try {
            source2 = $this$tryFromSource.fromJson(source);
        }
        catch (NoSuchElementException e) {
            InternalLogger internalLogger = RuntimeUtilsKt.getInternalLogger();
            String string = UNKNOWN_SOURCE_WARNING_MESSAGE_FORMAT;
            Locale locale = Locale.US;
            Object[] objectArray = new Object[]{source};
            String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(locale, this, *args)");
            internalLogger.log(InternalLogger.Level.ERROR, InternalLogger.Target.USER, string2, (Throwable)e);
            source2 = null;
        }
        return source2;
    }

    @Nullable
    public static final LongTaskEvent.Source tryFromSource(@NotNull LongTaskEvent.Source.Companion $this$tryFromSource, @NotNull String source) {
        LongTaskEvent.Source source2;
        Intrinsics.checkNotNullParameter((Object)$this$tryFromSource, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        try {
            source2 = $this$tryFromSource.fromJson(source);
        }
        catch (NoSuchElementException e) {
            InternalLogger internalLogger = RuntimeUtilsKt.getInternalLogger();
            String string = UNKNOWN_SOURCE_WARNING_MESSAGE_FORMAT;
            Locale locale = Locale.US;
            Object[] objectArray = new Object[]{source};
            String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(locale, this, *args)");
            internalLogger.log(InternalLogger.Level.ERROR, InternalLogger.Target.USER, string2, (Throwable)e);
            source2 = null;
        }
        return source2;
    }

    @Nullable
    public static final ErrorEvent.ErrorEventSource tryFromSource(@NotNull ErrorEvent.ErrorEventSource.Companion $this$tryFromSource, @NotNull String source) {
        ErrorEvent.ErrorEventSource errorEventSource;
        Intrinsics.checkNotNullParameter((Object)$this$tryFromSource, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        try {
            errorEventSource = $this$tryFromSource.fromJson(source);
        }
        catch (NoSuchElementException e) {
            InternalLogger internalLogger = RuntimeUtilsKt.getInternalLogger();
            String string = UNKNOWN_SOURCE_WARNING_MESSAGE_FORMAT;
            Locale locale = Locale.US;
            Object[] objectArray = new Object[]{source};
            String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(locale, this, *args)");
            internalLogger.log(InternalLogger.Level.ERROR, InternalLogger.Target.USER, string2, (Throwable)e);
            errorEventSource = null;
        }
        return errorEventSource;
    }

    @Nullable
    public static final ActionEvent.Source tryFromSource(@NotNull ActionEvent.Source.Companion $this$tryFromSource, @NotNull String source) {
        ActionEvent.Source source2;
        Intrinsics.checkNotNullParameter((Object)$this$tryFromSource, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        try {
            source2 = $this$tryFromSource.fromJson(source);
        }
        catch (NoSuchElementException e) {
            InternalLogger internalLogger = RuntimeUtilsKt.getInternalLogger();
            String string = UNKNOWN_SOURCE_WARNING_MESSAGE_FORMAT;
            Locale locale = Locale.US;
            Object[] objectArray = new Object[]{source};
            String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(locale, this, *args)");
            internalLogger.log(InternalLogger.Level.ERROR, InternalLogger.Target.USER, string2, (Throwable)e);
            source2 = null;
        }
        return source2;
    }

    @Nullable
    public static final ResourceEvent.Source tryFromSource(@NotNull ResourceEvent.Source.Companion $this$tryFromSource, @NotNull String source) {
        ResourceEvent.Source source2;
        Intrinsics.checkNotNullParameter((Object)$this$tryFromSource, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        try {
            source2 = $this$tryFromSource.fromJson(source);
        }
        catch (NoSuchElementException e) {
            InternalLogger internalLogger = RuntimeUtilsKt.getInternalLogger();
            String string = UNKNOWN_SOURCE_WARNING_MESSAGE_FORMAT;
            Locale locale = Locale.US;
            Object[] objectArray = new Object[]{source};
            String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(locale, this, *args)");
            internalLogger.log(InternalLogger.Level.ERROR, InternalLogger.Target.USER, string2, (Throwable)e);
            source2 = null;
        }
        return source2;
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;
        public static final /* synthetic */ int[] $EnumSwitchMapping$2;
        public static final /* synthetic */ int[] $EnumSwitchMapping$3;
        public static final /* synthetic */ int[] $EnumSwitchMapping$4;
        public static final /* synthetic */ int[] $EnumSwitchMapping$5;

        static {
            int[] nArray = new int[RumResourceKind.values().length];
            nArray[RumResourceKind.BEACON.ordinal()] = 1;
            nArray[RumResourceKind.FETCH.ordinal()] = 2;
            nArray[RumResourceKind.XHR.ordinal()] = 3;
            nArray[RumResourceKind.DOCUMENT.ordinal()] = 4;
            nArray[RumResourceKind.IMAGE.ordinal()] = 5;
            nArray[RumResourceKind.JS.ordinal()] = 6;
            nArray[RumResourceKind.FONT.ordinal()] = 7;
            nArray[RumResourceKind.CSS.ordinal()] = 8;
            nArray[RumResourceKind.MEDIA.ordinal()] = 9;
            nArray[RumResourceKind.NATIVE.ordinal()] = 10;
            nArray[RumResourceKind.UNKNOWN.ordinal()] = 11;
            nArray[RumResourceKind.OTHER.ordinal()] = 12;
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[RumErrorSource.values().length];
            nArray[RumErrorSource.NETWORK.ordinal()] = 1;
            nArray[RumErrorSource.SOURCE.ordinal()] = 2;
            nArray[RumErrorSource.CONSOLE.ordinal()] = 3;
            nArray[RumErrorSource.LOGGER.ordinal()] = 4;
            nArray[RumErrorSource.AGENT.ordinal()] = 5;
            nArray[RumErrorSource.WEBVIEW.ordinal()] = 6;
            $EnumSwitchMapping$1 = nArray;
            nArray = new int[RumErrorSourceType.values().length];
            nArray[RumErrorSourceType.ANDROID.ordinal()] = 1;
            nArray[RumErrorSourceType.BROWSER.ordinal()] = 2;
            nArray[RumErrorSourceType.REACT_NATIVE.ordinal()] = 3;
            nArray[RumErrorSourceType.FLUTTER.ordinal()] = 4;
            $EnumSwitchMapping$2 = nArray;
            nArray = new int[RumActionType.values().length];
            nArray[RumActionType.TAP.ordinal()] = 1;
            nArray[RumActionType.SCROLL.ordinal()] = 2;
            nArray[RumActionType.SWIPE.ordinal()] = 3;
            nArray[RumActionType.CLICK.ordinal()] = 4;
            nArray[RumActionType.BACK.ordinal()] = 5;
            nArray[RumActionType.CUSTOM.ordinal()] = 6;
            $EnumSwitchMapping$3 = nArray;
            nArray = new int[NetworkInfo.Connectivity.values().length];
            nArray[NetworkInfo.Connectivity.NETWORK_ETHERNET.ordinal()] = 1;
            nArray[NetworkInfo.Connectivity.NETWORK_WIFI.ordinal()] = 2;
            nArray[NetworkInfo.Connectivity.NETWORK_WIMAX.ordinal()] = 3;
            nArray[NetworkInfo.Connectivity.NETWORK_BLUETOOTH.ordinal()] = 4;
            nArray[NetworkInfo.Connectivity.NETWORK_2G.ordinal()] = 5;
            nArray[NetworkInfo.Connectivity.NETWORK_3G.ordinal()] = 6;
            nArray[NetworkInfo.Connectivity.NETWORK_4G.ordinal()] = 7;
            nArray[NetworkInfo.Connectivity.NETWORK_5G.ordinal()] = 8;
            nArray[NetworkInfo.Connectivity.NETWORK_MOBILE_OTHER.ordinal()] = 9;
            nArray[NetworkInfo.Connectivity.NETWORK_CELLULAR.ordinal()] = 10;
            nArray[NetworkInfo.Connectivity.NETWORK_OTHER.ordinal()] = 11;
            nArray[NetworkInfo.Connectivity.NETWORK_NOT_CONNECTED.ordinal()] = 12;
            $EnumSwitchMapping$4 = nArray;
            nArray = new int[DeviceType.values().length];
            nArray[DeviceType.MOBILE.ordinal()] = 1;
            nArray[DeviceType.TABLET.ordinal()] = 2;
            nArray[DeviceType.TV.ordinal()] = 3;
            nArray[DeviceType.DESKTOP.ordinal()] = 4;
            $EnumSwitchMapping$5 = nArray;
        }
    }
}

