/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.rum.internal.domain.scope;

import androidx.annotation.WorkerThread;
import com.datadog.android.core.internal.net.FirstPartyHostHeaderTypeResolver;
import com.datadog.android.core.internal.utils.RuntimeUtilsKt;
import com.datadog.android.core.internal.utils.ThrowableExtKt;
import com.datadog.android.rum.GlobalRum;
import com.datadog.android.rum.RumErrorSource;
import com.datadog.android.rum.RumResourceKind;
import com.datadog.android.rum.internal.FeaturesContextResolver;
import com.datadog.android.rum.internal.domain.RumContext;
import com.datadog.android.rum.internal.domain.Time;
import com.datadog.android.rum.internal.domain.event.ResourceTiming;
import com.datadog.android.rum.internal.domain.scope.ExternalResourceTimingsKt;
import com.datadog.android.rum.internal.domain.scope.RumEventExtKt;
import com.datadog.android.rum.internal.domain.scope.RumRawEvent;
import com.datadog.android.rum.internal.domain.scope.RumScope;
import com.datadog.android.rum.model.ErrorEvent;
import com.datadog.android.rum.model.ResourceEvent;
import com.datadog.android.v2.api.EventBatchWriter;
import com.datadog.android.v2.api.FeatureScope;
import com.datadog.android.v2.api.InternalLogger;
import com.datadog.android.v2.api.SdkCore;
import com.datadog.android.v2.api.context.DatadogContext;
import com.datadog.android.v2.api.context.NetworkInfo;
import com.datadog.android.v2.api.context.UserInfo;
import com.datadog.android.v2.core.internal.ContextProvider;
import com.datadog.android.v2.core.internal.storage.DataWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00b8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u0000 ]2\u00020\u0001:\u0001]Bk\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0014\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\r0\f\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\u0002\u0010\u0016J\b\u0010>\u001a\u00020!H\u0016J \u0010?\u001a\u0004\u0018\u00010\u00012\u0006\u0010@\u001a\u00020A2\f\u0010B\u001a\b\u0012\u0004\u0012\u00020\r0CH\u0017J\b\u0010D\u001a\u000200H\u0016J\u001e\u0010E\u001a\u00020F2\u0006\u0010@\u001a\u00020G2\f\u0010B\u001a\b\u0012\u0004\u0012\u00020\r0CH\u0003J\u001e\u0010H\u001a\u00020F2\u0006\u0010@\u001a\u00020I2\f\u0010B\u001a\b\u0012\u0004\u0012\u00020\r0CH\u0003J\u001e\u0010J\u001a\u00020F2\u0006\u0010@\u001a\u00020K2\f\u0010B\u001a\b\u0012\u0004\u0012\u00020\r0CH\u0003J\u001e\u0010L\u001a\u00020F2\u0006\u0010@\u001a\u00020M2\f\u0010B\u001a\b\u0012\u0004\u0012\u00020\r0CH\u0003J\u0010\u0010N\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\n\u0010O\u001a\u0004\u0018\u00010PH\u0002J\u0010\u0010Q\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\nH\u0002J\n\u0010R\u001a\u0004\u0018\u00010SH\u0002JI\u0010T\u001a\u00020F2\u0006\u0010U\u001a\u00020\u00062\u0006\u0010V\u001a\u00020W2\b\u00104\u001a\u0004\u0018\u00010\u000f2\b\u0010X\u001a\u0004\u0018\u00010\u00062\b\u0010Y\u001a\u0004\u0018\u00010\u00062\f\u0010B\u001a\b\u0012\u0004\u0012\u00020\r0CH\u0002\u00a2\u0006\u0002\u0010ZJ?\u0010[\u001a\u00020F2\u0006\u0010$\u001a\u00020%2\b\u00104\u001a\u0004\u0018\u00010\u000f2\b\u00101\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\t\u001a\u00020\n2\f\u0010B\u001a\b\u0012\u0004\u0012\u00020\r0CH\u0002\u00a2\u0006\u0002\u0010\\R\"\u0010\u0017\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\r0\u0018X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\u000fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\u0011X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u000e\u0010$\u001a\u00020%X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010#R\u000e\u0010'\u001a\u00020(X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u0014\u0010+\u001a\u00020\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010#R\u0014\u0010\u0003\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.R\u000e\u0010/\u001a\u000200X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u00101\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u00102R\u000e\u00103\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u00104\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u00102R\u001a\u00105\u001a\u000200X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b6\u00107\"\u0004\b8\u00109R\u0010\u0010:\u001a\u0004\u0018\u00010;X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b<\u0010#R\u000e\u0010=\u001a\u000200X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006^"}, d2={"Lcom/datadog/android/rum/internal/domain/scope/RumResourceScope;", "Lcom/datadog/android/rum/internal/domain/scope/RumScope;", "parentScope", "sdkCore", "Lcom/datadog/android/v2/api/SdkCore;", "url", "", "method", "key", "eventTime", "Lcom/datadog/android/rum/internal/domain/Time;", "initialAttributes", "", "", "serverTimeOffsetInMs", "", "firstPartyHostHeaderTypeResolver", "Lcom/datadog/android/core/internal/net/FirstPartyHostHeaderTypeResolver;", "contextProvider", "Lcom/datadog/android/v2/core/internal/ContextProvider;", "featuresContextResolver", "Lcom/datadog/android/rum/internal/FeaturesContextResolver;", "(Lcom/datadog/android/rum/internal/domain/scope/RumScope;Lcom/datadog/android/v2/api/SdkCore;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lcom/datadog/android/rum/internal/domain/Time;Ljava/util/Map;JLcom/datadog/android/core/internal/net/FirstPartyHostHeaderTypeResolver;Lcom/datadog/android/v2/core/internal/ContextProvider;Lcom/datadog/android/rum/internal/FeaturesContextResolver;)V", "attributes", "", "getAttributes$dd_sdk_android_release", "()Ljava/util/Map;", "eventTimestamp", "getEventTimestamp$dd_sdk_android_release", "()J", "getFirstPartyHostHeaderTypeResolver$dd_sdk_android_release", "()Lcom/datadog/android/core/internal/net/FirstPartyHostHeaderTypeResolver;", "initialContext", "Lcom/datadog/android/rum/internal/domain/RumContext;", "getKey$dd_sdk_android_release", "()Ljava/lang/String;", "kind", "Lcom/datadog/android/rum/RumResourceKind;", "getMethod$dd_sdk_android_release", "networkInfo", "Lcom/datadog/android/v2/api/context/NetworkInfo;", "getParentScope$dd_sdk_android_release", "()Lcom/datadog/android/rum/internal/domain/scope/RumScope;", "resourceId", "getResourceId$dd_sdk_android_release", "getSdkCore$dd_sdk_android_release", "()Lcom/datadog/android/v2/api/SdkCore;", "sent", "", "size", "Ljava/lang/Long;", "startedNanos", "statusCode", "stopped", "getStopped$dd_sdk_android_release", "()Z", "setStopped$dd_sdk_android_release", "(Z)V", "timing", "Lcom/datadog/android/rum/internal/domain/event/ResourceTiming;", "getUrl$dd_sdk_android_release", "waitForTiming", "getRumContext", "handleEvent", "event", "Lcom/datadog/android/rum/internal/domain/scope/RumRawEvent;", "writer", "Lcom/datadog/android/v2/core/internal/storage/DataWriter;", "isActive", "onAddResourceTiming", "", "Lcom/datadog/android/rum/internal/domain/scope/RumRawEvent$AddResourceTiming;", "onStopResource", "Lcom/datadog/android/rum/internal/domain/scope/RumRawEvent$StopResource;", "onStopResourceWithError", "Lcom/datadog/android/rum/internal/domain/scope/RumRawEvent$StopResourceWithError;", "onStopResourceWithStackTrace", "Lcom/datadog/android/rum/internal/domain/scope/RumRawEvent$StopResourceWithStackTrace;", "resolveDomain", "resolveErrorProvider", "Lcom/datadog/android/rum/model/ErrorEvent$Provider;", "resolveResourceDuration", "resolveResourceProvider", "Lcom/datadog/android/rum/model/ResourceEvent$Provider;", "sendError", "message", "source", "Lcom/datadog/android/rum/RumErrorSource;", "stackTrace", "errorType", "(Ljava/lang/String;Lcom/datadog/android/rum/RumErrorSource;Ljava/lang/Long;Ljava/lang/String;Ljava/lang/String;Lcom/datadog/android/v2/core/internal/storage/DataWriter;)V", "sendResource", "(Lcom/datadog/android/rum/RumResourceKind;Ljava/lang/Long;Ljava/lang/Long;Lcom/datadog/android/rum/internal/domain/Time;Lcom/datadog/android/v2/core/internal/storage/DataWriter;)V", "Companion", "dd-sdk-android_release"})
public final class RumResourceScope
implements RumScope {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final RumScope parentScope;
    @NotNull
    private final SdkCore sdkCore;
    @NotNull
    private final String url;
    @NotNull
    private final String method;
    @NotNull
    private final String key;
    @NotNull
    private final FirstPartyHostHeaderTypeResolver firstPartyHostHeaderTypeResolver;
    @NotNull
    private final FeaturesContextResolver featuresContextResolver;
    @NotNull
    private final String resourceId;
    @NotNull
    private final Map<String, Object> attributes;
    @Nullable
    private ResourceTiming timing;
    @NotNull
    private final RumContext initialContext;
    private final long eventTimestamp;
    private final long startedNanos;
    @NotNull
    private final NetworkInfo networkInfo;
    private boolean sent;
    private boolean waitForTiming;
    private boolean stopped;
    @NotNull
    private RumResourceKind kind;
    @Nullable
    private Long statusCode;
    @Nullable
    private Long size;
    @NotNull
    public static final String NEGATIVE_DURATION_WARNING_MESSAGE = "The computed duration for your resource: %s was 0 or negative. In order to keep the resource event we forced it to 1ns.";

    /*
     * WARNING - void declaration
     */
    public RumResourceScope(@NotNull RumScope parentScope, @NotNull SdkCore sdkCore, @NotNull String url, @NotNull String method, @NotNull String key, @NotNull Time eventTime, @NotNull Map<String, ? extends Object> initialAttributes, long serverTimeOffsetInMs, @NotNull FirstPartyHostHeaderTypeResolver firstPartyHostHeaderTypeResolver, @NotNull ContextProvider contextProvider, @NotNull FeaturesContextResolver featuresContextResolver) {
        void $this$attributes_u24lambda_u2d0;
        Intrinsics.checkNotNullParameter((Object)parentScope, (String)"parentScope");
        Intrinsics.checkNotNullParameter((Object)sdkCore, (String)"sdkCore");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)eventTime, (String)"eventTime");
        Intrinsics.checkNotNullParameter(initialAttributes, (String)"initialAttributes");
        Intrinsics.checkNotNullParameter((Object)firstPartyHostHeaderTypeResolver, (String)"firstPartyHostHeaderTypeResolver");
        Intrinsics.checkNotNullParameter((Object)contextProvider, (String)"contextProvider");
        Intrinsics.checkNotNullParameter((Object)featuresContextResolver, (String)"featuresContextResolver");
        this.parentScope = parentScope;
        this.sdkCore = sdkCore;
        this.url = url;
        this.method = method;
        this.key = key;
        this.firstPartyHostHeaderTypeResolver = firstPartyHostHeaderTypeResolver;
        this.featuresContextResolver = featuresContextResolver;
        Object object = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"randomUUID().toString()");
        this.resourceId = object;
        Object object2 = object = MapsKt.toMutableMap(initialAttributes);
        RumResourceScope rumResourceScope = this;
        boolean bl = false;
        $this$attributes_u24lambda_u2d0.putAll(GlobalRum.INSTANCE.getGlobalAttributes$dd_sdk_android_release());
        rumResourceScope.attributes = object;
        this.initialContext = this.parentScope.getRumContext();
        this.eventTimestamp = eventTime.getTimestamp() + serverTimeOffsetInMs;
        this.startedNanos = eventTime.getNanoTime();
        this.networkInfo = contextProvider.getContext().getNetworkInfo();
        this.kind = RumResourceKind.UNKNOWN;
    }

    @NotNull
    public final RumScope getParentScope$dd_sdk_android_release() {
        return this.parentScope;
    }

    @NotNull
    public final SdkCore getSdkCore$dd_sdk_android_release() {
        return this.sdkCore;
    }

    @NotNull
    public final String getUrl$dd_sdk_android_release() {
        return this.url;
    }

    @NotNull
    public final String getMethod$dd_sdk_android_release() {
        return this.method;
    }

    @NotNull
    public final String getKey$dd_sdk_android_release() {
        return this.key;
    }

    @NotNull
    public final FirstPartyHostHeaderTypeResolver getFirstPartyHostHeaderTypeResolver$dd_sdk_android_release() {
        return this.firstPartyHostHeaderTypeResolver;
    }

    @NotNull
    public final String getResourceId$dd_sdk_android_release() {
        return this.resourceId;
    }

    @NotNull
    public final Map<String, Object> getAttributes$dd_sdk_android_release() {
        return this.attributes;
    }

    public final long getEventTimestamp$dd_sdk_android_release() {
        return this.eventTimestamp;
    }

    public final boolean getStopped$dd_sdk_android_release() {
        return this.stopped;
    }

    public final void setStopped$dd_sdk_android_release(boolean bl) {
        this.stopped = bl;
    }

    @Override
    @WorkerThread
    @Nullable
    public RumScope handleEvent(@NotNull RumRawEvent event, @NotNull DataWriter<Object> writer) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter(writer, (String)"writer");
        RumRawEvent rumRawEvent = event;
        if (rumRawEvent instanceof RumRawEvent.WaitForResourceTiming) {
            if (Intrinsics.areEqual((Object)this.key, (Object)((RumRawEvent.WaitForResourceTiming)event).getKey())) {
                this.waitForTiming = true;
            }
        } else if (rumRawEvent instanceof RumRawEvent.AddResourceTiming) {
            this.onAddResourceTiming((RumRawEvent.AddResourceTiming)event, writer);
        } else if (rumRawEvent instanceof RumRawEvent.StopResource) {
            this.onStopResource((RumRawEvent.StopResource)event, writer);
        } else if (rumRawEvent instanceof RumRawEvent.StopResourceWithError) {
            this.onStopResourceWithError((RumRawEvent.StopResourceWithError)event, writer);
        } else if (rumRawEvent instanceof RumRawEvent.StopResourceWithStackTrace) {
            this.onStopResourceWithStackTrace((RumRawEvent.StopResourceWithStackTrace)event, writer);
        }
        return this.sent ? null : (RumScope)this;
    }

    @Override
    @NotNull
    public RumContext getRumContext() {
        return this.initialContext;
    }

    @Override
    public boolean isActive() {
        return !this.stopped;
    }

    @WorkerThread
    private final void onStopResource(RumRawEvent.StopResource event, DataWriter<Object> writer) {
        if (!Intrinsics.areEqual((Object)this.key, (Object)event.getKey())) {
            return;
        }
        this.stopped = true;
        this.attributes.putAll(event.getAttributes());
        this.kind = event.getKind();
        this.statusCode = event.getStatusCode();
        this.size = event.getSize();
        if (!this.waitForTiming || this.timing != null) {
            this.sendResource(this.kind, event.getStatusCode(), event.getSize(), event.getEventTime(), writer);
        }
    }

    @WorkerThread
    private final void onAddResourceTiming(RumRawEvent.AddResourceTiming event, DataWriter<Object> writer) {
        if (!Intrinsics.areEqual((Object)this.key, (Object)event.getKey())) {
            return;
        }
        this.timing = event.getTiming();
        if (this.stopped && !this.sent) {
            this.sendResource(this.kind, this.statusCode, this.size, event.getEventTime(), writer);
        }
    }

    @WorkerThread
    private final void onStopResourceWithError(RumRawEvent.StopResourceWithError event, DataWriter<Object> writer) {
        if (!Intrinsics.areEqual((Object)this.key, (Object)event.getKey())) {
            return;
        }
        this.attributes.putAll(event.getAttributes());
        this.sendError(event.getMessage(), event.getSource(), event.getStatusCode(), ThrowableExtKt.loggableStackTrace(event.getThrowable()), event.getThrowable().getClass().getCanonicalName(), writer);
    }

    @WorkerThread
    private final void onStopResourceWithStackTrace(RumRawEvent.StopResourceWithStackTrace event, DataWriter<Object> writer) {
        if (!Intrinsics.areEqual((Object)this.key, (Object)event.getKey())) {
            return;
        }
        this.attributes.putAll(event.getAttributes());
        this.sendError(event.getMessage(), event.getSource(), event.getStatusCode(), event.getStackTrace(), event.getErrorType(), writer);
    }

    private final void sendResource(RumResourceKind kind, Long statusCode, Long size, Time eventTime, DataWriter<Object> writer) {
        FeatureScope featureScope;
        ResourceTiming finalTiming;
        this.attributes.putAll(GlobalRum.INSTANCE.getGlobalAttributes$dd_sdk_android_release());
        Object object = this.attributes.remove("_dd.trace_id");
        String traceId = object == null ? null : object.toString();
        Object object2 = this.attributes.remove("_dd.span_id");
        String spanId = object2 == null ? null : object2.toString();
        Object object3 = this.attributes.remove("_dd.rule_psr");
        Number rulePsr = object3 instanceof Number ? (Number)((Number)object3) : (Number)null;
        RumContext rumContext = this.getRumContext();
        ResourceTiming resourceTiming = this.timing;
        if (resourceTiming == null) {
            Object object4 = this.attributes.remove("_dd.resource_timings");
            resourceTiming = finalTiming = ExternalResourceTimingsKt.extractResourceTiming(object4 instanceof Map ? (Map)object4 : null);
        }
        if ((featureScope = this.sdkCore.getFeature("rum")) != null) {
            FeatureScope.DefaultImpls.withWriteContext$default(featureScope, false, (Function2)new Function2<DatadogContext, EventBatchWriter, Unit>(this, eventTime, kind, finalTiming, statusCode, size, rumContext, spanId, traceId, rulePsr, writer){
                final /* synthetic */ RumResourceScope this$0;
                final /* synthetic */ Time $eventTime;
                final /* synthetic */ RumResourceKind $kind;
                final /* synthetic */ ResourceTiming $finalTiming;
                final /* synthetic */ Long $statusCode;
                final /* synthetic */ Long $size;
                final /* synthetic */ RumContext $rumContext;
                final /* synthetic */ String $spanId;
                final /* synthetic */ String $traceId;
                final /* synthetic */ Number $rulePsr;
                final /* synthetic */ DataWriter<Object> $writer;
                {
                    this.this$0 = $receiver;
                    this.$eventTime = $eventTime;
                    this.$kind = $kind;
                    this.$finalTiming = $finalTiming;
                    this.$statusCode = $statusCode;
                    this.$size = $size;
                    this.$rumContext = $rumContext;
                    this.$spanId = $spanId;
                    this.$traceId = $traceId;
                    this.$rulePsr = $rulePsr;
                    this.$writer = $writer;
                    super(2);
                }

                public final void invoke(@NotNull DatadogContext datadogContext, @NotNull EventBatchWriter eventBatchWriter) {
                    ResourceEvent.Action action;
                    Intrinsics.checkNotNullParameter((Object)datadogContext, (String)"datadogContext");
                    Intrinsics.checkNotNullParameter((Object)eventBatchWriter, (String)"eventBatchWriter");
                    UserInfo user = datadogContext.getUserInfo();
                    boolean hasReplay = RumResourceScope.access$getFeaturesContextResolver$p(this.this$0).resolveHasReplay(datadogContext);
                    long duration = RumResourceScope.access$resolveResourceDuration(this.this$0, this.$eventTime);
                    long l = this.this$0.getEventTimestamp$dd_sdk_android_release();
                    String string = this.this$0.getResourceId$dd_sdk_android_release();
                    Object object = RumEventExtKt.toSchemaType(this.$kind);
                    Object object2 = this.this$0.getUrl$dd_sdk_android_release();
                    Object object3 = RumEventExtKt.toMethod(this.this$0.getMethod$dd_sdk_android_release());
                    ResourceTiming resourceTiming = this.$finalTiming;
                    Object object4 = resourceTiming == null ? null : RumEventExtKt.dns(resourceTiming);
                    ResourceTiming resourceTiming2 = this.$finalTiming;
                    Object object5 = resourceTiming2 == null ? null : RumEventExtKt.connect(resourceTiming2);
                    ResourceTiming resourceTiming3 = this.$finalTiming;
                    Object object6 = resourceTiming3 == null ? null : RumEventExtKt.ssl(resourceTiming3);
                    ResourceTiming resourceTiming4 = this.$finalTiming;
                    Object object7 = resourceTiming4 == null ? null : RumEventExtKt.firstByte(resourceTiming4);
                    ResourceTiming resourceTiming5 = this.$finalTiming;
                    Object object8 = resourceTiming5 == null ? null : RumEventExtKt.download(resourceTiming5);
                    Object object9 = RumResourceScope.access$resolveResourceProvider(this.this$0);
                    ResourceEvent.Resource resource = new ResourceEvent.Resource(string, (ResourceEvent.ResourceType)((Object)object), (ResourceEvent.Method)((Object)object3), (String)object2, this.$statusCode, duration, this.$size, null, (ResourceEvent.Dns)object4, (ResourceEvent.Connect)object5, (ResourceEvent.Ssl)object6, (ResourceEvent.FirstByte)object7, (ResourceEvent.Download)object8, (ResourceEvent.Provider)object9, 128, null);
                    String string2 = this.$rumContext.getActionId();
                    if (string2 == null) {
                        action = null;
                    } else {
                        String it = string2;
                        boolean bl = false;
                        action = new ResourceEvent.Action(CollectionsKt.listOf((Object)it));
                    }
                    string = action;
                    String string3 = this.$rumContext.getViewId();
                    if (string3 == null) {
                        string3 = "";
                    }
                    object2 = string3;
                    object3 = this.$rumContext.getViewName();
                    String string4 = this.$rumContext.getViewUrl();
                    if (string4 == null) {
                        string4 = "";
                    }
                    object4 = string4;
                    object = new ResourceEvent.View((String)object2, null, (String)object4, (String)object3, 2, null);
                    object2 = user.hasUserData$dd_sdk_android_release() ? new ResourceEvent.Usr(user.getId(), user.getName(), user.getEmail(), MapsKt.toMutableMap(user.getAdditionalProperties())) : (ResourceEvent.Usr)null;
                    object3 = RumEventExtKt.toResourceConnectivity(RumResourceScope.access$getNetworkInfo$p(this.this$0));
                    object4 = new ResourceEvent.Application(this.$rumContext.getApplicationId());
                    object5 = new ResourceEvent.ResourceEventSession(this.$rumContext.getSessionId(), ResourceEvent.ResourceEventSessionType.USER, hasReplay);
                    object6 = RumEventExtKt.tryFromSource(ResourceEvent.Source.Companion, datadogContext.getSource());
                    object7 = new ResourceEvent.Os(datadogContext.getDeviceInfo().getOsName(), datadogContext.getDeviceInfo().getOsVersion(), datadogContext.getDeviceInfo().getOsMajorVersion());
                    object8 = new ResourceEvent.Device(RumEventExtKt.toResourceSchemaType(datadogContext.getDeviceInfo().getDeviceType()), datadogContext.getDeviceInfo().getDeviceName(), datadogContext.getDeviceInfo().getDeviceModel(), datadogContext.getDeviceInfo().getDeviceBrand(), datadogContext.getDeviceInfo().getArchitecture());
                    object9 = new ResourceEvent.Context(this.this$0.getAttributes$dd_sdk_android_release());
                    Object object10 = new ResourceEvent.DdSession(ResourceEvent.Plan.PLAN_1);
                    ResourceEvent.Dd dd = new ResourceEvent.Dd((ResourceEvent.DdSession)object10, null, this.$spanId, this.$traceId, this.$rulePsr, null, 34, null);
                    object10 = datadogContext.getService();
                    String string5 = datadogContext.getVersion();
                    ResourceEvent resourceEvent = new ResourceEvent(l, (ResourceEvent.Application)object4, (String)object10, string5, (ResourceEvent.ResourceEventSession)object5, (ResourceEvent.Source)((Object)object6), (ResourceEvent.View)object, (ResourceEvent.Usr)object2, (ResourceEvent.Connectivity)object3, null, null, null, (ResourceEvent.Os)object7, (ResourceEvent.Device)object8, dd, (ResourceEvent.Context)object9, (ResourceEvent.Action)((Object)string), resource, 3584, null);
                    this.$writer.write(eventBatchWriter, resourceEvent);
                }
            }, 1, null);
        }
        this.sent = true;
    }

    private final long resolveResourceDuration(Time eventTime) {
        long l;
        long duration = eventTime.getNanoTime() - this.startedNanos;
        if (duration <= 0L) {
            InternalLogger internalLogger = RuntimeUtilsKt.getInternalLogger();
            String string = NEGATIVE_DURATION_WARNING_MESSAGE;
            Locale locale = Locale.US;
            Object[] objectArray = new Object[]{this.url};
            String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(locale, this, *args)");
            InternalLogger.DefaultImpls.log$default(internalLogger, InternalLogger.Level.WARN, InternalLogger.Target.USER, string2, null, 8, null);
            l = 1L;
        } else {
            l = duration;
        }
        return l;
    }

    private final ResourceEvent.Provider resolveResourceProvider() {
        return this.firstPartyHostHeaderTypeResolver.isFirstPartyUrl(this.url) ? new ResourceEvent.Provider(this.resolveDomain(this.url), null, ResourceEvent.ProviderType.FIRST_PARTY, 2, null) : (ResourceEvent.Provider)null;
    }

    private final void sendError(String message, RumErrorSource source, Long statusCode, String stackTrace, String errorType, DataWriter<Object> writer) {
        this.attributes.putAll(GlobalRum.INSTANCE.getGlobalAttributes$dd_sdk_android_release());
        RumContext rumContext = this.getRumContext();
        FeatureScope featureScope = this.sdkCore.getFeature("rum");
        if (featureScope != null) {
            FeatureScope.DefaultImpls.withWriteContext$default(featureScope, false, (Function2)new Function2<DatadogContext, EventBatchWriter, Unit>(this, source, statusCode, message, stackTrace, errorType, rumContext, writer){
                final /* synthetic */ RumResourceScope this$0;
                final /* synthetic */ RumErrorSource $source;
                final /* synthetic */ Long $statusCode;
                final /* synthetic */ String $message;
                final /* synthetic */ String $stackTrace;
                final /* synthetic */ String $errorType;
                final /* synthetic */ RumContext $rumContext;
                final /* synthetic */ DataWriter<Object> $writer;
                {
                    this.this$0 = $receiver;
                    this.$source = $source;
                    this.$statusCode = $statusCode;
                    this.$message = $message;
                    this.$stackTrace = $stackTrace;
                    this.$errorType = $errorType;
                    this.$rumContext = $rumContext;
                    this.$writer = $writer;
                    super(2);
                }

                public final void invoke(@NotNull DatadogContext datadogContext, @NotNull EventBatchWriter eventBatchWriter) {
                    ErrorEvent.Action action;
                    Intrinsics.checkNotNullParameter((Object)datadogContext, (String)"datadogContext");
                    Intrinsics.checkNotNullParameter((Object)eventBatchWriter, (String)"eventBatchWriter");
                    UserInfo user = datadogContext.getUserInfo();
                    boolean hasReplay = RumResourceScope.access$getFeaturesContextResolver$p(this.this$0).resolveHasReplay(datadogContext);
                    long l = this.this$0.getEventTimestamp$dd_sdk_android_release();
                    ErrorEvent.ErrorSource errorSource = RumEventExtKt.toSchemaSource(this.$source);
                    Object object = this.this$0.getUrl$dd_sdk_android_release();
                    Object object2 = RumEventExtKt.toErrorMethod(this.this$0.getMethod$dd_sdk_android_release());
                    Long l2 = this.$statusCode;
                    long l3 = l2 == null ? 0L : l2;
                    Object object3 = RumResourceScope.access$resolveErrorProvider(this.this$0);
                    Object object4 = new ErrorEvent.Resource((ErrorEvent.Method)((Object)object2), l3, (String)object, (ErrorEvent.Provider)object3);
                    object = ErrorEvent.SourceType.ANDROID;
                    ErrorEvent.Error error = new ErrorEvent.Error(null, this.$message, errorSource, this.$stackTrace, null, false, this.$errorType, null, null, (ErrorEvent.SourceType)((Object)object), (ErrorEvent.Resource)object4, 401, null);
                    String string = this.$rumContext.getActionId();
                    if (string == null) {
                        action = null;
                    } else {
                        String it = string;
                        boolean bl = false;
                        action = new ErrorEvent.Action(CollectionsKt.listOf((Object)it));
                    }
                    errorSource = action;
                    String string2 = this.$rumContext.getViewId();
                    if (string2 == null) {
                        string2 = "";
                    }
                    object = string2;
                    object2 = this.$rumContext.getViewName();
                    String string3 = this.$rumContext.getViewUrl();
                    if (string3 == null) {
                        string3 = "";
                    }
                    Object object5 = string3;
                    object4 = new ErrorEvent.View((String)object, null, (String)object5, (String)object2, null, 18, null);
                    object = user.hasUserData$dd_sdk_android_release() ? new ErrorEvent.Usr(user.getId(), user.getName(), user.getEmail(), MapsKt.toMutableMap(user.getAdditionalProperties())) : (ErrorEvent.Usr)null;
                    object2 = RumEventExtKt.toErrorConnectivity(RumResourceScope.access$getNetworkInfo$p(this.this$0));
                    object5 = new ErrorEvent.Application(this.$rumContext.getApplicationId());
                    ErrorEvent.ErrorEventSession errorEventSession = new ErrorEvent.ErrorEventSession(this.$rumContext.getSessionId(), ErrorEvent.ErrorEventSessionType.USER, hasReplay);
                    object3 = RumEventExtKt.tryFromSource(ErrorEvent.ErrorEventSource.Companion, datadogContext.getSource());
                    ErrorEvent.Os os = new ErrorEvent.Os(datadogContext.getDeviceInfo().getOsName(), datadogContext.getDeviceInfo().getOsVersion(), datadogContext.getDeviceInfo().getOsMajorVersion());
                    ErrorEvent.Device device = new ErrorEvent.Device(RumEventExtKt.toErrorSchemaType(datadogContext.getDeviceInfo().getDeviceType()), datadogContext.getDeviceInfo().getDeviceName(), datadogContext.getDeviceInfo().getDeviceModel(), datadogContext.getDeviceInfo().getDeviceBrand(), datadogContext.getDeviceInfo().getArchitecture());
                    ErrorEvent.Context context = new ErrorEvent.Context(this.this$0.getAttributes$dd_sdk_android_release());
                    ErrorEvent.Dd dd = new ErrorEvent.Dd(new ErrorEvent.DdSession(ErrorEvent.Plan.PLAN_1), null, 2, null);
                    String string4 = datadogContext.getService();
                    String string5 = datadogContext.getVersion();
                    ErrorEvent errorEvent = new ErrorEvent(l, (ErrorEvent.Application)object5, string4, string5, errorEventSession, (ErrorEvent.ErrorEventSource)((Object)object3), (ErrorEvent.View)object4, (ErrorEvent.Usr)object, (ErrorEvent.Connectivity)object2, null, null, null, os, device, dd, context, (ErrorEvent.Action)((Object)errorSource), error, null, 265728, null);
                    this.$writer.write(eventBatchWriter, errorEvent);
                }
            }, 1, null);
        }
        this.sent = true;
    }

    private final ErrorEvent.Provider resolveErrorProvider() {
        return this.firstPartyHostHeaderTypeResolver.isFirstPartyUrl(this.url) ? new ErrorEvent.Provider(this.resolveDomain(this.url), null, ErrorEvent.ProviderType.FIRST_PARTY, 2, null) : (ErrorEvent.Provider)null;
    }

    private final String resolveDomain(String url) {
        String string;
        try {
            string = new URL(url).getHost();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"{\n            URL(url).host\n        }");
        }
        catch (MalformedURLException e) {
            string = url;
        }
        return string;
    }

    public static final /* synthetic */ FeaturesContextResolver access$getFeaturesContextResolver$p(RumResourceScope $this) {
        return $this.featuresContextResolver;
    }

    public static final /* synthetic */ long access$resolveResourceDuration(RumResourceScope $this, Time eventTime) {
        return $this.resolveResourceDuration(eventTime);
    }

    public static final /* synthetic */ ResourceEvent.Provider access$resolveResourceProvider(RumResourceScope $this) {
        return $this.resolveResourceProvider();
    }

    public static final /* synthetic */ NetworkInfo access$getNetworkInfo$p(RumResourceScope $this) {
        return $this.networkInfo;
    }

    public static final /* synthetic */ ErrorEvent.Provider access$resolveErrorProvider(RumResourceScope $this) {
        return $this.resolveErrorProvider();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J>\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/datadog/android/rum/internal/domain/scope/RumResourceScope$Companion;", "", "()V", "NEGATIVE_DURATION_WARNING_MESSAGE", "", "fromEvent", "Lcom/datadog/android/rum/internal/domain/scope/RumScope;", "parentScope", "sdkCore", "Lcom/datadog/android/v2/api/SdkCore;", "event", "Lcom/datadog/android/rum/internal/domain/scope/RumRawEvent$StartResource;", "firstPartyHostHeaderTypeResolver", "Lcom/datadog/android/core/internal/net/FirstPartyHostHeaderTypeResolver;", "timestampOffset", "", "contextProvider", "Lcom/datadog/android/v2/core/internal/ContextProvider;", "featuresContextResolver", "Lcom/datadog/android/rum/internal/FeaturesContextResolver;", "dd-sdk-android_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final RumScope fromEvent(@NotNull RumScope parentScope, @NotNull SdkCore sdkCore, @NotNull RumRawEvent.StartResource event, @NotNull FirstPartyHostHeaderTypeResolver firstPartyHostHeaderTypeResolver, long timestampOffset, @NotNull ContextProvider contextProvider, @NotNull FeaturesContextResolver featuresContextResolver) {
            Intrinsics.checkNotNullParameter((Object)parentScope, (String)"parentScope");
            Intrinsics.checkNotNullParameter((Object)sdkCore, (String)"sdkCore");
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Intrinsics.checkNotNullParameter((Object)firstPartyHostHeaderTypeResolver, (String)"firstPartyHostHeaderTypeResolver");
            Intrinsics.checkNotNullParameter((Object)contextProvider, (String)"contextProvider");
            Intrinsics.checkNotNullParameter((Object)featuresContextResolver, (String)"featuresContextResolver");
            return new RumResourceScope(parentScope, sdkCore, event.getUrl(), event.getMethod(), event.getKey(), event.getEventTime(), event.getAttributes(), timestampOffset, firstPartyHostHeaderTypeResolver, contextProvider, featuresContextResolver);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

