/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.rum.internal.domain.scope;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.Fragment;
import android.view.Display;
import android.view.WindowManager;
import androidx.annotation.WorkerThread;
import androidx.navigation.NavController;
import com.datadog.android.core.internal.net.FirstPartyHostHeaderTypeResolver;
import com.datadog.android.core.internal.system.BuildSdkVersionProvider;
import com.datadog.android.core.internal.system.DefaultBuildSdkVersionProvider;
import com.datadog.android.core.internal.utils.RuntimeUtilsKt;
import com.datadog.android.core.internal.utils.ThrowableExtKt;
import com.datadog.android.core.internal.utils.ViewUtilsKt;
import com.datadog.android.rum.GlobalRum;
import com.datadog.android.rum.RumActionType;
import com.datadog.android.rum.RumPerformanceMetric;
import com.datadog.android.rum.internal.FeaturesContextResolver;
import com.datadog.android.rum.internal.domain.RumContext;
import com.datadog.android.rum.internal.domain.Time;
import com.datadog.android.rum.internal.domain.scope.DefaultViewUpdatePredicate;
import com.datadog.android.rum.internal.domain.scope.RumActionScope;
import com.datadog.android.rum.internal.domain.scope.RumEventExtKt;
import com.datadog.android.rum.internal.domain.scope.RumRawEvent;
import com.datadog.android.rum.internal.domain.scope.RumResourceScope;
import com.datadog.android.rum.internal.domain.scope.RumScope;
import com.datadog.android.rum.internal.domain.scope.RumViewChangedListener;
import com.datadog.android.rum.internal.domain.scope.RumViewInfo;
import com.datadog.android.rum.internal.domain.scope.ViewUpdatePredicate;
import com.datadog.android.rum.internal.vitals.VitalInfo;
import com.datadog.android.rum.internal.vitals.VitalListener;
import com.datadog.android.rum.internal.vitals.VitalMonitor;
import com.datadog.android.rum.model.ActionEvent;
import com.datadog.android.rum.model.ErrorEvent;
import com.datadog.android.rum.model.LongTaskEvent;
import com.datadog.android.rum.model.ViewEvent;
import com.datadog.android.rum.tracking.NavigationViewTrackingStrategy;
import com.datadog.android.v2.api.EventBatchWriter;
import com.datadog.android.v2.api.FeatureScope;
import com.datadog.android.v2.api.InternalLogger;
import com.datadog.android.v2.api.SdkCore;
import com.datadog.android.v2.api.context.DatadogContext;
import com.datadog.android.v2.api.context.UserInfo;
import com.datadog.android.v2.core.internal.ContextProvider;
import com.datadog.android.v2.core.internal.storage.DataWriter;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00cc\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010%\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0016\n\u0002\u0018\u0002\n\u0002\b\u0015\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0010\u0018\u0000 \u00be\u00012\u00020\u0001:\u0004\u00be\u0001\u00bf\u0001B\u00a5\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0014\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\u00060\f\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\u0006\u0010\u0013\u001a\u00020\u0012\u0012\u0006\u0010\u0014\u001a\u00020\u0012\u0012\u0006\u0010\u0015\u001a\u00020\u0016\u0012\b\b\u0002\u0010\u0017\u001a\u00020\u0018\u0012\b\b\u0002\u0010\u0019\u001a\u00020\u001a\u0012\b\b\u0002\u0010\u001b\u001a\u00020\u001c\u0012\b\b\u0002\u0010\u001d\u001a\u00020\u001e\u0012\u0006\u0010\u001f\u001a\u00020 \u00a2\u0006\u0002\u0010!J,\u0010{\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\u00060*2\u0014\u0010-\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\u00060\fH\u0002J \u0010|\u001a\u00020}2\u0006\u0010~\u001a\u00020\u007f2\u000e\u0010\u0080\u0001\u001a\t\u0012\u0004\u0012\u00020\u00060\u0081\u0001H\u0003J!\u0010\u0082\u0001\u001a\u00020}2\u0006\u0010~\u001a\u00020\u007f2\u000e\u0010\u0080\u0001\u001a\t\u0012\u0004\u0012\u00020\u00060\u0081\u0001H\u0003J!\u0010\u0083\u0001\u001a\u00020}2\u0006\u0010~\u001a\u00020\u007f2\u000e\u0010\u0080\u0001\u001a\t\u0012\u0004\u0012\u00020\u00060\u0081\u0001H\u0003J\u0011\u0010\u0084\u0001\u001a\u00020}2\u0006\u0010\u0005\u001a\u00020\u0006H\u0003J\n\u0010\u0085\u0001\u001a\u00030\u0086\u0001H\u0016J#\u0010\u0087\u0001\u001a\u0004\u0018\u00010\u00012\u0006\u0010~\u001a\u00020\u007f2\u000e\u0010\u0080\u0001\u001a\t\u0012\u0004\u0012\u00020\u00060\u0081\u0001H\u0017J\t\u0010\u0088\u0001\u001a\u00020 H\u0016J\t\u0010\u0089\u0001\u001a\u00020 H\u0002J\u0012\u0010\u008a\u0001\u001a\u00020}2\u0007\u0010~\u001a\u00030\u008b\u0001H\u0002J\"\u0010\u008c\u0001\u001a\u00020}2\u0007\u0010~\u001a\u00030\u008d\u00012\u000e\u0010\u0080\u0001\u001a\t\u0012\u0004\u0012\u00020\u00060\u0081\u0001H\u0003J\"\u0010\u008e\u0001\u001a\u00020}2\u0007\u0010~\u001a\u00030\u008f\u00012\u000e\u0010\u0080\u0001\u001a\t\u0012\u0004\u0012\u00020\u00060\u0081\u0001H\u0003J\"\u0010\u0090\u0001\u001a\u00020}2\u0007\u0010~\u001a\u00030\u0091\u00012\u000e\u0010\u0080\u0001\u001a\t\u0012\u0004\u0012\u00020\u00060\u0081\u0001H\u0003J\"\u0010\u0092\u0001\u001a\u00020}2\u0007\u0010~\u001a\u00030\u0093\u00012\u000e\u0010\u0080\u0001\u001a\t\u0012\u0004\u0012\u00020\u00060\u0081\u0001H\u0002J\"\u0010\u0094\u0001\u001a\u00020}2\u0007\u0010~\u001a\u00030\u0095\u00012\u000e\u0010\u0080\u0001\u001a\t\u0012\u0004\u0012\u00020\u00060\u0081\u0001H\u0003J\"\u0010\u0096\u0001\u001a\u00020}2\u0007\u0010~\u001a\u00030\u0097\u00012\u000e\u0010\u0080\u0001\u001a\t\u0012\u0004\u0012\u00020\u00060\u0081\u0001H\u0003J\u0012\u0010\u0098\u0001\u001a\u00020}2\u0007\u0010~\u001a\u00030\u0099\u0001H\u0002J\"\u0010\u009a\u0001\u001a\u00020}2\u0007\u0010~\u001a\u00030\u009b\u00012\u000e\u0010\u0080\u0001\u001a\t\u0012\u0004\u0012\u00020\u00060\u0081\u0001H\u0003J\"\u0010\u009c\u0001\u001a\u00020}2\u0007\u0010~\u001a\u00030\u009d\u00012\u000e\u0010\u0080\u0001\u001a\t\u0012\u0004\u0012\u00020\u00060\u0081\u0001H\u0003J\u0012\u0010\u009e\u0001\u001a\u00020}2\u0007\u0010~\u001a\u00030\u009f\u0001H\u0002J\"\u0010\u00a0\u0001\u001a\u00020}2\u0007\u0010~\u001a\u00030\u00a1\u00012\u000e\u0010\u0080\u0001\u001a\t\u0012\u0004\u0012\u00020\u00060\u0081\u0001H\u0003J\u0012\u0010\u00a2\u0001\u001a\u00020}2\u0007\u0010~\u001a\u00030\u00a3\u0001H\u0002J\"\u0010\u00a4\u0001\u001a\u00020}2\u0007\u0010~\u001a\u00030\u00a5\u00012\u000e\u0010\u0080\u0001\u001a\t\u0012\u0004\u0012\u00020\u00060\u0081\u0001H\u0003J\"\u0010\u00a6\u0001\u001a\u00020}2\u0007\u0010~\u001a\u00030\u00a7\u00012\u000e\u0010\u0080\u0001\u001a\t\u0012\u0004\u0012\u00020\u00060\u0081\u0001H\u0003J\"\u0010\u00a8\u0001\u001a\u00020}2\u0007\u0010~\u001a\u00030\u00a9\u00012\u000e\u0010\u0080\u0001\u001a\t\u0012\u0004\u0012\u00020\u00060\u0081\u0001H\u0003J\"\u0010\u00aa\u0001\u001a\u00020}2\u0007\u0010~\u001a\u00030\u00ab\u00012\u000e\u0010\u0080\u0001\u001a\t\u0012\u0004\u0012\u00020\u00060\u0081\u0001H\u0003J\"\u0010\u00ac\u0001\u001a\u00020}2\u0007\u0010~\u001a\u00030\u00ad\u00012\u000e\u0010\u0080\u0001\u001a\t\u0012\u0004\u0012\u00020\u00060\u0081\u0001H\u0003J\"\u0010\u00ae\u0001\u001a\u00020}2\u0007\u0010~\u001a\u00030\u00af\u00012\u000e\u0010\u0080\u0001\u001a\t\u0012\u0004\u0012\u00020\u00060\u0081\u0001H\u0003J\u0012\u0010\u00b0\u0001\u001a\u00020}2\u0007\u0010~\u001a\u00030\u00b1\u0001H\u0002J\"\u0010\u00b2\u0001\u001a\u00020}2\u0007\u0010~\u001a\u00030\u00b3\u00012\u000e\u0010\u0080\u0001\u001a\t\u0012\u0004\u0012\u00020\u00060\u0081\u0001H\u0003J\f\u0010\u00b4\u0001\u001a\u0005\u0018\u00010\u00b5\u0001H\u0002J\u001c\u0010\u00b6\u0001\u001a\u0004\u0018\u00010 2\t\u0010\u00b7\u0001\u001a\u0004\u0018\u00010KH\u0002\u00a2\u0006\u0003\u0010\u00b8\u0001J\u0011\u0010\u00b9\u0001\u001a\u00020#2\u0006\u0010~\u001a\u00020\u007fH\u0002J\t\u0010\u00ba\u0001\u001a\u00020}H\u0002J!\u0010\u00bb\u0001\u001a\u00020}2\u0006\u0010~\u001a\u00020\u007f2\u000e\u0010\u0080\u0001\u001a\t\u0012\u0004\u0012\u00020\u00060\u0081\u0001H\u0002J\u0014\u0010\u00bc\u0001\u001a\u00020}2\t\u0010\u00bd\u0001\u001a\u0004\u0018\u00010\u0001H\u0002R\u000e\u0010\"\u001a\u00020#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010$\u001a\u0004\u0018\u00010\u0001X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R \u0010)\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00010*X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,R\"\u0010-\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\u00060*X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010,R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010/\u001a\u0004\u0018\u000100X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u00101R\u000e\u00102\u001a\u000203X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\u0012X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u00105R\u000e\u00106\u001a\u00020#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u00107\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020#0*X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b8\u0010,R\u000e\u00109\u001a\u00020#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010:\u001a\u00020#X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b;\u0010<R\"\u0010=\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\u00060*X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b>\u0010,R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\u0010X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b?\u0010@R\u000e\u0010A\u001a\u000203X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u0012X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bB\u00105R\u000e\u0010C\u001a\u00020#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010D\u001a\u00020EX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010F\u001a\b\u0012\u0004\u0012\u00020\u00060GX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bH\u0010IR\u0010\u0010J\u001a\u0004\u0018\u00010KX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010L\u001a\u0004\u0018\u00010KX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010M\u001a\u0004\u0018\u00010#X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010NR\u0010\u0010O\u001a\u0004\u0018\u00010PX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010Q\u001a\u00020#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010R\u001a\u000203X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\u00020\u0012X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bS\u00105R\u0014\u0010\u0007\u001a\u00020\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bT\u0010UR\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010V\u001a\u00020#X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bW\u0010<\"\u0004\bX\u0010YR\u001a\u0010Z\u001a\u00020#X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b[\u0010<\"\u0004\b\\\u0010YR\u001a\u0010]\u001a\u00020#X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b^\u0010<\"\u0004\b_\u0010YR\u001a\u0010`\u001a\u00020#X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\ba\u0010<\"\u0004\bb\u0010YR\u001a\u0010c\u001a\u00020#X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bd\u0010<\"\u0004\be\u0010YR\u001a\u0010f\u001a\u000e\u0012\u0004\u0012\u00020g\u0012\u0004\u0012\u00020K0*X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010h\u001a\u000200X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010i\u001a\u00020#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010j\u001a\u00020#X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bk\u0010<R\u000e\u0010l\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010m\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010n\u001a\u00020 X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bo\u0010p\"\u0004\bq\u0010rR\u000e\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\u00020\u001eX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bs\u0010tR\u0014\u0010u\u001a\u00020\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bv\u0010UR\u000e\u0010w\u001a\u00020#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010y\u001a\u00020\b2\u0006\u0010x\u001a\u00020\b@BX\u0080\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\bz\u0010UR\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u00c0\u0001"}, d2={"Lcom/datadog/android/rum/internal/domain/scope/RumViewScope;", "Lcom/datadog/android/rum/internal/domain/scope/RumScope;", "parentScope", "sdkCore", "Lcom/datadog/android/v2/api/SdkCore;", "key", "", "name", "", "eventTime", "Lcom/datadog/android/rum/internal/domain/Time;", "initialAttributes", "", "viewChangedListener", "Lcom/datadog/android/rum/internal/domain/scope/RumViewChangedListener;", "firstPartyHostHeaderTypeResolver", "Lcom/datadog/android/core/internal/net/FirstPartyHostHeaderTypeResolver;", "cpuVitalMonitor", "Lcom/datadog/android/rum/internal/vitals/VitalMonitor;", "memoryVitalMonitor", "frameRateVitalMonitor", "contextProvider", "Lcom/datadog/android/v2/core/internal/ContextProvider;", "buildSdkVersionProvider", "Lcom/datadog/android/core/internal/system/BuildSdkVersionProvider;", "viewUpdatePredicate", "Lcom/datadog/android/rum/internal/domain/scope/ViewUpdatePredicate;", "featuresContextResolver", "Lcom/datadog/android/rum/internal/FeaturesContextResolver;", "type", "Lcom/datadog/android/rum/internal/domain/scope/RumViewScope$RumViewType;", "trackFrustrations", "", "(Lcom/datadog/android/rum/internal/domain/scope/RumScope;Lcom/datadog/android/v2/api/SdkCore;Ljava/lang/Object;Ljava/lang/String;Lcom/datadog/android/rum/internal/domain/Time;Ljava/util/Map;Lcom/datadog/android/rum/internal/domain/scope/RumViewChangedListener;Lcom/datadog/android/core/internal/net/FirstPartyHostHeaderTypeResolver;Lcom/datadog/android/rum/internal/vitals/VitalMonitor;Lcom/datadog/android/rum/internal/vitals/VitalMonitor;Lcom/datadog/android/rum/internal/vitals/VitalMonitor;Lcom/datadog/android/v2/core/internal/ContextProvider;Lcom/datadog/android/core/internal/system/BuildSdkVersionProvider;Lcom/datadog/android/rum/internal/domain/scope/ViewUpdatePredicate;Lcom/datadog/android/rum/internal/FeaturesContextResolver;Lcom/datadog/android/rum/internal/domain/scope/RumViewScope$RumViewType;Z)V", "actionCount", "", "activeActionScope", "getActiveActionScope$dd_sdk_android_release", "()Lcom/datadog/android/rum/internal/domain/scope/RumScope;", "setActiveActionScope$dd_sdk_android_release", "(Lcom/datadog/android/rum/internal/domain/scope/RumScope;)V", "activeResourceScopes", "", "getActiveResourceScopes$dd_sdk_android_release", "()Ljava/util/Map;", "attributes", "getAttributes$dd_sdk_android_release", "cpuTicks", "", "Ljava/lang/Double;", "cpuVitalListener", "Lcom/datadog/android/rum/internal/vitals/VitalListener;", "getCpuVitalMonitor$dd_sdk_android_release", "()Lcom/datadog/android/rum/internal/vitals/VitalMonitor;", "crashCount", "customTimings", "getCustomTimings$dd_sdk_android_release", "errorCount", "eventTimestamp", "getEventTimestamp$dd_sdk_android_release", "()J", "featureFlags", "getFeatureFlags$dd_sdk_android_release", "getFirstPartyHostHeaderTypeResolver$dd_sdk_android_release", "()Lcom/datadog/android/core/internal/net/FirstPartyHostHeaderTypeResolver;", "frameRateVitalListener", "getFrameRateVitalMonitor$dd_sdk_android_release", "frozenFrameCount", "frustrationCount", "", "keyRef", "Ljava/lang/ref/Reference;", "getKeyRef$dd_sdk_android_release", "()Ljava/lang/ref/Reference;", "lastFrameRateInfo", "Lcom/datadog/android/rum/internal/vitals/VitalInfo;", "lastMemoryInfo", "loadingTime", "Ljava/lang/Long;", "loadingType", "Lcom/datadog/android/rum/model/ViewEvent$LoadingType;", "longTaskCount", "memoryVitalListener", "getMemoryVitalMonitor$dd_sdk_android_release", "getName$dd_sdk_android_release", "()Ljava/lang/String;", "pendingActionCount", "getPendingActionCount$dd_sdk_android_release", "setPendingActionCount$dd_sdk_android_release", "(J)V", "pendingErrorCount", "getPendingErrorCount$dd_sdk_android_release", "setPendingErrorCount$dd_sdk_android_release", "pendingFrozenFrameCount", "getPendingFrozenFrameCount$dd_sdk_android_release", "setPendingFrozenFrameCount$dd_sdk_android_release", "pendingLongTaskCount", "getPendingLongTaskCount$dd_sdk_android_release", "setPendingLongTaskCount$dd_sdk_android_release", "pendingResourceCount", "getPendingResourceCount$dd_sdk_android_release", "setPendingResourceCount$dd_sdk_android_release", "performanceMetrics", "Lcom/datadog/android/rum/RumPerformanceMetric;", "refreshRateScale", "resourceCount", "serverTimeOffsetInMs", "getServerTimeOffsetInMs$dd_sdk_android_release", "sessionId", "startedNanos", "stopped", "getStopped$dd_sdk_android_release", "()Z", "setStopped$dd_sdk_android_release", "(Z)V", "getType$dd_sdk_android_release", "()Lcom/datadog/android/rum/internal/domain/scope/RumViewScope$RumViewType;", "url", "getUrl$dd_sdk_android_release", "version", "<set-?>", "viewId", "getViewId$dd_sdk_android_release", "addExtraAttributes", "delegateEventToAction", "", "event", "Lcom/datadog/android/rum/internal/domain/scope/RumRawEvent;", "writer", "Lcom/datadog/android/v2/core/internal/storage/DataWriter;", "delegateEventToChildren", "delegateEventToResources", "detectRefreshRateScale", "getRumContext", "Lcom/datadog/android/rum/internal/domain/RumContext;", "handleEvent", "isActive", "isViewComplete", "onActionDropped", "Lcom/datadog/android/rum/internal/domain/scope/RumRawEvent$ActionDropped;", "onActionSent", "Lcom/datadog/android/rum/internal/domain/scope/RumRawEvent$ActionSent;", "onAddCustomTiming", "Lcom/datadog/android/rum/internal/domain/scope/RumRawEvent$AddCustomTiming;", "onAddError", "Lcom/datadog/android/rum/internal/domain/scope/RumRawEvent$AddError;", "onAddFeatureFlagEvaluation", "Lcom/datadog/android/rum/internal/domain/scope/RumRawEvent$AddFeatureFlagEvaluation;", "onAddLongTask", "Lcom/datadog/android/rum/internal/domain/scope/RumRawEvent$AddLongTask;", "onApplicationStarted", "Lcom/datadog/android/rum/internal/domain/scope/RumRawEvent$ApplicationStarted;", "onErrorDropped", "Lcom/datadog/android/rum/internal/domain/scope/RumRawEvent$ErrorDropped;", "onErrorSent", "Lcom/datadog/android/rum/internal/domain/scope/RumRawEvent$ErrorSent;", "onKeepAlive", "Lcom/datadog/android/rum/internal/domain/scope/RumRawEvent$KeepAlive;", "onLongTaskDropped", "Lcom/datadog/android/rum/internal/domain/scope/RumRawEvent$LongTaskDropped;", "onLongTaskSent", "Lcom/datadog/android/rum/internal/domain/scope/RumRawEvent$LongTaskSent;", "onResourceDropped", "Lcom/datadog/android/rum/internal/domain/scope/RumRawEvent$ResourceDropped;", "onResourceSent", "Lcom/datadog/android/rum/internal/domain/scope/RumRawEvent$ResourceSent;", "onStartAction", "Lcom/datadog/android/rum/internal/domain/scope/RumRawEvent$StartAction;", "onStartResource", "Lcom/datadog/android/rum/internal/domain/scope/RumRawEvent$StartResource;", "onStartView", "Lcom/datadog/android/rum/internal/domain/scope/RumRawEvent$StartView;", "onStopSession", "Lcom/datadog/android/rum/internal/domain/scope/RumRawEvent$StopSession;", "onStopView", "Lcom/datadog/android/rum/internal/domain/scope/RumRawEvent$StopView;", "onUpdatePerformanceMetric", "Lcom/datadog/android/rum/internal/domain/scope/RumRawEvent$UpdatePerformanceMetric;", "onUpdateViewLoadingTime", "Lcom/datadog/android/rum/internal/domain/scope/RumRawEvent$UpdateViewLoadingTime;", "resolveCustomTimings", "Lcom/datadog/android/rum/model/ViewEvent$CustomTimings;", "resolveRefreshRateInfo", "refreshRateInfo", "(Lcom/datadog/android/rum/internal/vitals/VitalInfo;)Ljava/lang/Boolean;", "resolveViewDuration", "sendViewChanged", "sendViewUpdate", "updateActiveActionScope", "scope", "Companion", "RumViewType", "dd-sdk-android_release"})
public class RumViewScope
implements RumScope {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final RumScope parentScope;
    @NotNull
    private final SdkCore sdkCore;
    @NotNull
    private final String name;
    @Nullable
    private final RumViewChangedListener viewChangedListener;
    @NotNull
    private final FirstPartyHostHeaderTypeResolver firstPartyHostHeaderTypeResolver;
    @NotNull
    private final VitalMonitor cpuVitalMonitor;
    @NotNull
    private final VitalMonitor memoryVitalMonitor;
    @NotNull
    private final VitalMonitor frameRateVitalMonitor;
    @NotNull
    private final ContextProvider contextProvider;
    @NotNull
    private final BuildSdkVersionProvider buildSdkVersionProvider;
    @NotNull
    private final ViewUpdatePredicate viewUpdatePredicate;
    @NotNull
    private final FeaturesContextResolver featuresContextResolver;
    @NotNull
    private final RumViewType type;
    private final boolean trackFrustrations;
    @NotNull
    private final String url;
    @NotNull
    private final Reference<Object> keyRef;
    @NotNull
    private final Map<String, Object> attributes;
    @NotNull
    private String sessionId;
    @NotNull
    private String viewId;
    private final long startedNanos;
    private final long serverTimeOffsetInMs;
    private final long eventTimestamp;
    @Nullable
    private RumScope activeActionScope;
    @NotNull
    private final Map<String, RumScope> activeResourceScopes;
    private long resourceCount;
    private long actionCount;
    private int frustrationCount;
    private long errorCount;
    private long crashCount;
    private long longTaskCount;
    private long frozenFrameCount;
    private long pendingResourceCount;
    private long pendingActionCount;
    private long pendingErrorCount;
    private long pendingLongTaskCount;
    private long pendingFrozenFrameCount;
    private long version;
    @Nullable
    private Long loadingTime;
    @Nullable
    private ViewEvent.LoadingType loadingType;
    @NotNull
    private final Map<String, Long> customTimings;
    @NotNull
    private final Map<String, Object> featureFlags;
    private boolean stopped;
    @Nullable
    private Double cpuTicks;
    @NotNull
    private VitalListener cpuVitalListener;
    @Nullable
    private VitalInfo lastMemoryInfo;
    @NotNull
    private VitalListener memoryVitalListener;
    private double refreshRateScale;
    @Nullable
    private VitalInfo lastFrameRateInfo;
    @NotNull
    private VitalListener frameRateVitalListener;
    @NotNull
    private Map<RumPerformanceMetric, VitalInfo> performanceMetrics;
    public static final double STANDARD_FPS = 60.0;
    private static final long ONE_SECOND_NS;
    @NotNull
    public static final String ACTION_DROPPED_WARNING = "RUM Action (%s on %s) was dropped, because another action is still active for the same view";
    @NotNull
    public static final String RUM_CONTEXT_UPDATE_IGNORED_AT_STOP_VIEW_MESSAGE = "Trying to update global RUM context when StopView event arrived, but the context doesn't reference this view.";
    @NotNull
    public static final String RUM_CONTEXT_UPDATE_IGNORED_AT_ACTION_UPDATE_MESSAGE = "Trying to update active action in the global RUM context, but the context doesn't reference this view.";
    private static final long FROZEN_FRAME_THRESHOLD_NS;
    public static final int SLOW_RENDERED_THRESHOLD_FPS = 55;
    @NotNull
    public static final String NEGATIVE_DURATION_WARNING_MESSAGE = "The computed duration for your view: %s was 0 or negative. In order to keep the view we forced it to 1ns.";
    @Nullable
    private static final Field navControllerActivityField;

    /*
     * WARNING - void declaration
     */
    public RumViewScope(@NotNull RumScope parentScope, @NotNull SdkCore sdkCore, @NotNull Object key, @NotNull String name, @NotNull Time eventTime, @NotNull Map<String, ? extends Object> initialAttributes, @Nullable RumViewChangedListener viewChangedListener, @NotNull FirstPartyHostHeaderTypeResolver firstPartyHostHeaderTypeResolver, @NotNull VitalMonitor cpuVitalMonitor, @NotNull VitalMonitor memoryVitalMonitor, @NotNull VitalMonitor frameRateVitalMonitor, @NotNull ContextProvider contextProvider, @NotNull BuildSdkVersionProvider buildSdkVersionProvider, @NotNull ViewUpdatePredicate viewUpdatePredicate, @NotNull FeaturesContextResolver featuresContextResolver, @NotNull RumViewType type, boolean trackFrustrations2) {
        void $this$attributes_u24lambda_u2d0;
        Intrinsics.checkNotNullParameter((Object)parentScope, (String)"parentScope");
        Intrinsics.checkNotNullParameter((Object)sdkCore, (String)"sdkCore");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)eventTime, (String)"eventTime");
        Intrinsics.checkNotNullParameter(initialAttributes, (String)"initialAttributes");
        Intrinsics.checkNotNullParameter((Object)firstPartyHostHeaderTypeResolver, (String)"firstPartyHostHeaderTypeResolver");
        Intrinsics.checkNotNullParameter((Object)cpuVitalMonitor, (String)"cpuVitalMonitor");
        Intrinsics.checkNotNullParameter((Object)memoryVitalMonitor, (String)"memoryVitalMonitor");
        Intrinsics.checkNotNullParameter((Object)frameRateVitalMonitor, (String)"frameRateVitalMonitor");
        Intrinsics.checkNotNullParameter((Object)contextProvider, (String)"contextProvider");
        Intrinsics.checkNotNullParameter((Object)buildSdkVersionProvider, (String)"buildSdkVersionProvider");
        Intrinsics.checkNotNullParameter((Object)viewUpdatePredicate, (String)"viewUpdatePredicate");
        Intrinsics.checkNotNullParameter((Object)featuresContextResolver, (String)"featuresContextResolver");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        this.parentScope = parentScope;
        this.sdkCore = sdkCore;
        this.name = name;
        this.viewChangedListener = viewChangedListener;
        this.firstPartyHostHeaderTypeResolver = firstPartyHostHeaderTypeResolver;
        this.cpuVitalMonitor = cpuVitalMonitor;
        this.memoryVitalMonitor = memoryVitalMonitor;
        this.frameRateVitalMonitor = frameRateVitalMonitor;
        this.contextProvider = contextProvider;
        this.buildSdkVersionProvider = buildSdkVersionProvider;
        this.viewUpdatePredicate = viewUpdatePredicate;
        this.featuresContextResolver = featuresContextResolver;
        this.type = type;
        this.trackFrustrations = trackFrustrations2;
        this.url = StringsKt.replace$default((String)ViewUtilsKt.resolveViewUrl(key), (char)'.', (char)'/', (boolean)false, (int)4, null);
        this.keyRef = new WeakReference<Object>(key);
        Object object = MapsKt.toMutableMap(initialAttributes);
        Map map = object;
        RumViewScope rumViewScope = this;
        boolean bl = false;
        $this$attributes_u24lambda_u2d0.putAll(GlobalRum.INSTANCE.getGlobalAttributes$dd_sdk_android_release());
        rumViewScope.attributes = object;
        this.sessionId = this.parentScope.getRumContext().getSessionId();
        object = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"randomUUID().toString()");
        this.viewId = object;
        this.startedNanos = eventTime.getNanoTime();
        this.serverTimeOffsetInMs = this.sdkCore.getTime().getServerTimeOffsetMs();
        this.eventTimestamp = eventTime.getTimestamp() + this.serverTimeOffsetInMs;
        this.activeResourceScopes = new LinkedHashMap();
        this.version = 1L;
        this.customTimings = new LinkedHashMap();
        this.featureFlags = new LinkedHashMap();
        this.cpuVitalListener = new VitalListener(this){
            private double initialTickCount;
            final /* synthetic */ RumViewScope this$0;
            {
                this.this$0 = $receiver;
                this.initialTickCount = Double.NaN;
            }

            public void onVitalUpdate(@NotNull VitalInfo info) {
                Intrinsics.checkNotNullParameter((Object)info, (String)"info");
                if (Double.isNaN(this.initialTickCount)) {
                    this.initialTickCount = info.getMaxValue();
                } else {
                    RumViewScope.access$setCpuTicks$p(this.this$0, info.getMaxValue() - this.initialTickCount);
                }
            }
        };
        this.memoryVitalListener = new VitalListener(this){
            final /* synthetic */ RumViewScope this$0;
            {
                this.this$0 = $receiver;
            }

            public void onVitalUpdate(@NotNull VitalInfo info) {
                Intrinsics.checkNotNullParameter((Object)info, (String)"info");
                RumViewScope.access$setLastMemoryInfo$p(this.this$0, info);
            }
        };
        this.refreshRateScale = 1.0;
        this.frameRateVitalListener = new VitalListener(this){
            final /* synthetic */ RumViewScope this$0;
            {
                this.this$0 = $receiver;
            }

            public void onVitalUpdate(@NotNull VitalInfo info) {
                Intrinsics.checkNotNullParameter((Object)info, (String)"info");
                RumViewScope.access$setLastFrameRateInfo$p(this.this$0, info);
            }
        };
        this.performanceMetrics = new LinkedHashMap();
        this.sdkCore.updateFeatureContext("rum", (Function1<? super Map<String, Object>, Unit>)((Function1)new Function1<Map<String, Object>, Unit>(){

            public final void invoke(@NotNull Map<String, Object> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                it.putAll(this.getRumContext().toMap());
                it.put("view_timestamp_offset", this.getServerTimeOffsetInMs$dd_sdk_android_release());
            }
        }));
        this.attributes.putAll(GlobalRum.INSTANCE.getGlobalAttributes$dd_sdk_android_release());
        this.cpuVitalMonitor.register(this.cpuVitalListener);
        this.memoryVitalMonitor.register(this.memoryVitalListener);
        this.frameRateVitalMonitor.register(this.frameRateVitalListener);
        this.detectRefreshRateScale(key);
    }

    public /* synthetic */ RumViewScope(RumScope rumScope, SdkCore sdkCore, Object object, String string, Time time, Map map, RumViewChangedListener rumViewChangedListener, FirstPartyHostHeaderTypeResolver firstPartyHostHeaderTypeResolver, VitalMonitor vitalMonitor, VitalMonitor vitalMonitor2, VitalMonitor vitalMonitor3, ContextProvider contextProvider, BuildSdkVersionProvider buildSdkVersionProvider, ViewUpdatePredicate viewUpdatePredicate, FeaturesContextResolver featuresContextResolver, RumViewType rumViewType, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x1000) != 0) {
            buildSdkVersionProvider = new DefaultBuildSdkVersionProvider();
        }
        if ((n & 0x2000) != 0) {
            viewUpdatePredicate = new DefaultViewUpdatePredicate(0L, 1, null);
        }
        if ((n & 0x4000) != 0) {
            featuresContextResolver = new FeaturesContextResolver();
        }
        if ((n & 0x8000) != 0) {
            rumViewType = RumViewType.FOREGROUND;
        }
        this(rumScope, sdkCore, object, string, time, map, rumViewChangedListener, firstPartyHostHeaderTypeResolver, vitalMonitor, vitalMonitor2, vitalMonitor3, contextProvider, buildSdkVersionProvider, viewUpdatePredicate, featuresContextResolver, rumViewType, bl);
    }

    @NotNull
    public final String getName$dd_sdk_android_release() {
        return this.name;
    }

    @NotNull
    public final FirstPartyHostHeaderTypeResolver getFirstPartyHostHeaderTypeResolver$dd_sdk_android_release() {
        return this.firstPartyHostHeaderTypeResolver;
    }

    @NotNull
    public final VitalMonitor getCpuVitalMonitor$dd_sdk_android_release() {
        return this.cpuVitalMonitor;
    }

    @NotNull
    public final VitalMonitor getMemoryVitalMonitor$dd_sdk_android_release() {
        return this.memoryVitalMonitor;
    }

    @NotNull
    public final VitalMonitor getFrameRateVitalMonitor$dd_sdk_android_release() {
        return this.frameRateVitalMonitor;
    }

    @NotNull
    public final RumViewType getType$dd_sdk_android_release() {
        return this.type;
    }

    @NotNull
    public final String getUrl$dd_sdk_android_release() {
        return this.url;
    }

    @NotNull
    public final Reference<Object> getKeyRef$dd_sdk_android_release() {
        return this.keyRef;
    }

    @NotNull
    public final Map<String, Object> getAttributes$dd_sdk_android_release() {
        return this.attributes;
    }

    @NotNull
    public final String getViewId$dd_sdk_android_release() {
        return this.viewId;
    }

    public final long getServerTimeOffsetInMs$dd_sdk_android_release() {
        return this.serverTimeOffsetInMs;
    }

    public final long getEventTimestamp$dd_sdk_android_release() {
        return this.eventTimestamp;
    }

    @Nullable
    public final RumScope getActiveActionScope$dd_sdk_android_release() {
        return this.activeActionScope;
    }

    public final void setActiveActionScope$dd_sdk_android_release(@Nullable RumScope rumScope) {
        this.activeActionScope = rumScope;
    }

    @NotNull
    public final Map<String, RumScope> getActiveResourceScopes$dd_sdk_android_release() {
        return this.activeResourceScopes;
    }

    public final long getPendingResourceCount$dd_sdk_android_release() {
        return this.pendingResourceCount;
    }

    public final void setPendingResourceCount$dd_sdk_android_release(long l) {
        this.pendingResourceCount = l;
    }

    public final long getPendingActionCount$dd_sdk_android_release() {
        return this.pendingActionCount;
    }

    public final void setPendingActionCount$dd_sdk_android_release(long l) {
        this.pendingActionCount = l;
    }

    public final long getPendingErrorCount$dd_sdk_android_release() {
        return this.pendingErrorCount;
    }

    public final void setPendingErrorCount$dd_sdk_android_release(long l) {
        this.pendingErrorCount = l;
    }

    public final long getPendingLongTaskCount$dd_sdk_android_release() {
        return this.pendingLongTaskCount;
    }

    public final void setPendingLongTaskCount$dd_sdk_android_release(long l) {
        this.pendingLongTaskCount = l;
    }

    public final long getPendingFrozenFrameCount$dd_sdk_android_release() {
        return this.pendingFrozenFrameCount;
    }

    public final void setPendingFrozenFrameCount$dd_sdk_android_release(long l) {
        this.pendingFrozenFrameCount = l;
    }

    @NotNull
    public final Map<String, Long> getCustomTimings$dd_sdk_android_release() {
        return this.customTimings;
    }

    @NotNull
    public final Map<String, Object> getFeatureFlags$dd_sdk_android_release() {
        return this.featureFlags;
    }

    public final boolean getStopped$dd_sdk_android_release() {
        return this.stopped;
    }

    public final void setStopped$dd_sdk_android_release(boolean bl) {
        this.stopped = bl;
    }

    @Override
    @WorkerThread
    @Nullable
    public RumScope handleEvent(@NotNull RumRawEvent event, @NotNull DataWriter<Object> writer) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter(writer, (String)"writer");
        RumRawEvent rumRawEvent = event;
        if (rumRawEvent instanceof RumRawEvent.ResourceSent) {
            this.onResourceSent((RumRawEvent.ResourceSent)event, writer);
        } else if (rumRawEvent instanceof RumRawEvent.ActionSent) {
            this.onActionSent((RumRawEvent.ActionSent)event, writer);
        } else if (rumRawEvent instanceof RumRawEvent.ErrorSent) {
            this.onErrorSent((RumRawEvent.ErrorSent)event, writer);
        } else if (rumRawEvent instanceof RumRawEvent.LongTaskSent) {
            this.onLongTaskSent((RumRawEvent.LongTaskSent)event, writer);
        } else if (rumRawEvent instanceof RumRawEvent.ResourceDropped) {
            this.onResourceDropped((RumRawEvent.ResourceDropped)event);
        } else if (rumRawEvent instanceof RumRawEvent.ActionDropped) {
            this.onActionDropped((RumRawEvent.ActionDropped)event);
        } else if (rumRawEvent instanceof RumRawEvent.ErrorDropped) {
            this.onErrorDropped((RumRawEvent.ErrorDropped)event);
        } else if (rumRawEvent instanceof RumRawEvent.LongTaskDropped) {
            this.onLongTaskDropped((RumRawEvent.LongTaskDropped)event);
        } else if (rumRawEvent instanceof RumRawEvent.StartView) {
            this.onStartView((RumRawEvent.StartView)event, writer);
        } else if (rumRawEvent instanceof RumRawEvent.StopView) {
            this.onStopView((RumRawEvent.StopView)event, writer);
        } else if (rumRawEvent instanceof RumRawEvent.StartAction) {
            this.onStartAction((RumRawEvent.StartAction)event, writer);
        } else if (rumRawEvent instanceof RumRawEvent.StartResource) {
            this.onStartResource((RumRawEvent.StartResource)event, writer);
        } else if (rumRawEvent instanceof RumRawEvent.AddError) {
            this.onAddError((RumRawEvent.AddError)event, writer);
        } else if (rumRawEvent instanceof RumRawEvent.AddLongTask) {
            this.onAddLongTask((RumRawEvent.AddLongTask)event, writer);
        } else if (rumRawEvent instanceof RumRawEvent.AddFeatureFlagEvaluation) {
            this.onAddFeatureFlagEvaluation((RumRawEvent.AddFeatureFlagEvaluation)event, writer);
        } else if (rumRawEvent instanceof RumRawEvent.ApplicationStarted) {
            this.onApplicationStarted((RumRawEvent.ApplicationStarted)event, writer);
        } else if (rumRawEvent instanceof RumRawEvent.UpdateViewLoadingTime) {
            this.onUpdateViewLoadingTime((RumRawEvent.UpdateViewLoadingTime)event, writer);
        } else if (rumRawEvent instanceof RumRawEvent.AddCustomTiming) {
            this.onAddCustomTiming((RumRawEvent.AddCustomTiming)event, writer);
        } else if (rumRawEvent instanceof RumRawEvent.KeepAlive) {
            this.onKeepAlive((RumRawEvent.KeepAlive)event, writer);
        } else if (rumRawEvent instanceof RumRawEvent.StopSession) {
            this.onStopSession((RumRawEvent.StopSession)event, writer);
        } else if (rumRawEvent instanceof RumRawEvent.UpdatePerformanceMetric) {
            this.onUpdatePerformanceMetric((RumRawEvent.UpdatePerformanceMetric)event);
        } else {
            this.delegateEventToChildren(event, writer);
        }
        return this.isViewComplete() ? (RumScope)null : (RumScope)this;
    }

    @Override
    @NotNull
    public RumContext getRumContext() {
        RumScope rumScope;
        RumContext parentContext = this.parentScope.getRumContext();
        if (!Intrinsics.areEqual((Object)parentContext.getSessionId(), (Object)this.sessionId)) {
            this.sessionId = parentContext.getSessionId();
            String string = UUID.randomUUID().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"randomUUID().toString()");
            this.viewId = string;
        }
        RumActionScope rumActionScope = (rumScope = this.activeActionScope) instanceof RumActionScope ? (RumActionScope)rumScope : null;
        return RumContext.copy$default(parentContext, null, null, false, this.viewId, this.name, this.url, (String)(rumActionScope == null ? null : rumActionScope.getActionId$dd_sdk_android_release()), null, this.type, 135, null);
    }

    @Override
    public boolean isActive() {
        return !this.stopped;
    }

    @WorkerThread
    private final void onStartView(RumRawEvent.StartView event, DataWriter<Object> writer) {
        if (!this.stopped) {
            this.stopped = true;
            this.sendViewUpdate(event, writer);
            this.delegateEventToChildren(event, writer);
            this.sendViewChanged();
        }
    }

    @WorkerThread
    private final void onStopView(RumRawEvent.StopView event, DataWriter<Object> writer) {
        boolean shouldStop;
        this.delegateEventToChildren(event, writer);
        Object startedKey = this.keyRef.get();
        boolean bl = shouldStop = Intrinsics.areEqual((Object)event.getKey(), (Object)startedKey) || startedKey == null;
        if (shouldStop && !this.stopped) {
            RumContext rumContext = this.getRumContext();
            RumViewType rumViewType = RumViewType.NONE;
            RumContext newRumContext = RumContext.copy$default(rumContext, null, null, false, null, null, null, null, null, rumViewType, 135, null);
            this.sdkCore.updateFeatureContext("rum", (Function1<? super Map<String, Object>, Unit>)((Function1)new Function1<Map<String, Object>, Unit>(this, newRumContext){
                final /* synthetic */ RumViewScope this$0;
                final /* synthetic */ RumContext $newRumContext;
                {
                    this.this$0 = $receiver;
                    this.$newRumContext = $newRumContext;
                    super(1);
                }

                public final void invoke(@NotNull Map<String, Object> currentRumContext) {
                    boolean canUpdate;
                    Intrinsics.checkNotNullParameter(currentRumContext, (String)"currentRumContext");
                    boolean bl = !Intrinsics.areEqual((Object)currentRumContext.get("session_id"), (Object)RumViewScope.access$getSessionId$p(this.this$0)) ? true : (canUpdate = Intrinsics.areEqual((Object)currentRumContext.get("view_id"), (Object)this.this$0.getViewId$dd_sdk_android_release()));
                    if (canUpdate) {
                        currentRumContext.clear();
                        currentRumContext.putAll(this.$newRumContext.toMap());
                    } else {
                        InternalLogger.Target[] targetArray = new InternalLogger.Target[]{InternalLogger.Target.MAINTAINER, InternalLogger.Target.TELEMETRY};
                        InternalLogger.DefaultImpls.log$default(RuntimeUtilsKt.getInternalLogger(), InternalLogger.Level.DEBUG, CollectionsKt.listOf((Object[])targetArray), "Trying to update global RUM context when StopView event arrived, but the context doesn't reference this view.", null, 8, null);
                    }
                }
            }));
            this.attributes.putAll(event.getAttributes());
            this.stopped = true;
            this.sendViewUpdate(event, writer);
            this.sendViewChanged();
        }
    }

    @WorkerThread
    private final void onStartAction(RumRawEvent.StartAction event, DataWriter<Object> writer) {
        this.delegateEventToChildren(event, writer);
        if (this.stopped) {
            return;
        }
        if (this.activeActionScope != null) {
            if (event.getType() == RumActionType.CUSTOM && !event.getWaitForStop()) {
                RumScope customActionScope = RumActionScope.Companion.fromEvent(this, this.sdkCore, event, this.serverTimeOffsetInMs, this.contextProvider, this.featuresContextResolver, this.trackFrustrations);
                long l = this.pendingActionCount;
                this.pendingActionCount = l + 1L;
                customActionScope.handleEvent(new RumRawEvent.SendCustomActionNow(null, 1, null), writer);
                return;
            }
            InternalLogger internalLogger = RuntimeUtilsKt.getInternalLogger();
            String string = ACTION_DROPPED_WARNING;
            Locale locale = Locale.US;
            Object[] objectArray = new Object[]{event.getType(), event.getName()};
            String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(locale, this, *args)");
            InternalLogger.DefaultImpls.log$default(internalLogger, InternalLogger.Level.WARN, InternalLogger.Target.USER, string2, null, 8, null);
            return;
        }
        this.updateActiveActionScope(RumActionScope.Companion.fromEvent(this, this.sdkCore, event, this.serverTimeOffsetInMs, this.contextProvider, this.featuresContextResolver, this.trackFrustrations));
        long l = this.pendingActionCount;
        this.pendingActionCount = l + 1L;
    }

    @WorkerThread
    private final void onStartResource(RumRawEvent.StartResource event, DataWriter<Object> writer) {
        this.delegateEventToChildren(event, writer);
        if (this.stopped) {
            return;
        }
        RumRawEvent.StartResource updatedEvent = RumRawEvent.StartResource.copy$default(event, null, null, null, this.addExtraAttributes(event.getAttributes()), null, 23, null);
        this.activeResourceScopes.put(event.getKey(), RumResourceScope.Companion.fromEvent(this, this.sdkCore, updatedEvent, this.firstPartyHostHeaderTypeResolver, this.serverTimeOffsetInMs, this.contextProvider, this.featuresContextResolver));
        long l = this.pendingResourceCount;
        this.pendingResourceCount = l + 1L;
    }

    @WorkerThread
    private final void onAddError(RumRawEvent.AddError event, DataWriter<Object> writer) {
        String string;
        boolean isFatal;
        this.delegateEventToChildren(event, writer);
        if (this.stopped) {
            return;
        }
        RumContext rumContext = this.getRumContext();
        Map<String, Object> updatedAttributes = this.addExtraAttributes(event.getAttributes());
        Object object = updatedAttributes.remove("_dd.error.is_crash");
        boolean bl = isFatal = Intrinsics.areEqual((Object)(object instanceof Boolean ? (Boolean)object : null), (Object)true) || event.isFatal();
        if (this.crashCount > 0L && isFatal) {
            return;
        }
        String string2 = event.getType();
        if (string2 == null) {
            Throwable throwable = event.getThrowable();
            if (throwable == null) {
                string2 = null;
            } else {
                Class<?> clazz = throwable.getClass();
                string2 = clazz == null ? null : clazz.getCanonicalName();
            }
        }
        String errorType = string2;
        Throwable throwable = event.getThrowable();
        if (throwable == null) {
            string = "";
        } else {
            string = throwable.getMessage();
            if (string == null) {
                string = "";
            }
        }
        String throwableMessage = string;
        String message = !StringsKt.isBlank((CharSequence)throwableMessage) && !Intrinsics.areEqual((Object)event.getMessage(), (Object)throwableMessage) ? event.getMessage() + ": " + throwableMessage : event.getMessage();
        FeatureScope featureScope = this.sdkCore.getFeature("rum");
        if (featureScope != null) {
            FeatureScope.DefaultImpls.withWriteContext$default(featureScope, false, (Function2)new Function2<DatadogContext, EventBatchWriter, Unit>(this, event, message, isFatal, errorType, rumContext, updatedAttributes, writer){
                final /* synthetic */ RumViewScope this$0;
                final /* synthetic */ RumRawEvent.AddError $event;
                final /* synthetic */ String $message;
                final /* synthetic */ boolean $isFatal;
                final /* synthetic */ String $errorType;
                final /* synthetic */ RumContext $rumContext;
                final /* synthetic */ Map<String, Object> $updatedAttributes;
                final /* synthetic */ DataWriter<Object> $writer;
                {
                    this.this$0 = $receiver;
                    this.$event = $event;
                    this.$message = $message;
                    this.$isFatal = $isFatal;
                    this.$errorType = $errorType;
                    this.$rumContext = $rumContext;
                    this.$updatedAttributes = $updatedAttributes;
                    this.$writer = $writer;
                    super(2);
                }

                public final void invoke(@NotNull DatadogContext datadogContext, @NotNull EventBatchWriter eventBatchWriter) {
                    ErrorEvent.Action action;
                    Intrinsics.checkNotNullParameter((Object)datadogContext, (String)"datadogContext");
                    Intrinsics.checkNotNullParameter((Object)eventBatchWriter, (String)"eventBatchWriter");
                    UserInfo user = datadogContext.getUserInfo();
                    boolean hasReplay = RumViewScope.access$getFeaturesContextResolver$p(this.this$0).resolveHasReplay(datadogContext);
                    long l = this.$event.getEventTime().getTimestamp() + this.this$0.getServerTimeOffsetInMs$dd_sdk_android_release();
                    ErrorEvent.Context context = new ErrorEvent.Context(this.this$0.getFeatureFlags$dd_sdk_android_release());
                    ErrorEvent.ErrorSource errorSource = RumEventExtKt.toSchemaSource(this.$event.getSource());
                    String string = this.$event.getStacktrace();
                    if (string == null) {
                        Throwable throwable = this.$event.getThrowable();
                        string = throwable == null ? null : ThrowableExtKt.loggableStackTrace(throwable);
                    }
                    ErrorEvent.Error error = new ErrorEvent.Error(null, this.$message, errorSource, string, null, this.$isFatal, this.$errorType, null, null, RumEventExtKt.toSchemaSourceType(this.$event.getSourceType()), null, 1425, null);
                    String string2 = this.$rumContext.getActionId();
                    if (string2 == null) {
                        action = null;
                    } else {
                        String it = string2;
                        boolean bl = false;
                        action = new ErrorEvent.Action(CollectionsKt.listOf((Object)it));
                    }
                    ErrorEvent.Action action2 = action;
                    String string3 = this.$rumContext.getViewId();
                    if (string3 == null) {
                        string3 = "";
                    }
                    Object object = string3;
                    Object object2 = this.$rumContext.getViewName();
                    String string4 = this.$rumContext.getViewUrl();
                    if (string4 == null) {
                        string4 = "";
                    }
                    Object object3 = string4;
                    ErrorEvent.View view = new ErrorEvent.View((String)object, null, (String)object3, (String)object2, null, 18, null);
                    object = user.hasUserData$dd_sdk_android_release() ? new ErrorEvent.Usr(user.getId(), user.getName(), user.getEmail(), MapsKt.toMutableMap(user.getAdditionalProperties())) : (ErrorEvent.Usr)null;
                    object2 = RumEventExtKt.toErrorConnectivity(datadogContext.getNetworkInfo());
                    object3 = new ErrorEvent.Application(this.$rumContext.getApplicationId());
                    ErrorEvent.ErrorEventSession errorEventSession = new ErrorEvent.ErrorEventSession(this.$rumContext.getSessionId(), ErrorEvent.ErrorEventSessionType.USER, hasReplay);
                    ErrorEvent.ErrorEventSource errorEventSource = RumEventExtKt.tryFromSource(ErrorEvent.ErrorEventSource.Companion, datadogContext.getSource());
                    ErrorEvent.Os os = new ErrorEvent.Os(datadogContext.getDeviceInfo().getOsName(), datadogContext.getDeviceInfo().getOsVersion(), datadogContext.getDeviceInfo().getOsMajorVersion());
                    ErrorEvent.Device device = new ErrorEvent.Device(RumEventExtKt.toErrorSchemaType(datadogContext.getDeviceInfo().getDeviceType()), datadogContext.getDeviceInfo().getDeviceName(), datadogContext.getDeviceInfo().getDeviceModel(), datadogContext.getDeviceInfo().getDeviceBrand(), datadogContext.getDeviceInfo().getArchitecture());
                    ErrorEvent.Context context2 = new ErrorEvent.Context(this.$updatedAttributes);
                    ErrorEvent.Dd dd = new ErrorEvent.Dd(new ErrorEvent.DdSession(ErrorEvent.Plan.PLAN_1), null, 2, null);
                    String string5 = datadogContext.getService();
                    String string6 = datadogContext.getVersion();
                    ErrorEvent errorEvent = new ErrorEvent(l, (ErrorEvent.Application)object3, string5, string6, errorEventSession, errorEventSource, view, (ErrorEvent.Usr)object, (ErrorEvent.Connectivity)object2, null, null, null, os, device, dd, context2, action2, error, context, 3584, null);
                    this.$writer.write(eventBatchWriter, errorEvent);
                }
            }, 1, null);
        }
        if (isFatal) {
            long l = this.errorCount;
            this.errorCount = l + 1L;
            l = this.crashCount;
            this.crashCount = l + 1L;
            this.sendViewUpdate(event, writer);
        } else {
            long l = this.pendingErrorCount;
            this.pendingErrorCount = l + 1L;
        }
    }

    @WorkerThread
    private final void onAddCustomTiming(RumRawEvent.AddCustomTiming event, DataWriter<Object> writer) {
        if (this.stopped) {
            return;
        }
        this.customTimings.put(event.getName(), Math.max(event.getEventTime().getNanoTime() - this.startedNanos, 1L));
        this.sendViewUpdate(event, writer);
    }

    private final void onUpdatePerformanceMetric(RumRawEvent.UpdatePerformanceMetric event) {
        if (this.stopped) {
            return;
        }
        double value = event.getValue();
        VitalInfo vitalInfo = this.performanceMetrics.get((Object)event.getMetric());
        if (vitalInfo == null) {
            vitalInfo = VitalInfo.Companion.getEMPTY();
        }
        VitalInfo vitalInfo2 = vitalInfo;
        int newSampleCount = vitalInfo2.getSampleCount() + 1;
        double meanValue = (value + (double)vitalInfo2.getSampleCount() * vitalInfo2.getMeanValue()) / (double)newSampleCount;
        Map<RumPerformanceMetric, VitalInfo> map = this.performanceMetrics;
        RumPerformanceMetric rumPerformanceMetric = event.getMetric();
        double d = vitalInfo2.getMinValue();
        double d2 = Math.min(value, d);
        d = vitalInfo2.getMaxValue();
        VitalInfo vitalInfo3 = new VitalInfo(newSampleCount, d2, Math.max(value, d), meanValue);
        map.put(rumPerformanceMetric, vitalInfo3);
    }

    @WorkerThread
    private final void onStopSession(RumRawEvent.StopSession event, DataWriter<Object> writer) {
        this.stopped = true;
        this.sendViewUpdate(event, writer);
    }

    @WorkerThread
    private final void onKeepAlive(RumRawEvent.KeepAlive event, DataWriter<Object> writer) {
        this.delegateEventToChildren(event, writer);
        if (this.stopped) {
            return;
        }
        this.sendViewUpdate(event, writer);
    }

    @WorkerThread
    private final void delegateEventToChildren(RumRawEvent event, DataWriter<Object> writer) {
        this.delegateEventToResources(event, writer);
        this.delegateEventToAction(event, writer);
    }

    @WorkerThread
    private final void delegateEventToAction(RumRawEvent event, DataWriter<Object> writer) {
        RumScope updatedAction;
        RumScope currentAction = this.activeActionScope;
        if (currentAction != null && (updatedAction = currentAction.handleEvent(event, writer)) == null) {
            this.updateActiveActionScope(null);
        }
    }

    private final void updateActiveActionScope(RumScope scope) {
        this.activeActionScope = scope;
        RumContext newRumContext = this.getRumContext();
        this.sdkCore.updateFeatureContext("rum", (Function1<? super Map<String, Object>, Unit>)((Function1)new Function1<Map<String, Object>, Unit>(this, newRumContext){
            final /* synthetic */ RumViewScope this$0;
            final /* synthetic */ RumContext $newRumContext;
            {
                this.this$0 = $receiver;
                this.$newRumContext = $newRumContext;
                super(1);
            }

            public final void invoke(@NotNull Map<String, Object> currentRumContext) {
                boolean canUpdate;
                Intrinsics.checkNotNullParameter(currentRumContext, (String)"currentRumContext");
                boolean bl = !Intrinsics.areEqual((Object)currentRumContext.get("session_id"), (Object)RumViewScope.access$getSessionId$p(this.this$0)) ? true : (canUpdate = Intrinsics.areEqual((Object)currentRumContext.get("view_id"), (Object)this.this$0.getViewId$dd_sdk_android_release()));
                if (canUpdate) {
                    currentRumContext.clear();
                    currentRumContext.putAll(this.$newRumContext.toMap());
                } else {
                    InternalLogger.Target[] targetArray = new InternalLogger.Target[]{InternalLogger.Target.MAINTAINER, InternalLogger.Target.TELEMETRY};
                    InternalLogger.DefaultImpls.log$default(RuntimeUtilsKt.getInternalLogger(), InternalLogger.Level.DEBUG, CollectionsKt.listOf((Object[])targetArray), "Trying to update active action in the global RUM context, but the context doesn't reference this view.", null, 8, null);
                }
            }
        }));
    }

    @WorkerThread
    private final void delegateEventToResources(RumRawEvent event, DataWriter<Object> writer) {
        Iterator<Map.Entry<String, RumScope>> iterator = this.activeResourceScopes.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, RumScope> entry = iterator.next();
            RumScope scope = entry.getValue().handleEvent(event, writer);
            if (scope != null) continue;
            iterator.remove();
        }
    }

    @WorkerThread
    private final void onResourceSent(RumRawEvent.ResourceSent event, DataWriter<Object> writer) {
        if (Intrinsics.areEqual((Object)event.getViewId(), (Object)this.viewId)) {
            long l = this.pendingResourceCount;
            this.pendingResourceCount = l + -1L;
            l = this.resourceCount;
            this.resourceCount = l + 1L;
            this.sendViewUpdate(event, writer);
        }
    }

    @WorkerThread
    private final void onActionSent(RumRawEvent.ActionSent event, DataWriter<Object> writer) {
        if (Intrinsics.areEqual((Object)event.getViewId(), (Object)this.viewId)) {
            long l = this.pendingActionCount;
            this.pendingActionCount = l + -1L;
            l = this.actionCount;
            this.actionCount = l + 1L;
            this.frustrationCount += event.getFrustrationCount();
            this.sendViewUpdate(event, writer);
        }
    }

    @WorkerThread
    private final void onLongTaskSent(RumRawEvent.LongTaskSent event, DataWriter<Object> writer) {
        if (Intrinsics.areEqual((Object)event.getViewId(), (Object)this.viewId)) {
            long l = this.pendingLongTaskCount;
            this.pendingLongTaskCount = l + -1L;
            l = this.longTaskCount;
            this.longTaskCount = l + 1L;
            if (event.isFrozenFrame()) {
                l = this.pendingFrozenFrameCount;
                this.pendingFrozenFrameCount = l + -1L;
                l = this.frozenFrameCount;
                this.frozenFrameCount = l + 1L;
            }
            this.sendViewUpdate(event, writer);
        }
    }

    @WorkerThread
    private final void onErrorSent(RumRawEvent.ErrorSent event, DataWriter<Object> writer) {
        if (Intrinsics.areEqual((Object)event.getViewId(), (Object)this.viewId)) {
            long l = this.pendingErrorCount;
            this.pendingErrorCount = l + -1L;
            l = this.errorCount;
            this.errorCount = l + 1L;
            this.sendViewUpdate(event, writer);
        }
    }

    private final void onResourceDropped(RumRawEvent.ResourceDropped event) {
        if (Intrinsics.areEqual((Object)event.getViewId(), (Object)this.viewId)) {
            long l = this.pendingResourceCount;
            this.pendingResourceCount = l + -1L;
        }
    }

    private final void onActionDropped(RumRawEvent.ActionDropped event) {
        if (Intrinsics.areEqual((Object)event.getViewId(), (Object)this.viewId)) {
            long l = this.pendingActionCount;
            this.pendingActionCount = l + -1L;
        }
    }

    private final void onErrorDropped(RumRawEvent.ErrorDropped event) {
        if (Intrinsics.areEqual((Object)event.getViewId(), (Object)this.viewId)) {
            long l = this.pendingErrorCount;
            this.pendingErrorCount = l + -1L;
        }
    }

    private final void onLongTaskDropped(RumRawEvent.LongTaskDropped event) {
        if (Intrinsics.areEqual((Object)event.getViewId(), (Object)this.viewId)) {
            long l = this.pendingLongTaskCount;
            this.pendingLongTaskCount = l + -1L;
            if (event.isFrozenFrame()) {
                l = this.pendingFrozenFrameCount;
                this.pendingFrozenFrameCount = l + -1L;
            }
        }
    }

    private final void sendViewUpdate(RumRawEvent event, DataWriter<Object> writer) {
        boolean viewComplete = this.isViewComplete();
        if (!this.viewUpdatePredicate.canUpdateView(viewComplete, event)) {
            return;
        }
        this.attributes.putAll(GlobalRum.INSTANCE.getGlobalAttributes$dd_sdk_android_release());
        long l = this.version;
        long eventVersion = this.version = l + 1L;
        Long eventLoadingTime = this.loadingTime;
        ViewEvent.LoadingType eventLoadingType = this.loadingType;
        long eventActionCount = this.actionCount;
        long eventErrorCount = this.errorCount;
        long eventResourceCount = this.resourceCount;
        long eventCrashCount = this.crashCount;
        long eventLongTaskCount = this.longTaskCount;
        long eventFrozenFramesCount = this.frozenFrameCount;
        Double eventCpuTicks = this.cpuTicks;
        int eventFrustrationCount = this.frustrationCount;
        VitalInfo vitalInfo = this.performanceMetrics.get((Object)RumPerformanceMetric.FLUTTER_BUILD_TIME);
        ViewEvent.FlutterBuildTime eventFlutterBuildTime = vitalInfo == null ? null : RumViewScope.Companion.toPerformanceMetric(vitalInfo);
        VitalInfo vitalInfo2 = this.performanceMetrics.get((Object)RumPerformanceMetric.FLUTTER_RASTER_TIME);
        ViewEvent.FlutterBuildTime eventFlutterRasterTime = vitalInfo2 == null ? null : RumViewScope.Companion.toPerformanceMetric(vitalInfo2);
        VitalInfo vitalInfo3 = this.performanceMetrics.get((Object)RumPerformanceMetric.JS_FRAME_TIME);
        ViewEvent.FlutterBuildTime eventJsRefreshRate = vitalInfo3 == null ? null : RumViewScope.Companion.toInversePerformanceMetric(vitalInfo3);
        double eventRefreshRateScale = this.refreshRateScale;
        long updatedDurationNs = this.resolveViewDuration(event);
        RumContext rumContext = this.getRumContext();
        ViewEvent.CustomTimings timings = this.resolveCustomTimings();
        VitalInfo memoryInfo = this.lastMemoryInfo;
        VitalInfo refreshRateInfo = this.lastFrameRateInfo;
        Boolean bl = this.resolveRefreshRateInfo(refreshRateInfo);
        boolean isSlowRendered = bl == null ? false : bl;
        FeatureScope featureScope = this.sdkCore.getFeature("rum");
        if (featureScope != null) {
            FeatureScope.DefaultImpls.withWriteContext$default(featureScope, false, (Function2)new Function2<DatadogContext, EventBatchWriter, Unit>(this, rumContext, eventActionCount, eventResourceCount, eventErrorCount, eventCrashCount, eventLongTaskCount, eventFrozenFramesCount, viewComplete, updatedDurationNs, eventCpuTicks, memoryInfo, refreshRateInfo, eventFrustrationCount, eventLoadingTime, eventLoadingType, timings, isSlowRendered, eventFlutterBuildTime, eventFlutterRasterTime, eventJsRefreshRate, eventVersion, writer, eventRefreshRateScale){
                final /* synthetic */ RumViewScope this$0;
                final /* synthetic */ RumContext $rumContext;
                final /* synthetic */ long $eventActionCount;
                final /* synthetic */ long $eventResourceCount;
                final /* synthetic */ long $eventErrorCount;
                final /* synthetic */ long $eventCrashCount;
                final /* synthetic */ long $eventLongTaskCount;
                final /* synthetic */ long $eventFrozenFramesCount;
                final /* synthetic */ boolean $viewComplete;
                final /* synthetic */ long $updatedDurationNs;
                final /* synthetic */ Double $eventCpuTicks;
                final /* synthetic */ VitalInfo $memoryInfo;
                final /* synthetic */ VitalInfo $refreshRateInfo;
                final /* synthetic */ int $eventFrustrationCount;
                final /* synthetic */ Long $eventLoadingTime;
                final /* synthetic */ ViewEvent.LoadingType $eventLoadingType;
                final /* synthetic */ ViewEvent.CustomTimings $timings;
                final /* synthetic */ boolean $isSlowRendered;
                final /* synthetic */ ViewEvent.FlutterBuildTime $eventFlutterBuildTime;
                final /* synthetic */ ViewEvent.FlutterBuildTime $eventFlutterRasterTime;
                final /* synthetic */ ViewEvent.FlutterBuildTime $eventJsRefreshRate;
                final /* synthetic */ long $eventVersion;
                final /* synthetic */ DataWriter<Object> $writer;
                final /* synthetic */ double $eventRefreshRateScale;
                {
                    this.this$0 = $receiver;
                    this.$rumContext = $rumContext;
                    this.$eventActionCount = $eventActionCount;
                    this.$eventResourceCount = $eventResourceCount;
                    this.$eventErrorCount = $eventErrorCount;
                    this.$eventCrashCount = $eventCrashCount;
                    this.$eventLongTaskCount = $eventLongTaskCount;
                    this.$eventFrozenFramesCount = $eventFrozenFramesCount;
                    this.$viewComplete = $viewComplete;
                    this.$updatedDurationNs = $updatedDurationNs;
                    this.$eventCpuTicks = $eventCpuTicks;
                    this.$memoryInfo = $memoryInfo;
                    this.$refreshRateInfo = $refreshRateInfo;
                    this.$eventFrustrationCount = $eventFrustrationCount;
                    this.$eventLoadingTime = $eventLoadingTime;
                    this.$eventLoadingType = $eventLoadingType;
                    this.$timings = $timings;
                    this.$isSlowRendered = $isSlowRendered;
                    this.$eventFlutterBuildTime = $eventFlutterBuildTime;
                    this.$eventFlutterRasterTime = $eventFlutterRasterTime;
                    this.$eventJsRefreshRate = $eventJsRefreshRate;
                    this.$eventVersion = $eventVersion;
                    this.$writer = $writer;
                    this.$eventRefreshRateScale = $eventRefreshRateScale;
                    super(2);
                }

                public final void invoke(@NotNull DatadogContext datadogContext, @NotNull EventBatchWriter eventBatchWriter) {
                    Double d;
                    double d2;
                    Double d3;
                    Double d4;
                    Double d5;
                    boolean bl;
                    Intrinsics.checkNotNullParameter((Object)datadogContext, (String)"datadogContext");
                    Intrinsics.checkNotNullParameter((Object)eventBatchWriter, (String)"eventBatchWriter");
                    UserInfo user = datadogContext.getUserInfo();
                    boolean hasReplay = RumViewScope.access$getFeaturesContextResolver$p(this.this$0).resolveHasReplay(datadogContext);
                    long l = this.this$0.getEventTimestamp$dd_sdk_android_release();
                    ViewEvent.Context context = new ViewEvent.Context(this.this$0.getFeatureFlags$dd_sdk_android_release());
                    String string = this.$rumContext.getViewId();
                    if (string == null) {
                        string = "";
                    }
                    Object object = string;
                    Object object2 = this.$rumContext.getViewName();
                    String string2 = this.$rumContext.getViewUrl();
                    if (string2 == null) {
                        string2 = "";
                    }
                    Object object3 = string2;
                    Object object4 = new ViewEvent.Action(this.$eventActionCount);
                    Object object5 = new ViewEvent.Resource(this.$eventResourceCount);
                    Object object6 = new ViewEvent.Error(this.$eventErrorCount);
                    Object object7 = new ViewEvent.Crash(this.$eventCrashCount);
                    Object object8 = new ViewEvent.LongTask(this.$eventLongTaskCount);
                    Object object9 = new ViewEvent.FrozenFrame(this.$eventFrozenFramesCount);
                    boolean bl2 = bl = !this.$viewComplete;
                    if (this.$updatedDurationNs >= RumViewScope.Companion.getONE_SECOND_NS$dd_sdk_android_release()) {
                        Double d6 = this.$eventCpuTicks;
                        if (d6 == null) {
                            d5 = null;
                        } else {
                            d4 = d6;
                            long l2 = this.$updatedDurationNs;
                            double it = ((Number)d4).doubleValue();
                            boolean bl3 = false;
                            d5 = it * (double)RumViewScope.Companion.getONE_SECOND_NS$dd_sdk_android_release() / (double)l2;
                        }
                    } else {
                        d5 = null;
                    }
                    Object object10 = d5;
                    VitalInfo vitalInfo = this.$memoryInfo;
                    Double d7 = vitalInfo == null ? null : Double.valueOf(vitalInfo.getMeanValue());
                    VitalInfo vitalInfo2 = this.$memoryInfo;
                    d4 = vitalInfo2 == null ? null : Double.valueOf(vitalInfo2.getMaxValue());
                    VitalInfo vitalInfo3 = this.$refreshRateInfo;
                    if (vitalInfo3 == null) {
                        d3 = null;
                    } else {
                        double d8;
                        d2 = d8 = vitalInfo3.getMeanValue();
                        double d9 = this.$eventRefreshRateScale;
                        double it = d2;
                        boolean bl4 = false;
                        d3 = it * d9;
                    }
                    Double d10 = d3;
                    VitalInfo vitalInfo4 = this.$refreshRateInfo;
                    if (vitalInfo4 == null) {
                        d = null;
                    } else {
                        double d11 = d2 = vitalInfo4.getMinValue();
                        double d12 = this.$eventRefreshRateScale;
                        double it = d11;
                        boolean bl5 = false;
                        d = it * d12;
                    }
                    Double d13 = d;
                    ViewEvent.Frustration frustration = new ViewEvent.Frustration(this.$eventFrustrationCount);
                    ViewEvent.View view = new ViewEvent.View((String)object, null, (String)object3, (String)object2, this.$eventLoadingTime, this.$eventLoadingType, this.$updatedDurationNs, null, null, null, null, null, null, null, null, null, null, this.$timings, bl, this.$isSlowRendered, (ViewEvent.Action)object4, (ViewEvent.Error)object6, (ViewEvent.Crash)object7, (ViewEvent.LongTask)object8, (ViewEvent.FrozenFrame)object9, (ViewEvent.Resource)object5, frustration, null, d7, d4, this.$eventCpuTicks, (Number)object10, d10, d13, this.$eventFlutterBuildTime, this.$eventFlutterRasterTime, this.$eventJsRefreshRate, 134348674, 0, null);
                    object = user.hasUserData$dd_sdk_android_release() ? new ViewEvent.Usr(user.getId(), user.getName(), user.getEmail(), MapsKt.toMutableMap(user.getAdditionalProperties())) : (ViewEvent.Usr)null;
                    object2 = new ViewEvent.Application(this.$rumContext.getApplicationId());
                    object3 = new ViewEvent.ViewEventSession(this.$rumContext.getSessionId(), ViewEvent.ViewEventSessionType.USER, hasReplay, null, this.$rumContext.isSessionActive(), 8, null);
                    object4 = RumEventExtKt.tryFromSource(ViewEvent.Source.Companion, datadogContext.getSource());
                    object5 = new ViewEvent.Os(datadogContext.getDeviceInfo().getOsName(), datadogContext.getDeviceInfo().getOsVersion(), datadogContext.getDeviceInfo().getOsMajorVersion());
                    object6 = new ViewEvent.Device(RumEventExtKt.toViewSchemaType(datadogContext.getDeviceInfo().getDeviceType()), datadogContext.getDeviceInfo().getDeviceName(), datadogContext.getDeviceInfo().getDeviceModel(), datadogContext.getDeviceInfo().getDeviceBrand(), datadogContext.getDeviceInfo().getArchitecture());
                    object7 = new ViewEvent.Context(this.this$0.getAttributes$dd_sdk_android_release());
                    object9 = new ViewEvent.DdSession(ViewEvent.Plan.PLAN_1);
                    object8 = new ViewEvent.Dd((ViewEvent.DdSession)object9, null, this.$eventVersion, 2, null);
                    object9 = RumEventExtKt.toViewConnectivity(datadogContext.getNetworkInfo());
                    String string3 = datadogContext.getService();
                    object10 = datadogContext.getVersion();
                    ViewEvent viewEvent = new ViewEvent(l, (ViewEvent.Application)object2, string3, (String)object10, (ViewEvent.ViewEventSession)object3, (ViewEvent.Source)((Object)object4), view, (ViewEvent.Usr)object, (ViewEvent.Connectivity)object9, null, null, null, (ViewEvent.Os)object5, (ViewEvent.Device)object6, (ViewEvent.Dd)object8, (ViewEvent.Context)object7, context, 3584, null);
                    this.$writer.write(eventBatchWriter, viewEvent);
                }
            }, 1, null);
        }
    }

    private final long resolveViewDuration(RumRawEvent event) {
        long l;
        long duration = event.getEventTime().getNanoTime() - this.startedNanos;
        if (duration <= 0L) {
            InternalLogger internalLogger = RuntimeUtilsKt.getInternalLogger();
            String string = NEGATIVE_DURATION_WARNING_MESSAGE;
            Locale locale = Locale.US;
            Object[] objectArray = new Object[]{this.name};
            String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(locale, this, *args)");
            InternalLogger.DefaultImpls.log$default(internalLogger, InternalLogger.Level.WARN, InternalLogger.Target.USER, string2, null, 8, null);
            l = 1L;
        } else {
            l = duration;
        }
        return l;
    }

    private final Boolean resolveRefreshRateInfo(VitalInfo refreshRateInfo) {
        return refreshRateInfo == null ? (Boolean)null : Boolean.valueOf(refreshRateInfo.getMeanValue() < 55.0);
    }

    private final ViewEvent.CustomTimings resolveCustomTimings() {
        return !this.customTimings.isEmpty() ? new ViewEvent.CustomTimings((Map<String, Long>)new LinkedHashMap<String, Long>(this.customTimings)) : (ViewEvent.CustomTimings)null;
    }

    private final Map<String, Object> addExtraAttributes(Map<String, ? extends Object> attributes) {
        Map map;
        Map $this$addExtraAttributes_u24lambda_u2d1 = map = MapsKt.toMutableMap(attributes);
        boolean bl = false;
        $this$addExtraAttributes_u24lambda_u2d1.putAll(GlobalRum.INSTANCE.getGlobalAttributes$dd_sdk_android_release());
        return map;
    }

    @WorkerThread
    private final void onUpdateViewLoadingTime(RumRawEvent.UpdateViewLoadingTime event, DataWriter<Object> writer) {
        Object startedKey = this.keyRef.get();
        if (!Intrinsics.areEqual((Object)event.getKey(), (Object)startedKey)) {
            return;
        }
        this.loadingTime = event.getLoadingTime();
        this.loadingType = event.getLoadingType();
        this.sendViewUpdate(event, writer);
    }

    @WorkerThread
    private final void onApplicationStarted(RumRawEvent.ApplicationStarted event, DataWriter<Object> writer) {
        long l = this.pendingActionCount;
        this.pendingActionCount = l + 1L;
        RumContext rumContext = this.getRumContext();
        Map<String, Object> attributes = GlobalRum.INSTANCE.getGlobalAttributes$dd_sdk_android_release();
        FeatureScope featureScope = this.sdkCore.getFeature("rum");
        if (featureScope != null) {
            FeatureScope.DefaultImpls.withWriteContext$default(featureScope, false, (Function2)new Function2<DatadogContext, EventBatchWriter, Unit>(this, event, rumContext, attributes, writer){
                final /* synthetic */ RumViewScope this$0;
                final /* synthetic */ RumRawEvent.ApplicationStarted $event;
                final /* synthetic */ RumContext $rumContext;
                final /* synthetic */ Map<String, Object> $attributes;
                final /* synthetic */ DataWriter<Object> $writer;
                {
                    this.this$0 = $receiver;
                    this.$event = $event;
                    this.$rumContext = $rumContext;
                    this.$attributes = $attributes;
                    this.$writer = $writer;
                    super(2);
                }

                public final void invoke(@NotNull DatadogContext datadogContext, @NotNull EventBatchWriter eventBatchWriter) {
                    Intrinsics.checkNotNullParameter((Object)datadogContext, (String)"datadogContext");
                    Intrinsics.checkNotNullParameter((Object)eventBatchWriter, (String)"eventBatchWriter");
                    UserInfo user = datadogContext.getUserInfo();
                    long l = this.this$0.getEventTimestamp$dd_sdk_android_release();
                    Object object = ActionEvent.ActionEventActionType.APPLICATION_START;
                    Object object2 = UUID.randomUUID().toString();
                    Object object3 = new ActionEvent.Error(0L);
                    Object object4 = new ActionEvent.Crash(0L);
                    Object object5 = new ActionEvent.LongTask(0L);
                    Object object6 = new ActionEvent.Resource(0L);
                    long l2 = this.$event.getApplicationStartupNanos();
                    ActionEvent.ActionEventAction actionEventAction = new ActionEvent.ActionEventAction((ActionEvent.ActionEventActionType)((Object)object), (String)object2, l2, null, null, (ActionEvent.Error)object3, (ActionEvent.Crash)object4, (ActionEvent.LongTask)object5, (ActionEvent.Resource)object6, 24, null);
                    String string = this.$rumContext.getViewId();
                    if (string == null) {
                        string = "";
                    }
                    object2 = string;
                    object3 = this.$rumContext.getViewName();
                    String string2 = this.$rumContext.getViewUrl();
                    if (string2 == null) {
                        string2 = "";
                    }
                    object4 = string2;
                    object = new ActionEvent.View((String)object2, null, (String)object4, (String)object3, null, 18, null);
                    object2 = user.hasUserData$dd_sdk_android_release() ? new ActionEvent.Usr(user.getId(), user.getName(), user.getEmail(), MapsKt.toMutableMap(user.getAdditionalProperties())) : (ActionEvent.Usr)null;
                    object3 = new ActionEvent.Application(this.$rumContext.getApplicationId());
                    object4 = new ActionEvent.ActionEventSession(this.$rumContext.getSessionId(), ActionEvent.ActionEventSessionType.USER, false);
                    object5 = RumEventExtKt.tryFromSource(ActionEvent.Source.Companion, datadogContext.getSource());
                    object6 = new ActionEvent.Os(datadogContext.getDeviceInfo().getOsName(), datadogContext.getDeviceInfo().getOsVersion(), datadogContext.getDeviceInfo().getOsMajorVersion());
                    ActionEvent.Device device = new ActionEvent.Device(RumEventExtKt.toActionSchemaType(datadogContext.getDeviceInfo().getDeviceType()), datadogContext.getDeviceInfo().getDeviceName(), datadogContext.getDeviceInfo().getDeviceModel(), datadogContext.getDeviceInfo().getDeviceBrand(), datadogContext.getDeviceInfo().getArchitecture());
                    ActionEvent.Context context = new ActionEvent.Context(this.$attributes);
                    ActionEvent.Dd dd = new ActionEvent.Dd(new ActionEvent.DdSession(ActionEvent.Plan.PLAN_1), null, null, 6, null);
                    ActionEvent.Connectivity connectivity = RumEventExtKt.toActionConnectivity(datadogContext.getNetworkInfo());
                    String string3 = datadogContext.getService();
                    String string4 = datadogContext.getVersion();
                    ActionEvent actionEvent = new ActionEvent(l, (ActionEvent.Application)object3, string3, string4, (ActionEvent.ActionEventSession)object4, (ActionEvent.Source)((Object)object5), (ActionEvent.View)object, (ActionEvent.Usr)object2, connectivity, null, null, null, (ActionEvent.Os)object6, device, dd, context, actionEventAction, 3584, null);
                    this.$writer.write(eventBatchWriter, actionEvent);
                }
            }, 1, null);
        }
    }

    @WorkerThread
    private final void onAddLongTask(RumRawEvent.AddLongTask event, DataWriter<Object> writer) {
        this.delegateEventToChildren(event, writer);
        if (this.stopped) {
            return;
        }
        RumContext rumContext = this.getRumContext();
        Map<String, Object> updatedAttributes = this.addExtraAttributes(MapsKt.mapOf((Pair)TuplesKt.to((Object)"long_task.target", (Object)event.getTarget())));
        long timestamp = event.getEventTime().getTimestamp() + this.serverTimeOffsetInMs;
        boolean isFrozenFrame = event.getDurationNs() > FROZEN_FRAME_THRESHOLD_NS;
        FeatureScope featureScope = this.sdkCore.getFeature("rum");
        if (featureScope != null) {
            FeatureScope.DefaultImpls.withWriteContext$default(featureScope, false, (Function2)new Function2<DatadogContext, EventBatchWriter, Unit>(this, timestamp, event, isFrozenFrame, rumContext, updatedAttributes, writer){
                final /* synthetic */ RumViewScope this$0;
                final /* synthetic */ long $timestamp;
                final /* synthetic */ RumRawEvent.AddLongTask $event;
                final /* synthetic */ boolean $isFrozenFrame;
                final /* synthetic */ RumContext $rumContext;
                final /* synthetic */ Map<String, Object> $updatedAttributes;
                final /* synthetic */ DataWriter<Object> $writer;
                {
                    this.this$0 = $receiver;
                    this.$timestamp = $timestamp;
                    this.$event = $event;
                    this.$isFrozenFrame = $isFrozenFrame;
                    this.$rumContext = $rumContext;
                    this.$updatedAttributes = $updatedAttributes;
                    this.$writer = $writer;
                    super(2);
                }

                public final void invoke(@NotNull DatadogContext datadogContext, @NotNull EventBatchWriter eventBatchWriter) {
                    LongTaskEvent.Action action;
                    Intrinsics.checkNotNullParameter((Object)datadogContext, (String)"datadogContext");
                    Intrinsics.checkNotNullParameter((Object)eventBatchWriter, (String)"eventBatchWriter");
                    UserInfo user = datadogContext.getUserInfo();
                    boolean hasReplay = RumViewScope.access$getFeaturesContextResolver$p(this.this$0).resolveHasReplay(datadogContext);
                    long l = this.$timestamp - TimeUnit.NANOSECONDS.toMillis(this.$event.getDurationNs());
                    LongTaskEvent.LongTask longTask = new LongTaskEvent.LongTask(null, this.$event.getDurationNs(), this.$isFrozenFrame, 1, null);
                    String string = this.$rumContext.getActionId();
                    if (string == null) {
                        action = null;
                    } else {
                        String it = string;
                        boolean bl = false;
                        action = new LongTaskEvent.Action(CollectionsKt.listOf((Object)it));
                    }
                    LongTaskEvent.Action action2 = action;
                    String string2 = this.$rumContext.getViewId();
                    if (string2 == null) {
                        string2 = "";
                    }
                    Object object = string2;
                    Object object2 = this.$rumContext.getViewName();
                    String string3 = this.$rumContext.getViewUrl();
                    if (string3 == null) {
                        string3 = "";
                    }
                    Object object3 = string3;
                    LongTaskEvent.View view = new LongTaskEvent.View((String)object, null, (String)object3, (String)object2, 2, null);
                    object = user.hasUserData$dd_sdk_android_release() ? new LongTaskEvent.Usr(user.getId(), user.getName(), user.getEmail(), MapsKt.toMutableMap(user.getAdditionalProperties())) : (LongTaskEvent.Usr)null;
                    object2 = RumEventExtKt.toLongTaskConnectivity(datadogContext.getNetworkInfo());
                    object3 = new LongTaskEvent.Application(this.$rumContext.getApplicationId());
                    LongTaskEvent.LongTaskEventSession longTaskEventSession = new LongTaskEvent.LongTaskEventSession(this.$rumContext.getSessionId(), LongTaskEvent.LongTaskEventSessionType.USER, hasReplay);
                    LongTaskEvent.Source source = RumEventExtKt.tryFromSource(LongTaskEvent.Source.Companion, datadogContext.getSource());
                    LongTaskEvent.Os os = new LongTaskEvent.Os(datadogContext.getDeviceInfo().getOsName(), datadogContext.getDeviceInfo().getOsVersion(), datadogContext.getDeviceInfo().getOsMajorVersion());
                    LongTaskEvent.Device device = new LongTaskEvent.Device(RumEventExtKt.toLongTaskSchemaType(datadogContext.getDeviceInfo().getDeviceType()), datadogContext.getDeviceInfo().getDeviceName(), datadogContext.getDeviceInfo().getDeviceModel(), datadogContext.getDeviceInfo().getDeviceBrand(), datadogContext.getDeviceInfo().getArchitecture());
                    LongTaskEvent.Context context = new LongTaskEvent.Context(this.$updatedAttributes);
                    LongTaskEvent.Dd dd = new LongTaskEvent.Dd(new LongTaskEvent.DdSession(LongTaskEvent.Plan.PLAN_1), null, null, 6, null);
                    String string4 = datadogContext.getService();
                    String string5 = datadogContext.getVersion();
                    LongTaskEvent longTaskEvent = new LongTaskEvent(l, (LongTaskEvent.Application)object3, string4, string5, longTaskEventSession, source, view, (LongTaskEvent.Usr)object, (LongTaskEvent.Connectivity)object2, null, null, null, os, device, dd, context, action2, longTask, 3584, null);
                    this.$writer.write(eventBatchWriter, longTaskEvent);
                }
            }, 1, null);
        }
        long l = this.pendingLongTaskCount;
        this.pendingLongTaskCount = l + 1L;
        if (isFrozenFrame) {
            l = this.pendingFrozenFrameCount;
            this.pendingFrozenFrameCount = l + 1L;
        }
    }

    private final void onAddFeatureFlagEvaluation(RumRawEvent.AddFeatureFlagEvaluation event, DataWriter<Object> writer) {
        if (this.stopped) {
            return;
        }
        this.featureFlags.put(event.getName(), event.getValue());
        this.sendViewUpdate(event, writer);
        this.sendViewChanged();
    }

    private final void sendViewChanged() {
        RumViewChangedListener rumViewChangedListener = this.viewChangedListener;
        if (rumViewChangedListener != null) {
            rumViewChangedListener.onViewChanged(new RumViewInfo(this.keyRef, this.name, this.attributes, this.isActive()));
        }
    }

    private final boolean isViewComplete() {
        long pending = this.pendingActionCount + this.pendingResourceCount + this.pendingErrorCount + this.pendingLongTaskCount;
        return this.stopped && this.activeResourceScopes.isEmpty() && pending <= 0L;
    }

    @SuppressLint(value={"NewApi"})
    private final void detectRefreshRateScale(Object key) {
        Display display;
        Object object;
        Activity activity;
        Object object2;
        Object object3 = key;
        if (object3 instanceof Activity) {
            object2 = (Activity)key;
        } else if (object3 instanceof androidx.fragment.app.Fragment) {
            object2 = (Activity)((androidx.fragment.app.Fragment)key).getActivity();
        } else if (object3 instanceof Fragment) {
            object2 = ((Fragment)key).getActivity();
        } else if (object3 instanceof NavigationViewTrackingStrategy.NavigationKey) {
            if (navControllerActivityField == null) {
                InternalLogger.DefaultImpls.log$default(RuntimeUtilsKt.getInternalLogger(), InternalLogger.Level.WARN, InternalLogger.Target.TELEMETRY, "Unable to retrieve the activity field from the navigationController", null, 8, null);
                object2 = null;
            } else {
                navControllerActivityField.setAccessible(true);
                Object object4 = navControllerActivityField.get(((NavigationViewTrackingStrategy.NavigationKey)key).getController());
                object2 = object4 instanceof Activity ? (Activity)object4 : null;
            }
        } else {
            object2 = activity = null;
        }
        if (activity == null) {
            InternalLogger.DefaultImpls.log$default(RuntimeUtilsKt.getInternalLogger(), InternalLogger.Level.WARN, InternalLogger.Target.MAINTAINER, "Unable to retrieve the activity from " + key + ", the frame rate might be reported with the wrong scale", null, 8, null);
            return;
        }
        if (this.buildSdkVersionProvider.version() >= 30) {
            object = activity.getDisplay();
        } else {
            Object object5 = activity.getSystemService("window");
            WindowManager windowManager = object5 instanceof WindowManager ? (WindowManager)object5 : null;
            object = display = windowManager == null ? null : windowManager.getDefaultDisplay();
        }
        if (display == null) {
            return;
        }
        Display display2 = display;
        this.refreshRateScale = 60.0 / (double)display2.getRefreshRate();
    }

    public static final /* synthetic */ String access$getSessionId$p(RumViewScope $this) {
        return $this.sessionId;
    }

    public static final /* synthetic */ FeaturesContextResolver access$getFeaturesContextResolver$p(RumViewScope $this) {
        return $this.featuresContextResolver;
    }

    public static final /* synthetic */ void access$setCpuTicks$p(RumViewScope $this, Double d) {
        $this.cpuTicks = d;
    }

    public static final /* synthetic */ void access$setLastMemoryInfo$p(RumViewScope $this, VitalInfo vitalInfo) {
        $this.lastMemoryInfo = vitalInfo;
    }

    public static final /* synthetic */ void access$setLastFrameRateInfo$p(RumViewScope $this, VitalInfo vitalInfo) {
        $this.lastFrameRateInfo = vitalInfo;
    }

    static {
        Object object;
        block1: {
            Companion = new Companion(null);
            ONE_SECOND_NS = TimeUnit.SECONDS.toNanos(1L);
            FROZEN_FRAME_THRESHOLD_NS = TimeUnit.MILLISECONDS.toNanos(700L);
            Field[] fieldArray = NavController.class.getDeclaredFields();
            Intrinsics.checkNotNullExpressionValue((Object)fieldArray, (String)"NavController::class.java.declaredFields");
            Object[] $this$firstOrNull$iv = fieldArray;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Field it = (Field)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual(it.getType(), Activity.class)) continue;
                object = element$iv;
                break block1;
            }
            object = null;
        }
        navControllerActivityField = (Field)object;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/datadog/android/rum/internal/domain/scope/RumViewScope$RumViewType;", "", "(Ljava/lang/String;I)V", "NONE", "FOREGROUND", "BACKGROUND", "APPLICATION_LAUNCH", "dd-sdk-android_release"})
    public static final class RumViewType
    extends Enum<RumViewType> {
        public static final /* enum */ RumViewType NONE = new RumViewType();
        public static final /* enum */ RumViewType FOREGROUND = new RumViewType();
        public static final /* enum */ RumViewType BACKGROUND = new RumViewType();
        public static final /* enum */ RumViewType APPLICATION_LAUNCH = new RumViewType();
        private static final /* synthetic */ RumViewType[] $VALUES;

        public static RumViewType[] values() {
            return (RumViewType[])$VALUES.clone();
        }

        public static RumViewType valueOf(String value) {
            return Enum.valueOf(RumViewType.class, value);
        }

        static {
            $VALUES = rumViewTypeArray = new RumViewType[]{RumViewType.NONE, RumViewType.FOREGROUND, RumViewType.BACKGROUND, RumViewType.APPLICATION_LAUNCH};
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J_\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020#2\u0006\u0010%\u001a\u00020#2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0000\u00a2\u0006\u0002\b*J\u0010\u0010+\u001a\u00020\u00112\u0006\u0010,\u001a\u00020\u0011H\u0002J\f\u0010-\u001a\u00020.*\u00020/H\u0002J\f\u00100\u001a\u00020.*\u00020/H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\bR\u000e\u0010\f\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0080T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0012\u001a\u0004\u0018\u00010\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u00061"}, d2={"Lcom/datadog/android/rum/internal/domain/scope/RumViewScope$Companion;", "", "()V", "ACTION_DROPPED_WARNING", "", "FROZEN_FRAME_THRESHOLD_NS", "", "getFROZEN_FRAME_THRESHOLD_NS$dd_sdk_android_release", "()J", "NEGATIVE_DURATION_WARNING_MESSAGE", "ONE_SECOND_NS", "getONE_SECOND_NS$dd_sdk_android_release", "RUM_CONTEXT_UPDATE_IGNORED_AT_ACTION_UPDATE_MESSAGE", "RUM_CONTEXT_UPDATE_IGNORED_AT_STOP_VIEW_MESSAGE", "SLOW_RENDERED_THRESHOLD_FPS", "", "STANDARD_FPS", "", "navControllerActivityField", "Ljava/lang/reflect/Field;", "getNavControllerActivityField", "()Ljava/lang/reflect/Field;", "fromEvent", "Lcom/datadog/android/rum/internal/domain/scope/RumViewScope;", "parentScope", "Lcom/datadog/android/rum/internal/domain/scope/RumScope;", "sdkCore", "Lcom/datadog/android/v2/api/SdkCore;", "event", "Lcom/datadog/android/rum/internal/domain/scope/RumRawEvent$StartView;", "viewChangedListener", "Lcom/datadog/android/rum/internal/domain/scope/RumViewChangedListener;", "firstPartyHostHeaderTypeResolver", "Lcom/datadog/android/core/internal/net/FirstPartyHostHeaderTypeResolver;", "cpuVitalMonitor", "Lcom/datadog/android/rum/internal/vitals/VitalMonitor;", "memoryVitalMonitor", "frameRateVitalMonitor", "contextProvider", "Lcom/datadog/android/v2/core/internal/ContextProvider;", "trackFrustrations", "", "fromEvent$dd_sdk_android_release", "invertValue", "value", "toInversePerformanceMetric", "Lcom/datadog/android/rum/model/ViewEvent$FlutterBuildTime;", "Lcom/datadog/android/rum/internal/vitals/VitalInfo;", "toPerformanceMetric", "dd-sdk-android_release"})
    public static final class Companion {
        private Companion() {
        }

        public final long getONE_SECOND_NS$dd_sdk_android_release() {
            return ONE_SECOND_NS;
        }

        public final long getFROZEN_FRAME_THRESHOLD_NS$dd_sdk_android_release() {
            return FROZEN_FRAME_THRESHOLD_NS;
        }

        @Nullable
        public final Field getNavControllerActivityField() {
            return navControllerActivityField;
        }

        @NotNull
        public final RumViewScope fromEvent$dd_sdk_android_release(@NotNull RumScope parentScope, @NotNull SdkCore sdkCore, @NotNull RumRawEvent.StartView event, @Nullable RumViewChangedListener viewChangedListener, @NotNull FirstPartyHostHeaderTypeResolver firstPartyHostHeaderTypeResolver, @NotNull VitalMonitor cpuVitalMonitor, @NotNull VitalMonitor memoryVitalMonitor, @NotNull VitalMonitor frameRateVitalMonitor, @NotNull ContextProvider contextProvider, boolean trackFrustrations2) {
            Intrinsics.checkNotNullParameter((Object)parentScope, (String)"parentScope");
            Intrinsics.checkNotNullParameter((Object)sdkCore, (String)"sdkCore");
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Intrinsics.checkNotNullParameter((Object)firstPartyHostHeaderTypeResolver, (String)"firstPartyHostHeaderTypeResolver");
            Intrinsics.checkNotNullParameter((Object)cpuVitalMonitor, (String)"cpuVitalMonitor");
            Intrinsics.checkNotNullParameter((Object)memoryVitalMonitor, (String)"memoryVitalMonitor");
            Intrinsics.checkNotNullParameter((Object)frameRateVitalMonitor, (String)"frameRateVitalMonitor");
            Intrinsics.checkNotNullParameter((Object)contextProvider, (String)"contextProvider");
            return new RumViewScope(parentScope, sdkCore, event.getKey(), event.getName(), event.getEventTime(), event.getAttributes(), viewChangedListener, firstPartyHostHeaderTypeResolver, cpuVitalMonitor, memoryVitalMonitor, frameRateVitalMonitor, contextProvider, null, null, null, null, trackFrustrations2, 61440, null);
        }

        private final ViewEvent.FlutterBuildTime toPerformanceMetric(VitalInfo $this$toPerformanceMetric) {
            return new ViewEvent.FlutterBuildTime($this$toPerformanceMetric.getMinValue(), $this$toPerformanceMetric.getMaxValue(), $this$toPerformanceMetric.getMeanValue(), null, 8, null);
        }

        private final ViewEvent.FlutterBuildTime toInversePerformanceMetric(VitalInfo $this$toInversePerformanceMetric) {
            return new ViewEvent.FlutterBuildTime(this.invertValue($this$toInversePerformanceMetric.getMaxValue()) * (double)TimeUnit.SECONDS.toNanos(1L), this.invertValue($this$toInversePerformanceMetric.getMinValue()) * (double)TimeUnit.SECONDS.toNanos(1L), this.invertValue($this$toInversePerformanceMetric.getMeanValue()) * (double)TimeUnit.SECONDS.toNanos(1L), null, 8, null);
        }

        private final double invertValue(double value) {
            return value == 0.0 ? 0.0 : 1.0 / value;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

