/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.rum.internal.instrumentation.gestures;

import android.content.Context;
import android.view.GestureDetector;
import android.view.MotionEvent;
import androidx.core.view.GestureDetectorCompat;
import com.datadog.android.rum.internal.instrumentation.gestures.GesturesListener;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/datadog/android/rum/internal/instrumentation/gestures/GesturesDetectorWrapper;", "", "context", "Landroid/content/Context;", "gestureListener", "Lcom/datadog/android/rum/internal/instrumentation/gestures/GesturesListener;", "(Landroid/content/Context;Lcom/datadog/android/rum/internal/instrumentation/gestures/GesturesListener;)V", "defaultGesturesDetector", "Landroidx/core/view/GestureDetectorCompat;", "(Lcom/datadog/android/rum/internal/instrumentation/gestures/GesturesListener;Landroidx/core/view/GestureDetectorCompat;)V", "onTouchEvent", "", "event", "Landroid/view/MotionEvent;", "dd-sdk-android_release"})
public final class GesturesDetectorWrapper {
    @NotNull
    private final GesturesListener gestureListener;
    @NotNull
    private final GestureDetectorCompat defaultGesturesDetector;

    public GesturesDetectorWrapper(@NotNull GesturesListener gestureListener, @NotNull GestureDetectorCompat defaultGesturesDetector) {
        Intrinsics.checkNotNullParameter((Object)gestureListener, (String)"gestureListener");
        Intrinsics.checkNotNullParameter((Object)defaultGesturesDetector, (String)"defaultGesturesDetector");
        this.gestureListener = gestureListener;
        this.defaultGesturesDetector = defaultGesturesDetector;
    }

    public GesturesDetectorWrapper(@NotNull Context context, @NotNull GesturesListener gestureListener) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)gestureListener, (String)"gestureListener");
        this(gestureListener, new GestureDetectorCompat(context, (GestureDetector.OnGestureListener)gestureListener));
    }

    public final void onTouchEvent(@NotNull MotionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.defaultGesturesDetector.onTouchEvent(event);
        int action = event.getActionMasked();
        if (action == 1) {
            this.gestureListener.onUp(event);
        }
    }
}

