/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.rum.internal.monitor;

import android.os.Handler;
import com.datadog.android.core.configuration.Configuration;
import com.datadog.android.core.internal.net.FirstPartyHostHeaderTypeResolver;
import com.datadog.android.core.internal.utils.RuntimeUtilsKt;
import com.datadog.android.core.internal.utils.ThrowableExtKt;
import com.datadog.android.rum.RumActionType;
import com.datadog.android.rum.RumErrorSource;
import com.datadog.android.rum.RumMonitor;
import com.datadog.android.rum.RumPerformanceMetric;
import com.datadog.android.rum.RumResourceKind;
import com.datadog.android.rum.RumSessionListener;
import com.datadog.android.rum._RumInternalProxy;
import com.datadog.android.rum.internal.CombinedRumSessionListener;
import com.datadog.android.rum.internal.RumErrorSourceType;
import com.datadog.android.rum.internal.debug.RumDebugListener;
import com.datadog.android.rum.internal.domain.Time;
import com.datadog.android.rum.internal.domain.TimeKt;
import com.datadog.android.rum.internal.domain.event.ResourceTiming;
import com.datadog.android.rum.internal.domain.scope.RumApplicationScope;
import com.datadog.android.rum.internal.domain.scope.RumRawEvent;
import com.datadog.android.rum.internal.domain.scope.RumScope;
import com.datadog.android.rum.internal.domain.scope.RumSessionScope;
import com.datadog.android.rum.internal.domain.scope.RumViewManagerScope;
import com.datadog.android.rum.internal.domain.scope.RumViewScope;
import com.datadog.android.rum.internal.monitor.AdvancedRumMonitor;
import com.datadog.android.rum.internal.monitor.StorageEvent;
import com.datadog.android.rum.internal.vitals.VitalMonitor;
import com.datadog.android.rum.model.ViewEvent;
import com.datadog.android.telemetry.internal.TelemetryEventHandler;
import com.datadog.android.telemetry.internal.TelemetryType;
import com.datadog.android.v2.api.InternalLogger;
import com.datadog.android.v2.api.SdkCore;
import com.datadog.android.v2.core.internal.ContextProvider;
import com.datadog.android.v2.core.internal.storage.DataWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00fc\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0007\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \u0092\u00012\u00020\u00012\u00020\u0002:\u0002\u0092\u0001B\u0087\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\u0006\u0010\u0013\u001a\u00020\u0014\u0012\u0006\u0010\u0015\u001a\u00020\u0016\u0012\u0006\u0010\u0017\u001a\u00020\u0016\u0012\u0006\u0010\u0018\u001a\u00020\u0016\u0012\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a\u0012\u0006\u0010\u001b\u001a\u00020\u001c\u0012\b\b\u0002\u0010\u001d\u001a\u00020\u001e\u00a2\u0006\u0002\u0010\u001fJ\b\u0010;\u001a\u00020+H\u0016J \u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020\u00042\u0006\u0010?\u001a\u00020@2\u0006\u0010A\u001a\u00020BH\u0016J8\u0010C\u001a\u00020=2\u0006\u0010>\u001a\u00020\u00042\u0006\u0010?\u001a\u00020@2\b\u0010A\u001a\u0004\u0018\u00010B2\u0014\u0010D\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u000e0EH\u0016J8\u0010F\u001a\u00020=2\u0006\u0010>\u001a\u00020\u00042\u0006\u0010?\u001a\u00020@2\b\u0010G\u001a\u0004\u0018\u00010\u00042\u0014\u0010D\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u000e0EH\u0016J\u0018\u0010H\u001a\u00020=2\u0006\u0010I\u001a\u00020\u00042\u0006\u0010J\u001a\u00020\u000eH\u0016J\u0018\u0010K\u001a\u00020=2\u0006\u0010L\u001a\u00020M2\u0006\u0010N\u001a\u00020\u0004H\u0016J\u0018\u0010O\u001a\u00020=2\u0006\u0010P\u001a\u00020\u00042\u0006\u0010Q\u001a\u00020RH\u0016J\u0010\u0010S\u001a\u00020=2\u0006\u0010I\u001a\u00020\u0004H\u0016J.\u0010T\u001a\u00020=2\u0006\u0010U\u001a\u00020V2\u0006\u0010I\u001a\u00020\u00042\u0014\u0010D\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u000e0EH\u0016J\r\u0010W\u001a\u00020=H\u0000\u00a2\u0006\u0002\bXJ\u0018\u0010Y\u001a\u00020=2\u0006\u0010Z\u001a\u00020\u00042\u0006\u0010[\u001a\u00020\\H\u0016J\u0018\u0010]\u001a\u00020=2\u0006\u0010Z\u001a\u00020\u00042\u0006\u0010[\u001a\u00020\\H\u0016J\u001e\u0010^\u001a\u00020_2\u0014\u0010D\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u000e0EH\u0002J \u0010`\u001a\u0004\u0018\u00010\u00042\u0014\u0010D\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u000e0EH\u0002J\u001e\u0010a\u001a\u00020b2\u0014\u0010D\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u000e0EH\u0002J\u0015\u0010c\u001a\u00020=2\u0006\u0010[\u001a\u00020dH\u0000\u00a2\u0006\u0002\beJ\r\u0010f\u001a\u00020=H\u0000\u00a2\u0006\u0002\bgJ\b\u0010h\u001a\u00020=H\u0016J\b\u0010i\u001a\u00020=H\u0016J\u0010\u0010j\u001a\u00020=2\u0006\u0010k\u001a\u00020lH\u0016J\u0010\u0010m\u001a\u00020=2\u0006\u0010>\u001a\u00020\u0004H\u0016J$\u0010n\u001a\u00020=2\u0006\u0010>\u001a\u00020\u00042\b\u0010o\u001a\u0004\u0018\u00010\u00042\b\u0010p\u001a\u0004\u0018\u00010\u0004H\u0016J\u001a\u0010n\u001a\u00020=2\u0006\u0010>\u001a\u00020\u00042\b\u0010A\u001a\u0004\u0018\u00010BH\u0016J\b\u0010q\u001a\u00020=H\u0016J\u0012\u0010r\u001a\u00020=2\b\u0010s\u001a\u0004\u0018\u00010#H\u0016J6\u0010t\u001a\u00020=2\u0006\u0010P\u001a\u00020\u00042\u0006\u0010u\u001a\u00020\u00042\u0006\u0010v\u001a\u00020\u00042\u0014\u0010D\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u000e0EH\u0016J.\u0010w\u001a\u00020=2\u0006\u0010U\u001a\u00020V2\u0006\u0010I\u001a\u00020\u00042\u0014\u0010D\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u000e0EH\u0016J.\u0010x\u001a\u00020=2\u0006\u0010P\u001a\u00020\u000e2\u0006\u0010I\u001a\u00020\u00042\u0014\u0010D\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u000e0EH\u0016J\r\u0010y\u001a\u00020=H\u0000\u00a2\u0006\u0002\bzJH\u0010{\u001a\u00020=2\u0006\u0010P\u001a\u00020\u00042\b\u0010|\u001a\u0004\u0018\u00010}2\b\u0010~\u001a\u0004\u0018\u00010M2\u0006\u0010p\u001a\u00020\u007f2\u0014\u0010D\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u000e0EH\u0016\u00a2\u0006\u0003\u0010\u0080\u0001J[\u0010\u0081\u0001\u001a\u00020=2\u0006\u0010P\u001a\u00020\u00042\b\u0010|\u001a\u0004\u0018\u00010}2\u0006\u0010>\u001a\u00020\u00042\u0006\u0010?\u001a\u00020@2\u0007\u0010\u0082\u0001\u001a\u00020\u00042\t\u0010\u0083\u0001\u001a\u0004\u0018\u00010\u00042\u0014\u0010D\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u000e0EH\u0016\u00a2\u0006\u0003\u0010\u0084\u0001JO\u0010\u0081\u0001\u001a\u00020=2\u0006\u0010P\u001a\u00020\u00042\b\u0010|\u001a\u0004\u0018\u00010}2\u0006\u0010>\u001a\u00020\u00042\u0006\u0010?\u001a\u00020@2\u0006\u0010A\u001a\u00020B2\u0014\u0010D\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u000e0EH\u0016\u00a2\u0006\u0003\u0010\u0085\u0001J\t\u0010\u0086\u0001\u001a\u00020=H\u0016J/\u0010\u0087\u0001\u001a\u00020=2\u0006\u0010U\u001a\u00020V2\u0006\u0010I\u001a\u00020\u00042\u0014\u0010D\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u000e0EH\u0016J'\u0010\u0088\u0001\u001a\u00020=2\u0006\u0010P\u001a\u00020\u000e2\u0014\u0010D\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u000e0EH\u0016J\u001c\u0010\u0089\u0001\u001a\u00020=2\b\u0010\u008a\u0001\u001a\u00030\u008b\u00012\u0007\u0010J\u001a\u00030\u008c\u0001H\u0016J#\u0010\u008d\u0001\u001a\u00020=2\u0006\u0010P\u001a\u00020\u000e2\u0007\u0010\u008e\u0001\u001a\u00020M2\u0007\u0010U\u001a\u00030\u008f\u0001H\u0016J\t\u0010\u0090\u0001\u001a\u00020=H\u0002J\u0011\u0010\u0091\u0001\u001a\u00020=2\u0006\u0010P\u001a\u00020\u0004H\u0016R\u0014\u0010\t\u001a\u00020\nX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u001c\u0010\"\u001a\u0004\u0018\u00010#X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\u0010X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u000e\u0010*\u001a\u00020+X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010,\u001a\u00020-X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010/R\u001a\u00100\u001a\u000201X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u00103\"\u0004\b4\u00105R\u0014\u0010\u0007\u001a\u00020\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u00107R\u0014\u0010\u0011\u001a\u00020\u0012X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b8\u00109R\u0014\u0010\u000b\u001a\u00020\nX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b:\u0010!R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0093\u0001"}, d2={"Lcom/datadog/android/rum/internal/monitor/DatadogRumMonitor;", "Lcom/datadog/android/rum/RumMonitor;", "Lcom/datadog/android/rum/internal/monitor/AdvancedRumMonitor;", "applicationId", "", "sdkCore", "Lcom/datadog/android/v2/api/SdkCore;", "samplingRate", "", "backgroundTrackingEnabled", "", "trackFrustrations", "writer", "Lcom/datadog/android/v2/core/internal/storage/DataWriter;", "", "handler", "Landroid/os/Handler;", "telemetryEventHandler", "Lcom/datadog/android/telemetry/internal/TelemetryEventHandler;", "firstPartyHostHeaderTypeResolver", "Lcom/datadog/android/core/internal/net/FirstPartyHostHeaderTypeResolver;", "cpuVitalMonitor", "Lcom/datadog/android/rum/internal/vitals/VitalMonitor;", "memoryVitalMonitor", "frameRateVitalMonitor", "sessionListener", "Lcom/datadog/android/rum/RumSessionListener;", "contextProvider", "Lcom/datadog/android/v2/core/internal/ContextProvider;", "executorService", "Ljava/util/concurrent/ExecutorService;", "(Ljava/lang/String;Lcom/datadog/android/v2/api/SdkCore;FZZLcom/datadog/android/v2/core/internal/storage/DataWriter;Landroid/os/Handler;Lcom/datadog/android/telemetry/internal/TelemetryEventHandler;Lcom/datadog/android/core/internal/net/FirstPartyHostHeaderTypeResolver;Lcom/datadog/android/rum/internal/vitals/VitalMonitor;Lcom/datadog/android/rum/internal/vitals/VitalMonitor;Lcom/datadog/android/rum/internal/vitals/VitalMonitor;Lcom/datadog/android/rum/RumSessionListener;Lcom/datadog/android/v2/core/internal/ContextProvider;Ljava/util/concurrent/ExecutorService;)V", "getBackgroundTrackingEnabled$dd_sdk_android_release", "()Z", "debugListener", "Lcom/datadog/android/rum/internal/debug/RumDebugListener;", "getDebugListener$dd_sdk_android_release", "()Lcom/datadog/android/rum/internal/debug/RumDebugListener;", "setDebugListener$dd_sdk_android_release", "(Lcom/datadog/android/rum/internal/debug/RumDebugListener;)V", "getHandler$dd_sdk_android_release", "()Landroid/os/Handler;", "internalProxy", "Lcom/datadog/android/rum/_RumInternalProxy;", "keepAliveRunnable", "Ljava/lang/Runnable;", "getKeepAliveRunnable$dd_sdk_android_release", "()Ljava/lang/Runnable;", "rootScope", "Lcom/datadog/android/rum/internal/domain/scope/RumScope;", "getRootScope$dd_sdk_android_release", "()Lcom/datadog/android/rum/internal/domain/scope/RumScope;", "setRootScope$dd_sdk_android_release", "(Lcom/datadog/android/rum/internal/domain/scope/RumScope;)V", "getSamplingRate$dd_sdk_android_release", "()F", "getTelemetryEventHandler$dd_sdk_android_release", "()Lcom/datadog/android/telemetry/internal/TelemetryEventHandler;", "getTrackFrustrations$dd_sdk_android_release", "_getInternal", "addCrash", "", "message", "source", "Lcom/datadog/android/rum/RumErrorSource;", "throwable", "", "addError", "attributes", "", "addErrorWithStacktrace", "stacktrace", "addFeatureFlagEvaluation", "name", "value", "addLongTask", "durationNs", "", "target", "addResourceTiming", "key", "timing", "Lcom/datadog/android/rum/internal/domain/event/ResourceTiming;", "addTiming", "addUserAction", "type", "Lcom/datadog/android/rum/RumActionType;", "drainExecutorService", "drainExecutorService$dd_sdk_android_release", "eventDropped", "viewId", "event", "Lcom/datadog/android/rum/internal/monitor/StorageEvent;", "eventSent", "getErrorSourceType", "Lcom/datadog/android/rum/internal/RumErrorSourceType;", "getErrorType", "getEventTime", "Lcom/datadog/android/rum/internal/domain/Time;", "handleEvent", "Lcom/datadog/android/rum/internal/domain/scope/RumRawEvent;", "handleEvent$dd_sdk_android_release", "notifyDebugListenerWithState", "notifyDebugListenerWithState$dd_sdk_android_release", "notifyInterceptorInstantiated", "resetSession", "sendConfigurationTelemetryEvent", "configuration", "Lcom/datadog/android/core/configuration/Configuration;", "sendDebugTelemetryEvent", "sendErrorTelemetryEvent", "stack", "kind", "sendWebViewEvent", "setDebugListener", "listener", "startResource", "method", "url", "startUserAction", "startView", "stopKeepAliveCallback", "stopKeepAliveCallback$dd_sdk_android_release", "stopResource", "statusCode", "", "size", "Lcom/datadog/android/rum/RumResourceKind;", "(Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/Long;Lcom/datadog/android/rum/RumResourceKind;Ljava/util/Map;)V", "stopResourceWithError", "stackTrace", "errorType", "(Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/String;Lcom/datadog/android/rum/RumErrorSource;Ljava/lang/String;Ljava/lang/String;Ljava/util/Map;)V", "(Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/String;Lcom/datadog/android/rum/RumErrorSource;Ljava/lang/Throwable;Ljava/util/Map;)V", "stopSession", "stopUserAction", "stopView", "updatePerformanceMetric", "metric", "Lcom/datadog/android/rum/RumPerformanceMetric;", "", "updateViewLoadingTime", "loadingTimeInNs", "Lcom/datadog/android/rum/model/ViewEvent$LoadingType;", "waitForPendingEvents", "waitForResourceTiming", "Companion", "dd-sdk-android_release"})
public final class DatadogRumMonitor
implements RumMonitor,
AdvancedRumMonitor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final float samplingRate;
    private final boolean backgroundTrackingEnabled;
    private final boolean trackFrustrations;
    @NotNull
    private final DataWriter<Object> writer;
    @NotNull
    private final Handler handler;
    @NotNull
    private final TelemetryEventHandler telemetryEventHandler;
    @NotNull
    private final ExecutorService executorService;
    @NotNull
    private RumScope rootScope;
    @NotNull
    private final Runnable keepAliveRunnable;
    @Nullable
    private RumDebugListener debugListener;
    @NotNull
    private final _RumInternalProxy internalProxy;
    private static final long KEEP_ALIVE_MS = TimeUnit.MINUTES.toMillis(5L);

    public DatadogRumMonitor(@NotNull String applicationId, @NotNull SdkCore sdkCore, float samplingRate, boolean backgroundTrackingEnabled, boolean trackFrustrations2, @NotNull DataWriter<Object> writer, @NotNull Handler handler, @NotNull TelemetryEventHandler telemetryEventHandler, @NotNull FirstPartyHostHeaderTypeResolver firstPartyHostHeaderTypeResolver, @NotNull VitalMonitor cpuVitalMonitor, @NotNull VitalMonitor memoryVitalMonitor, @NotNull VitalMonitor frameRateVitalMonitor, @Nullable RumSessionListener sessionListener, @NotNull ContextProvider contextProvider, @NotNull ExecutorService executorService) {
        RumSessionListener rumSessionListener;
        Intrinsics.checkNotNullParameter((Object)applicationId, (String)"applicationId");
        Intrinsics.checkNotNullParameter((Object)sdkCore, (String)"sdkCore");
        Intrinsics.checkNotNullParameter(writer, (String)"writer");
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        Intrinsics.checkNotNullParameter((Object)telemetryEventHandler, (String)"telemetryEventHandler");
        Intrinsics.checkNotNullParameter((Object)firstPartyHostHeaderTypeResolver, (String)"firstPartyHostHeaderTypeResolver");
        Intrinsics.checkNotNullParameter((Object)cpuVitalMonitor, (String)"cpuVitalMonitor");
        Intrinsics.checkNotNullParameter((Object)memoryVitalMonitor, (String)"memoryVitalMonitor");
        Intrinsics.checkNotNullParameter((Object)frameRateVitalMonitor, (String)"frameRateVitalMonitor");
        Intrinsics.checkNotNullParameter((Object)contextProvider, (String)"contextProvider");
        Intrinsics.checkNotNullParameter((Object)executorService, (String)"executorService");
        this.samplingRate = samplingRate;
        this.backgroundTrackingEnabled = backgroundTrackingEnabled;
        this.trackFrustrations = trackFrustrations2;
        this.writer = writer;
        this.handler = handler;
        this.telemetryEventHandler = telemetryEventHandler;
        this.executorService = executorService;
        if (sessionListener != null) {
            RumSessionListener[] rumSessionListenerArray = new RumSessionListener[]{sessionListener, this.telemetryEventHandler};
            rumSessionListener = new CombinedRumSessionListener(rumSessionListenerArray);
        } else {
            rumSessionListener = this.telemetryEventHandler;
        }
        this.rootScope = new RumApplicationScope(applicationId, sdkCore, this.samplingRate, this.backgroundTrackingEnabled, this.trackFrustrations, firstPartyHostHeaderTypeResolver, cpuVitalMonitor, memoryVitalMonitor, frameRateVitalMonitor, rumSessionListener, contextProvider);
        this.keepAliveRunnable = () -> DatadogRumMonitor.keepAliveRunnable$lambda-0(this);
        this.internalProxy = new _RumInternalProxy(this);
        this.handler.postDelayed(this.keepAliveRunnable, KEEP_ALIVE_MS);
    }

    public /* synthetic */ DatadogRumMonitor(String string, SdkCore sdkCore, float f, boolean bl, boolean bl2, DataWriter dataWriter, Handler handler, TelemetryEventHandler telemetryEventHandler, FirstPartyHostHeaderTypeResolver firstPartyHostHeaderTypeResolver, VitalMonitor vitalMonitor, VitalMonitor vitalMonitor2, VitalMonitor vitalMonitor3, RumSessionListener rumSessionListener, ContextProvider contextProvider, ExecutorService executorService, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x4000) != 0) {
            ExecutorService executorService2 = Executors.newSingleThreadExecutor();
            Intrinsics.checkNotNullExpressionValue((Object)executorService2, (String)"newSingleThreadExecutor()");
            executorService = executorService2;
        }
        this(string, sdkCore, f, bl, bl2, dataWriter, handler, telemetryEventHandler, firstPartyHostHeaderTypeResolver, vitalMonitor, vitalMonitor2, vitalMonitor3, rumSessionListener, contextProvider, executorService);
    }

    public final float getSamplingRate$dd_sdk_android_release() {
        return this.samplingRate;
    }

    public final boolean getBackgroundTrackingEnabled$dd_sdk_android_release() {
        return this.backgroundTrackingEnabled;
    }

    public final boolean getTrackFrustrations$dd_sdk_android_release() {
        return this.trackFrustrations;
    }

    @NotNull
    public final Handler getHandler$dd_sdk_android_release() {
        return this.handler;
    }

    @NotNull
    public final TelemetryEventHandler getTelemetryEventHandler$dd_sdk_android_release() {
        return this.telemetryEventHandler;
    }

    @NotNull
    public final RumScope getRootScope$dd_sdk_android_release() {
        return this.rootScope;
    }

    public final void setRootScope$dd_sdk_android_release(@NotNull RumScope rumScope) {
        Intrinsics.checkNotNullParameter((Object)rumScope, (String)"<set-?>");
        this.rootScope = rumScope;
    }

    @NotNull
    public final Runnable getKeepAliveRunnable$dd_sdk_android_release() {
        return this.keepAliveRunnable;
    }

    @Nullable
    public final RumDebugListener getDebugListener$dd_sdk_android_release() {
        return this.debugListener;
    }

    public final void setDebugListener$dd_sdk_android_release(@Nullable RumDebugListener rumDebugListener) {
        this.debugListener = rumDebugListener;
    }

    @Override
    public void startView(@NotNull Object key, @NotNull String name, @NotNull Map<String, ? extends Object> attributes) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
        Time eventTime = this.getEventTime(attributes);
        this.handleEvent$dd_sdk_android_release(new RumRawEvent.StartView(key, name, attributes, eventTime));
    }

    @Override
    public void stopView(@NotNull Object key, @NotNull Map<String, ? extends Object> attributes) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
        Time eventTime = this.getEventTime(attributes);
        this.handleEvent$dd_sdk_android_release(new RumRawEvent.StopView(key, attributes, eventTime));
    }

    @Override
    public void addUserAction(@NotNull RumActionType type, @NotNull String name, @NotNull Map<String, ? extends Object> attributes) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
        Time eventTime = this.getEventTime(attributes);
        this.handleEvent$dd_sdk_android_release(new RumRawEvent.StartAction(type, name, false, attributes, eventTime));
    }

    @Override
    public void startUserAction(@NotNull RumActionType type, @NotNull String name, @NotNull Map<String, ? extends Object> attributes) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
        Time eventTime = this.getEventTime(attributes);
        this.handleEvent$dd_sdk_android_release(new RumRawEvent.StartAction(type, name, true, attributes, eventTime));
    }

    @Override
    public void stopUserAction(@NotNull RumActionType type, @NotNull String name, @NotNull Map<String, ? extends Object> attributes) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
        Time eventTime = this.getEventTime(attributes);
        this.handleEvent$dd_sdk_android_release(new RumRawEvent.StopAction(type, name, attributes, eventTime));
    }

    @Override
    public void startResource(@NotNull String key, @NotNull String method, @NotNull String url, @NotNull Map<String, ? extends Object> attributes) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
        Time eventTime = this.getEventTime(attributes);
        this.handleEvent$dd_sdk_android_release(new RumRawEvent.StartResource(key, url, method, attributes, eventTime));
    }

    @Override
    public void stopResource(@NotNull String key, @Nullable Integer statusCode, @Nullable Long size, @NotNull RumResourceKind kind, @NotNull Map<String, ? extends Object> attributes) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)((Object)kind), (String)"kind");
        Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
        Time eventTime = this.getEventTime(attributes);
        Integer n = statusCode;
        this.handleEvent$dd_sdk_android_release(new RumRawEvent.StopResource(key, n == null ? null : Long.valueOf(n.intValue()), size, kind, attributes, eventTime));
    }

    @Override
    public void stopResourceWithError(@NotNull String key, @Nullable Integer statusCode, @NotNull String message, @NotNull RumErrorSource source, @NotNull Throwable throwable, @NotNull Map<String, ? extends Object> attributes) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)((Object)source), (String)"source");
        Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
        Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
        Integer n = statusCode;
        this.handleEvent$dd_sdk_android_release(new RumRawEvent.StopResourceWithError(key, n == null ? null : Long.valueOf(n.intValue()), message, source, throwable, attributes, null, 64, null));
    }

    @Override
    public void stopResourceWithError(@NotNull String key, @Nullable Integer statusCode, @NotNull String message, @NotNull RumErrorSource source, @NotNull String stackTrace, @Nullable String errorType, @NotNull Map<String, ? extends Object> attributes) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)((Object)source), (String)"source");
        Intrinsics.checkNotNullParameter((Object)stackTrace, (String)"stackTrace");
        Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
        Integer n = statusCode;
        this.handleEvent$dd_sdk_android_release(new RumRawEvent.StopResourceWithStackTrace(key, n == null ? null : Long.valueOf(n.intValue()), message, source, stackTrace, errorType, attributes, null, 128, null));
    }

    @Override
    public void addError(@NotNull String message, @NotNull RumErrorSource source, @Nullable Throwable throwable, @NotNull Map<String, ? extends Object> attributes) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)((Object)source), (String)"source");
        Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
        Time eventTime = this.getEventTime(attributes);
        String errorType = this.getErrorType(attributes);
        this.handleEvent$dd_sdk_android_release(new RumRawEvent.AddError(message, source, throwable, null, false, attributes, eventTime, errorType, null, 256, null));
    }

    @Override
    public void addErrorWithStacktrace(@NotNull String message, @NotNull RumErrorSource source, @Nullable String stacktrace, @NotNull Map<String, ? extends Object> attributes) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)((Object)source), (String)"source");
        Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
        Time eventTime = this.getEventTime(attributes);
        String errorType = this.getErrorType(attributes);
        RumErrorSourceType errorSourceType = this.getErrorSourceType(attributes);
        this.handleEvent$dd_sdk_android_release(new RumRawEvent.AddError(message, source, null, stacktrace, false, attributes, eventTime, errorType, errorSourceType));
    }

    @Override
    public void addFeatureFlagEvaluation(@NotNull String name, @NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.handleEvent$dd_sdk_android_release(new RumRawEvent.AddFeatureFlagEvaluation(name, value, null, 4, null));
    }

    @Override
    public void stopSession() {
        this.handleEvent$dd_sdk_android_release(new RumRawEvent.StopSession(null, 1, null));
    }

    @Override
    public void sendWebViewEvent() {
        this.handleEvent$dd_sdk_android_release(new RumRawEvent.WebViewEvent(null, 1, null));
    }

    @Override
    public void resetSession() {
        this.handleEvent$dd_sdk_android_release(new RumRawEvent.ResetSession(null, 1, null));
    }

    @Override
    public void waitForResourceTiming(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.handleEvent$dd_sdk_android_release(new RumRawEvent.WaitForResourceTiming(key, null, 2, null));
    }

    @Override
    public void addResourceTiming(@NotNull String key, @NotNull ResourceTiming timing) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)timing, (String)"timing");
        this.handleEvent$dd_sdk_android_release(new RumRawEvent.AddResourceTiming(key, timing, null, 4, null));
    }

    @Override
    public void addCrash(@NotNull String message, @NotNull RumErrorSource source, @NotNull Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)((Object)source), (String)"source");
        Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
        this.handleEvent$dd_sdk_android_release(new RumRawEvent.AddError(message, source, throwable, null, true, MapsKt.emptyMap(), null, null, null, 448, null));
    }

    @Override
    public void updateViewLoadingTime(@NotNull Object key, long loadingTimeInNs, @NotNull ViewEvent.LoadingType type) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        this.handleEvent$dd_sdk_android_release(new RumRawEvent.UpdateViewLoadingTime(key, loadingTimeInNs, type, null, 8, null));
    }

    @Override
    public void addTiming(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.handleEvent$dd_sdk_android_release(new RumRawEvent.AddCustomTiming(name, null, 2, null));
    }

    @Override
    public void addLongTask(long durationNs, @NotNull String target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        this.handleEvent$dd_sdk_android_release(new RumRawEvent.AddLongTask(durationNs, target, null, 4, null));
    }

    @Override
    public void eventSent(@NotNull String viewId, @NotNull StorageEvent event) {
        Intrinsics.checkNotNullParameter((Object)viewId, (String)"viewId");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        StorageEvent storageEvent = event;
        if (storageEvent instanceof StorageEvent.Action) {
            this.handleEvent$dd_sdk_android_release(new RumRawEvent.ActionSent(viewId, ((StorageEvent.Action)event).getFrustrationCount(), null, 4, null));
        } else if (storageEvent instanceof StorageEvent.Resource) {
            this.handleEvent$dd_sdk_android_release(new RumRawEvent.ResourceSent(viewId, null, 2, null));
        } else if (storageEvent instanceof StorageEvent.Error) {
            this.handleEvent$dd_sdk_android_release(new RumRawEvent.ErrorSent(viewId, null, 2, null));
        } else if (storageEvent instanceof StorageEvent.LongTask) {
            this.handleEvent$dd_sdk_android_release(new RumRawEvent.LongTaskSent(viewId, false, null, 4, null));
        } else if (storageEvent instanceof StorageEvent.FrozenFrame) {
            this.handleEvent$dd_sdk_android_release(new RumRawEvent.LongTaskSent(viewId, true, null, 4, null));
        } else if (storageEvent instanceof StorageEvent.View) {
            // empty if block
        }
    }

    @Override
    public void eventDropped(@NotNull String viewId, @NotNull StorageEvent event) {
        Intrinsics.checkNotNullParameter((Object)viewId, (String)"viewId");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        StorageEvent storageEvent = event;
        if (storageEvent instanceof StorageEvent.Action) {
            this.handleEvent$dd_sdk_android_release(new RumRawEvent.ActionDropped(viewId, null, 2, null));
        } else if (storageEvent instanceof StorageEvent.Resource) {
            this.handleEvent$dd_sdk_android_release(new RumRawEvent.ResourceDropped(viewId, null, 2, null));
        } else if (storageEvent instanceof StorageEvent.Error) {
            this.handleEvent$dd_sdk_android_release(new RumRawEvent.ErrorDropped(viewId, null, 2, null));
        } else if (storageEvent instanceof StorageEvent.LongTask) {
            this.handleEvent$dd_sdk_android_release(new RumRawEvent.LongTaskDropped(viewId, false, null, 4, null));
        } else if (storageEvent instanceof StorageEvent.FrozenFrame) {
            this.handleEvent$dd_sdk_android_release(new RumRawEvent.LongTaskDropped(viewId, true, null, 4, null));
        } else if (storageEvent instanceof StorageEvent.View) {
            // empty if block
        }
    }

    @Override
    public void setDebugListener(@Nullable RumDebugListener listener) {
        this.debugListener = listener;
    }

    @Override
    public void sendDebugTelemetryEvent(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.handleEvent$dd_sdk_android_release(new RumRawEvent.SendTelemetry(TelemetryType.DEBUG, message, null, null, null, null, 32, null));
    }

    @Override
    public void sendErrorTelemetryEvent(@NotNull String message, @Nullable Throwable throwable) {
        String string;
        String string2;
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Throwable throwable2 = throwable;
        String stack = throwable2 == null ? null : ThrowableExtKt.loggableStackTrace(throwable2);
        Throwable throwable3 = throwable;
        if (throwable3 == null) {
            string2 = null;
        } else {
            Class<?> clazz = throwable3.getClass();
            string2 = string = clazz == null ? null : clazz.getCanonicalName();
        }
        if (string2 == null) {
            Throwable throwable4 = throwable;
            if (throwable4 == null) {
                string = null;
            } else {
                Class<?> clazz = throwable4.getClass();
                string = clazz == null ? null : clazz.getSimpleName();
            }
        }
        String kind = string;
        this.handleEvent$dd_sdk_android_release(new RumRawEvent.SendTelemetry(TelemetryType.ERROR, message, stack, kind, null, null, 32, null));
    }

    @Override
    public void sendErrorTelemetryEvent(@NotNull String message, @Nullable String stack, @Nullable String kind) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.handleEvent$dd_sdk_android_release(new RumRawEvent.SendTelemetry(TelemetryType.ERROR, message, stack, kind, null, null, 32, null));
    }

    @Override
    public void sendConfigurationTelemetryEvent(@NotNull Configuration configuration) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        this.handleEvent$dd_sdk_android_release(new RumRawEvent.SendTelemetry(TelemetryType.CONFIGURATION, "", null, null, configuration, null, 32, null));
    }

    @Override
    public void notifyInterceptorInstantiated() {
        this.handleEvent$dd_sdk_android_release(new RumRawEvent.SendTelemetry(TelemetryType.INTERCEPTOR_SETUP, "", null, null, null, null, 32, null));
    }

    @Override
    public void updatePerformanceMetric(@NotNull RumPerformanceMetric metric, double value) {
        Intrinsics.checkNotNullParameter((Object)((Object)metric), (String)"metric");
        this.handleEvent$dd_sdk_android_release(new RumRawEvent.UpdatePerformanceMetric(metric, value, null, 4, null));
    }

    @Override
    @NotNull
    public _RumInternalProxy _getInternal() {
        return this.internalProxy;
    }

    public final void drainExecutorService$dd_sdk_android_release() throws UnsupportedOperationException, InterruptedException {
        ThreadPoolExecutor threadPoolExecutor;
        ArrayList tasks = new ArrayList();
        Object object = this.executorService;
        ThreadPoolExecutor threadPoolExecutor2 = threadPoolExecutor = object instanceof ThreadPoolExecutor ? (ThreadPoolExecutor)object : null;
        if (threadPoolExecutor != null && (object = threadPoolExecutor.getQueue()) != null) {
            object.drainTo(tasks);
        }
        this.executorService.shutdown();
        this.executorService.awaitTermination(10L, TimeUnit.SECONDS);
        Iterable $this$forEach$iv = tasks;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Runnable it = (Runnable)element$iv;
            boolean bl = false;
            it.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void handleEvent$dd_sdk_android_release(@NotNull RumRawEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event instanceof RumRawEvent.AddError && ((RumRawEvent.AddError)event).isFatal()) {
            RumScope rumScope = this.rootScope;
            synchronized (rumScope) {
                boolean bl = false;
                RumScope rumScope2 = this.getRootScope$dd_sdk_android_release().handleEvent(event, this.writer);
            }
        }
        if (event instanceof RumRawEvent.SendTelemetry) {
            this.telemetryEventHandler.handleEvent((RumRawEvent.SendTelemetry)event, this.writer);
        } else {
            this.handler.removeCallbacks(this.keepAliveRunnable);
            if (!this.executorService.isShutdown()) {
                try {
                    this.executorService.submit(() -> DatadogRumMonitor.handleEvent$lambda-4(this, event));
                }
                catch (RejectedExecutionException e) {
                    RuntimeUtilsKt.getInternalLogger().log(InternalLogger.Level.ERROR, InternalLogger.Target.USER, "Unable to handle a RUM event, the ", (Throwable)e);
                }
            }
        }
    }

    private final void waitForPendingEvents() {
        if (!this.executorService.isShutdown()) {
            CountDownLatch latch = new CountDownLatch(1);
            this.executorService.submit(() -> DatadogRumMonitor.waitForPendingEvents$lambda-5(latch));
            try {
                latch.await(1L, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {
                InternalLogger.DefaultImpls.log$default(RuntimeUtilsKt.getInternalLogger(), InternalLogger.Level.WARN, InternalLogger.Target.MAINTAINER, "Waiting for pending RUM events was interrupted", null, 8, null);
            }
        }
    }

    public final void stopKeepAliveCallback$dd_sdk_android_release() {
        this.handler.removeCallbacks(this.keepAliveRunnable);
    }

    /*
     * WARNING - void declaration
     */
    public final void notifyDebugListenerWithState$dd_sdk_android_release() {
        RumDebugListener rumDebugListener = this.debugListener;
        if (rumDebugListener != null) {
            RumViewManagerScope viewManagerScope;
            RumSessionScope sessionScope;
            RumApplicationScope applicationScope;
            RumDebugListener it = rumDebugListener;
            boolean bl = false;
            RumScope rumScope = this.getRootScope$dd_sdk_android_release();
            RumApplicationScope rumApplicationScope = applicationScope = rumScope instanceof RumApplicationScope ? (RumApplicationScope)rumScope : null;
            RumScope rumScope2 = rumApplicationScope == null ? null : rumApplicationScope.getActiveSession();
            RumSessionScope rumSessionScope = sessionScope = rumScope2 instanceof RumSessionScope ? (RumSessionScope)rumScope2 : null;
            Object object = rumSessionScope == null ? null : rumSessionScope.getChildScope$dd_sdk_android_release();
            RumViewManagerScope rumViewManagerScope = viewManagerScope = object instanceof RumViewManagerScope ? (RumViewManagerScope)object : null;
            if (viewManagerScope != null) {
                void $this$mapNotNullTo$iv$iv;
                void $this$mapNotNull$iv;
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv;
                void $this$filterIsInstanceTo$iv$iv;
                Iterable $this$filterIsInstance$iv;
                object = viewManagerScope.getChildrenScopes$dd_sdk_android_release();
                RumDebugListener rumDebugListener2 = it;
                boolean $i$f$filterIsInstance = false;
                void var9_9 = $this$filterIsInstance$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterIsInstanceTo = false;
                for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof RumViewScope)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filterIsInstance$iv = (List)destination$iv$iv;
                boolean $i$f$filter = false;
                $this$filterIsInstanceTo$iv$iv = $this$filter$iv;
                destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    RumViewScope viewScope = (RumViewScope)element$iv$iv;
                    boolean bl2 = false;
                    if (!viewScope.isActive()) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                boolean $i$f$mapNotNull = false;
                $this$filterTo$iv$iv = $this$mapNotNull$iv;
                destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    String it$iv$iv;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl3 = false;
                    RumViewScope viewScope = (RumViewScope)element$iv$iv;
                    boolean bl4 = false;
                    if (viewScope.getRumContext().getViewName() == null) continue;
                    boolean bl5 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                rumDebugListener2.onReceiveRumActiveViews((List)destination$iv$iv);
            }
        }
    }

    private final Time getEventTime(Map<String, ? extends Object> attributes) {
        Object object = attributes.get("_dd.timestamp");
        Long l = object instanceof Long ? (Long)object : null;
        Time time = l == null ? null : TimeKt.asTime(l);
        if (time == null) {
            time = new Time(0L, 0L, 3, null);
        }
        return time;
    }

    private final String getErrorType(Map<String, ? extends Object> attributes) {
        Object object = attributes.get("_dd.error_type");
        return object instanceof String ? (String)object : null;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final RumErrorSourceType getErrorSourceType(Map<String, ? extends Object> attributes) {
        RumErrorSourceType rumErrorSourceType;
        Object object;
        Object object2 = attributes.get("_dd.error.source_type");
        String sourceType = object2 instanceof String ? (String)object2 : null;
        String string = sourceType;
        if (string == null) {
            object = null;
        } else {
            Locale locale = Locale.US;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
            String string2 = string.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(locale)");
            object = object2 = string2;
        }
        if (object2 != null) {
            int n = -1;
            switch (((String)object2).hashCode()) {
                case 828638245: {
                    if (!((String)object2).equals("react-native")) break;
                    n = 1;
                    break;
                }
                case -760334308: {
                    if (!((String)object2).equals("flutter")) break;
                    n = 2;
                    break;
                }
                case -861391249: {
                    if (!((String)object2).equals("android")) break;
                    n = 3;
                    break;
                }
                case 150940456: {
                    if (!((String)object2).equals("browser")) break;
                    n = 4;
                    break;
                }
            }
            switch (n) {
                case 3: {
                    rumErrorSourceType = RumErrorSourceType.ANDROID;
                    return rumErrorSourceType;
                }
                case 1: {
                    rumErrorSourceType = RumErrorSourceType.REACT_NATIVE;
                    return rumErrorSourceType;
                }
                case 4: {
                    rumErrorSourceType = RumErrorSourceType.BROWSER;
                    return rumErrorSourceType;
                }
                case 2: {
                    rumErrorSourceType = RumErrorSourceType.FLUTTER;
                    return rumErrorSourceType;
                }
            }
        }
        rumErrorSourceType = RumErrorSourceType.ANDROID;
        return rumErrorSourceType;
    }

    private static final void keepAliveRunnable$lambda-0(DatadogRumMonitor this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.handleEvent$dd_sdk_android_release(new RumRawEvent.KeepAlive(null, 1, null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void handleEvent$lambda-4(DatadogRumMonitor this$0, RumRawEvent $event) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$event, (String)"$event");
        RumScope rumScope = this$0.rootScope;
        synchronized (rumScope) {
            boolean bl = false;
            this$0.getRootScope$dd_sdk_android_release().handleEvent($event, this$0.writer);
            this$0.notifyDebugListenerWithState$dd_sdk_android_release();
            Unit unit = Unit.INSTANCE;
        }
        this$0.handler.postDelayed(this$0.keepAliveRunnable, KEEP_ALIVE_MS);
    }

    private static final void waitForPendingEvents$lambda-5(CountDownLatch $latch) {
        Intrinsics.checkNotNullParameter((Object)$latch, (String)"$latch");
        $latch.countDown();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/datadog/android/rum/internal/monitor/DatadogRumMonitor$Companion;", "", "()V", "KEEP_ALIVE_MS", "", "getKEEP_ALIVE_MS$dd_sdk_android_release", "()J", "dd-sdk-android_release"})
    public static final class Companion {
        private Companion() {
        }

        public final long getKEEP_ALIVE_MS$dd_sdk_android_release() {
            return KEEP_ALIVE_MS;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

