/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.rum.internal.ndk;

import com.datadog.android.core.internal.persistence.Deserializer;
import com.datadog.android.core.internal.utils.RuntimeUtilsKt;
import com.datadog.android.rum.internal.domain.event.RumEventDeserializer;
import com.datadog.android.rum.internal.domain.scope.RumEventExtKt;
import com.datadog.android.rum.internal.ndk.NdkCrashEventHandler;
import com.datadog.android.rum.model.ErrorEvent;
import com.datadog.android.rum.model.ViewEvent;
import com.datadog.android.v2.api.EventBatchWriter;
import com.datadog.android.v2.api.FeatureScope;
import com.datadog.android.v2.api.InternalLogger;
import com.datadog.android.v2.api.SdkCore;
import com.datadog.android.v2.api.context.DatadogContext;
import com.datadog.android.v2.core.internal.storage.DataWriter;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u001b\u0012\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\u0010\u0006J.\u0010\u0007\u001a\u00020\b2\u000e\u0010\t\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\u000eH\u0016J8\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001aH\u0002R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/datadog/android/rum/internal/ndk/DatadogNdkCrashEventHandler;", "Lcom/datadog/android/rum/internal/ndk/NdkCrashEventHandler;", "rumEventDeserializer", "Lcom/datadog/android/core/internal/persistence/Deserializer;", "Lcom/google/gson/JsonObject;", "", "(Lcom/datadog/android/core/internal/persistence/Deserializer;)V", "handleEvent", "", "event", "", "sdkCore", "Lcom/datadog/android/v2/api/SdkCore;", "rumWriter", "Lcom/datadog/android/v2/core/internal/storage/DataWriter;", "resolveErrorEventFromViewEvent", "Lcom/datadog/android/rum/model/ErrorEvent;", "datadogContext", "Lcom/datadog/android/v2/api/context/DatadogContext;", "errorLogMessage", "", "timestamp", "", "stacktrace", "signalName", "viewEvent", "Lcom/datadog/android/rum/model/ViewEvent;", "updateViewEvent", "lastViewEvent", "Companion", "dd-sdk-android_release"})
public final class DatadogNdkCrashEventHandler
implements NdkCrashEventHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Deserializer<JsonObject, Object> rumEventDeserializer;
    @NotNull
    public static final String INFO_RUM_FEATURE_NOT_REGISTERED = "RUM feature is not registered, won't report NDK crash info as RUM error.";
    @NotNull
    public static final String NDK_CRASH_EVENT_MISSING_MANDATORY_FIELDS = "RUM feature received a NDK crash event where one or more mandatory (timestamp, signalName, stacktrace, message, lastViewEvent) fields are either missing or have wrong type.";
    private static final long VIEW_EVENT_AVAILABILITY_TIME_THRESHOLD = TimeUnit.HOURS.toMillis(4L);

    public DatadogNdkCrashEventHandler(@NotNull Deserializer<JsonObject, Object> rumEventDeserializer) {
        Intrinsics.checkNotNullParameter(rumEventDeserializer, (String)"rumEventDeserializer");
        this.rumEventDeserializer = rumEventDeserializer;
    }

    public /* synthetic */ DatadogNdkCrashEventHandler(Deserializer deserializer, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            deserializer = new RumEventDeserializer();
        }
        this(deserializer);
    }

    @Override
    public void handleEvent(@NotNull Map<?, ?> event, @NotNull SdkCore sdkCore, @NotNull DataWriter<Object> rumWriter) {
        ViewEvent viewEvent;
        Intrinsics.checkNotNullParameter(event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)sdkCore, (String)"sdkCore");
        Intrinsics.checkNotNullParameter(rumWriter, (String)"rumWriter");
        FeatureScope rumFeature = sdkCore.getFeature("rum");
        if (rumFeature == null) {
            InternalLogger.DefaultImpls.log$default(RuntimeUtilsKt.getInternalLogger(), InternalLogger.Level.INFO, InternalLogger.Target.USER, INFO_RUM_FEATURE_NOT_REGISTERED, null, 8, null);
            return;
        }
        Object obj = event.get("timestamp");
        Long timestamp = obj instanceof Long ? (Long)obj : null;
        Object obj2 = event.get("signalName");
        String signalName = obj2 instanceof String ? (String)obj2 : null;
        Object obj3 = event.get("stacktrace");
        String stacktrace = obj3 instanceof String ? (String)obj3 : null;
        Object obj4 = event.get("message");
        String errorLogMessage = obj4 instanceof String ? (String)obj4 : null;
        Object obj5 = event.get("lastViewEvent");
        JsonObject jsonObject = obj5 instanceof JsonObject ? (JsonObject)obj5 : null;
        if (jsonObject == null) {
            viewEvent = null;
        } else {
            JsonObject it = jsonObject;
            boolean bl = false;
            Object object = this.rumEventDeserializer.deserialize(it);
            viewEvent = object instanceof ViewEvent ? (ViewEvent)object : null;
        }
        ViewEvent lastViewEvent = viewEvent;
        if (timestamp == null || signalName == null || stacktrace == null || errorLogMessage == null || lastViewEvent == null) {
            InternalLogger.DefaultImpls.log$default(RuntimeUtilsKt.getInternalLogger(), InternalLogger.Level.WARN, InternalLogger.Target.USER, NDK_CRASH_EVENT_MISSING_MANDATORY_FIELDS, null, 8, null);
            return;
        }
        long now = System.currentTimeMillis();
        FeatureScope.DefaultImpls.withWriteContext$default(rumFeature, false, (Function2)new Function2<DatadogContext, EventBatchWriter, Unit>(this, errorLogMessage, timestamp, stacktrace, signalName, lastViewEvent, rumWriter, now){
            final /* synthetic */ DatadogNdkCrashEventHandler this$0;
            final /* synthetic */ String $errorLogMessage;
            final /* synthetic */ Long $timestamp;
            final /* synthetic */ String $stacktrace;
            final /* synthetic */ String $signalName;
            final /* synthetic */ ViewEvent $lastViewEvent;
            final /* synthetic */ DataWriter<Object> $rumWriter;
            final /* synthetic */ long $now;
            {
                this.this$0 = $receiver;
                this.$errorLogMessage = $errorLogMessage;
                this.$timestamp = $timestamp;
                this.$stacktrace = $stacktrace;
                this.$signalName = $signalName;
                this.$lastViewEvent = $lastViewEvent;
                this.$rumWriter = $rumWriter;
                this.$now = $now;
                super(2);
            }

            public final void invoke(@NotNull DatadogContext datadogContext, @NotNull EventBatchWriter eventBatchWriter) {
                Intrinsics.checkNotNullParameter((Object)datadogContext, (String)"datadogContext");
                Intrinsics.checkNotNullParameter((Object)eventBatchWriter, (String)"eventBatchWriter");
                ErrorEvent toSendErrorEvent = DatadogNdkCrashEventHandler.access$resolveErrorEventFromViewEvent(this.this$0, datadogContext, this.$errorLogMessage, this.$timestamp, this.$stacktrace, this.$signalName, this.$lastViewEvent);
                this.$rumWriter.write(eventBatchWriter, toSendErrorEvent);
                long sessionsTimeDifference = this.$now - this.$lastViewEvent.getDate();
                if (sessionsTimeDifference < DatadogNdkCrashEventHandler.Companion.getVIEW_EVENT_AVAILABILITY_TIME_THRESHOLD$dd_sdk_android_release()) {
                    ViewEvent updatedViewEvent = DatadogNdkCrashEventHandler.access$updateViewEvent(this.this$0, this.$lastViewEvent);
                    this.$rumWriter.write(eventBatchWriter, updatedViewEvent);
                }
            }
        }, 1, null);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final ErrorEvent resolveErrorEventFromViewEvent(DatadogContext datadogContext, String errorLogMessage, long timestamp, String stacktrace, String signalName, ViewEvent viewEvent) {
        v0 = viewEvent.getConnectivity();
        if (v0 == null) {
            v1 = null;
        } else {
            it = v0;
            $i$a$-let-DatadogNdkCrashEventHandler$resolveErrorEventFromViewEvent$connectivity$1 = false;
            connectivityStatus = ErrorEvent.Status.valueOf(it.getStatus().name());
            $this$map$iv = it.getInterfaces();
            $i$f$map = false;
            var16_13 = $this$map$iv;
            destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (T item$iv$iv : $this$mapTo$iv$iv) {
                var21_19 /* !! */  = (ViewEvent.Interface)item$iv$iv;
                var22_20 = destination$iv$iv;
                $i$a$-map-DatadogNdkCrashEventHandler$resolveErrorEventFromViewEvent$connectivity$1$connectivityInterfaces$1 = false;
                var22_20.add(ErrorEvent.Interface.valueOf(it.name()));
            }
            connectivityInterfaces = (List)destination$iv$iv;
            v2 = it.getCellular();
            v3 = it.getCellular();
            cellular = new ErrorEvent.Cellular((String)(v2 == null ? null : v2.getTechnology()), (String)(v3 == null ? null : v3.getCarrierName()));
            v1 = new ErrorEvent.Connectivity(connectivityStatus, connectivityInterfaces, cellular);
        }
        connectivity = v1;
        v4 = viewEvent.getContext();
        var10_26 = v4 == null ? null : v4.getAdditionalProperties();
        additionalProperties = var10_26 == null ? (Map)new LinkedHashMap<K, V>() : var10_26;
        v5 = viewEvent.getUsr();
        it = v5 == null ? null : v5.getAdditionalProperties();
        additionalUserProperties = it == null ? (Map)new LinkedHashMap<K, V>() : it;
        v6 = user = viewEvent.getUsr();
        if ((v6 == null ? null : v6.getId()) != null) ** GOTO lbl-1000
        v7 = user;
        if ((v7 == null ? null : v7.getName()) != null) ** GOTO lbl-1000
        v8 = user;
        if ((v8 == null ? null : v8.getEmail()) != null || additionalUserProperties.isEmpty() == false) lbl-1000:
        // 3 sources

        {
            v9 = true;
        } else {
            v9 = false;
        }
        hasUserInfo = v9;
        deviceInfo = datadogContext.getDeviceInfo();
        var14_11 = timestamp + datadogContext.getTime().getServerTimeOffsetMs();
        var16_13 = new ErrorEvent.Application(viewEvent.getApplication().getId());
        var17_14 = viewEvent.getService();
        var18_16 = new ErrorEvent.ErrorEventSession(viewEvent.getSession().getId(), ErrorEvent.ErrorEventSessionType.USER, null, 4, null);
        v10 = viewEvent.getSource();
        if (v10 == null) {
            v11 = null;
        } else {
            v12 = v10.toJson();
            if (v12 == null) {
                v11 = null;
            } else {
                v13 = v12.getAsString();
                if (v13 == null) {
                    v11 = null;
                } else {
                    it = v13;
                    $i$a$-let-DatadogNdkCrashEventHandler$resolveErrorEventFromViewEvent$1 = false;
                    v11 = RumEventExtKt.tryFromSource(ErrorEvent.ErrorEventSource.Companion, it);
                }
            }
        }
        var19_17 = v11;
        var21_19 /* !! */  = viewEvent.getView().getId();
        var22_20 = viewEvent.getView().getName();
        var23_22 = viewEvent.getView().getReferrer();
        var24_28 = viewEvent.getView().getUrl();
        var20_18 = new ErrorEvent.View((String)var21_19 /* !! */ , (String)var23_22, (String)var24_28, (String)var22_20, null, 16, null);
        if (!hasUserInfo) {
            v14 = null;
        } else {
            v15 = user;
            v16 = user;
            v17 = user;
            v14 = new ErrorEvent.Usr((String)(v15 == null ? null : v15.getId()), (String)(v16 == null ? null : v16.getName()), (String)(v17 == null ? null : v17.getEmail()), (Map<String, Object>)additionalUserProperties);
        }
        var21_19 /* !! */  = v14;
        var22_20 = new ErrorEvent.Os(deviceInfo.getOsName(), deviceInfo.getOsVersion(), deviceInfo.getOsMajorVersion());
        var23_22 = new ErrorEvent.Device(RumEventExtKt.toErrorSchemaType(deviceInfo.getDeviceType()), deviceInfo.getDeviceName(), deviceInfo.getDeviceModel(), deviceInfo.getDeviceBrand(), deviceInfo.getArchitecture());
        var24_28 = new ErrorEvent.Dd(new ErrorEvent.DdSession(ErrorEvent.Plan.PLAN_1), null, 2, null);
        var25_23 = new ErrorEvent.Context(additionalProperties);
        var26_29 = new ErrorEvent.Error(null, errorLogMessage, ErrorEvent.ErrorSource.SOURCE, stacktrace, null, true, signalName, null, null, ErrorEvent.SourceType.ANDROID, null, 1425, null);
        var27_30 = viewEvent.getVersion();
        return new ErrorEvent(var14_11, (ErrorEvent.Application)var16_13, var17_14, var27_30, var18_16, (ErrorEvent.ErrorEventSource)var19_17, var20_18, (ErrorEvent.Usr)var21_19 /* !! */ , connectivity, null, null, null, (ErrorEvent.Os)var22_20, (ErrorEvent.Device)var23_22, (ErrorEvent.Dd)var24_28, var25_23, null, var26_29, null, 331264, null);
    }

    private final ViewEvent updateViewEvent(ViewEvent lastViewEvent) {
        ViewEvent.Crash currentCrash;
        ViewEvent.Crash crash = currentCrash = lastViewEvent.getView().getCrash();
        ViewEvent.Crash crash2 = crash == null ? null : crash.copy(currentCrash.getCount() + 1L);
        if (crash2 == null) {
            crash2 = new ViewEvent.Crash(1L);
        }
        ViewEvent.Crash newCrash = crash2;
        return ViewEvent.copy$default(lastViewEvent, 0L, null, null, null, null, null, ViewEvent.View.copy$default(lastViewEvent.getView(), null, null, null, null, null, null, 0L, null, null, null, null, null, null, null, null, null, null, null, false, null, null, null, newCrash, null, null, null, null, null, null, null, null, null, null, null, null, null, null, -4456449, 31, null), null, null, null, null, null, null, null, ViewEvent.Dd.copy$default(lastViewEvent.getDd(), null, null, lastViewEvent.getDd().getDocumentVersion() + 1L, 3, null), null, null, 114623, null);
    }

    public DatadogNdkCrashEventHandler() {
        this(null, 1, null);
    }

    public static final /* synthetic */ ErrorEvent access$resolveErrorEventFromViewEvent(DatadogNdkCrashEventHandler $this, DatadogContext datadogContext, String errorLogMessage, long timestamp, String stacktrace, String signalName, ViewEvent viewEvent) {
        return $this.resolveErrorEventFromViewEvent(datadogContext, errorLogMessage, timestamp, stacktrace, signalName, viewEvent);
    }

    public static final /* synthetic */ ViewEvent access$updateViewEvent(DatadogNdkCrashEventHandler $this, ViewEvent lastViewEvent) {
        return $this.updateViewEvent(lastViewEvent);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lcom/datadog/android/rum/internal/ndk/DatadogNdkCrashEventHandler$Companion;", "", "()V", "INFO_RUM_FEATURE_NOT_REGISTERED", "", "NDK_CRASH_EVENT_MISSING_MANDATORY_FIELDS", "VIEW_EVENT_AVAILABILITY_TIME_THRESHOLD", "", "getVIEW_EVENT_AVAILABILITY_TIME_THRESHOLD$dd_sdk_android_release", "()J", "dd-sdk-android_release"})
    public static final class Companion {
        private Companion() {
        }

        public final long getVIEW_EVENT_AVAILABILITY_TIME_THRESHOLD$dd_sdk_android_release() {
            return VIEW_EVENT_AVAILABILITY_TIME_THRESHOLD;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

