/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.rum.internal.tracking;

import android.app.Activity;
import android.app.Dialog;
import android.app.DialogFragment;
import android.app.Fragment;
import android.app.FragmentManager;
import android.content.Context;
import android.os.Bundle;
import android.view.Window;
import androidx.annotation.RequiresApi;
import com.datadog.android.core.internal.system.BuildSdkVersionProvider;
import com.datadog.android.core.internal.system.DefaultBuildSdkVersionProvider;
import com.datadog.android.core.internal.utils.RuntimeUtilsKt;
import com.datadog.android.core.internal.utils.ViewUtilsKt;
import com.datadog.android.rum.RumMonitor;
import com.datadog.android.rum.internal.RumFeature;
import com.datadog.android.rum.internal.instrumentation.gestures.GesturesTracker;
import com.datadog.android.rum.internal.monitor.AdvancedRumMonitor;
import com.datadog.android.rum.internal.tracking.FragmentLifecycleCallbacks;
import com.datadog.android.rum.internal.tracking.ViewLoadingTimer;
import com.datadog.android.rum.model.ViewEvent;
import com.datadog.android.rum.tracking.ComponentPredicate;
import com.datadog.android.v2.api.InternalLogger;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0001\u0018\u0000 .2\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0001.Ba\u0012 \u0010\u0004\u001a\u001c\u0012\u0004\u0012\u00020\u0006\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\t0\u00070\u0005\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\b\b\u0002\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\u0002\u0010\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0006H\u0002J\"\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00062\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0016J$\u0010!\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u00062\b\u0010\"\u001a\u0004\u0018\u00010#H\u0016J\u001a\u0010$\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u0006H\u0016J\u0018\u0010%\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0006H\u0016J\u0018\u0010&\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0006H\u0016J\u001a\u0010'\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u0006H\u0016J\u0010\u0010(\u001a\u00020\u001b2\u0006\u0010)\u001a\u00020\u0002H\u0016J\u0010\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\u0018H\u0002J\u0010\u0010-\u001a\u00020\u001b2\u0006\u0010)\u001a\u00020\u0002H\u0016R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\u0004\u001a\u001c\u0012\u0004\u0012\u00020\u0006\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\t0\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lcom/datadog/android/rum/internal/tracking/OreoFragmentLifecycleCallbacks;", "Lcom/datadog/android/rum/internal/tracking/FragmentLifecycleCallbacks;", "Landroid/app/Activity;", "Landroid/app/FragmentManager$FragmentLifecycleCallbacks;", "argumentsProvider", "Lkotlin/Function1;", "Landroid/app/Fragment;", "", "", "", "componentPredicate", "Lcom/datadog/android/rum/tracking/ComponentPredicate;", "viewLoadingTimer", "Lcom/datadog/android/rum/internal/tracking/ViewLoadingTimer;", "rumFeature", "Lcom/datadog/android/rum/internal/RumFeature;", "rumMonitor", "Lcom/datadog/android/rum/RumMonitor;", "advancedRumMonitor", "Lcom/datadog/android/rum/internal/monitor/AdvancedRumMonitor;", "buildSdkVersionProvider", "Lcom/datadog/android/core/internal/system/BuildSdkVersionProvider;", "(Lkotlin/jvm/functions/Function1;Lcom/datadog/android/rum/tracking/ComponentPredicate;Lcom/datadog/android/rum/internal/tracking/ViewLoadingTimer;Lcom/datadog/android/rum/internal/RumFeature;Lcom/datadog/android/rum/RumMonitor;Lcom/datadog/android/rum/internal/monitor/AdvancedRumMonitor;Lcom/datadog/android/core/internal/system/BuildSdkVersionProvider;)V", "isNotAViewFragment", "", "fragment", "onFragmentActivityCreated", "", "fm", "Landroid/app/FragmentManager;", "f", "savedInstanceState", "Landroid/os/Bundle;", "onFragmentAttached", "context", "Landroid/content/Context;", "onFragmentDestroyed", "onFragmentPaused", "onFragmentResumed", "onFragmentStarted", "register", "activity", "resolveLoadingType", "Lcom/datadog/android/rum/model/ViewEvent$LoadingType;", "firstTimeLoading", "unregister", "Companion", "dd-sdk-android_release"})
@RequiresApi(value=26)
public final class OreoFragmentLifecycleCallbacks
extends FragmentManager.FragmentLifecycleCallbacks
implements FragmentLifecycleCallbacks<Activity> {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final Function1<Fragment, Map<String, Object>> argumentsProvider;
    @NotNull
    private final ComponentPredicate<Fragment> componentPredicate;
    @NotNull
    private final ViewLoadingTimer viewLoadingTimer;
    @NotNull
    private final RumFeature rumFeature;
    @NotNull
    private final RumMonitor rumMonitor;
    @NotNull
    private final AdvancedRumMonitor advancedRumMonitor;
    @NotNull
    private final BuildSdkVersionProvider buildSdkVersionProvider;
    @Deprecated
    @NotNull
    private static final String REPORT_FRAGMENT_NAME = "androidx.lifecycle.ReportFragment";

    public OreoFragmentLifecycleCallbacks(@NotNull Function1<? super Fragment, ? extends Map<String, ? extends Object>> argumentsProvider, @NotNull ComponentPredicate<Fragment> componentPredicate, @NotNull ViewLoadingTimer viewLoadingTimer, @NotNull RumFeature rumFeature, @NotNull RumMonitor rumMonitor, @NotNull AdvancedRumMonitor advancedRumMonitor2, @NotNull BuildSdkVersionProvider buildSdkVersionProvider) {
        Intrinsics.checkNotNullParameter(argumentsProvider, (String)"argumentsProvider");
        Intrinsics.checkNotNullParameter(componentPredicate, (String)"componentPredicate");
        Intrinsics.checkNotNullParameter((Object)viewLoadingTimer, (String)"viewLoadingTimer");
        Intrinsics.checkNotNullParameter((Object)rumFeature, (String)"rumFeature");
        Intrinsics.checkNotNullParameter((Object)rumMonitor, (String)"rumMonitor");
        Intrinsics.checkNotNullParameter((Object)advancedRumMonitor2, (String)"advancedRumMonitor");
        Intrinsics.checkNotNullParameter((Object)buildSdkVersionProvider, (String)"buildSdkVersionProvider");
        this.argumentsProvider = argumentsProvider;
        this.componentPredicate = componentPredicate;
        this.viewLoadingTimer = viewLoadingTimer;
        this.rumFeature = rumFeature;
        this.rumMonitor = rumMonitor;
        this.advancedRumMonitor = advancedRumMonitor2;
        this.buildSdkVersionProvider = buildSdkVersionProvider;
    }

    public /* synthetic */ OreoFragmentLifecycleCallbacks(Function1 function1, ComponentPredicate componentPredicate, ViewLoadingTimer viewLoadingTimer, RumFeature rumFeature, RumMonitor rumMonitor, AdvancedRumMonitor advancedRumMonitor2, BuildSdkVersionProvider buildSdkVersionProvider, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            viewLoadingTimer = new ViewLoadingTimer();
        }
        if ((n & 0x40) != 0) {
            buildSdkVersionProvider = new DefaultBuildSdkVersionProvider();
        }
        this((Function1<? super Fragment, ? extends Map<String, ? extends Object>>)function1, componentPredicate, viewLoadingTimer, rumFeature, rumMonitor, advancedRumMonitor2, buildSdkVersionProvider);
    }

    @Override
    public void register(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        if (this.buildSdkVersionProvider.version() >= 26) {
            activity.getFragmentManager().registerFragmentLifecycleCallbacks((FragmentManager.FragmentLifecycleCallbacks)this, true);
        }
    }

    @Override
    public void unregister(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        if (this.buildSdkVersionProvider.version() >= 26) {
            activity.getFragmentManager().unregisterFragmentLifecycleCallbacks((FragmentManager.FragmentLifecycleCallbacks)this);
        }
    }

    public void onFragmentActivityCreated(@NotNull FragmentManager fm, @NotNull Fragment f, @Nullable Bundle savedInstanceState) {
        Intrinsics.checkNotNullParameter((Object)fm, (String)"fm");
        Intrinsics.checkNotNullParameter((Object)f, (String)"f");
        super.onFragmentActivityCreated(fm, f, savedInstanceState);
        if (this.isNotAViewFragment(f)) {
            return;
        }
        Context context = f.getContext();
        if (f instanceof DialogFragment && context != null) {
            Dialog dialog = ((DialogFragment)f).getDialog();
            Window window = dialog == null ? null : dialog.getWindow();
            GesturesTracker gesturesTracker = this.rumFeature.getActionTrackingStrategy$dd_sdk_android_release().getGesturesTracker();
            gesturesTracker.startTracking(window, context);
        }
    }

    public void onFragmentAttached(@Nullable FragmentManager fm, @NotNull Fragment f, @Nullable Context context) {
        Intrinsics.checkNotNullParameter((Object)f, (String)"f");
        super.onFragmentAttached(fm, f, context);
        if (this.isNotAViewFragment(f)) {
            return;
        }
        ComponentPredicate<Fragment> $this$runIfValid$iv = this.componentPredicate;
        boolean $i$f$runIfValid = false;
        if ($this$runIfValid$iv.accept(f)) {
            try {
                Fragment it = f;
                boolean bl = false;
                this.viewLoadingTimer.onCreated(it);
            }
            catch (Exception e$iv) {
                InternalLogger.Target[] targetArray = new InternalLogger.Target[]{InternalLogger.Target.MAINTAINER, InternalLogger.Target.TELEMETRY};
                RuntimeUtilsKt.getInternalLogger().log(InternalLogger.Level.ERROR, CollectionsKt.listOf((Object[])targetArray), "Internal operation failed", (Throwable)e$iv);
            }
        }
    }

    public void onFragmentStarted(@Nullable FragmentManager fm, @NotNull Fragment f) {
        Intrinsics.checkNotNullParameter((Object)f, (String)"f");
        super.onFragmentStarted(fm, f);
        if (this.isNotAViewFragment(f)) {
            return;
        }
        ComponentPredicate<Fragment> $this$runIfValid$iv = this.componentPredicate;
        boolean $i$f$runIfValid = false;
        if ($this$runIfValid$iv.accept(f)) {
            try {
                Fragment it = f;
                boolean bl = false;
                this.viewLoadingTimer.onStartLoading(it);
            }
            catch (Exception e$iv) {
                InternalLogger.Target[] targetArray = new InternalLogger.Target[]{InternalLogger.Target.MAINTAINER, InternalLogger.Target.TELEMETRY};
                RuntimeUtilsKt.getInternalLogger().log(InternalLogger.Level.ERROR, CollectionsKt.listOf((Object[])targetArray), "Internal operation failed", (Throwable)e$iv);
            }
        }
    }

    public void onFragmentResumed(@NotNull FragmentManager fm, @NotNull Fragment f) {
        Intrinsics.checkNotNullParameter((Object)fm, (String)"fm");
        Intrinsics.checkNotNullParameter((Object)f, (String)"f");
        super.onFragmentResumed(fm, f);
        if (this.isNotAViewFragment(f)) {
            return;
        }
        ComponentPredicate<Fragment> $this$runIfValid$iv = this.componentPredicate;
        boolean $i$f$runIfValid = false;
        if ($this$runIfValid$iv.accept(f)) {
            try {
                Fragment it = f;
                boolean bl = false;
                ComponentPredicate<Fragment> $this$resolveViewName$iv = this.componentPredicate;
                boolean $i$f$resolveViewName = false;
                String customName$iv = $this$resolveViewName$iv.getViewName(f);
                CharSequence charSequence = customName$iv;
                String viewName = charSequence == null || StringsKt.isBlank((CharSequence)charSequence) ? ViewUtilsKt.resolveViewUrl(f) : customName$iv;
                this.viewLoadingTimer.onFinishedLoading(f);
                this.rumMonitor.startView(it, viewName, (Map)this.argumentsProvider.invoke((Object)it));
                Long loadingTime = this.viewLoadingTimer.getLoadingTime(it);
                if (loadingTime != null) {
                    this.advancedRumMonitor.updateViewLoadingTime(it, loadingTime, this.resolveLoadingType(this.viewLoadingTimer.isFirstTimeLoading(it)));
                }
            }
            catch (Exception e$iv) {
                InternalLogger.Target[] targetArray = new InternalLogger.Target[]{InternalLogger.Target.MAINTAINER, InternalLogger.Target.TELEMETRY};
                RuntimeUtilsKt.getInternalLogger().log(InternalLogger.Level.ERROR, CollectionsKt.listOf((Object[])targetArray), "Internal operation failed", (Throwable)e$iv);
            }
        }
    }

    public void onFragmentPaused(@NotNull FragmentManager fm, @NotNull Fragment f) {
        Intrinsics.checkNotNullParameter((Object)fm, (String)"fm");
        Intrinsics.checkNotNullParameter((Object)f, (String)"f");
        super.onFragmentPaused(fm, f);
        if (this.isNotAViewFragment(f)) {
            return;
        }
        ComponentPredicate<Fragment> $this$runIfValid$iv = this.componentPredicate;
        boolean $i$f$runIfValid = false;
        if ($this$runIfValid$iv.accept(f)) {
            try {
                Fragment it = f;
                boolean bl = false;
                RumMonitor.DefaultImpls.stopView$default(this.rumMonitor, it, null, 2, null);
                this.viewLoadingTimer.onPaused(it);
            }
            catch (Exception e$iv) {
                InternalLogger.Target[] targetArray = new InternalLogger.Target[]{InternalLogger.Target.MAINTAINER, InternalLogger.Target.TELEMETRY};
                RuntimeUtilsKt.getInternalLogger().log(InternalLogger.Level.ERROR, CollectionsKt.listOf((Object[])targetArray), "Internal operation failed", (Throwable)e$iv);
            }
        }
    }

    public void onFragmentDestroyed(@Nullable FragmentManager fm, @NotNull Fragment f) {
        Intrinsics.checkNotNullParameter((Object)f, (String)"f");
        super.onFragmentDestroyed(fm, f);
        if (this.isNotAViewFragment(f)) {
            return;
        }
        ComponentPredicate<Fragment> $this$runIfValid$iv = this.componentPredicate;
        boolean $i$f$runIfValid = false;
        if ($this$runIfValid$iv.accept(f)) {
            try {
                Fragment it = f;
                boolean bl = false;
                this.viewLoadingTimer.onDestroyed(it);
            }
            catch (Exception e$iv) {
                InternalLogger.Target[] targetArray = new InternalLogger.Target[]{InternalLogger.Target.MAINTAINER, InternalLogger.Target.TELEMETRY};
                RuntimeUtilsKt.getInternalLogger().log(InternalLogger.Level.ERROR, CollectionsKt.listOf((Object[])targetArray), "Internal operation failed", (Throwable)e$iv);
            }
        }
    }

    private final ViewEvent.LoadingType resolveLoadingType(boolean firstTimeLoading) {
        return firstTimeLoading ? ViewEvent.LoadingType.FRAGMENT_DISPLAY : ViewEvent.LoadingType.FRAGMENT_REDISPLAY;
    }

    private final boolean isNotAViewFragment(Fragment fragment) {
        return Intrinsics.areEqual((Object)fragment.getClass().getName(), (Object)REPORT_FRAGMENT_NAME);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/datadog/android/rum/internal/tracking/OreoFragmentLifecycleCallbacks$Companion;", "", "()V", "REPORT_FRAGMENT_NAME", "", "dd-sdk-android_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

