/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.rum.internal.vitals;

import com.datadog.android.core.internal.utils.ConcurrencyExtKt;
import com.datadog.android.rum.internal.domain.scope.RumViewScope;
import com.datadog.android.rum.internal.vitals.VitalObserver;
import com.datadog.android.rum.internal.vitals.VitalReader;
import com.datadog.android.v2.api.SdkCore;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\f\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\b\u0010\u0017\u001a\u00020\u0018H\u0016R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0019"}, d2={"Lcom/datadog/android/rum/internal/vitals/VitalReaderRunnable;", "Ljava/lang/Runnable;", "sdkCore", "Lcom/datadog/android/v2/api/SdkCore;", "reader", "Lcom/datadog/android/rum/internal/vitals/VitalReader;", "observer", "Lcom/datadog/android/rum/internal/vitals/VitalObserver;", "executor", "Ljava/util/concurrent/ScheduledExecutorService;", "periodMs", "", "(Lcom/datadog/android/v2/api/SdkCore;Lcom/datadog/android/rum/internal/vitals/VitalReader;Lcom/datadog/android/rum/internal/vitals/VitalObserver;Ljava/util/concurrent/ScheduledExecutorService;J)V", "getExecutor", "()Ljava/util/concurrent/ScheduledExecutorService;", "getObserver", "()Lcom/datadog/android/rum/internal/vitals/VitalObserver;", "getPeriodMs", "()J", "getReader", "()Lcom/datadog/android/rum/internal/vitals/VitalReader;", "getSdkCore", "()Lcom/datadog/android/v2/api/SdkCore;", "run", "", "dd-sdk-android_release"})
public final class VitalReaderRunnable
implements Runnable {
    @NotNull
    private final SdkCore sdkCore;
    @NotNull
    private final VitalReader reader;
    @NotNull
    private final VitalObserver observer;
    @NotNull
    private final ScheduledExecutorService executor;
    private final long periodMs;

    public VitalReaderRunnable(@NotNull SdkCore sdkCore, @NotNull VitalReader reader2, @NotNull VitalObserver observer, @NotNull ScheduledExecutorService executor, long periodMs) {
        Intrinsics.checkNotNullParameter((Object)sdkCore, (String)"sdkCore");
        Intrinsics.checkNotNullParameter((Object)reader2, (String)"reader");
        Intrinsics.checkNotNullParameter((Object)observer, (String)"observer");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        this.sdkCore = sdkCore;
        this.reader = reader2;
        this.observer = observer;
        this.executor = executor;
        this.periodMs = periodMs;
    }

    @NotNull
    public final SdkCore getSdkCore() {
        return this.sdkCore;
    }

    @NotNull
    public final VitalReader getReader() {
        return this.reader;
    }

    @NotNull
    public final VitalObserver getObserver() {
        return this.observer;
    }

    @NotNull
    public final ScheduledExecutorService getExecutor() {
        return this.executor;
    }

    public final long getPeriodMs() {
        return this.periodMs;
    }

    @Override
    public void run() {
        Double data;
        RumViewScope.RumViewType rumViewType;
        Map<String, Object> rumContext = this.sdkCore.getFeatureContext("rum");
        Object object = rumContext.get("view_type");
        RumViewScope.RumViewType rumViewType2 = rumViewType = object instanceof RumViewScope.RumViewType ? (RumViewScope.RumViewType)((Object)object) : null;
        if (rumViewType == RumViewScope.RumViewType.FOREGROUND && (data = this.reader.readVitalData()) != null) {
            this.observer.onNewSample(data);
        }
        ConcurrencyExtKt.scheduleSafe(this.executor, "Vitals monitoring", this.periodMs, TimeUnit.MILLISECONDS, this);
    }
}

