/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.rum.resource;

import com.datadog.android.rum.GlobalRum;
import com.datadog.android.rum.RumErrorSource;
import com.datadog.android.rum.RumMonitor;
import com.datadog.android.rum.RumResourceKind;
import com.datadog.android.rum.internal.domain.event.ResourceTiming;
import com.datadog.android.rum.internal.monitor.AdvancedRumMonitor;
import com.datadog.android.rum.resource.RumResourceInputStream;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0010\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0002\b\u0007\u0018\u0000 12\u00020\u0001:\u00011B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u001b\u001a\u00020\u001cH\u0016J4\u0010\u001d\u001a\u0002H\u001e\"\u0004\b\u0000\u0010\u001e2\u0006\u0010\u001f\u001a\u00020\u00042\u0017\u0010 \u001a\u0013\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u0002H\u001e0!\u00a2\u0006\u0002\b\"H\u0002\u00a2\u0006\u0002\u0010#J\b\u0010$\u001a\u00020%H\u0016J\u0010\u0010&\u001a\u00020%2\u0006\u0010'\u001a\u00020\u001cH\u0016J\b\u0010(\u001a\u00020\u000bH\u0016J\b\u0010)\u001a\u00020\u001cH\u0016J\u0010\u0010)\u001a\u00020\u001c2\u0006\u0010*\u001a\u00020+H\u0016J \u0010)\u001a\u00020\u001c2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\u001c2\u0006\u0010-\u001a\u00020\u001cH\u0016J\b\u0010.\u001a\u00020%H\u0016J\u0010\u0010/\u001a\u00020\u00072\u0006\u00100\u001a\u00020\u0007H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0015\u001a\u00020\u0007X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0013\u00a8\u00062"}, d2={"Lcom/datadog/android/rum/resource/RumResourceInputStream;", "Ljava/io/InputStream;", "delegate", "url", "", "(Ljava/io/InputStream;Ljava/lang/String;)V", "callStart", "", "getDelegate", "()Ljava/io/InputStream;", "failed", "", "getFailed$dd_sdk_android_release", "()Z", "setFailed$dd_sdk_android_release", "(Z)V", "firstByte", "key", "getKey$dd_sdk_android_release", "()Ljava/lang/String;", "lastByte", "size", "getSize$dd_sdk_android_release", "()J", "setSize$dd_sdk_android_release", "(J)V", "getUrl", "available", "", "callWithErrorTracking", "T", "errorMessage", "operation", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "(Ljava/lang/String;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "close", "", "mark", "readlimit", "markSupported", "read", "b", "", "off", "len", "reset", "skip", "n", "Companion", "dd-sdk-android_release"})
public final class RumResourceInputStream
extends InputStream {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final InputStream delegate;
    @NotNull
    private final String url;
    @NotNull
    private final String key;
    private long size;
    private boolean failed;
    private long callStart;
    private long firstByte;
    private long lastByte;
    @NotNull
    public static final String METHOD = "GET";
    @NotNull
    public static final String ERROR_CLOSE = "Error closing input stream";
    @NotNull
    public static final String ERROR_MARK = "Error marking input stream";
    @NotNull
    public static final String ERROR_READ = "Error reading from input stream";
    @NotNull
    public static final String ERROR_RESET = "Error resetting input stream";
    @NotNull
    public static final String ERROR_SKIP = "Error skipping bytes from input stream";

    public RumResourceInputStream(@NotNull InputStream delegate, @NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        this.delegate = delegate;
        this.url = url;
        this.key = this.delegate.getClass().getSimpleName() + "@" + System.identityHashCode(this.delegate);
        RumMonitor rumMonitor = GlobalRum.get();
        rumMonitor.startResource(this.key, METHOD, this.url, MapsKt.emptyMap());
        this.callStart = System.nanoTime();
        if (rumMonitor instanceof AdvancedRumMonitor) {
            ((AdvancedRumMonitor)rumMonitor).waitForResourceTiming(this.key);
        }
    }

    @NotNull
    public final InputStream getDelegate() {
        return this.delegate;
    }

    @NotNull
    public final String getUrl() {
        return this.url;
    }

    @NotNull
    public final String getKey$dd_sdk_android_release() {
        return this.key;
    }

    public final long getSize$dd_sdk_android_release() {
        return this.size;
    }

    public final void setSize$dd_sdk_android_release(long l) {
        this.size = l;
    }

    public final boolean getFailed$dd_sdk_android_release() {
        return this.failed;
    }

    public final void setFailed$dd_sdk_android_release(boolean bl) {
        this.failed = bl;
    }

    @Override
    public int read() {
        if (this.firstByte == 0L) {
            this.firstByte = System.nanoTime();
        }
        return ((Number)this.callWithErrorTracking(ERROR_READ, (Function1)new Function1<InputStream, Integer>(this){
            final /* synthetic */ RumResourceInputStream this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Integer invoke(@NotNull InputStream $this$callWithErrorTracking) {
                Intrinsics.checkNotNullParameter((Object)$this$callWithErrorTracking, (String)"$this$callWithErrorTracking");
                Integer n = $this$callWithErrorTracking.read();
                RumResourceInputStream rumResourceInputStream = this.this$0;
                int it = ((Number)n).intValue();
                boolean bl = false;
                if (it >= 0) {
                    long l = rumResourceInputStream.getSize$dd_sdk_android_release();
                    rumResourceInputStream.setSize$dd_sdk_android_release(l + 1L);
                }
                RumResourceInputStream.access$setLastByte$p(rumResourceInputStream, System.nanoTime());
                return n;
            }
        })).intValue();
    }

    @Override
    public int read(@NotNull byte[] b) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        if (this.firstByte == 0L) {
            this.firstByte = System.nanoTime();
        }
        return ((Number)this.callWithErrorTracking(ERROR_READ, (Function1)new Function1<InputStream, Integer>(b, this){
            final /* synthetic */ byte[] $b;
            final /* synthetic */ RumResourceInputStream this$0;
            {
                this.$b = $b;
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Integer invoke(@NotNull InputStream $this$callWithErrorTracking) {
                Intrinsics.checkNotNullParameter((Object)$this$callWithErrorTracking, (String)"$this$callWithErrorTracking");
                Integer n = $this$callWithErrorTracking.read(this.$b);
                RumResourceInputStream rumResourceInputStream = this.this$0;
                int it = ((Number)n).intValue();
                boolean bl = false;
                if (it >= 0) {
                    rumResourceInputStream.setSize$dd_sdk_android_release(rumResourceInputStream.getSize$dd_sdk_android_release() + (long)it);
                }
                RumResourceInputStream.access$setLastByte$p(rumResourceInputStream, System.nanoTime());
                return n;
            }
        })).intValue();
    }

    @Override
    public int read(@NotNull byte[] b, int off, int len) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        if (this.firstByte == 0L) {
            this.firstByte = System.nanoTime();
        }
        return ((Number)this.callWithErrorTracking(ERROR_READ, (Function1)new Function1<InputStream, Integer>(b, off, len, this){
            final /* synthetic */ byte[] $b;
            final /* synthetic */ int $off;
            final /* synthetic */ int $len;
            final /* synthetic */ RumResourceInputStream this$0;
            {
                this.$b = $b;
                this.$off = $off;
                this.$len = $len;
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Integer invoke(@NotNull InputStream $this$callWithErrorTracking) {
                Intrinsics.checkNotNullParameter((Object)$this$callWithErrorTracking, (String)"$this$callWithErrorTracking");
                Integer n = $this$callWithErrorTracking.read(this.$b, this.$off, this.$len);
                RumResourceInputStream rumResourceInputStream = this.this$0;
                int it = ((Number)n).intValue();
                boolean bl = false;
                if (it >= 0) {
                    rumResourceInputStream.setSize$dd_sdk_android_release(rumResourceInputStream.getSize$dd_sdk_android_release() + (long)it);
                }
                RumResourceInputStream.access$setLastByte$p(rumResourceInputStream, System.nanoTime());
                return n;
            }
        })).intValue();
    }

    @Override
    public int available() {
        return ((Number)this.callWithErrorTracking(ERROR_READ, available.1.INSTANCE)).intValue();
    }

    @Override
    public long skip(long n) {
        return ((Number)this.callWithErrorTracking(ERROR_SKIP, (Function1)new Function1<InputStream, Long>(n){
            final /* synthetic */ long $n;
            {
                this.$n = $n;
                super(1);
            }

            @NotNull
            public final Long invoke(@NotNull InputStream $this$callWithErrorTracking) {
                Intrinsics.checkNotNullParameter((Object)$this$callWithErrorTracking, (String)"$this$callWithErrorTracking");
                return $this$callWithErrorTracking.skip(this.$n);
            }
        })).longValue();
    }

    @Override
    public boolean markSupported() {
        return (Boolean)this.callWithErrorTracking(ERROR_READ, markSupported.1.INSTANCE);
    }

    @Override
    public void mark(int readlimit) {
        this.callWithErrorTracking(ERROR_MARK, (Function1)new Function1<InputStream, Unit>(readlimit){
            final /* synthetic */ int $readlimit;
            {
                this.$readlimit = $readlimit;
                super(1);
            }

            public final void invoke(@NotNull InputStream $this$callWithErrorTracking) {
                Intrinsics.checkNotNullParameter((Object)$this$callWithErrorTracking, (String)"$this$callWithErrorTracking");
                $this$callWithErrorTracking.mark(this.$readlimit);
            }
        });
    }

    @Override
    public void reset() {
        this.callWithErrorTracking(ERROR_RESET, reset.1.INSTANCE);
    }

    @Override
    public void close() {
        this.callWithErrorTracking(ERROR_CLOSE, (Function1)new Function1<InputStream, Unit>(this){
            final /* synthetic */ RumResourceInputStream this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull InputStream $this$callWithErrorTracking) {
                Intrinsics.checkNotNullParameter((Object)$this$callWithErrorTracking, (String)"$this$callWithErrorTracking");
                $this$callWithErrorTracking.close();
                RumMonitor monitor = GlobalRum.get();
                AdvancedRumMonitor advancedRumMonitor2 = monitor instanceof AdvancedRumMonitor ? (AdvancedRumMonitor)monitor : null;
                if (advancedRumMonitor2 != null) {
                    advancedRumMonitor2.addResourceTiming(this.this$0.getKey$dd_sdk_android_release(), new ResourceTiming(0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, RumResourceInputStream.access$getFirstByte$p(this.this$0) - RumResourceInputStream.access$getCallStart$p(this.this$0), RumResourceInputStream.access$getLastByte$p(this.this$0) - RumResourceInputStream.access$getFirstByte$p(this.this$0), 255, null));
                }
                monitor.stopResource(this.this$0.getKey$dd_sdk_android_release(), null, this.this$0.getSize$dd_sdk_android_release(), RumResourceKind.OTHER, MapsKt.emptyMap());
            }
        });
    }

    private final <T> T callWithErrorTracking(String errorMessage, Function1<? super InputStream, ? extends T> operation) {
        try {
            return (T)operation.invoke((Object)this.delegate);
        }
        catch (Throwable e) {
            if (!this.failed) {
                this.failed = true;
                RumMonitor.DefaultImpls.stopResourceWithError$default(GlobalRum.get(), this.key, null, errorMessage, RumErrorSource.SOURCE, e, null, 32, null);
            }
            throw e;
        }
    }

    public static final /* synthetic */ void access$setLastByte$p(RumResourceInputStream $this, long l) {
        $this.lastByte = l;
    }

    public static final /* synthetic */ long access$getFirstByte$p(RumResourceInputStream $this) {
        return $this.firstByte;
    }

    public static final /* synthetic */ long access$getCallStart$p(RumResourceInputStream $this) {
        return $this.callStart;
    }

    public static final /* synthetic */ long access$getLastByte$p(RumResourceInputStream $this) {
        return $this.lastByte;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/datadog/android/rum/resource/RumResourceInputStream$Companion;", "", "()V", "ERROR_CLOSE", "", "ERROR_MARK", "ERROR_READ", "ERROR_RESET", "ERROR_SKIP", "METHOD", "dd-sdk-android_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

