/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.rum.tracking;

import android.app.Activity;
import android.os.Bundle;
import androidx.annotation.IdRes;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import androidx.navigation.ActivityKt;
import androidx.navigation.NavController;
import androidx.navigation.NavDestination;
import androidx.navigation.fragment.NavHostFragment;
import com.datadog.android.Datadog;
import com.datadog.android.core.configuration.Configuration;
import com.datadog.android.core.internal.utils.RuntimeUtilsKt;
import com.datadog.android.core.internal.utils.ViewUtilsKt;
import com.datadog.android.rum.GlobalRum;
import com.datadog.android.rum.NoOpRumMonitor;
import com.datadog.android.rum.RumActionType;
import com.datadog.android.rum.RumErrorSource;
import com.datadog.android.rum.RumMonitor;
import com.datadog.android.rum.RumPerformanceMetric;
import com.datadog.android.rum.RumResourceKind;
import com.datadog.android.rum._RumInternalProxy;
import com.datadog.android.rum.internal.RumFeature;
import com.datadog.android.rum.internal.debug.RumDebugListener;
import com.datadog.android.rum.internal.domain.event.ResourceTiming;
import com.datadog.android.rum.internal.monitor.AdvancedRumMonitor;
import com.datadog.android.rum.internal.monitor.NoOpAdvancedRumMonitor;
import com.datadog.android.rum.internal.monitor.StorageEvent;
import com.datadog.android.rum.internal.tracking.AndroidXFragmentLifecycleCallbacks;
import com.datadog.android.rum.model.ViewEvent;
import com.datadog.android.rum.tracking.AcceptAllNavDestinations;
import com.datadog.android.rum.tracking.ActivityLifecycleTrackingStrategy;
import com.datadog.android.rum.tracking.ComponentPredicate;
import com.datadog.android.rum.tracking.NavigationViewTrackingStrategy;
import com.datadog.android.rum.tracking.ViewTrackingStrategy;
import com.datadog.android.v2.api.InternalLogger;
import com.datadog.android.v2.api.SdkCore;
import com.datadog.android.v2.core.DatadogCore;
import java.util.Map;
import java.util.WeakHashMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003:\u0003\"#$B'\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000eH\u0016J\u0010\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000eH\u0016J\u0010\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000eH\u0016J\"\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\n2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0016J\u0006\u0010\u001e\u001a\u00020\u0014J\u0006\u0010\u001f\u001a\u00020\u0014J\u0018\u0010 \u001a\u0004\u0018\u00010\u001a*\u00020\u000e2\b\b\u0001\u0010!\u001a\u00020\u0005H\u0002R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/datadog/android/rum/tracking/NavigationViewTrackingStrategy;", "Lcom/datadog/android/rum/tracking/ActivityLifecycleTrackingStrategy;", "Lcom/datadog/android/rum/tracking/ViewTrackingStrategy;", "Landroidx/navigation/NavController$OnDestinationChangedListener;", "navigationViewId", "", "trackArguments", "", "componentPredicate", "Lcom/datadog/android/rum/tracking/ComponentPredicate;", "Landroidx/navigation/NavDestination;", "(IZLcom/datadog/android/rum/tracking/ComponentPredicate;)V", "lifecycleCallbackRefs", "Ljava/util/WeakHashMap;", "Landroid/app/Activity;", "Lcom/datadog/android/rum/tracking/NavigationViewTrackingStrategy$NavControllerFragmentLifecycleCallbacks;", "predicate", "Landroidx/fragment/app/Fragment;", "startedActivity", "onActivityPaused", "", "activity", "onActivityStarted", "onActivityStopped", "onDestinationChanged", "controller", "Landroidx/navigation/NavController;", "destination", "arguments", "Landroid/os/Bundle;", "startTracking", "stopTracking", "findNavControllerOrNull", "viewId", "AdvancedMonitorDecorator", "NavControllerFragmentLifecycleCallbacks", "NavigationKey", "dd-sdk-android_release"})
public final class NavigationViewTrackingStrategy
extends ActivityLifecycleTrackingStrategy
implements ViewTrackingStrategy,
NavController.OnDestinationChangedListener {
    private final int navigationViewId;
    private final boolean trackArguments;
    @NotNull
    private final ComponentPredicate<NavDestination> componentPredicate;
    @Nullable
    private Activity startedActivity;
    @NotNull
    private WeakHashMap<Activity, NavControllerFragmentLifecycleCallbacks> lifecycleCallbackRefs;
    @NotNull
    private final ComponentPredicate<Fragment> predicate;

    public NavigationViewTrackingStrategy(@IdRes int navigationViewId, boolean trackArguments, @NotNull ComponentPredicate<NavDestination> componentPredicate) {
        Intrinsics.checkNotNullParameter(componentPredicate, (String)"componentPredicate");
        this.navigationViewId = navigationViewId;
        this.trackArguments = trackArguments;
        this.componentPredicate = componentPredicate;
        this.lifecycleCallbackRefs = new WeakHashMap();
        this.predicate = new ComponentPredicate<Fragment>(){

            public boolean accept(@NotNull Fragment component) {
                Intrinsics.checkNotNullParameter((Object)component, (String)"component");
                return !NavHostFragment.class.isAssignableFrom(component.getClass());
            }

            @Nullable
            public String getViewName(@NotNull Fragment component) {
                Intrinsics.checkNotNullParameter((Object)component, (String)"component");
                return null;
            }
        };
    }

    public /* synthetic */ NavigationViewTrackingStrategy(int n, boolean bl, ComponentPredicate componentPredicate, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            componentPredicate = new AcceptAllNavDestinations();
        }
        this(n, bl, componentPredicate);
    }

    @Override
    public void onActivityStarted(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        super.onActivityStarted(activity);
        this.startedActivity = activity;
        this.startTracking();
    }

    @Override
    public void onActivityStopped(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        super.onActivityStopped(activity);
        this.stopTracking();
        this.startedActivity = null;
    }

    @Override
    public void onActivityPaused(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        super.onActivityPaused(activity);
        NavController navController = this.findNavControllerOrNull(activity, this.navigationViewId);
        if (navController != null) {
            NavDestination navDestination = navController.getCurrentDestination();
            if (navDestination != null) {
                NavDestination it = navDestination;
                boolean bl = false;
                RumMonitor.DefaultImpls.stopView$default(GlobalRum.get(), it, null, 2, null);
            }
        }
    }

    public void onDestinationChanged(@NotNull NavController controller, @NotNull NavDestination destination, @Nullable Bundle arguments) {
        Intrinsics.checkNotNullParameter((Object)controller, (String)"controller");
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        ComponentPredicate<NavDestination> $this$runIfValid$iv = this.componentPredicate;
        boolean $i$f$runIfValid = false;
        if ($this$runIfValid$iv.accept(destination)) {
            try {
                NavDestination it = destination;
                boolean bl = false;
                Map<String, Object> attributes = this.trackArguments ? this.convertToRumAttributes(arguments) : MapsKt.emptyMap();
                ComponentPredicate<NavDestination> $this$resolveViewName$iv = this.componentPredicate;
                boolean $i$f$resolveViewName = false;
                String customName$iv = $this$resolveViewName$iv.getViewName(destination);
                CharSequence charSequence = customName$iv;
                String viewName = charSequence == null || StringsKt.isBlank((CharSequence)charSequence) ? ViewUtilsKt.resolveViewUrl(destination) : customName$iv;
                GlobalRum.get().startView(new NavigationKey(controller, destination), viewName, attributes);
            }
            catch (Exception e$iv) {
                InternalLogger.Target[] targetArray = new InternalLogger.Target[]{InternalLogger.Target.MAINTAINER, InternalLogger.Target.TELEMETRY};
                RuntimeUtilsKt.getInternalLogger().log(InternalLogger.Level.ERROR, CollectionsKt.listOf((Object[])targetArray), "Internal operation failed", (Throwable)e$iv);
            }
        }
    }

    public final void startTracking() {
        Activity activity = this.startedActivity;
        if (activity == null) {
            return;
        }
        Activity activity2 = activity;
        SdkCore sdkCore = Datadog.INSTANCE.getGlobalSdkCore$dd_sdk_android_release();
        DatadogCore datadogCore = sdkCore instanceof DatadogCore ? (DatadogCore)sdkCore : null;
        RumFeature rumFeature = datadogCore == null ? null : datadogCore.getRumFeature$dd_sdk_android_release();
        if (rumFeature == null) {
            return;
        }
        RumFeature rumFeature2 = rumFeature;
        NavController navController = this.findNavControllerOrNull(activity2, this.navigationViewId);
        if (navController != null) {
            NavController it = navController;
            boolean bl = false;
            if (FragmentActivity.class.isAssignableFrom(activity2.getClass())) {
                NavControllerFragmentLifecycleCallbacks navControllerFragmentCallbacks2 = new NavControllerFragmentLifecycleCallbacks(it, (Function1<? super Fragment, ? extends Map<String, ? extends Object>>)((Function1)startTracking.1.navControllerFragmentCallbacks.1.INSTANCE), this.predicate, rumFeature2);
                Activity activity3 = this.startedActivity;
                if (activity3 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type androidx.fragment.app.FragmentActivity");
                }
                navControllerFragmentCallbacks2.register((FragmentActivity)activity3);
                Map map = this.lifecycleCallbackRefs;
                Activity activity4 = this.startedActivity;
                map.put(activity4, navControllerFragmentCallbacks2);
            }
            it.addOnDestinationChangedListener((NavController.OnDestinationChangedListener)this);
        }
    }

    public final void stopTracking() {
        Activity activity = this.startedActivity;
        if (activity == null) {
            return;
        }
        Activity activity2 = activity;
        NavController navController = this.findNavControllerOrNull(activity2, this.navigationViewId);
        if (navController != null) {
            NavController it = navController;
            boolean bl = false;
            it.removeOnDestinationChangedListener((NavController.OnDestinationChangedListener)this);
            if (FragmentActivity.class.isAssignableFrom(activity2.getClass())) {
                NavControllerFragmentLifecycleCallbacks navControllerFragmentLifecycleCallbacks = this.lifecycleCallbackRefs.remove(activity2);
                if (navControllerFragmentLifecycleCallbacks != null) {
                    navControllerFragmentLifecycleCallbacks.unregister((FragmentActivity)activity2);
                }
            }
        }
    }

    private final NavController findNavControllerOrNull(Activity $this$findNavControllerOrNull, @IdRes int viewId) {
        NavController navController;
        try {
            navController = ActivityKt.findNavController((Activity)$this$findNavControllerOrNull, (int)viewId);
        }
        catch (IllegalArgumentException e) {
            navController = null;
        }
        catch (IllegalStateException e) {
            navController = null;
        }
        return navController;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0080\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lcom/datadog/android/rum/tracking/NavigationViewTrackingStrategy$NavigationKey;", "", "controller", "Landroidx/navigation/NavController;", "destination", "Landroidx/navigation/NavDestination;", "(Landroidx/navigation/NavController;Landroidx/navigation/NavDestination;)V", "getController", "()Landroidx/navigation/NavController;", "getDestination", "()Landroidx/navigation/NavDestination;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "dd-sdk-android_release"})
    public static final class NavigationKey {
        @NotNull
        private final NavController controller;
        @NotNull
        private final NavDestination destination;

        public NavigationKey(@NotNull NavController controller, @NotNull NavDestination destination) {
            Intrinsics.checkNotNullParameter((Object)controller, (String)"controller");
            Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
            this.controller = controller;
            this.destination = destination;
        }

        @NotNull
        public final NavController getController() {
            return this.controller;
        }

        @NotNull
        public final NavDestination getDestination() {
            return this.destination;
        }

        @NotNull
        public final NavController component1() {
            return this.controller;
        }

        @NotNull
        public final NavDestination component2() {
            return this.destination;
        }

        @NotNull
        public final NavigationKey copy(@NotNull NavController controller, @NotNull NavDestination destination) {
            Intrinsics.checkNotNullParameter((Object)controller, (String)"controller");
            Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
            return new NavigationKey(controller, destination);
        }

        public static /* synthetic */ NavigationKey copy$default(NavigationKey navigationKey, NavController navController, NavDestination navDestination, int n, Object object) {
            if ((n & 1) != 0) {
                navController = navigationKey.controller;
            }
            if ((n & 2) != 0) {
                navDestination = navigationKey.destination;
            }
            return navigationKey.copy(navController, navDestination);
        }

        @NotNull
        public String toString() {
            return "NavigationKey(controller=" + this.controller + ", destination=" + this.destination + ")";
        }

        public int hashCode() {
            int result = this.controller.hashCode();
            result = result * 31 + this.destination.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof NavigationKey)) {
                return false;
            }
            NavigationKey navigationKey = (NavigationKey)other;
            if (!Intrinsics.areEqual((Object)this.controller, (Object)navigationKey.controller)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.destination, (Object)navigationKey.destination);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011BE\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012 \u0010\u0004\u001a\u001c\u0012\u0004\u0012\u00020\u0006\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\t0\u00070\u0005\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0006H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/datadog/android/rum/tracking/NavigationViewTrackingStrategy$NavControllerFragmentLifecycleCallbacks;", "Lcom/datadog/android/rum/internal/tracking/AndroidXFragmentLifecycleCallbacks;", "navController", "Landroidx/navigation/NavController;", "argumentsProvider", "Lkotlin/Function1;", "Landroidx/fragment/app/Fragment;", "", "", "", "componentPredicate", "Lcom/datadog/android/rum/tracking/ComponentPredicate;", "rumFeature", "Lcom/datadog/android/rum/internal/RumFeature;", "(Landroidx/navigation/NavController;Lkotlin/jvm/functions/Function1;Lcom/datadog/android/rum/tracking/ComponentPredicate;Lcom/datadog/android/rum/internal/RumFeature;)V", "resolveKey", "fragment", "Companion", "dd-sdk-android_release"})
    public static final class NavControllerFragmentLifecycleCallbacks
    extends AndroidXFragmentLifecycleCallbacks {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final NavController navController;
        @NotNull
        private static final Object NO_DESTINATION_FOUND = new Object();

        public NavControllerFragmentLifecycleCallbacks(@NotNull NavController navController, @NotNull Function1<? super Fragment, ? extends Map<String, ? extends Object>> argumentsProvider, @NotNull ComponentPredicate<Fragment> componentPredicate, @NotNull RumFeature rumFeature) {
            Intrinsics.checkNotNullParameter((Object)navController, (String)"navController");
            Intrinsics.checkNotNullParameter(argumentsProvider, (String)"argumentsProvider");
            Intrinsics.checkNotNullParameter(componentPredicate, (String)"componentPredicate");
            Intrinsics.checkNotNullParameter((Object)rumFeature, (String)"rumFeature");
            NoOpRumMonitor noOpRumMonitor = new NoOpRumMonitor();
            RumMonitor rumMonitor = GlobalRum.get();
            AdvancedRumMonitor advancedRumMonitor2 = rumMonitor instanceof AdvancedRumMonitor ? (AdvancedRumMonitor)rumMonitor : null;
            if (advancedRumMonitor2 == null) {
                advancedRumMonitor2 = new NoOpAdvancedRumMonitor();
            }
            AdvancedMonitorDecorator advancedMonitorDecorator = new AdvancedMonitorDecorator(advancedRumMonitor2);
            super(argumentsProvider, componentPredicate, null, rumFeature, noOpRumMonitor, advancedMonitorDecorator, 4, null);
            this.navController = navController;
        }

        @Override
        @NotNull
        public Object resolveKey(@NotNull Fragment fragment) {
            Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
            Object object = this.navController.getCurrentDestination();
            if (object == null) {
                object = NO_DESTINATION_FOUND;
            }
            return object;
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lcom/datadog/android/rum/tracking/NavigationViewTrackingStrategy$NavControllerFragmentLifecycleCallbacks$Companion;", "", "()V", "NO_DESTINATION_FOUND", "getNO_DESTINATION_FOUND", "()Ljava/lang/Object;", "dd-sdk-android_release"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Object getNO_DESTINATION_FOUND() {
                return NO_DESTINATION_FOUND;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0007\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0003J\u000b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u0096\u0001J!\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0096\u0001J9\u0010\u000e\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0014\u0010\u000f\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u0010H\u0096\u0001J9\u0010\u0012\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\u0013\u001a\u0004\u0018\u00010\t2\u0014\u0010\u000f\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u0010H\u0096\u0001J\u0019\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u0011H\u0096\u0001J\u0019\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\tH\u0096\u0001J\u0019\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\u001eH\u0096\u0001J\u0011\u0010\u001f\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\tH\u0096\u0001J/\u0010 \u001a\u00020\u00072\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0015\u001a\u00020\t2\u0014\u0010\u000f\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u0010H\u0096\u0001J\u0019\u0010#\u001a\u00020\u00072\u0006\u0010$\u001a\u00020\t2\u0006\u0010%\u001a\u00020&H\u0096\u0001J\u0019\u0010'\u001a\u00020\u00072\u0006\u0010$\u001a\u00020\t2\u0006\u0010%\u001a\u00020&H\u0096\u0001J\t\u0010(\u001a\u00020\u0007H\u0096\u0001J\t\u0010)\u001a\u00020\u0007H\u0096\u0001J\u0011\u0010*\u001a\u00020\u00072\u0006\u0010+\u001a\u00020,H\u0096\u0001J\u0011\u0010-\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0096\u0001J%\u0010.\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010/\u001a\u0004\u0018\u00010\t2\b\u00100\u001a\u0004\u0018\u00010\tH\u0096\u0001J\u001b\u0010.\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0096\u0001J\t\u00101\u001a\u00020\u0007H\u0096\u0001J\u0013\u00102\u001a\u00020\u00072\b\u00103\u001a\u0004\u0018\u000104H\u0096\u0001J7\u00105\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\t2\u0006\u00106\u001a\u00020\t2\u0006\u00107\u001a\u00020\t2\u0014\u0010\u000f\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u0010H\u0096\u0001J/\u00108\u001a\u00020\u00072\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0015\u001a\u00020\t2\u0014\u0010\u000f\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u0010H\u0096\u0001J/\u00109\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\t2\u0014\u0010\u000f\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u0010H\u0096\u0001JH\u0010:\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\t2\b\u0010;\u001a\u0004\u0018\u00010<2\b\u0010=\u001a\u0004\u0018\u00010\u00192\u0006\u00100\u001a\u00020>2\u0014\u0010\u000f\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u0010H\u0096\u0001\u00a2\u0006\u0002\u0010?JX\u0010@\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\t2\b\u0010;\u001a\u0004\u0018\u00010<2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010A\u001a\u00020\t2\b\u0010B\u001a\u0004\u0018\u00010\t2\u0014\u0010\u000f\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u0010H\u0096\u0001\u00a2\u0006\u0002\u0010CJN\u0010@\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\t2\b\u0010;\u001a\u0004\u0018\u00010<2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0014\u0010\u000f\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u0010H\u0096\u0001\u00a2\u0006\u0002\u0010DJ\t\u0010E\u001a\u00020\u0007H\u0096\u0001J/\u0010F\u001a\u00020\u00072\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0015\u001a\u00020\t2\u0014\u0010\u000f\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u0010H\u0096\u0001J'\u0010G\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u00112\u0014\u0010\u000f\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u0010H\u0096\u0001J\u0019\u0010H\u001a\u00020\u00072\u0006\u0010I\u001a\u00020J2\u0006\u0010\u0016\u001a\u00020KH\u0096\u0001J \u0010L\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u00112\u0006\u0010M\u001a\u00020\u00192\u0006\u0010!\u001a\u00020NH\u0016J\u0011\u0010O\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\tH\u0096\u0001R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006P"}, d2={"Lcom/datadog/android/rum/tracking/NavigationViewTrackingStrategy$AdvancedMonitorDecorator;", "Lcom/datadog/android/rum/internal/monitor/AdvancedRumMonitor;", "advancedRumMonitor", "(Lcom/datadog/android/rum/internal/monitor/AdvancedRumMonitor;)V", "_getInternal", "Lcom/datadog/android/rum/_RumInternalProxy;", "addCrash", "", "message", "", "source", "Lcom/datadog/android/rum/RumErrorSource;", "throwable", "", "addError", "attributes", "", "", "addErrorWithStacktrace", "stacktrace", "addFeatureFlagEvaluation", "name", "value", "addLongTask", "durationNs", "", "target", "addResourceTiming", "key", "timing", "Lcom/datadog/android/rum/internal/domain/event/ResourceTiming;", "addTiming", "addUserAction", "type", "Lcom/datadog/android/rum/RumActionType;", "eventDropped", "viewId", "event", "Lcom/datadog/android/rum/internal/monitor/StorageEvent;", "eventSent", "notifyInterceptorInstantiated", "resetSession", "sendConfigurationTelemetryEvent", "configuration", "Lcom/datadog/android/core/configuration/Configuration;", "sendDebugTelemetryEvent", "sendErrorTelemetryEvent", "stack", "kind", "sendWebViewEvent", "setDebugListener", "listener", "Lcom/datadog/android/rum/internal/debug/RumDebugListener;", "startResource", "method", "url", "startUserAction", "startView", "stopResource", "statusCode", "", "size", "Lcom/datadog/android/rum/RumResourceKind;", "(Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/Long;Lcom/datadog/android/rum/RumResourceKind;Ljava/util/Map;)V", "stopResourceWithError", "stackTrace", "errorType", "(Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/String;Lcom/datadog/android/rum/RumErrorSource;Ljava/lang/String;Ljava/lang/String;Ljava/util/Map;)V", "(Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/String;Lcom/datadog/android/rum/RumErrorSource;Ljava/lang/Throwable;Ljava/util/Map;)V", "stopSession", "stopUserAction", "stopView", "updatePerformanceMetric", "metric", "Lcom/datadog/android/rum/RumPerformanceMetric;", "", "updateViewLoadingTime", "loadingTimeInNs", "Lcom/datadog/android/rum/model/ViewEvent$LoadingType;", "waitForResourceTiming", "dd-sdk-android_release"})
    public static final class AdvancedMonitorDecorator
    implements AdvancedRumMonitor {
        @NotNull
        private final AdvancedRumMonitor advancedRumMonitor;

        public AdvancedMonitorDecorator(@NotNull AdvancedRumMonitor advancedRumMonitor2) {
            Intrinsics.checkNotNullParameter((Object)advancedRumMonitor2, (String)"advancedRumMonitor");
            this.advancedRumMonitor = advancedRumMonitor2;
        }

        @Override
        @Nullable
        public _RumInternalProxy _getInternal() {
            return this.advancedRumMonitor._getInternal();
        }

        @Override
        public void addCrash(@NotNull String message, @NotNull RumErrorSource source, @NotNull Throwable throwable) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            Intrinsics.checkNotNullParameter((Object)((Object)source), (String)"source");
            Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
            this.advancedRumMonitor.addCrash(message, source, throwable);
        }

        @Override
        public void addError(@NotNull String message, @NotNull RumErrorSource source, @Nullable Throwable throwable, @NotNull Map<String, ? extends Object> attributes) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            Intrinsics.checkNotNullParameter((Object)((Object)source), (String)"source");
            Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
            this.advancedRumMonitor.addError(message, source, throwable, attributes);
        }

        @Override
        public void addErrorWithStacktrace(@NotNull String message, @NotNull RumErrorSource source, @Nullable String stacktrace, @NotNull Map<String, ? extends Object> attributes) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            Intrinsics.checkNotNullParameter((Object)((Object)source), (String)"source");
            Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
            this.advancedRumMonitor.addErrorWithStacktrace(message, source, stacktrace, attributes);
        }

        @Override
        public void addFeatureFlagEvaluation(@NotNull String name, @NotNull Object value) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            this.advancedRumMonitor.addFeatureFlagEvaluation(name, value);
        }

        @Override
        public void addLongTask(long durationNs, @NotNull String target) {
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            this.advancedRumMonitor.addLongTask(durationNs, target);
        }

        @Override
        public void addResourceTiming(@NotNull String key, @NotNull ResourceTiming timing) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)timing, (String)"timing");
            this.advancedRumMonitor.addResourceTiming(key, timing);
        }

        @Override
        public void addTiming(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this.advancedRumMonitor.addTiming(name);
        }

        @Override
        public void addUserAction(@NotNull RumActionType type, @NotNull String name, @NotNull Map<String, ? extends Object> attributes) {
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
            this.advancedRumMonitor.addUserAction(type, name, attributes);
        }

        @Override
        public void eventDropped(@NotNull String viewId, @NotNull StorageEvent event) {
            Intrinsics.checkNotNullParameter((Object)viewId, (String)"viewId");
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            this.advancedRumMonitor.eventDropped(viewId, event);
        }

        @Override
        public void eventSent(@NotNull String viewId, @NotNull StorageEvent event) {
            Intrinsics.checkNotNullParameter((Object)viewId, (String)"viewId");
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            this.advancedRumMonitor.eventSent(viewId, event);
        }

        @Override
        public void notifyInterceptorInstantiated() {
            this.advancedRumMonitor.notifyInterceptorInstantiated();
        }

        @Override
        public void resetSession() {
            this.advancedRumMonitor.resetSession();
        }

        @Override
        public void sendConfigurationTelemetryEvent(@NotNull Configuration configuration) {
            Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
            this.advancedRumMonitor.sendConfigurationTelemetryEvent(configuration);
        }

        @Override
        public void sendDebugTelemetryEvent(@NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            this.advancedRumMonitor.sendDebugTelemetryEvent(message);
        }

        @Override
        public void sendErrorTelemetryEvent(@NotNull String message, @Nullable String stack, @Nullable String kind) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            this.advancedRumMonitor.sendErrorTelemetryEvent(message, stack, kind);
        }

        @Override
        public void sendErrorTelemetryEvent(@NotNull String message, @Nullable Throwable throwable) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            this.advancedRumMonitor.sendErrorTelemetryEvent(message, throwable);
        }

        @Override
        public void sendWebViewEvent() {
            this.advancedRumMonitor.sendWebViewEvent();
        }

        @Override
        public void setDebugListener(@Nullable RumDebugListener listener) {
            this.advancedRumMonitor.setDebugListener(listener);
        }

        @Override
        public void startResource(@NotNull String key, @NotNull String method, @NotNull String url, @NotNull Map<String, ? extends Object> attributes) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)method, (String)"method");
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
            this.advancedRumMonitor.startResource(key, method, url, attributes);
        }

        @Override
        public void startUserAction(@NotNull RumActionType type, @NotNull String name, @NotNull Map<String, ? extends Object> attributes) {
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
            this.advancedRumMonitor.startUserAction(type, name, attributes);
        }

        @Override
        public void startView(@NotNull Object key, @NotNull String name, @NotNull Map<String, ? extends Object> attributes) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
            this.advancedRumMonitor.startView(key, name, attributes);
        }

        @Override
        public void stopResource(@NotNull String key, @Nullable Integer statusCode, @Nullable Long size, @NotNull RumResourceKind kind, @NotNull Map<String, ? extends Object> attributes) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)((Object)kind), (String)"kind");
            Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
            this.advancedRumMonitor.stopResource(key, statusCode, size, kind, attributes);
        }

        @Override
        public void stopResourceWithError(@NotNull String key, @Nullable Integer statusCode, @NotNull String message, @NotNull RumErrorSource source, @NotNull String stackTrace, @Nullable String errorType, @NotNull Map<String, ? extends Object> attributes) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            Intrinsics.checkNotNullParameter((Object)((Object)source), (String)"source");
            Intrinsics.checkNotNullParameter((Object)stackTrace, (String)"stackTrace");
            Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
            this.advancedRumMonitor.stopResourceWithError(key, statusCode, message, source, stackTrace, errorType, attributes);
        }

        @Override
        public void stopResourceWithError(@NotNull String key, @Nullable Integer statusCode, @NotNull String message, @NotNull RumErrorSource source, @NotNull Throwable throwable, @NotNull Map<String, ? extends Object> attributes) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            Intrinsics.checkNotNullParameter((Object)((Object)source), (String)"source");
            Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
            Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
            this.advancedRumMonitor.stopResourceWithError(key, statusCode, message, source, throwable, attributes);
        }

        @Override
        public void stopSession() {
            this.advancedRumMonitor.stopSession();
        }

        @Override
        public void stopUserAction(@NotNull RumActionType type, @NotNull String name, @NotNull Map<String, ? extends Object> attributes) {
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
            this.advancedRumMonitor.stopUserAction(type, name, attributes);
        }

        @Override
        public void stopView(@NotNull Object key, @NotNull Map<String, ? extends Object> attributes) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
            this.advancedRumMonitor.stopView(key, attributes);
        }

        @Override
        public void updatePerformanceMetric(@NotNull RumPerformanceMetric metric, double value) {
            Intrinsics.checkNotNullParameter((Object)((Object)metric), (String)"metric");
            this.advancedRumMonitor.updatePerformanceMetric(metric, value);
        }

        @Override
        public void waitForResourceTiming(@NotNull String key) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            this.advancedRumMonitor.waitForResourceTiming(key);
        }

        @Override
        public void updateViewLoadingTime(@NotNull Object key, long loadingTimeInNs, @NotNull ViewEvent.LoadingType type) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            if (!Intrinsics.areEqual((Object)key, (Object)NavControllerFragmentLifecycleCallbacks.Companion.getNO_DESTINATION_FOUND())) {
                this.advancedRumMonitor.updateViewLoadingTime(key, loadingTimeInNs, type);
            }
        }
    }
}

