/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.sessionreplay.internal;

import android.app.Application;
import android.content.Context;
import com.datadog.android.core.configuration.Configuration;
import com.datadog.android.core.internal.utils.RuntimeUtilsKt;
import com.datadog.android.sessionreplay.LifecycleCallback;
import com.datadog.android.sessionreplay.RecordCallback;
import com.datadog.android.sessionreplay.RecordWriter;
import com.datadog.android.sessionreplay.SessionReplayLifecycleCallback;
import com.datadog.android.sessionreplay.internal.NoOpLifecycleCallback;
import com.datadog.android.sessionreplay.internal.SessionReplayRecordCallback;
import com.datadog.android.sessionreplay.internal.SessionReplayRumContextProvider;
import com.datadog.android.sessionreplay.internal.storage.NoOpRecordWriter;
import com.datadog.android.sessionreplay.internal.storage.SessionReplayRecordWriter;
import com.datadog.android.sessionreplay.internal.time.SessionReplayTimeProvider;
import com.datadog.android.sessionreplay.utils.RumContextProvider;
import com.datadog.android.sessionreplay.utils.TimeProvider;
import com.datadog.android.v2.api.FeatureEventReceiver;
import com.datadog.android.v2.api.InternalLogger;
import com.datadog.android.v2.api.SdkCore;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0002\b\n\b\u0000\u0018\u0000 02\u00020\u0001:\u00010B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u001a\b\u0002\u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0005\u00a2\u0006\u0002\u0010\tJ\b\u0010\u001f\u001a\u00020\u0006H\u0002J\u001d\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u000b2\u0006\u0010#\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b$J\u0010\u0010%\u001a\u00020!2\u0006\u0010&\u001a\u00020'H\u0016J\u0010\u0010(\u001a\u00020!2\u0006\u0010\"\u001a\u00020\u000bH\u0002J\r\u0010)\u001a\u00020!H\u0000\u00a2\u0006\u0002\b*J\r\u0010+\u001a\u00020!H\u0000\u00a2\u0006\u0002\b,J\r\u0010-\u001a\u00020!H\u0000\u00a2\u0006\u0002\b.J\u0010\u0010/\u001a\u00020!2\u0006\u0010\"\u001a\u00020\u000bH\u0002R\u001a\u0010\n\u001a\u00020\u000bX\u0080.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0006X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u0016X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0019\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001a\u001a\u00020\bX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR \u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lcom/datadog/android/sessionreplay/internal/SessionReplayFeature;", "Lcom/datadog/android/v2/api/FeatureEventReceiver;", "sdkCore", "Lcom/datadog/android/v2/api/SdkCore;", "sessionReplayCallbackProvider", "Lkotlin/Function2;", "Lcom/datadog/android/sessionreplay/RecordWriter;", "Lcom/datadog/android/core/configuration/Configuration$Feature$SessionReplay;", "Lcom/datadog/android/sessionreplay/LifecycleCallback;", "(Lcom/datadog/android/v2/api/SdkCore;Lkotlin/jvm/functions/Function2;)V", "appContext", "Landroid/content/Context;", "getAppContext$dd_sdk_android_release", "()Landroid/content/Context;", "setAppContext$dd_sdk_android_release", "(Landroid/content/Context;)V", "dataWriter", "getDataWriter$dd_sdk_android_release", "()Lcom/datadog/android/sessionreplay/RecordWriter;", "setDataWriter$dd_sdk_android_release", "(Lcom/datadog/android/sessionreplay/RecordWriter;)V", "initialized", "Ljava/util/concurrent/atomic/AtomicBoolean;", "getInitialized$dd_sdk_android_release", "()Ljava/util/concurrent/atomic/AtomicBoolean;", "isRecording", "sessionReplayCallback", "getSessionReplayCallback$dd_sdk_android_release", "()Lcom/datadog/android/sessionreplay/LifecycleCallback;", "setSessionReplayCallback$dd_sdk_android_release", "(Lcom/datadog/android/sessionreplay/LifecycleCallback;)V", "createDataWriter", "initialize", "", "context", "configuration", "initialize$dd_sdk_android_release", "onReceive", "event", "", "registerCallback", "startRecording", "startRecording$dd_sdk_android_release", "stop", "stop$dd_sdk_android_release", "stopRecording", "stopRecording$dd_sdk_android_release", "unregisterCallback", "Companion", "dd-sdk-android_release"})
public final class SessionReplayFeature
implements FeatureEventReceiver {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SdkCore sdkCore;
    @NotNull
    private final Function2<RecordWriter, Configuration.Feature.SessionReplay, LifecycleCallback> sessionReplayCallbackProvider;
    public Context appContext;
    @NotNull
    private AtomicBoolean isRecording;
    @NotNull
    private LifecycleCallback sessionReplayCallback;
    @NotNull
    private RecordWriter dataWriter;
    @NotNull
    private final AtomicBoolean initialized;
    @NotNull
    public static final String UNSUPPORTED_EVENT_TYPE = "Session Replay feature receive an event of unsupported type=%s.";
    @NotNull
    public static final String UNKNOWN_EVENT_TYPE_PROPERTY_VALUE = "Session Replay feature received an event with unknown value of \"type\" property=%s.";
    @NotNull
    public static final String EVENT_MISSING_MANDATORY_FIELDS = "Session Replay feature received an event where one or more mandatory (keepSession) fields are either missing or have wrong type.";
    @NotNull
    public static final String SESSION_REPLAY_FEATURE_NAME = "session-replay";
    @NotNull
    public static final String SESSION_REPLAY_BUS_MESSAGE_TYPE_KEY = "type";
    @NotNull
    public static final String RUM_SESSION_RENEWED_BUS_MESSAGE = "rum_session_renewed";
    @NotNull
    public static final String RUM_KEEP_SESSION_BUS_MESSAGE_KEY = "keepSession";
    @NotNull
    public static final String IS_RECORDING_CONTEXT_KEY = "is_recording";

    public SessionReplayFeature(@NotNull SdkCore sdkCore, @NotNull Function2<? super RecordWriter, ? super Configuration.Feature.SessionReplay, ? extends LifecycleCallback> sessionReplayCallbackProvider) {
        Intrinsics.checkNotNullParameter((Object)sdkCore, (String)"sdkCore");
        Intrinsics.checkNotNullParameter(sessionReplayCallbackProvider, (String)"sessionReplayCallbackProvider");
        this.sdkCore = sdkCore;
        this.sessionReplayCallbackProvider = sessionReplayCallbackProvider;
        this.isRecording = new AtomicBoolean(false);
        this.sessionReplayCallback = new NoOpLifecycleCallback();
        this.dataWriter = new NoOpRecordWriter();
        this.initialized = new AtomicBoolean(false);
    }

    public /* synthetic */ SessionReplayFeature(final SdkCore sdkCore, Function2 function2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            function2 = (Function2)new Function2<RecordWriter, Configuration.Feature.SessionReplay, SessionReplayLifecycleCallback>(){

                @NotNull
                public final SessionReplayLifecycleCallback invoke(@NotNull RecordWriter recordWriter, @NotNull Configuration.Feature.SessionReplay configuration) {
                    Intrinsics.checkNotNullParameter((Object)recordWriter, (String)"recordWriter");
                    Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
                    return new SessionReplayLifecycleCallback((RumContextProvider)new SessionReplayRumContextProvider(sdkCore), configuration.getPrivacy(), recordWriter, (TimeProvider)new SessionReplayTimeProvider(sdkCore, null, 2, null), (RecordCallback)new SessionReplayRecordCallback(sdkCore));
                }
            };
        }
        this(sdkCore, (Function2<? super RecordWriter, ? super Configuration.Feature.SessionReplay, ? extends LifecycleCallback>)function2);
    }

    @NotNull
    public final Context getAppContext$dd_sdk_android_release() {
        Context context = this.appContext;
        if (context != null) {
            return context;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"appContext");
        return null;
    }

    public final void setAppContext$dd_sdk_android_release(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"<set-?>");
        this.appContext = context;
    }

    @NotNull
    public final LifecycleCallback getSessionReplayCallback$dd_sdk_android_release() {
        return this.sessionReplayCallback;
    }

    public final void setSessionReplayCallback$dd_sdk_android_release(@NotNull LifecycleCallback lifecycleCallback) {
        Intrinsics.checkNotNullParameter((Object)lifecycleCallback, (String)"<set-?>");
        this.sessionReplayCallback = lifecycleCallback;
    }

    @NotNull
    public final RecordWriter getDataWriter$dd_sdk_android_release() {
        return this.dataWriter;
    }

    public final void setDataWriter$dd_sdk_android_release(@NotNull RecordWriter recordWriter) {
        Intrinsics.checkNotNullParameter((Object)recordWriter, (String)"<set-?>");
        this.dataWriter = recordWriter;
    }

    @NotNull
    public final AtomicBoolean getInitialized$dd_sdk_android_release() {
        return this.initialized;
    }

    public final void initialize$dd_sdk_android_release(@NotNull Context context, @NotNull Configuration.Feature.SessionReplay configuration) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        this.sdkCore.setEventReceiver(SESSION_REPLAY_FEATURE_NAME, this);
        this.setAppContext$dd_sdk_android_release(context);
        this.dataWriter = this.createDataWriter();
        this.sessionReplayCallback = (LifecycleCallback)this.sessionReplayCallbackProvider.invoke((Object)this.dataWriter, (Object)configuration);
        this.initialized.set(true);
        this.startRecording$dd_sdk_android_release();
    }

    public final void stop$dd_sdk_android_release() {
        this.stopRecording$dd_sdk_android_release();
        this.dataWriter = new NoOpRecordWriter();
        this.sessionReplayCallback = new NoOpLifecycleCallback();
        this.initialized.set(false);
    }

    private final RecordWriter createDataWriter() {
        return new SessionReplayRecordWriter(this.sdkCore);
    }

    public final void stopRecording$dd_sdk_android_release() {
        if (this.isRecording.getAndSet(false)) {
            this.unregisterCallback(this.getAppContext$dd_sdk_android_release());
        }
    }

    public final void startRecording$dd_sdk_android_release() {
        if (!this.isRecording.getAndSet(true)) {
            this.registerCallback(this.getAppContext$dd_sdk_android_release());
        }
    }

    @Override
    public void onReceive(@NotNull Object event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!(event instanceof Map)) {
            InternalLogger internalLogger = RuntimeUtilsKt.getInternalLogger();
            String string = UNSUPPORTED_EVENT_TYPE;
            Locale locale = Locale.US;
            Object[] objectArray = new Object[]{event.getClass().getCanonicalName()};
            String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(locale, this, *args)");
            InternalLogger.DefaultImpls.log$default(internalLogger, InternalLogger.Level.WARN, InternalLogger.Target.USER, string2, null, 8, null);
            return;
        }
        if (Intrinsics.areEqual(((Map)event).get(SESSION_REPLAY_BUS_MESSAGE_TYPE_KEY), (Object)RUM_SESSION_RENEWED_BUS_MESSAGE)) {
            Boolean keepSession;
            Object v = ((Map)event).get(RUM_KEEP_SESSION_BUS_MESSAGE_KEY);
            Boolean bl = keepSession = v instanceof Boolean ? (Boolean)v : null;
            if (keepSession == null) {
                InternalLogger.DefaultImpls.log$default(RuntimeUtilsKt.getInternalLogger(), InternalLogger.Level.WARN, InternalLogger.Target.USER, EVENT_MISSING_MANDATORY_FIELDS, null, 8, null);
                return;
            }
            if (keepSession.booleanValue()) {
                this.startRecording$dd_sdk_android_release();
            } else {
                this.stopRecording$dd_sdk_android_release();
            }
        } else {
            InternalLogger internalLogger = RuntimeUtilsKt.getInternalLogger();
            String string = UNKNOWN_EVENT_TYPE_PROPERTY_VALUE;
            Locale locale = Locale.US;
            Object[] objectArray = new Object[]{((Map)event).get(SESSION_REPLAY_BUS_MESSAGE_TYPE_KEY)};
            String string3 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(locale, this, *args)");
            InternalLogger.DefaultImpls.log$default(internalLogger, InternalLogger.Level.WARN, InternalLogger.Target.USER, string3, null, 8, null);
        }
    }

    private final void registerCallback(Context context) {
        if (context instanceof Application) {
            this.sessionReplayCallback.register((Application)context);
        }
    }

    private final void unregisterCallback(Context context) {
        if (context instanceof Application) {
            this.sessionReplayCallback.unregisterAndStopRecorders((Application)context);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/datadog/android/sessionreplay/internal/SessionReplayFeature$Companion;", "", "()V", "EVENT_MISSING_MANDATORY_FIELDS", "", "IS_RECORDING_CONTEXT_KEY", "RUM_KEEP_SESSION_BUS_MESSAGE_KEY", "RUM_SESSION_RENEWED_BUS_MESSAGE", "SESSION_REPLAY_BUS_MESSAGE_TYPE_KEY", "SESSION_REPLAY_FEATURE_NAME", "UNKNOWN_EVENT_TYPE_PROPERTY_VALUE", "UNSUPPORTED_EVENT_TYPE", "dd-sdk-android_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

